/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBInterceptorBinding {
    private static final String CLASS_NAME = EJBInterceptorBinding.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJB3Interceptors", "com.ibm.ejs.container.container");
    private static final List<String> EMPTY_LIST = new LinkedList<String>();
    final String ivEjbName;
    final ArrayList<String> ivInterceptorClassNames = new ArrayList();
    final ArrayList<String> ivInterceptorOrder = new ArrayList();
    final BindingStyle ivBindingStyle;
    final String ivMethodName;
    final List<String> ivMethodParms;
    Boolean ivExcludeDefaultLevelInterceptors;
    Boolean ivExcludeClassLevelInterceptors;

    public EJBInterceptorBinding(List<String> names, List<String> orderList) {
        this.ivEjbName = "*";
        this.ivBindingStyle = BindingStyle.STYLE1;
        if (names != null && !names.isEmpty()) {
            this.ivInterceptorClassNames.addAll(names);
        }
        if (orderList != null && !orderList.isEmpty()) {
            this.ivInterceptorOrder.addAll(orderList);
        }
        this.ivMethodName = null;
        this.ivMethodParms = EMPTY_LIST;
    }

    public EJBInterceptorBinding(String ejbName, List<String> names, List<String> orderList) {
        this.ivEjbName = ejbName;
        this.ivBindingStyle = BindingStyle.STYLE2;
        if (names != null && !names.isEmpty()) {
            this.ivInterceptorClassNames.addAll(names);
        }
        if (orderList != null && !orderList.isEmpty()) {
            this.ivInterceptorOrder.addAll(orderList);
        }
        this.ivMethodName = null;
        this.ivMethodParms = EMPTY_LIST;
    }

    public EJBInterceptorBinding(String ejbName, List<String> names, List<String> orderList, String method, List<String> methodParms) {
        this.ivEjbName = ejbName;
        if (names != null && !names.isEmpty()) {
            this.ivInterceptorClassNames.addAll(names);
        }
        if (orderList != null && !orderList.isEmpty()) {
            this.ivInterceptorOrder.addAll(orderList);
        }
        this.ivMethodName = method;
        if (methodParms == null) {
            this.ivBindingStyle = BindingStyle.STYLE3;
            this.ivMethodParms = EMPTY_LIST;
        } else {
            this.ivBindingStyle = BindingStyle.STYLE4;
            this.ivMethodParms = methodParms;
        }
    }

    private EJBInterceptorBinding() {
        this.ivMethodName = null;
        this.ivEjbName = null;
        this.ivMethodParms = EMPTY_LIST;
        this.ivBindingStyle = null;
    }

    public final String getEJBName() {
        return this.ivEjbName;
    }

    public final BindingStyle getBindingStyle() {
        return this.ivBindingStyle;
    }

    public final String getMethodName() {
        return this.ivMethodName;
    }

    public final List<String> getInterceptorNames() {
        return this.ivInterceptorClassNames;
    }

    public final List<String> getInterceptorOrder() {
        return this.ivInterceptorOrder;
    }

    public void setExcludeClassLevelInterceptors(boolean exclude) throws EJBConfigurationException {
        if (this.ivBindingStyle != BindingStyle.STYLE3 && this.ivBindingStyle != BindingStyle.STYLE4) {
            Tr.error(tc, "INVALID_EXCLUDE_CLASS_INTERCEPTORS_CNTR0224E", new Object[]{this.ivEjbName});
            throw new EJBConfigurationException("exclude-class-interceptors element can only be applied to a method of EJB");
        }
        this.ivExcludeClassLevelInterceptors = exclude ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setExcludeDefaultInterceptors(boolean exclude) throws EJBConfigurationException {
        if (this.ivBindingStyle == BindingStyle.STYLE1) {
            Tr.error(tc, "INVALID_EXCLUDE_DEFAULT_INTERCEPTORS_CNTR0225E");
            throw new EJBConfigurationException(" CNTR0225E: Invalid use of the exclude-default-interceptors element in interceptor-binding for EJB name \"*\"");
        }
        this.ivExcludeDefaultLevelInterceptors = exclude ? Boolean.TRUE : Boolean.FALSE;
    }

    public final List<String> getMethodParms() {
        return this.ivMethodParms;
    }

    public final boolean defaultInterceptorsExcluded() {
        return this.ivExcludeDefaultLevelInterceptors;
    }

    public final boolean classLevelInterceptorsExcluded() {
        return this.ivExcludeClassLevelInterceptors;
    }

    public void dump() {
        Object[] allData = new Object[]{this, "EJBName                     = " + this.ivEjbName, "method name                 = " + this.ivMethodName, "method parameters           = " + this.ivMethodParms, "binding style               = " + (Object)((Object)this.ivBindingStyle), "exclude default inteceptors = " + this.ivExcludeDefaultLevelInterceptors, "exclude class inteceptors   = " + this.ivExcludeClassLevelInterceptors};
        int totalLength = allData.length;
        String[] interceptorOrder = null;
        if (this.ivInterceptorOrder != null) {
            interceptorOrder = new String[this.ivInterceptorOrder.size()];
            interceptorOrder = this.ivInterceptorOrder.toArray(interceptorOrder);
            totalLength += interceptorOrder.length + 2;
        }
        String[] interceptorNames = null;
        if (this.ivInterceptorClassNames != null) {
            interceptorNames = new String[this.ivInterceptorClassNames.size()];
            interceptorNames = this.ivInterceptorClassNames.toArray(interceptorNames);
            totalLength += interceptorNames.length + 2;
        }
        int index = 0;
        Object[] dumpData = new Object[totalLength];
        System.arraycopy(allData, 0, dumpData, index, allData.length);
        index += allData.length;
        if (interceptorOrder != null) {
            dumpData[index++] = "Interceptor Order: ";
            dumpData[index++] = " ";
            System.arraycopy(interceptorOrder, 0, dumpData, index, interceptorOrder.length);
            index += interceptorOrder.length;
        }
        if (interceptorNames != null) {
            dumpData[index++] = "Interceptor Class Names: ";
            dumpData[index++] = " ";
            System.arraycopy(interceptorNames, 0, dumpData, index, interceptorNames.length);
            index += interceptorNames.length;
        }
        Tr.dump(tc, "-- EJBInterceptorBinding Dump --", dumpData);
        Tr.dump(tc, "-- EJBInterceptorBinding Dump End --");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BindingStyle {
        STYLE1,
        STYLE2,
        STYLE3,
        STYLE4;

    }
}

