/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wasresource.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.capability.IIdentity;
import com.ibm.ws.management.wasresource.capability.IManageability;
import com.ibm.ws.management.wasresource.capability.IOperationalStatus;
import com.ibm.ws.management.wasresource.capability.IRelationships;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceManager;
import com.ibm.ws.management.wasresource.common.WASResourceOperationException;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wasresource.common.WASResourceTypeRegistry;
import com.ibm.ws.management.wasresource.common.WASResourceUtilities;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.xml.namespace.QName;

public abstract class WASResource
implements IIdentity,
IManageability,
IOperationalStatus,
IRelationships {
    private static final TraceComponent tc = Tr.register(WASResource.class, null, null);
    protected String managedResourceID;
    protected String configID;
    protected String mbeanIdentifier;
    protected String mbeanType;
    protected ObjectName configData;
    protected ObjectName mbeanObject;
    protected HashMap referenceProperties;
    protected static ConfigService configService;
    protected static AppManagement appManagement;
    protected ObjectName perfMbean;
    private Session session;

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        this.referenceProperties = eprRefProps;
        this.managedResourceID = (String)this.referenceProperties.get(WASResourcesConstants.WAS_WSDM_Resource_MRID);
        try {
            if (this.referenceProperties.containsKey(WASResourcesConstants.WAS_WSDM_Resource_ConfigID)) {
                this.configData = this.getConfigData(this.referenceProperties);
            }
            if (this.referenceProperties.containsKey(WASResourcesConstants.WAS_WSDM_Resource_MbeanIdentifier)) {
                this.mbeanObject = this.getMbeanObject(this.referenceProperties);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wsdm.resource.WASResource.initialize", (String)"58", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while initialize", e);
            }
            throw new WASResourceInitializeException(e);
        }
    }

    protected ObjectName getConfigData(HashMap refProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigData", new Object[]{refProps, this});
        }
        this.configID = (String)refProps.get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config ID is " + this.configID);
        }
        ObjectName type = this.configID.equals("Cell") ? ConfigServiceHelper.createObjectName(null, "Cell") : ConfigServiceHelper.createObjectName(new ConfigDataId(this.configID));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config type is " + type);
        }
        ObjectName resultConfigData = this.getConfigService().queryConfigObjects(this.getSession(), null, type, null)[0];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigData", resultConfigData);
        }
        return resultConfigData;
    }

    protected ObjectName getMbeanObject(HashMap refProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanObject", new Object[]{refProps, this});
        }
        this.mbeanIdentifier = (String)refProps.get(WASResourcesConstants.WAS_WSDM_Resource_MbeanIdentifier);
        ObjectName resultMbean = new ObjectName(this.mbeanIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanObject", resultMbean);
        }
        return resultMbean;
    }

    public abstract String getResourceType();

    public String getConfigType() {
        return null;
    }

    public String getManagedResourceID() {
        return this.managedResourceID;
    }

    public void setManagedResourceID(String theManagedResourceID) {
        this.managedResourceID = theManagedResourceID;
    }

    public String getConfigID() {
        return this.configID;
    }

    public void setConfigID(String theConfigID) {
        this.configID = theConfigID;
    }

    public HashMap getReferenceProperties() {
        return this.referenceProperties;
    }

    public void setReferenceProperties(HashMap theReferenceProperties) {
        this.referenceProperties = theReferenceProperties;
    }

    public ObjectName getConfigData() {
        return this.configData;
    }

    public void setConfigData(ObjectName theConfigData) {
        this.configData = theConfigData;
    }

    public synchronized Session getSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSession", this);
        }
        if (this.session == null) {
            this.session = new Session();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSession", this.session);
        }
        return this.session;
    }

    public synchronized Session discardSession() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "discardession", this);
            }
            try {
                if (this.session != null) {
                    this.getConfigService().discard(this.session);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wsdm.resource.WASResource.discardSession", (String)"214", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Error while discarding session", e);
            }
        }
        this.session = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discardSession", this.session);
        }
        return this.session;
    }

    public void setSession(Session theSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSession", new Object[]{theSession, this});
        }
        this.session = theSession;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSession");
        }
    }

    public ConfigService getConfigService() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigService", this);
        }
        if ((configService = ConfigServiceFactory.getConfigService()) == null) {
            AdminService adminService = this.getAdminService();
            if (adminService != null) {
                if (this.isManagedProcess()) {
                    AdminClient dmgrAdminClient = adminService.getDeploymentManagerAdminClient();
                    configService = new ConfigServiceProxy(dmgrAdminClient);
                } else {
                    configService = ConfigServiceFactory.getConfigService();
                }
            }
            try {
                if (configService == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to get adminservice.  Using local configService");
                    }
                    Properties prop = new Properties();
                    prop.setProperty("location", "local");
                    configService = ConfigServiceFactory.createConfigService(true, prop);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wsdm.resource.WASResource.getConfigService", (String)"158", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error while getting configservice", e);
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigService", configService);
        }
        return configService;
    }

    public AppManagement getAppManagement() throws Exception {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAppManagement", this);
            }
            if (appManagement == null) {
                try {
                    appManagement = AppManagementProxy.getJMXProxyForServer();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Unable to get server AppManagement.  Using local");
                    appManagement = AppManagementProxy.getLocalProxy();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppManagement", appManagement);
        }
        return appManagement;
    }

    public AdminService getAdminService() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminService", this);
        }
        AdminService adminSrv = AdminServiceFactory.getAdminService();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminService", adminSrv);
        }
        return adminSrv;
    }

    public AdminClient getAdminClient(String host, String port, String connector2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", new Object[]{host, port, connector2, this});
        }
        AdminClient adminClient = null;
        Properties props = new Properties();
        props.put("type", connector2);
        props.put("host", host);
        props.put("port", port);
        adminClient = AdminClientFactory.createAdminClient(props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient", adminClient);
        }
        return adminClient;
    }

    public void cleanup() {
    }

    public String getGenericProperty(ObjectName scope, String locationPathExpression) throws InvalidResourcePropertyException, WASResourceException {
        String result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGenericProperty", new Object[]{scope, locationPathExpression, this});
        }
        try {
            ConfigService cs = this.getConfigService();
            Object attribute = cs.getAttribute(this.getSession(), scope, locationPathExpression);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute is " + attribute);
            }
            result = attribute.toString();
        }
        catch (ConfigServiceException cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.wsdm.resource.WASResource.getGenericProperty", (String)"253", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting attribute", cse);
            }
            throw new InvalidResourcePropertyException(cse);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wsdm.resource.WASResource.getGenericProperty", (String)"249", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting ConfigService", e);
            }
            throw new WASResourceException("Error getting ConfigService", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericProperty", result);
        }
        return result;
    }

    public AttributeList getGenericProperties(ObjectName scope, String[] attributes, boolean recursive) throws InvalidResourcePropertyException, WASResourceException {
        AttributeList result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGenericProperties", new Object[]{scope, attributes, recursive, this});
        }
        try {
            ConfigService cs = this.getConfigService();
            result = cs.getAttributes(this.getSession(), scope, attributes, recursive);
        }
        catch (ConfigServiceException cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.wsdm.resource.WASResource.getGenericProperty", (String)"253", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting attribute", cse);
            }
            throw new InvalidResourcePropertyException(cse);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wsdm.resource.WASResource.getGenericProperty", (String)"249", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting ConfigService", e);
            }
            throw new WASResourceException("Error getting ConfigService", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericProperties", result);
        }
        return result;
    }

    public void setGenericProperty(ObjectName scope, String name, Object value) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGenericProperty", new Object[]{scope, name, value, this});
        }
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, name, value);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AttributeList is " + attrList);
        }
        this.setGenericProperties(scope, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setGenericProperty");
        }
    }

    public void setGenericProperties(ObjectName scope, AttributeList aList) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGenericProperties", new Object[]{scope, aList, this});
        }
        try {
            ConfigService cs = this.getConfigService();
            cs.setAttributes(this.getSession(), scope, aList);
        }
        catch (ConfigServiceException cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.wsdm.resource.WASResource.getGenericProperty", (String)"253", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting attribute", cse);
            }
            throw new InvalidResourcePropertyException(cse);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wsdm.resource.WASResource.setGenericProperty", (String)"249", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting ConfigService", e);
            }
            throw new WASResourceException("Error getting ConfigService", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setGenericProperties");
        }
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName", this);
        }
        String resourceName = ConfigServiceHelper.getDisplayName(this.configData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName");
        }
        return resourceName;
    }

    public String getVersion() {
        String version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersion", this);
        }
        try {
            WASDirectory wasDirec;
            WASProductInfo prodInfo;
            String wasInstallDir = (String)this.getReferenceProperties().get("WASInstallDir");
            if (wasInstallDir == null || wasInstallDir.equals("")) {
                wasInstallDir = System.getProperty("was.install.root");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WAS install directory is " + wasInstallDir);
            }
            if ((prodInfo = (wasDirec = new WASDirectory(wasInstallDir)).getWASProductInfo("BASE")) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "collect Version info for ND Version");
                }
                prodInfo = wasDirec.getWASProductInfo("ND");
            }
            if (prodInfo == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not base nor ND.  Search any available product version");
                }
                prodInfo = wasDirec.getWASProductInfoInstances()[0];
            }
            version = prodInfo.getVersion();
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception found, return default version", t);
            }
            version = "7.0";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersion", version);
        }
        return version;
    }

    public abstract List getResourceInstances(Session var1, ObjectName var2, String var3) throws UnknownResourceTypeException, WASResourceException;

    protected List getConfigResourceInstanceForCreate(String containmentPath, boolean resolveMbeanID, String resType) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigResourceInstanceForCreate", new Object[]{containmentPath, resolveMbeanID, resType});
        }
        ArrayList<WASResourceReferenceParameters> result = new ArrayList<WASResourceReferenceParameters>();
        try {
            HashMap refProps = this.createRefProps(resType, "NONEXISTENTRESOURCE", null);
            WASResourceReferenceParameters resourceEpr = new WASResourceReferenceParameters("", refProps);
            result.add(resourceEpr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigResourceInstanceForCreate", result);
        }
        return result;
    }

    protected List getConfigResourceInstances(Session session, ObjectName scope, String containmentPath, boolean resolveMbeanID) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigResourceInstances", new Object[]{scope, containmentPath, resolveMbeanID, this});
        }
        ArrayList<WASResourceReferenceParameters> result = new ArrayList<WASResourceReferenceParameters>();
        try {
            ConfigService cs = this.getConfigService();
            ObjectName[] configObjectLists = this.getRelatedObjects(cs, session, scope, containmentPath);
            for (int i = 0; configObjectLists != null && i < configObjectLists.length; ++i) {
                String configType;
                String configDataType = ConfigServiceHelper.getConfigDataType(configObjectLists[i]);
                if (configDataType != null && configDataType.equals("Deployment")) {
                    configDataType = "Application";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Object found is " + configObjectLists[i] + ", type is " + configDataType);
                }
                if ((configType = this.getResourceType()) != null && !configType.equals("") && !configDataType.equals(this.getResourceType())) continue;
                String objectConfigIdString = ConfigServiceHelper.getConfigDataId(configObjectLists[i]).toString();
                HashMap refProps = this.createRefProps(this.getResourceType(), objectConfigIdString, null);
                if (resolveMbeanID) {
                    this.resolveMbeanIDFromConfigID(refProps, objectConfigIdString);
                }
                WASResourceReferenceParameters resourceEpr = new WASResourceReferenceParameters("", refProps);
                result.add(resourceEpr);
            }
        }
        catch (ConfigServiceException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.wsdm.resource.WASResource.getResourceInstances", (String)"332", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occured while resolveing resource type", ex);
            }
            throw new UnknownResourceTypeException(ex);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.wsdm.resource.WASResource.getResourceInstances", (String)"332", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occured while getting resource instances", ex);
            }
            throw new WASResourceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigResourceInstances", result);
        }
        return result;
    }

    protected HashMap createRefProps(String resType, String cfgId, HashMap additionalProps) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRefProps", new Object[]{resType, cfgId, additionalProps});
        }
        HashMap<QName, String> refProps = new HashMap<QName, String>();
        refProps.put(WASResourcesConstants.WAS_WSDM_Resource_Type, this.getResourceType());
        refProps.put(WASResourcesConstants.WAS_WSDM_Resource_MRID, WASResourceUtilities.constructMRID(resType, cfgId));
        refProps.put(WASResourcesConstants.WAS_WSDM_Resource_ConfigID, cfgId);
        if (additionalProps != null) {
            refProps.putAll(additionalProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRefProps", refProps);
        }
        return refProps;
    }

    protected List getMbeanResourceInstancesByType(String mbeanType, boolean resolveConfigID) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanResourceInstancesByType", new Object[]{mbeanType, resolveConfigID, this});
        }
        String queryString = "WebSphere:*,type=" + mbeanType;
        List result = this.getMbeanResourceInstances(queryString, resolveConfigID);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanResourceInstancesByType");
        }
        return result;
    }

    protected List getMbeanResourceInstances(String mbeanQueryString, boolean resolveConfigID) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanResourceInstances", new Object[]{mbeanQueryString, resolveConfigID, this});
        }
        List result = this.getMbeanResourceInstances(mbeanQueryString, resolveConfigID, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanResourceInstances", result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List getMbeanResourceInstances(String mbeanQueryString, boolean resolveConfigID, boolean filterResources) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanResourceInstances", new Object[]{mbeanQueryString, resolveConfigID, filterResources, this});
        }
        ArrayList<WASResourceReferenceParameters> result = new ArrayList<WASResourceReferenceParameters>();
        try {
            try {
                Set allResourceMbans = this.getResourceMbeans(mbeanQueryString);
                Set resourceMbans = filterResources ? this.filterResources(allResourceMbans) : allResourceMbans;
                for (ObjectName resourceMbean : resourceMbans) {
                    WASResourceReferenceParameters resourceEpr = this.getWASReferenceParametersFromMbean(resourceMbean);
                    if (resolveConfigID) {
                        this.resolveConfigIDFromMbeanID(resourceEpr.getReferenceProperties(), this.mbeanIdentifier);
                    }
                    result.add(resourceEpr);
                }
                Object var11_11 = null;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wsdm.resource.Servlet.getResourceInstances", (String)"42", (Object)this);
                if (!tc.isDebugEnabled()) throw new WASResourceException(e);
                Tr.debug(tc, "Exception during getResourceInstances", e);
                throw new WASResourceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "getMbeanResourceInstances", result);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return result;
        Tr.exit(tc, "getMbeanResourceInstances", result);
        return result;
    }

    protected WASResourceReferenceParameters getWASReferenceParametersFromMbean(ObjectName resourceMbean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWASReferenceParametersFromMbean", resourceMbean);
        }
        WASResourceReferenceParameters result = WASResourceUtilities.getWASReferenceParametersFromMbean(resourceMbean);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASReferenceParametersFromMbean", result);
        }
        return result;
    }

    protected void resolveConfigIDFromMbeanID(HashMap refProps, String servletMbeanIdentifier) throws Exception {
    }

    protected void resolveMbeanIDFromConfigID(HashMap refProps, String configID) throws Exception {
    }

    protected Set filterResources(Set unfilteredResource) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterResources", new Object[]{unfilteredResource, this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterResources", unfilteredResource);
        }
        return unfilteredResource;
    }

    public Object getMbeanAttribute(String attribute) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanAttribute", attribute);
        }
        Object result = WASResourceUtilities.getMbeanAttribute(this.mbeanObject, attribute);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanAttribute", result);
        }
        return result;
    }

    public void setMbeanAttribute(String attribute, Object attributeValue) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMbeanAttribute", new Object[]{attribute, attributeValue});
        }
        WASResourceUtilities.setMbeanAttribute(this.mbeanObject, attribute, attributeValue);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMbeanAttribute");
        }
    }

    public Object mbeanInvoke(String operationName, Object[] params, String[] sigs) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvoke", new Object[]{operationName, params, sigs});
        }
        Object result = WASResourceUtilities.mbeanInvoke(this.mbeanObject, operationName, params, sigs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvoke", result);
        }
        return result;
    }

    protected Set getResourceMbeansByType(String mbeanQueryString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceMbeansByType", new Object[]{mbeanQueryString, this});
        }
        Set resMbeans = WASResourceUtilities.getMBeansByType(null, null, mbeanQueryString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceMbeansByType", resMbeans);
        }
        return resMbeans;
    }

    protected Set getResourceMbeans(String mbeanQueryString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceMbeans", new Object[]{mbeanQueryString, this});
        }
        Set resMbeans = WASResourceUtilities.getMbeanByQueryString(mbeanQueryString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceMbeans", resMbeans);
        }
        return resMbeans;
    }

    protected synchronized ObjectName getPerfMbean(ObjectName resourceMbean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPerfMbean", this);
        }
        if (this.perfMbean == null) {
            this.perfMbean = WASResourceUtilities.getPerfMBean(resourceMbean);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerfMbean", this.perfMbean);
        }
        return this.perfMbean;
    }

    protected boolean isManagedProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedProcess", this);
        }
        boolean result = false;
        AdminService adminService = this.getAdminService();
        if (adminService != null) {
            String processType = adminService.getProcessType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ProcessType is " + processType);
            }
            if (!processType.equals("UnManagedProcess") && !processType.equals("DeploymentManager")) {
                result = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedProcess", new Boolean(result));
        }
        return result;
    }

    public List getRelationships(int relationType, boolean recursive) throws WASResourceException {
        return this.getRelationships(this.getResourceType(), relationType, recursive);
    }

    public List getRelationships(String cfgType, int relationType, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationShips", new Object[]{new Integer(relationType), new Boolean(recursive)});
        }
        AttributeList aList = null;
        try {
            aList = configService.getRelationshipsMetaInfo(this.getResourceType());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while getting relationship info", e);
            }
            throw new WASResourceException(e);
        }
        ArrayList refParams = new ArrayList();
        ArrayList<String> childTypes = new ArrayList<String>();
        ArrayList<String> parentTypes = new ArrayList<String>();
        ArrayList<String> types = null;
        if (recursive) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRelationships", refParams);
            }
            throw new WASResourceException("recursive getRelationShips() is not implemented by WASResource. Should be implemented by extending resources.");
        }
        if (relationType == 1 || relationType == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "relationType:", new Integer(relationType));
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRelationships", refParams);
            }
            throw new WASResourceException("getRelationShips() for relationType " + new Integer(relationType) + "is not implemented by WASResource.");
        }
        block2: for (int i = 0; i < aList.size(); ++i) {
            Attribute a;
            int j;
            Attribute at = (Attribute)aList.get(i);
            AttributeList al = (AttributeList)at.getValue();
            String name = at.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name of Attr is " + name);
            }
            if (name.equals("parent") && relationType == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found a parent!");
                }
                for (j = 0; j < al.size(); ++j) {
                    a = (Attribute)al.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "name of sub attr is " + a.getName());
                    }
                    if (!a.getName().equals("_Attribute_MetaInfo_Type")) continue;
                    List pTypes = (List)a.getValue();
                    for (String pType : pTypes) {
                        if (!WASResourceTypeRegistry.getInstance().isValidType(pType)) continue;
                        parentTypes.add(pType);
                    }
                    continue block2;
                }
                continue;
            }
            if (relationType != 1) continue;
            for (j = 0; j < al.size(); ++j) {
                a = (Attribute)al.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name of sub attr is " + a.getName());
                }
                if (!a.getName().equals("_Attribute_MetaInfo_Type")) continue;
                if (!(a.getValue() instanceof String)) continue block2;
                String childType = (String)a.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "val: " + childType);
                }
                if (!WASResourceTypeRegistry.getInstance().isValidType(childType)) continue block2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "val: " + childType);
                }
                childTypes.add(childType);
                continue block2;
            }
        }
        if (relationType != 1) {
            types = parentTypes;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getRelationships", refParams);
            }
            throw new WASResourceException("getRelationships(PARENT) is not implemented by WASResource");
        }
        types = childTypes;
        Iterator itr = types.iterator();
        while (itr.hasNext()) {
            String configType;
            String location = configType = (String)itr.next();
            refParams.addAll(WASResourceManager.getInstance().queryResource(this.getSession(), configType, this.getConfigData(), location));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", refParams);
        }
        return refParams;
    }

    private ObjectName[] getRelatedObjects(ConfigService cs, Session session, ObjectName scope, String containmentPath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelatedObjects", new Object[]{cs, session, scope, containmentPath});
        }
        ObjectName[] objs = null;
        try {
            objs = cs.getRelationship(session, scope, containmentPath);
            for (int i = 0; objs != null && i < objs.length; ++i) {
                objs[i] = cs.queryConfigObjects(session, null, objs[i], null)[0];
            }
        }
        catch (Exception e) {
            objs = null;
        }
        if (objs == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using resolve for ", new Object[]{scope, containmentPath});
            }
            ObjectName[] resolvedObjs = cs.resolve(session, scope, containmentPath);
            ArrayList<ObjectName> oList = new ArrayList<ObjectName>();
            for (int i = 0; resolvedObjs != null && i < resolvedObjs.length; ++i) {
                resolvedObjs[i] = cs.queryConfigObjects(session, null, resolvedObjs[i], null)[0];
                oList.add(resolvedObjs[i]);
            }
            objs = oList.toArray(new ObjectName[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelatedObjects", objs);
        }
        return objs;
    }
}

