/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wasresource.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.ApplyProperties;
import com.ibm.ws.management.commands.properties.resources.common.DeleteProperties;
import com.ibm.ws.management.commands.properties.resources.common.ExtractProperties;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.commands.properties.resources.common.SectionedPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.ValidationError;
import com.ibm.ws.management.commands.properties.resources.mapping.SectionData;
import com.ibm.ws.management.commands.properties.resources.properties.Props;
import com.ibm.ws.management.commands.properties.resources.properties.Section;
import com.ibm.ws.management.wasresource.capability.IConfiguration;
import com.ibm.ws.management.wasresource.capability.IRelationships;
import com.ibm.ws.management.wasresource.capability.ISectionConfiguration;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResource;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceManager;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wasresource.common.WASResourceTypeRegistry;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public abstract class PropWASResource
extends WASResource
implements IConfiguration,
ISectionConfiguration,
IRelationships {
    private static final TraceComponent tc = Tr.register(PropWASResource.class, null, null);
    private String currentResourceType = null;
    private String implementingResourceType = null;
    private String currentAttributeInfo = null;
    private Properties currentMappingData = null;
    private Section[] allSections = null;
    private Section[] currentSections = null;
    private String currentConfigId = null;
    private SectionedProperties[] currentSectionedProperties = null;
    private ObjectName currentConfigObject = null;
    private ObjectName parentObj = null;
    private Section createSection = null;
    private boolean validationError = false;

    private void cleanPrivateVariables() {
        this.currentResourceType = null;
        this.currentAttributeInfo = null;
        this.currentMappingData = null;
        this.allSections = null;
        this.currentSections = null;
        this.currentConfigId = null;
        this.currentSectionedProperties = null;
        this.currentConfigObject = null;
    }

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        try {
            SectionedPropertiesHelper.loadMappingFile(this.getResourceType());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.getReferenceProperties().get("RESOURCETYPE") != null) {
            this.currentResourceType = (String)this.getReferenceProperties().get("RESOURCETYPE");
        }
        this.implementingResourceType = this.getResourceType();
        if (this.getReferenceProperties().get("ATTRIBUTENAME") != null) {
            this.currentAttributeInfo = (String)this.getReferenceProperties().get("ATTRIBUTENAME");
        }
        if (this.getReferenceProperties().get("MAPPINGDATA") != null) {
            this.currentMappingData = (Properties)this.getReferenceProperties().get("MAPPINGDATA");
        }
        if (this.getReferenceProperties().get("SECTIONS") != null) {
            this.currentSections = (Section[])this.getReferenceProperties().get("SECTIONS");
        }
        if (this.getReferenceProperties().get("CURRENTCONFIGID") != null) {
            this.currentConfigId = (String)this.getReferenceProperties().get("CURRENTCONFIGID");
        }
        if (this.getReferenceProperties().get("ALLSECTIONS") != null) {
            this.allSections = (Section[])this.getReferenceProperties().get("ALLSECTIONS");
        }
        ObjectName cObj = super.getConfigData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "config object", cObj);
        }
        if (this.currentResourceType != null && this.implementingResourceType != null && !this.implementingResourceType.equals(this.currentResourceType)) {
            try {
                ConfigService cs = this.getConfigService();
                ObjectName[] oNames = cs.queryConfigObjects(this.getSession(), cObj, ConfigServiceHelper.createObjectName(null, this.currentResourceType), null);
                if (oNames != null && oNames.length > 0) {
                    cObj = oNames[0];
                }
                this.setConfigData(cObj);
                if (cObj != null) {
                    this.setConfigID(ConfigServiceHelper.getConfigDataId(cObj).toString());
                }
            }
            catch (Exception e) {
                throw new WASResourceInitializeException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{scope, containmentPath, this});
        }
        List result = null;
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = this.getResourceType();
        }
        result = containmentPath.equals("NONEXISTENTRESOURCE") ? super.getConfigResourceInstanceForCreate(containmentPath, false, this.getResourceType()) : super.getConfigResourceInstances(session, scope, containmentPath, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances");
        }
        return result;
    }

    public SectionedProperties[] getSectionedProperties(String configType) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSectionedProperties", configType);
        }
        Section[] sections = this.allSections;
        Section[] selectedSections = this.findAllSectionsByResourceType(sections, configType);
        ArrayList<SectionedProperties> spList = new ArrayList<SectionedProperties>();
        for (int i = 0; i < selectedSections.length; ++i) {
            Section section = selectedSections[i];
            SectionedProperties sp = this.createSectionedProperties(this.getSectionData(section), section.getCfgId(), section.getProperties());
            spList.add(sp);
        }
        SectionedProperties[] sps = null;
        if (spList.size() > 0) {
            sps = spList.toArray(new SectionedProperties[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSectionedProperties", sps);
        }
        return sps;
    }

    public SectionedProperties getSectionedPropertiesByResourceId(String configId) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSectionedPropertiesByResourceId", configId);
        }
        Section[] sections = this.allSections;
        Section[] selectedSections = this.findAllSectionsByResourceId(sections, this.configID);
        SectionedProperties sectionedProperty = null;
        ArrayList<SectionedProperties> spList = new ArrayList<SectionedProperties>();
        for (int i = 0; i < selectedSections.length; ++i) {
            Section section = selectedSections[i];
            SectionedProperties sp = this.createSectionedProperties(this.getSectionData(section), section.getCfgId(), section.getProperties());
            spList.add(sp);
        }
        if (spList.size() > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is more than one matching entry for ", configId);
            }
        } else if (spList.size() == 1) {
            sectionedProperty = (SectionedProperties)spList.get(0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSectionedPropertiesByResourceId", sectionedProperty);
        }
        return sectionedProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SectionedProperties[] getSectionedProperties() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSectionedProperties");
        }
        HashMap refProps = this.getReferenceProperties();
        HashMap oldRefProps = new HashMap();
        oldRefProps.putAll(refProps);
        String savedConfigId = this.getConfigID();
        ObjectName savedConfigData = this.getConfigData();
        SectionedProperties[] result = null;
        try {
            ArrayList sectionedPropertiesList = new ArrayList();
            ObjectName configId = this.getConfigData();
            String configType = this.getResourceType();
            SectionData[] sections = null;
            String resourceType = this.getResourceType();
            sections = resourceType.equals("GenericType") ? SectionedPropertiesHelper.getSections(this.getConfigData()) : SectionedPropertiesHelper.getSections(resourceType);
            if (sections != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Total sections : ", new Integer(sections.length));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No section found for : ", resourceType);
                }
            }
            String sectionNumber = "1.0";
            result = this.getSectionedProperties(sections, configId, configType, sectionNumber, true);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset configId and configData ", new Object[]{savedConfigData, savedConfigId});
            }
            this.cleanPrivateVariables();
            this.initialize(oldRefProps);
            this.setConfigData(savedConfigData);
            this.setConfigID(savedConfigId);
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Reset configId and configData ", new Object[]{savedConfigData, savedConfigId});
        }
        this.cleanPrivateVariables();
        this.initialize(oldRefProps);
        this.setConfigData(savedConfigData);
        this.setConfigID(savedConfigId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSectionedProperties", result);
        }
        return result;
    }

    private boolean isFiltered(String cType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFiltered", this.getResourceType());
        }
        boolean filtered = false;
        String[] types = (String[])this.getReferenceProperties().get("SELECTEDSUBTYPES");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "selected types ", types);
        }
        if (types != null && types.length > 0) {
            filtered = true;
            for (int i = 0; i < types.length; ++i) {
                if (!cType.equals(types[i])) continue;
                filtered = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFiltered", new Boolean(filtered));
        }
        return filtered;
    }

    private boolean isFiltered() {
        return this.isFiltered(this.getResourceType());
    }

    private SectionedProperties[] getSectionedProperties(SectionData[] sections, ObjectName configId, String configType, String sectionNumber, boolean firstTime) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSectionedProperties", new Object[]{sections, configId, configType});
        }
        ArrayList<SectionedProperties> sectionedPropertiesList = new ArrayList<SectionedProperties>();
        SectionedProperties[] result = null;
        Stack<ConfigIdAndType> nestedConfigIds = new Stack<ConfigIdAndType>();
        if (configId != null) {
            ConfigIdAndType nestedObject = new ConfigIdAndType(configId, configType, sectionNumber);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pushing ", nestedObject);
            }
            nestedConfigIds.push(nestedObject);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "not pushing ", new Object[]{configId, configType});
        }
        int sectionId = 0;
        String lastConfigType = configType;
        for (int i = 0; sections != null && i < sections.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handling section : ", sections[i]);
            }
            SectionData section = sections[i];
            String containingType = sections[i].getContainingType();
            String currentType = sections[i].getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Containing type " + containingType + " configtype " + configType);
            }
            boolean expandSection = true;
            if (containingType != null && !containingType.equals(configType)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "poping nested sections for ", containingType);
                }
                ConfigIdAndType parent = null;
                boolean found = false;
                ConfigIdAndType searchObject = new ConfigIdAndType(null, containingType, sectionNumber);
                if (nestedConfigIds.search(searchObject) != -1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "object present ", parent);
                    }
                    while (!nestedConfigIds.empty()) {
                        parent = (ConfigIdAndType)nestedConfigIds.pop();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "poped ", parent);
                        }
                        if (!parent.getCfgType().equals(containingType) || parent.getCfgId() == null) continue;
                        found = true;
                        break;
                    }
                }
                if (found) {
                    configId = parent.getCfgId();
                    configType = parent.getCfgType();
                    sectionNumber = parent.getSectionNumber();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "section number from parent ", sectionNumber);
                    }
                    sectionId = parent.incSubSection();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sub section number from parent ", new Integer(sectionId));
                    }
                    sectionNumber = ConfigPropertiesHelper.nextSectionNumber(sectionNumber, sectionId, true);
                    expandSection = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configId ", configId);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pushing back ", parent);
                    }
                    nestedConfigIds.push(parent);
                } else if (!firstTime || i != 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Skipping this section as there is no parent object : ", section);
                    continue;
                }
            }
            lastConfigType = currentType;
            if (expandSection) {
                sectionNumber = firstTime && i == 1 ? ConfigPropertiesHelper.nextSectionNumber(sectionNumber, sectionId, true) : ConfigPropertiesHelper.nextSectionNumber(sectionNumber, sectionId, false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Moving on to the next child. Trying to increment the parent's subsection number.");
                }
                ConfigIdAndType parentObject = null;
                for (int m = nestedConfigIds.size() - 1; m >= 0; --m) {
                    parentObject = (ConfigIdAndType)nestedConfigIds.get(m);
                    if (!parentObject.getCfgType().equals(containingType) || parentObject.getCfgId() == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found parent Object and will increment the subsection number.", parentObject);
                    }
                    parentObject.incSubSection();
                    break;
                }
            }
            if (this.getReferenceProperties().get("GENERATETEMPLATE") != null) {
                SectionedProperties[] sectionedPropertiesForCreate = this.getPropertiesRequiredToCreate(section, configId, section.getType());
                if (sectionedPropertiesForCreate != null && sectionedPropertiesForCreate.length > 0) {
                    for (int l = 0; sectionedPropertiesForCreate != null && sectionedPropertiesForCreate.length > 0 && l < sectionedPropertiesForCreate.length; ++l) {
                        sectionedPropertiesList.add(sectionedPropertiesForCreate[l]);
                    }
                }
                SectionedProperties[] sectionedPropertiesForDelete = this.getPropertiesRequiredToDelete(section, configId, section.getType());
                for (int l = 0; sectionedPropertiesForDelete != null && sectionedPropertiesForDelete.length > 0 && l < sectionedPropertiesForDelete.length; ++l) {
                    sectionedPropertiesList.add(sectionedPropertiesForDelete[l]);
                }
            }
            if (section.isCollection()) {
                String collectionSectionNumber = sectionNumber;
                if (expandSection) {
                    collectionSectionNumber = ConfigPropertiesHelper.nextSectionNumber(sectionNumber, 0, true);
                }
                SectionData[] relatedSections = this.getRelatedSections(sections, i);
                i += relatedSections.length - 1;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Total collected sections processed : ", new Integer(relatedSections.length));
                }
                SectionedProperties[] collectionProps = this.getPropertiesForCollectionType(relatedSections, configId, configType, sectionedPropertiesList, collectionSectionNumber);
                for (int j = 0; collectionProps != null && j < collectionProps.length; ++j) {
                    if (this.isFiltered(collectionProps[j].getResourceType())) continue;
                    sectionedPropertiesList.add(collectionProps[j]);
                }
            } else {
                SectionedProperties sectionedProperties = this.getPropertiesForThisSection(section, configId, configType, sectionedPropertiesList, sectionNumber);
                if (sectionedProperties != null) {
                    if (sectionedProperties.getConfigData() != null) {
                        ConfigIdAndType nestedObject = new ConfigIdAndType(sectionedProperties.getConfigData(), section.getType(), sectionNumber);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "pushing ", nestedObject);
                        }
                        nestedConfigIds.push(nestedObject);
                    } else if (!(section.getType() != null && section.getType().equals("EndPoint") && section.getContainingType() != null && section.getContainingType().equals("Server") || section.getType() != null && section.getType().equals("AuthorizationGroup"))) {
                        SectionData[] relatedSections = this.getRelatedSections(sections, i);
                        i += relatedSections.length - 1;
                    }
                    if (!this.isFiltered(sectionedProperties.getResourceType())) {
                        sectionedPropertiesList.add(sectionedProperties);
                    }
                }
            }
            ++sectionId;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Remaining Sections : ", new Integer(sections.length - i));
        }
        result = sectionedPropertiesList.toArray(new SectionedProperties[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSectionedProperties", result);
        }
        return result;
    }

    public String getCurrentResourceType() {
        return this.currentResourceType;
    }

    public String getCurrentConfigId() {
        return this.currentConfigId;
    }

    public void setCurrentResourceType(String crtype) {
        this.currentResourceType = crtype;
    }

    private SectionedProperties[] getPropertiesForCollectionType(SectionData[] sections, ObjectName configId, String configType, List previousSectionedProperties, String sectionNumber) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesForCollectionType", new Object[]{sections, configId, configType, previousSectionedProperties});
        }
        SectionedProperties[] sectionedProperties = null;
        ArrayList<SectionedProperties> spList = new ArrayList<SectionedProperties>();
        ObjectName[] configIds = null;
        if (sections[0].getType() != null && !configType.equals(sections[0].getType())) {
            try {
                String location = sections[0].getType() + "=";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "querying ", new Object[]{configId, location});
                }
                configIds = this.getConfigService().resolve(this.getSession(), configId, location);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Objects Found for this type " + sections[0].getType() + " in ", configId);
                }
                return sectionedProperties;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Query returned", configIds);
            }
        }
        SectionData[] nestedSections = null;
        if (sections.length > 1) {
            nestedSections = new SectionData[sections.length - 1];
            for (int k = 1; k < sections.length; ++k) {
                nestedSections[k - 1] = sections[k];
            }
        }
        for (int i = 0; configIds != null && i < configIds.length; ++i) {
            sectionNumber = ConfigPropertiesHelper.nextSectionNumber(sectionNumber, i, false);
            void cfgId = configIds[i];
            String cfgType = sections[0].getType();
            SectionedProperties sp = this.getPropertiesForThisSection(sections[0], (ObjectName)cfgId, cfgType, null, sectionNumber);
            if (sp == null) continue;
            spList.add(sp);
            if (nestedSections == null) continue;
            String nestedSectionNumber = ConfigPropertiesHelper.nextSectionNumber(sectionNumber, 0, true);
            SectionedProperties[] nestedProps = this.getSectionedProperties(nestedSections, (ObjectName)cfgId, cfgType, nestedSectionNumber, false);
            for (int j = 0; nestedProps != null && j < nestedProps.length; ++j) {
                spList.add(nestedProps[j]);
            }
        }
        sectionedProperties = spList.toArray(new SectionedProperties[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesForCollectionType", sectionedProperties);
        }
        return sectionedProperties;
    }

    private SectionedProperties getPropertiesForThisSection(SectionData section, ObjectName configId, String configType, List previousSectionedProperties, String sectionNumber) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesForThisSection", new Object[]{section, configId, configType, previousSectionedProperties});
        }
        SectionedProperties sectionedProperties = new SectionedProperties();
        sectionedProperties.setSectionNumber(sectionNumber);
        SectionedPropertiesHelper.setCommonSectionProperties(sectionedProperties, section);
        sectionedProperties.setImplementingResourceType(this.getResourceType());
        ObjectName oldConfigId = configId;
        if (section.getType() != null && !configType.equals(section.getType())) {
            block42: {
                try {
                    String location = section.getType() + "=";
                    ObjectName[] ons = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " resolving ", location);
                    }
                    if (section.getAttrName() == null || section.getAttrName().equals("")) {
                        ons = this.getConfigService().resolve(this.getSession(), configId, location);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " resolved ", ons);
                    }
                    if (ons != null && ons.length == 0) {
                        configId = null;
                        break block42;
                    }
                    if (ons != null && ons.length == 1) {
                        configId = ons[0];
                        break block42;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " Checking attribute ", new Object[]{configId, section.getAttrName()});
                    }
                    String aName = section.getAttrName();
                    Object obj = null;
                    if (section.getType().equals("J2EEResourcePropertySet")) {
                        aName = "propertySet";
                        try {
                            obj = this.getConfigService().getAttribute(this.getSession(), configId, aName, false);
                        }
                        catch (Exception e) {
                            aName = "complexPropertySet";
                            obj = this.getConfigService().getAttribute(this.getSession(), configId, aName, false);
                        }
                    } else {
                        obj = this.getConfigService().getAttribute(this.getSession(), configId, aName, false);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " cids ", obj);
                    }
                    if (obj == null) {
                        configId = null;
                    } else if (obj instanceof ArrayList) {
                        ArrayList lst = (ArrayList)obj;
                        if (lst.size() == 1) {
                            configId = (ObjectName)lst.get(0);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " Too many objects ", lst);
                            }
                            configId = null;
                            for (int i = 0; i < lst.size(); ++i) {
                                ObjectName on = (ObjectName)lst.get(i);
                                String ot = ConfigServiceHelper.getConfigDataType(on);
                                if (ot == null || !ot.equals(section.getType())) continue;
                                configId = on;
                                break;
                            }
                        }
                    } else if (obj instanceof Attribute) {
                        Attribute at = (Attribute)obj;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " Attribute ", new Object[]{at.getValue(), at.getName()});
                        }
                        configId = (ObjectName)at.getValue();
                    } else if (obj instanceof ObjectName) {
                        configId = (ObjectName)obj;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " configId ", configId);
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No Objects Found for this type " + section.getType() + "in " + configId);
                    }
                    configId = null;
                }
            }
            if (configId == null && this.getResourceType().equals("GenericType")) {
                configId = oldConfigId;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Query returned", configId);
            }
        }
        if (!(configId != null || section.getType() != null && section.getType().equals("EndPoint") && section.getContainingType() != null && section.getContainingType().equals("Server") || section.getType() != null && section.getType().equals("AuthorizationGroup"))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesForThisSection", null);
            }
            return null;
        }
        if (configId != null) {
            sectionedProperties.setResourceId(ConfigServiceHelper.getConfigDataId(configId).toString());
            sectionedProperties.setConfigData(configId);
        } else if (section.getType() != null && section.getType().equals("AuthorizationGroup")) {
            String cId = (String)this.getReferenceProperties().get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
            sectionedProperties.setResourceId(cId);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null configId. Using configId of resource ", this.getConfigID());
            }
            sectionedProperties.setResourceId(this.getConfigID());
        }
        Properties props = new Properties();
        try {
            props = this.getPropertiesFromResourceImplementation(section, configId == null ? oldConfigId : configId);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ExtractProperties failed", e);
            }
            throw new WASResourceException(e);
        }
        sectionedProperties.setConfigProperties(props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesForThisSection", sectionedProperties);
        }
        return sectionedProperties;
    }

    private SectionedProperties[] getPropertiesRequiredToCreate(SectionData sectionData, ObjectName configId, String configType) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesRequiredToCreate", new Object[]{sectionData, configId, configType});
        }
        SectionedProperties[] sp = null;
        HashMap refProps = this.getReferenceProperties();
        HashMap oldRefProps = new HashMap();
        oldRefProps.putAll(refProps);
        ObjectName savedConfigData = this.getConfigData();
        String savedConfigId = this.getConfigID();
        try {
            try {
                refProps.put("RESOURCETYPE", configType);
                refProps.put("IMPLEMENTINGRESOURCETYPE", this.getResourceType());
                if (configId != null) {
                    refProps.put("CURRENTCONFIGID", ConfigServiceHelper.getConfigDataId(configId).toString());
                }
                refProps.put("CREATERESOURCE", new Boolean(true));
                this.initialize(refProps);
                try {
                    sp = this.getCreateTemplateProperties();
                }
                catch (Exception e) {
                    sp = null;
                }
                Object var11_11 = null;
            }
            catch (Exception e) {
                throw new WASResourceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.initialize(oldRefProps);
            this.setConfigData(savedConfigData);
            this.setConfigID(savedConfigId);
            throw throwable;
        }
        this.initialize(oldRefProps);
        this.setConfigData(savedConfigData);
        this.setConfigID(savedConfigId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesRequiredToCreate", sp);
        }
        return sp;
    }

    private SectionedProperties[] getPropertiesRequiredToDelete(SectionData sectionData, ObjectName configId, String configType) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesRequiredToDelete", new Object[]{sectionData, configId, configType});
        }
        SectionedProperties[] sp = null;
        HashMap refProps = this.getReferenceProperties();
        HashMap oldRefProps = new HashMap();
        oldRefProps.putAll(refProps);
        ObjectName savedConfigData = this.getConfigData();
        String savedConfigId = this.getConfigID();
        try {
            try {
                refProps.put("RESOURCETYPE", configType);
                refProps.put("IMPLEMENTINGRESOURCETYPE", this.getResourceType());
                if (configId != null) {
                    refProps.put("CURRENTCONFIGID", ConfigServiceHelper.getConfigDataId(configId).toString());
                }
                refProps.put("DELETERESOURCE", new Boolean(true));
                this.initialize(refProps);
                try {
                    sp = this.getDeleteTemplateProperties();
                }
                catch (Exception e) {
                    sp = null;
                }
                Object var11_11 = null;
            }
            catch (Exception e) {
                throw new WASResourceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.initialize(oldRefProps);
            this.setConfigData(savedConfigData);
            this.setConfigID(savedConfigId);
            throw throwable;
        }
        this.initialize(oldRefProps);
        this.setConfigData(savedConfigData);
        this.setConfigID(savedConfigId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesRequiredToDelete", sp);
        }
        return sp;
    }

    private SectionData[] getRelatedSections(SectionData[] sections, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelatedSections", new Object[]{sections, new Integer(i)});
        }
        SectionData[] relatedSections = null;
        String prevContainingType = sections[i].getContainingType();
        ArrayList<SectionData> commonSections = new ArrayList<SectionData>();
        commonSections.add(sections[i]);
        String prevType = sections[i].getType();
        ArrayList<String> containingTypes = new ArrayList<String>();
        containingTypes.add(prevType);
        if (prevContainingType != null) {
            ++i;
            while (i < sections.length) {
                SectionData s = sections[i];
                String containType = s.getContainingType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "section info ", new Object[]{s.getType(), containType});
                }
                if (containType == null || containType.equals(prevContainingType)) break;
                if (prevType != null && containType.equals(prevType)) {
                    commonSections.add(s);
                } else {
                    if (!containingTypes.contains(containType)) break;
                    commonSections.add(s);
                }
                prevType = s.getType();
                if (!containingTypes.contains(prevType)) {
                    containingTypes.add(prevType);
                }
                ++i;
            }
        }
        relatedSections = commonSections.toArray(new SectionData[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelatedSections", relatedSections);
        }
        return relatedSections;
    }

    public void createSectionedProperties(Section[] sections) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSectionedProperties", sections);
        }
        ConfigService cs = null;
        try {
            cs = this.getConfigService();
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSectionedProperties No configservice object");
            }
            return;
        }
        Session session = this.getSession();
        if (sections[0].getCreateDeleteCommandProperties() != null || sections[0].isCreateTemplate() || sections[0].isDeleteTemplate()) {
            this.getReferenceProperties().put("USECOMMANDS", new Boolean(true));
            this.getReferenceProperties().put("SECTIONS", sections);
            this.setProperties(sections[0].getProperties());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSectionedProperties handled by commands");
            }
            return;
        }
        for (int i = 0; i < sections.length; ++i) {
            List commonSectionsList = ConfigPropertiesHelper.getCommonSections(sections, i);
            i = i + commonSectionsList.size() - 1;
            Section[] commonSections = ConfigPropertiesHelper.removeSkippedSections(commonSectionsList);
            if (commonSections.length < 1) continue;
            for (int j = 0; j < commonSections.length; ++j) {
                String configId;
                Section s = commonSections[j];
                String objType = s.getType();
                String resType = s.getImplementingResourceType();
                if (ConfigPropertiesHelper.resourceExists(cs, session, resType, objType, configId = s.getCfgId(), null, ConfigPropertiesHelper.getNameProperty(s))) continue;
                if (s.canCreate()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No object found in config tree for this config id and will be created ", configId);
                    }
                    this.logReport("ADMG0803I", new Object[]{configId});
                    ArrayList<Section> cSecList = new ArrayList<Section>();
                    cSecList.add(s);
                    Section[] cSections = cSecList.toArray(new Section[0]);
                    this.createSection = s;
                    if (configId != null && ConfigPropertiesHelper.isConfigId(configId)) {
                        this.parentObj = this.getParentObj(sections, s, i);
                    }
                    if (configId == null || configId.equals("null")) continue;
                    this.createResource(cs, session, resType, objType, configId, cSections);
                    continue;
                }
                configId = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No object found in config tree for this config id and will not be created because, create is disabled for this section ", configId);
                }
                this.logReport("ADMG0804I", new Object[]{configId});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSectionedProperties");
        }
    }

    private void logReport(String key, Object[] objs) {
        try {
            FileOutputStream os = (FileOutputStream)this.getReferenceProperties().get("REPORTFILE_OS");
            if (os != null) {
                ConfigPropertiesHelper.logReport(os, key, objs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int skipCreateDeleteSections(Section[] sections) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "skipCreateDeleteSections", sections);
        }
        int cnt = 0;
        for (int i = 0; sections != null && i < sections.length; ++i) {
            if (sections[i].isCreateTemplate() || sections[i].isDeleteTemplate()) {
                ++cnt;
                continue;
            }
            if (sections[i].getCreateDeleteCommandProperties() == null || !sections[i].getCreateDeleteCommandProperties().equals("true")) continue;
            ++cnt;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "skipCreateDeleteSections", new Integer(cnt));
        }
        return cnt;
    }

    private int skipCreateDeleteTemplateSections(Section[] sections) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "skipCreateDeleteTempalteSections", sections);
        }
        int cnt = 0;
        for (int i = 0; sections != null && i < sections.length; ++i) {
            if (!sections[i].isCreateTemplate() && !sections[i].isDeleteTemplate()) continue;
            ++cnt;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "skipCreateDeleteTemplateSections", new Integer(cnt));
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List validateSectionedProperties(Section[] sections) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSectionedProperties", sections);
        }
        ArrayList<ValidationError> errList = new ArrayList<ValidationError>();
        HashMap refProps = this.getReferenceProperties();
        HashMap oldRefProps = new HashMap();
        oldRefProps.putAll(refProps);
        String savedConfigId = this.getConfigID();
        ObjectName savedConfigData = this.getConfigData();
        int skipedSections = this.skipCreateDeleteSections(sections);
        if (skipedSections > 0) {
            ArrayList<Section> createSections = new ArrayList<Section>();
            for (int i = 0; i < skipedSections; ++i) {
                createSections.add(sections[i]);
            }
            Section[] cSections = createSections.toArray(new Section[0]);
            this.getReferenceProperties().put("VALIDATERESOURCE", new Boolean(true));
            try {
                this.createSectionedProperties(cSections);
                Object var11_12 = null;
                this.getReferenceProperties().remove("VALIDATERESOURCE");
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.getReferenceProperties().remove("VALIDATERESOURCE");
                throw throwable;
            }
            {
            }
        }
        for (int i = skipedSections; sections != null && i < sections.length; ++i) {
            Object var16_20;
            Section section = sections[i];
            SectionData sectionData = this.getSectionData(section);
            try {
                block13: {
                    try {
                        Section[] subSections;
                        if (section.canApply()) {
                            subSections = PropWASResource.getSubSections(sections, i);
                            i += subSections.length - 1;
                            this.createSectionedProperties(subSections);
                            for (int j = 0; j < subSections.length; ++j) {
                                sectionData = this.getSectionData(subSections[j]);
                                String[] res = this.validateProperties(sectionData, subSections[j]);
                                if (res == null || res.length <= 0) continue;
                                ValidationError valErr = new ValidationError(sectionData, subSections[j], res);
                                errList.add(valErr);
                            }
                            break block13;
                        }
                        if (!section.skipSubSections()) break block13;
                        subSections = PropWASResource.getSubSections(sections, i);
                        i += subSections.length - 1;
                    }
                    catch (Exception e) {
                        throw new WASResourceException(e);
                    }
                }
                var16_20 = null;
                this.cleanPrivateVariables();
            }
            catch (Throwable throwable) {
                var16_20 = null;
                this.cleanPrivateVariables();
                this.initialize(oldRefProps);
                this.setConfigData(savedConfigData);
                this.setConfigID(savedConfigId);
                throw throwable;
            }
            this.initialize(oldRefProps);
            this.setConfigData(savedConfigData);
            this.setConfigID(savedConfigId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateSectionedProperties", errList);
        }
        return errList;
    }

    public void setSectionedProperties(Section[] sections) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSectionedProperties", sections);
        }
        HashMap refProps = this.getReferenceProperties();
        HashMap oldRefProps = new HashMap();
        oldRefProps.putAll(refProps);
        String savedConfigId = this.getConfigID();
        ObjectName savedConfigData = this.getConfigData();
        int skipedSections = this.skipCreateDeleteSections(sections);
        if (skipedSections > 0) {
            ArrayList<Section> createSections = new ArrayList<Section>();
            for (int i = 0; i < skipedSections; ++i) {
                createSections.add(sections[i]);
            }
            Section[] cSections = createSections.toArray(new Section[0]);
            this.createSectionedProperties(cSections);
        }
        for (int i = skipedSections; sections != null && i < sections.length; ++i) {
            Object var13_15;
            Section section = sections[i];
            SectionData sectionData = this.getSectionData(section);
            try {
                block11: {
                    try {
                        Section[] subSections;
                        if (section.canApply()) {
                            subSections = PropWASResource.getSubSections(sections, i);
                            i += subSections.length - 1;
                            this.createSectionedProperties(subSections);
                            for (int j = 0; j < subSections.length; ++j) {
                                sectionData = this.getSectionData(subSections[j]);
                                this.setProperties(sectionData, subSections[j]);
                            }
                            break block11;
                        }
                        if (!section.skipSubSections()) break block11;
                        subSections = PropWASResource.getSubSections(sections, i);
                        i += subSections.length - 1;
                    }
                    catch (Exception e) {
                        throw new WASResourceException(e);
                    }
                }
                var13_15 = null;
                this.cleanPrivateVariables();
            }
            catch (Throwable throwable) {
                var13_15 = null;
                this.cleanPrivateVariables();
                this.initialize(oldRefProps);
                this.setConfigData(savedConfigData);
                this.setConfigID(savedConfigId);
                throw throwable;
            }
            this.initialize(oldRefProps);
            this.setConfigData(savedConfigData);
            this.setConfigID(savedConfigId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSectionedProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deleteSectionedProperties(Section[] sections) throws WASResourceException {
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteSectionedProperties", sections);
            }
            HashMap refProps = this.getReferenceProperties();
            HashMap oldRefProps = new HashMap();
            oldRefProps.putAll(refProps);
            ObjectName savedConfigData = this.getConfigData();
            String savedConfigId = this.getConfigID();
            if (!sections[0].canDeleteWholeSection()) break block19;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "delete whole section including subsections ");
            }
            this.deleteProperties(sections);
            Object var13_6 = null;
            try {
                this.cleanPrivateVariables();
                this.initialize(oldRefProps);
                this.setConfigData(savedConfigData);
                this.setConfigID(savedConfigId);
            }
            catch (Exception e) {
                // empty catch block
            }
            {
                block19: {
                    return;
                }
                int skipedSections = this.skipCreateDeleteSections(sections);
                if (skipedSections > 0) {
                    ArrayList<Section> deleteSections = new ArrayList<Section>();
                    for (int i = 0; i < skipedSections; ++i) {
                        deleteSections.add(sections[i]);
                    }
                    Section[] dSections = deleteSections.toArray(new Section[0]);
                    this.deleteProperties(dSections);
                }
                for (int i = skipedSections; sections != null && i < sections.length; ++i) {
                    Section section = sections[i];
                    SectionData sectionData = this.getSectionData(section);
                    try {
                        Section[] subSections;
                        if (section.canDelete()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "delete this section", section);
                            }
                            subSections = PropWASResource.getSubSections(sections, i);
                            i += subSections.length - 1;
                            if (section.canDeleteWholeSection()) {
                                this.deleteProperties(subSections);
                                continue;
                            }
                            for (int j = 0; j < subSections.length; ++j) {
                                sectionData = this.getSectionData(subSections[j]);
                                if (!subSections[j].canDelete()) continue;
                                this.deleteProperties(sectionData, subSections[j]);
                            }
                            continue;
                        }
                        if (!section.skipSubSections()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "skiping sub sections", section);
                        }
                        subSections = PropWASResource.getSubSections(sections, i);
                        i += subSections.length - 1;
                        continue;
                    }
                    catch (Exception e) {
                        throw new WASResourceException(e);
                    }
                }
            }
            Object var13_7 = null;
            try {
                this.cleanPrivateVariables();
                this.initialize(oldRefProps);
                this.setConfigData(savedConfigData);
                this.setConfigID(savedConfigId);
            }
            catch (Exception e) {}
            break block20;
            catch (Throwable throwable) {
                Object var13_8 = null;
                try {
                    this.cleanPrivateVariables();
                    this.initialize(oldRefProps);
                    this.setConfigData(savedConfigData);
                    this.setConfigID(savedConfigId);
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteSectionedProperties");
        }
    }

    public String getUniqueId() throws WASResourceException {
        return null;
    }

    public List getRelationships(int relationType, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationShips", new Object[]{new Integer(relationType), new Boolean(recursive)});
        }
        ArrayList refParams = new ArrayList();
        ArrayList childTypes = new ArrayList();
        String[] types = null;
        if (recursive) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRelationships", refParams);
            }
            throw new WASResourceException("recursive getRelationShips() is not implemented. Should be implemented by extending resources.");
        }
        if (relationType == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "relationType:", new Integer(relationType));
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRelationships", refParams);
            }
            throw new WASResourceException("getRelationShips() for relationType " + new Integer(relationType) + "is not implemented by WASResource.");
        }
        types = SectionedPropertiesHelper.getSubTypes(this.getResourceType());
        for (int i = 0; types != null && i < types.length; ++i) {
            String configType = types[i];
            if (!WASResourceTypeRegistry.getInstance().isValidType(configType)) continue;
            String location = configType;
            List lst = WASResourceManager.getInstance().queryResource(this.getSession(), configType, this.getConfigData(), location);
            if (lst == null) continue;
            refParams.addAll(lst);
        }
        List refParamsNonPropBased = super.getRelationships(relationType, recursive);
        for (int i = 0; refParamsNonPropBased != null && i < refParamsNonPropBased.size(); ++i) {
            if (!this.matchFound(refParams, refParamsNonPropBased.get(i))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding :", refParamsNonPropBased.get(i));
                }
                refParams.add(refParamsNonPropBased.get(i));
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Not adding :", refParamsNonPropBased.get(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationShips", refParams);
        }
        return refParams;
    }

    private boolean matchFound(List refParams, Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchFound", new Object[]{refParams, obj});
        }
        boolean result = false;
        if (obj instanceof WASResourceReferenceParameters) {
            WASResourceReferenceParameters refParam = (WASResourceReferenceParameters)obj;
            for (int i = 0; refParams != null && i < refParams.size(); ++i) {
                WASResourceReferenceParameters rp;
                if (!(refParams.get(i) instanceof WASResourceReferenceParameters) || !(rp = (WASResourceReferenceParameters)refParams.get(i)).getReferenceProperties().equals(refParam.getReferenceProperties())) continue;
                result = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchFound", new Boolean(result));
        }
        return result;
    }

    public boolean supportsSections() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportsSection", this.getResourceType());
        }
        boolean result = SectionedPropertiesHelper.supportsSection(this.getResourceType());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportsSection", new Boolean(result));
        }
        return result;
    }

    public String getPropertyFromSection(String sectionId, String name) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyFromSection", new Object[]{sectionId, name});
        }
        Object propValue = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyFromSection", propValue);
        }
        throw new WASResourceException("getPropertyFromSection() not implemented");
    }

    public void setPropertyInSection(String sectionId, String name, String value) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropertyInSection", new Object[]{sectionId, name, value});
        }
        Object propValue = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyFromSection", propValue);
        }
        throw new WASResourceException("getPropertyFromSection() not implemented");
    }

    private String createResource(ConfigService cs, Session session, String resType, String objType, String configId, Section[] sections) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResource", new Object[]{cs, session, resType, objType, configId, sections});
        }
        String res = null;
        String currConfigType = objType;
        String currConfigId = configId;
        for (int i = 0; i < sections.length; ++i) {
            String resId = this.createResource(cs, session, resType, currConfigType, currConfigId, sections[i]);
            if (res == null) {
                res = resId;
            }
            if (res == null) break;
            currConfigType = ConfigServiceHelper.getConfigDataType(ConfigServiceHelper.createObjectName(new ConfigDataId(resId)));
            currConfigId = resId;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResource", res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createResource(ConfigService cs, Session session, String resType, String objType, String configId, Section section) throws WASResourceException {
        String res;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createResource", new Object[]{cs, session, resType, objType, configId, section});
            }
            res = null;
            HashMap refProps = this.getReferenceProperties();
            HashMap oldRefProps = new HashMap();
            oldRefProps.putAll(refProps);
            ObjectName savedConfigData = this.getConfigData();
            String savedConfigId = this.getConfigID();
            try {
                try {
                    refProps.put("RESOURCETYPE", objType);
                    refProps.put("IMPLEMENTINGRESOURCETYPE", resType);
                    refProps.put("CURRENTCONFIGID", configId);
                    refProps.put("CREATERESOURCE", new Boolean(true));
                    Section[] sections = new Section[]{section};
                    refProps.put("SECTIONS", sections);
                    SectionData sectionData = this.getSectionData(section);
                    if (sectionData != null) {
                        Properties mappingData = sectionData.getPropertiesToAttributesMapping();
                        refProps.put("MAPPINGDATA", mappingData);
                    }
                    this.initialize(refProps);
                    Properties props = section.getProperties();
                    this.setProperties(props);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "set properties done");
                    }
                    res = ConfigPropertiesHelper.getConfigId(cs, session, resType, objType, configId, null);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createResource", e);
                    }
                    Object var16_17 = null;
                    this.initialize(oldRefProps);
                    this.setConfigData(savedConfigData);
                    this.setConfigID(savedConfigId);
                    break block9;
                }
                Object var16_16 = null;
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                this.initialize(oldRefProps);
                this.setConfigData(savedConfigData);
                this.setConfigID(savedConfigId);
                throw throwable;
            }
            this.initialize(oldRefProps);
            this.setConfigData(savedConfigData);
            this.setConfigID(savedConfigId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResource", res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProperties(Section[] sections) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteProperties", sections);
        }
        HashMap refProps = this.getReferenceProperties();
        HashMap oldRefProps = new HashMap();
        oldRefProps.putAll(refProps);
        ObjectName savedConfigData = this.getConfigData();
        String savedConfigId = this.getConfigID();
        try {
            String objType = sections[0].getType();
            String resType = sections[0].getImplementingResourceType();
            String configId = sections[0].getCfgId();
            refProps.put("RESOURCETYPE", objType);
            refProps.put("IMPLEMENTINGRESOURCETYPE", resType);
            refProps.put("CURRENTCONFIGID", configId);
            refProps.put("SECTIONS", sections);
            SectionData sectionData = this.getSectionData(sections[0]);
            if (sectionData != null) {
                Properties mappingData = sectionData.getPropertiesToAttributesMapping();
                refProps.put("MAPPINGDATA", mappingData);
            }
            refProps.put("DELETERESOURCE", new Boolean(true));
            if (sections[0].canDeleteWholeSection()) {
                refProps.put("DELETEALLCONTENTS", new Boolean(true));
            }
            if (sections[0].getCreateDeleteCommandProperties() != null || sections[0].isCreateTemplate() || sections[0].isDeleteTemplate()) {
                refProps.put("USECOMMANDS", new Boolean(true));
            }
            this.initialize(refProps);
            Properties props = sections[0].getProperties();
            this.setProperties(props);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                this.initialize(oldRefProps);
                this.setConfigData(savedConfigData);
                this.setConfigID(savedConfigId);
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.initialize(oldRefProps);
            this.setConfigData(savedConfigData);
            this.setConfigID(savedConfigId);
        }
        catch (Exception e) {}
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteProperties");
        }
    }

    private void deleteProperties(SectionData sectionData, Section section) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteProperties", new Object[]{sectionData, section});
        }
        this.setDeleteValidateProperties(sectionData, section, true, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteProperties");
        }
    }

    private void setProperties(SectionData sectionData, Section section) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{sectionData, section});
        }
        this.setDeleteValidateProperties(sectionData, section, false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    private String[] validateProperties(SectionData sectionData, Section section) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validProperties", new Object[]{sectionData, section});
        }
        String[] res = this.setDeleteValidateProperties(sectionData, section, false, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateProperties", res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setDeleteValidateProperties(SectionData sectionData, Section section, boolean delete, boolean validate) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDeleteValidateProperties", new Object[]{sectionData, section});
        }
        String[] res = null;
        HashMap refProps = this.getReferenceProperties();
        HashMap oldRefProps = new HashMap();
        oldRefProps.putAll(refProps);
        ObjectName savedConfigData = this.getConfigData();
        String savedConfigId = this.getConfigID();
        try {
            String objType = section.getType();
            String resType = section.getImplementingResourceType();
            String configId = section.getCfgId();
            refProps.put("RESOURCETYPE", objType);
            refProps.put("IMPLEMENTINGRESOURCETYPE", resType);
            refProps.put("CURRENTCONFIGID", configId);
            Section[] sections = new Section[]{section};
            refProps.put("SECTIONS", sections);
            if (sectionData != null) {
                Properties mappingData = sectionData.getPropertiesToAttributesMapping();
                refProps.put("MAPPINGDATA", mappingData);
            }
            if (delete) {
                refProps.put("DELETERESOURCE", new Boolean(delete));
            }
            if (validate) {
                refProps.put("VALIDATERESOURCE", new Boolean(validate));
            }
            this.initialize(refProps);
            Properties props = section.getProperties();
            if (!validate) {
                this.setProperties(props);
            } else {
                res = this.validateProperties(props);
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.initialize(oldRefProps);
            this.setConfigData(savedConfigData);
            this.setConfigID(savedConfigId);
            throw throwable;
        }
        this.initialize(oldRefProps);
        this.setConfigData(savedConfigData);
        this.setConfigID(savedConfigId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDeleteValidateProperties", res);
        }
        return res;
    }

    public boolean isValidating() {
        boolean result = false;
        HashMap refProps = this.getReferenceProperties();
        Boolean validate = (Boolean)refProps.get("VALIDATERESOURCE");
        if (validate != null) {
            result = validate;
        }
        return result;
    }

    public void setProperties(Properties props) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", props);
        }
        this.setOrValidateProperties(props, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setOrValidateProperties(Properties props, boolean apply) throws WASResourceException {
        String[] result;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setOrValidateProperties", new Object[]{props, new Boolean(apply)});
            }
            result = null;
            Boolean useCommands = (Boolean)this.getReferenceProperties().get("USECOMMANDS");
            if (useCommands == null || !useCommands.booleanValue()) break block20;
            ConfigPropertiesHelper.handleCommandProperties(this, (Section[])this.getReferenceProperties().get("SECTIONS"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setOrValidateProperties", result);
            }
            String[] stringArray = result;
            Object var22_9 = null;
            return stringArray;
        }
        try {
            block21: {
                try {
                    Boolean create = (Boolean)this.getReferenceProperties().get("CREATERESOURCE");
                    Boolean delete = (Boolean)this.getReferenceProperties().get("DELETERESOURCE");
                    Boolean deleteAllContents = (Boolean)this.getReferenceProperties().get("DELETEALLCONTENTS");
                    Section[] sections = this.currentSections;
                    Properties mappingData = this.currentMappingData;
                    ArrayList<Props> propsList = new ArrayList<Props>();
                    AttributeList attrList = null;
                    if (sections != null && sections.length > 0) {
                        if (create != null && create.booleanValue()) {
                            attrList = ApplyProperties.getAttributeList(this.getSectionData(sections[0]), sections[0].getProps());
                        }
                    } else {
                        String resType = this.currentResourceType;
                        if (resType == null) {
                            resType = this.getResourceType();
                        }
                        SectionData[] sectionDataArray = SectionedPropertiesHelper.getSections(this.getResourceType());
                        SectionData sectionData = null;
                        for (int i = 0; sectionDataArray != null && i < sectionDataArray.length; ++i) {
                            sectionData = sectionDataArray[i];
                            String cType = sectionData.getType();
                            if (cType == null || resType == null || !cType.equals(resType)) continue;
                            Properties prps = sectionData.getPropertiesToAttributesMapping();
                            Enumeration<?> e = prps.propertyNames();
                            while (e.hasMoreElements()) {
                                String pName = (String)e.nextElement();
                                if (!props.containsKey(pName)) continue;
                                Props p = new Props(pName, props.getProperty(pName));
                                propsList.add(p);
                            }
                            break;
                        }
                        Props[] ps = propsList.toArray(new Props[0]);
                        attrList = ApplyProperties.getAttributeList(sectionData, ps);
                    }
                    ConfigService cs = this.getConfigService();
                    Session session = null;
                    session = this.getSession();
                    if (create != null && create.booleanValue()) {
                        Section s = sections[0];
                        SectionData sd = this.getSectionData(s);
                        String attrName = sd.getAttrName();
                        String type = sd.getType();
                        this.createConfigObject(session, this.configData, attrName, type, attrList, sd, s);
                        break block21;
                    }
                    if (delete != null && delete.booleanValue()) {
                        if (deleteAllContents != null && deleteAllContents.booleanValue()) {
                            cs.deleteConfigData(session, this.configData);
                        } else {
                            DeleteProperties.deleteProperties(cs, session, this.getSectionData(sections[0]), sections[0], (WASResource)this);
                        }
                        break block21;
                    }
                    if (attrList != null) {
                        cs.setAttributes(session, this.configData, attrList);
                        break block21;
                    }
                    ApplyProperties.setProperties(cs, session, this.getSectionData(sections[0]), sections[0], (WASResource)this);
                }
                catch (Exception e) {
                    if (apply) {
                        throw new WASResourceException(e);
                    }
                    ArrayList<String> errList = new ArrayList<String>();
                    errList.add(e.getMessage());
                    result = errList.toArray(new String[0]);
                    Object var22_11 = null;
                }
            }
            Object var22_10 = null;
        }
        catch (Throwable throwable) {
            Object var22_12 = null;
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOrValidateProperties", result);
        }
        return result;
    }

    public String[] validateProperties(Properties props) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateProperties", this.getReferenceProperties());
        }
        String[] result = this.setOrValidateProperties(props, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateProperties", result);
        }
        return result;
    }

    public List getAllPropertyNames() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPropertyNames");
        }
        Section[] sections = this.currentSections;
        Properties mappingData = this.currentMappingData;
        ArrayList<String> result = new ArrayList<String>();
        if (sections != null && sections.length > 0) {
            SectionData sd = this.getSectionData(sections[0]);
            Properties props = sd.getPropertiesToAttributesMapping();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String pName = (String)e.nextElement();
                result.add(pName);
            }
        } else {
            String resType = this.currentResourceType;
            if (resType == null) {
                resType = this.getResourceType();
            }
            SectionData[] sectionDataArray = SectionedPropertiesHelper.getSections(this.getResourceType());
            SectionData sectionData = null;
            for (int i = 0; sectionDataArray != null && i < sectionDataArray.length; ++i) {
                sectionData = sectionDataArray[i];
                String cType = sectionData.getType();
                if (cType == null || resType == null || !cType.equals(resType)) continue;
                Properties props = sectionData.getPropertiesToAttributesMapping();
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String pName = (String)e.nextElement();
                    result.add(pName);
                }
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPropertyNames", result);
        }
        return result;
    }

    public void setProperty(String pName, String pValue) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", new Object[]{pName, pValue});
        }
        Section[] sections = this.currentSections;
        Properties mappingData = this.currentMappingData;
        AttributeList attrList = null;
        Props prop = new Props(pName, pValue);
        Props[] props = new Props[]{prop};
        if (sections != null && sections.length > 0) {
            attrList = ApplyProperties.getAttributeList(this.getSectionData(sections[0]), props);
        } else {
            String resType = this.currentResourceType;
            if (resType == null) {
                resType = this.getResourceType();
            }
            SectionData[] sectionDataArray = SectionedPropertiesHelper.getSections(this.getResourceType());
            SectionData sectionData = null;
            boolean found = false;
            for (int i = 0; sectionDataArray != null && i < sectionDataArray.length; ++i) {
                sectionData = sectionDataArray[i];
                String cType = sectionData.getType();
                if (cType != null && resType != null && cType.equals(resType)) {
                    Properties prps = sectionData.getPropertiesToAttributesMapping();
                    Enumeration<?> e = prps.propertyNames();
                    while (e.hasMoreElements()) {
                        String propName = (String)e.nextElement();
                        if (!propName.equals(pName)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                attrList = ApplyProperties.getAttributeList(sectionData, props);
                break;
            }
        }
        try {
            ConfigService cs = this.getConfigService();
            Session session = this.getSession();
            if (attrList != null) {
                cs.setAttributes(session, this.configData, attrList);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown property name", pName);
            }
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public String getProperty(String pName) throws WASResourceException {
        String finalResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", pName);
        }
        Object result = null;
        Section[] sections = this.currentSections;
        Properties mappingData = this.currentMappingData;
        String attrName = null;
        SectionData sectionData = null;
        if (sections != null && sections.length > 0) {
            sectionData = this.getSectionData(sections[0]);
            String cType = sectionData.getType();
            Properties prps = sectionData.getPropertiesToAttributesMapping();
            Enumeration<?> e = prps.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                if (!propName.equals(pName)) continue;
                attrName = prps.getProperty(propName);
                break;
            }
        } else {
            String resType = this.currentResourceType;
            if (resType == null) {
                resType = this.getResourceType();
            }
            SectionData[] sectionDataArray = SectionedPropertiesHelper.getSections(this.getResourceType());
            boolean found = false;
            for (int i = 0; sectionDataArray != null && i < sectionDataArray.length; ++i) {
                sectionData = sectionDataArray[i];
                String cType = sectionData.getType();
                if (cType != null && resType != null && cType.equals(resType)) {
                    Properties prps = sectionData.getPropertiesToAttributesMapping();
                    Enumeration<?> e = prps.propertyNames();
                    while (e.hasMoreElements()) {
                        String propName = (String)e.nextElement();
                        if (!propName.equals(pName)) continue;
                        found = true;
                        attrName = prps.getProperty(propName);
                        break;
                    }
                }
                if (!found) {
                    continue;
                }
                break;
            }
        }
        try {
            ConfigService cs = this.getConfigService();
            Session session = this.getSession();
            if (attrName != null) {
                result = cs.getAttribute(session, this.configData, attrName);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown property name", pName);
            }
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        String string = finalResult = result != null ? result.toString() : null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", finalResult);
        }
        return finalResult;
    }

    private Properties getPropertiesFromResourceImplementation(SectionData sectionData, ObjectName configId) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesFromResourceImplementation", new Object[]{sectionData, configId});
        }
        Properties props = null;
        try {
            String oldObjType = (String)this.getReferenceProperties().get("RESOURCETYPE");
            String objType = sectionData.getType();
            String resType = this.getResourceType();
            Object oldCfgId = this.getReferenceProperties().get("CURRENTCONFIGID");
            Object oldSection = this.getReferenceProperties().remove("SECTIONS");
            this.getReferenceProperties().put("RESOURCETYPE", objType);
            this.currentResourceType = objType;
            this.getReferenceProperties().put("SECTIONS", sectionData);
            if (configId != null) {
                this.getReferenceProperties().put("CURRENTCONFIGID", configId);
            }
            props = this.getProperties();
            if (oldObjType != null) {
                this.getReferenceProperties().put("RESOURCETYPE", oldObjType);
                this.currentResourceType = oldObjType;
            } else {
                this.getReferenceProperties().remove("RESOURCETYPE");
            }
            if (oldSection != null) {
                this.getReferenceProperties().put("SECTIONS", oldSection);
            } else {
                this.getReferenceProperties().remove("SECTIONS");
            }
            if (oldCfgId != null) {
                this.getReferenceProperties().put("CURRENTCONFIGID", oldCfgId);
            } else {
                this.getReferenceProperties().remove("CURRENTCONFIGID");
            }
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesFromResourceImplementation", props);
        }
        return props;
    }

    public Properties getProperties() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        Properties props = null;
        SectionData sectionData = (SectionData)this.getReferenceProperties().get("SECTIONS");
        ObjectName currConfigObj = (ObjectName)this.getReferenceProperties().get("CURRENTCONFIGID");
        if (sectionData != null) {
            try {
                ObjectName cfgId = currConfigObj != null ? currConfigObj : this.getConfigData();
                props = ExtractProperties.getProperties(this.getConfigService(), this.getSession(), cfgId, sectionData, this);
            }
            catch (Exception e) {
                throw new WASResourceException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    private SectionedProperties createSectionedProperties(SectionData section, String configId, Properties props) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSectionedProperties", new Object[]{section, configId, props});
        }
        SectionedProperties sectionedProperties = new SectionedProperties();
        SectionedPropertiesHelper.setCommonSectionProperties(sectionedProperties, section);
        sectionedProperties.setImplementingResourceType(this.getResourceType());
        if (configId != null) {
            sectionedProperties.setResourceId(configId);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null configId. Using configId of resource ", this.getConfigID());
            }
            sectionedProperties.setResourceId(this.getConfigID());
        }
        sectionedProperties.setConfigProperties(props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSectionedProperties", sectionedProperties);
        }
        return sectionedProperties;
    }

    private Section findSectionByResourceType(Section[] sections, String configType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findSectionByResourceType", new Object[]{sections, configType});
        }
        Section section = null;
        for (int i = 0; i < sections.length; ++i) {
            if (!sections[i].getType().equals(configType)) continue;
            section = sections[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResourceByResoureceType", section);
        }
        return section;
    }

    private Section[] findAllSectionsByResourceId(Section[] sections, String configId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findResourceByResourceId", new Object[]{sections, configId});
        }
        ArrayList<Section> selectedSections = new ArrayList<Section>();
        for (int i = 0; i < sections.length; ++i) {
            if (!sections[i].getCfgId().equals(configId)) continue;
            selectedSections.add(sections[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResourceByResouurceId", selectedSections);
        }
        return selectedSections.toArray(new Section[0]);
    }

    private Section[] findAllSectionsByResourceType(Section[] sections, String configType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findSectionByResourceType", new Object[]{sections, configType});
        }
        ArrayList<Section> selectedSections = new ArrayList<Section>();
        for (int i = 0; i < sections.length; ++i) {
            if (!sections[i].getType().equals(configType)) continue;
            selectedSections.add(sections[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResourceByResoureceType", selectedSections);
        }
        return selectedSections.toArray(new Section[0]);
    }

    private Section findSectionByResourceId(Section[] sections, String configId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findResourceByResourceId", new Object[]{sections, configId});
        }
        Section section = null;
        for (int i = 0; i < sections.length; ++i) {
            if (!sections[i].getCfgId().equals(configId)) continue;
            section = sections[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResourceByResouurceId", section);
        }
        return section;
    }

    private SectionData getSectionData(Section section) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSectionData", new Object[]{section});
        }
        SectionData[] sectionDataArray = SectionedPropertiesHelper.getSections(this.getResourceType());
        if (this.getResourceType().equals("GenericType")) {
            sectionDataArray = SectionedPropertiesHelper.getSections(this.getConfigData());
        }
        SectionData sectionData = null;
        String cfgType = section.getType();
        boolean found = false;
        for (int i = 0; sectionDataArray != null && i < sectionDataArray.length; ++i) {
            sectionData = sectionDataArray[i];
            String cType = sectionData.getType();
            if (cType == null || cfgType == null || !cType.equals(cfgType) || !this.attrCompare(section, sectionData)) continue;
            found = true;
            break;
        }
        if (!found) {
            sectionData = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSectionData", sectionData);
        }
        return sectionData;
    }

    private boolean isMatchingSection(Section section, SectionData sectionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMatchingSectionData", new Object[]{section, sectionData});
        }
        boolean result = false;
        String cfgType = section.getType();
        String cType = sectionData.getType();
        if (cType != null && cfgType != null && cType.equals(cfgType) && this.attrCompare(section, sectionData)) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchingSectionData", new Boolean(result));
        }
        return result;
    }

    private boolean attrCompare(Section section, SectionData sectionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attrCompare", sectionData);
        }
        boolean result = false;
        String attrName = section.getAttrName();
        String aName = sectionData.getAttrName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrNames", new Object[]{attrName, aName});
        }
        if (attrName != null && aName != null && aName.equals(attrName)) {
            result = true;
        } else if (attrName == null) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attrCompare", new Boolean(result));
        }
        return result;
    }

    private static List getAllNestedTypes(String type, String implType) {
        int j;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllNestedTypes", new Object[]{type, implType});
        }
        SectionData[] sectionData = SectionedPropertiesHelper.getSections(implType);
        ArrayList<String> allTypes = new ArrayList<String>();
        allTypes.add(type);
        for (j = 0; sectionData != null && j < sectionData.length && !sectionData[j].getType().equals(type); ++j) {
        }
        while (sectionData != null && j < sectionData.length) {
            String containingType = sectionData[j].getContainingType();
            if (containingType != null && containingType.equals(type)) {
                allTypes.add(sectionData[j].getType());
            } else if (allTypes.contains(containingType)) {
                allTypes.add(sectionData[j].getType());
            }
            ++j;
        }
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < allTypes.size(); ++i) {
                Tr.debug(tc, "type = ", allTypes.get(i));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllNestedTypes", allTypes);
        }
        return allTypes;
    }

    private static Section[] getSubSections(Section[] sections, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubSections", new Object[]{sections, new Integer(i)});
        }
        int origIndex = i;
        String origCfgId = sections[i].getCfgId();
        ArrayList<Section> subSections = new ArrayList<Section>();
        String implType = sections[i].getImplementingResourceType();
        String type = sections[i].getType();
        List allTypes = null;
        if (implType.equals("GenericType")) {
            implType = SectionedPropertiesHelper.getImplType(type);
            allTypes = PropWASResource.getAllNestedTypes(type, implType);
        } else {
            allTypes = PropWASResource.getAllNestedTypes(type, implType);
        }
        Object savedResourceType = null;
        while (i < sections.length) {
            Section s = sections[i];
            String resType = s.getType();
            String configId = s.getCfgId();
            if (i != origIndex && resType.equals(type) && !configId.equals(origCfgId)) break;
            if (allTypes.contains(resType)) {
                subSections.add(s);
            }
            ++i;
        }
        if (tc.isDebugEnabled()) {
            for (int j = 0; j < subSections.size(); ++j) {
                Tr.debug(tc, "common section = ", subSections.get(j));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubSections", subSections);
        }
        return subSections.toArray(new Section[0]);
    }

    private void createConfigObject(Session session, ObjectName configData, String attrName, String type, AttributeList attrList, SectionData sectionData, Section section) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, configData, attrName, type, attrList});
        }
        ConfigService cs = this.getConfigService();
        if (ApplyProperties.isIntermediateObject(type)) {
            attrName = ApplyProperties.getIntermediateAttrName(type);
        }
        if (this.parentObj != null) {
            if (attrName != null) {
                Attribute a = new Attribute("_Websphere_Config_Data_Type", type);
                attrList.add(a);
                ObjectName on = cs.createConfigDataByTemplate(session, this.parentObj, attrName, attrList, null);
                this.createSection.setCfgId(ConfigServiceHelper.getConfigDataId(on).toString());
            } else {
                ObjectName on = null;
                String aName = ApplyProperties.getAttrName(type);
                if (aName != null) {
                    Attribute a = new Attribute("_Websphere_Config_Data_Type", type);
                    attrList.add(a);
                    on = cs.createConfigDataByTemplate(session, this.parentObj, aName, attrList, null);
                } else {
                    on = cs.createConfigDataByTemplate(session, this.parentObj, type, attrList, null);
                }
                this.createSection.setCfgId(ConfigServiceHelper.getConfigDataId(on).toString());
            }
        } else {
            String cId = section.getCfgId();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cId = " + cId);
            }
            if (ConfigPropertiesHelper.isScopeId(cId)) {
                int inx = cId.lastIndexOf(":");
                String pId = cId.substring(0, inx);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pId = " + pId);
                }
                ObjectName parentObj = PropertiesUtils.convertConfigScopeToConfigObject(null, pId, session, cs);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parent = " + parentObj);
                }
                ObjectName on = null;
                if (attrName != null) {
                    Attribute a = new Attribute("_Websphere_Config_Data_Type", type);
                    attrList.add(a);
                    on = cs.createConfigDataByTemplate(session, parentObj, attrName, attrList, null);
                    this.createSection.setCfgId(ConfigServiceHelper.getConfigDataId(on).toString());
                } else {
                    String aName = ApplyProperties.getAttrName(type);
                    if (aName != null) {
                        Attribute a = new Attribute("_Websphere_Config_Data_Type", type);
                        attrList.add(a);
                        on = cs.createConfigDataByTemplate(session, parentObj, aName, attrList, null);
                    } else {
                        on = cs.createConfigDataByTemplate(session, parentObj, type, attrList, null);
                    }
                    this.createSection.setCfgId(ConfigServiceHelper.getConfigDataId(on).toString());
                }
                if (this.getConfigData() == null) {
                    this.setConfigData(on);
                    this.setConfigID(ConfigServiceHelper.getConfigDataId(on).toString());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected path taken: Not scope Id and no parent object");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData");
        }
    }

    private ObjectName getParentObj(Section[] sections, Section s, int lastSection) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentObj", new Object[]{sections, s, new Integer(lastSection)});
        }
        String type = s.getType();
        String containingType = null;
        String cfgId = null;
        ObjectName on = null;
        SectionData[] sectionData = SectionedPropertiesHelper.getSections(s.getImplementingResourceType());
        for (int j = 0; sectionData != null && j < sectionData.length; ++j) {
            if (!sectionData[j].getType().equals(type)) continue;
            containingType = sectionData[j].getContainingType();
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Containing Type = " + containingType);
        }
        if (containingType == null) {
            cfgId = s.getCfgId();
            Properties props = ConfigServiceHelper.getObjectLocation(ConfigServiceHelper.createObjectName(new ConfigDataId(cfgId)));
            String cell = props.getProperty("cell");
            String node = props.getProperty("node");
            String server = props.getProperty("server");
            String app = props.getProperty("application");
            String cluster = props.getProperty("cluster");
            String scope = "Cell=";
            scope = scope + cell;
            if (node != null) {
                scope = scope + ":Node=" + node;
            }
            if (server != null) {
                scope = scope + ":Server=" + server;
            }
            if (cluster != null) {
                scope = scope + ":ServerCluster=" + cluster;
            }
            if (app != null) {
                scope = scope + ":Deployment=" + app;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scope Id = " + scope);
            }
            try {
                on = configService.resolve(this.getSession(), scope)[0];
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception " + e);
                }
            }
        } else {
            for (int i = 0; i < lastSection && i < sections.length; ++i) {
                if (sections[i].getType().equals(containingType)) {
                    cfgId = sections[i].getCfgId();
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Cfg Id = " + cfgId);
            }
            String cType = ApplyProperties.getParentType(type);
            if (cType != null) {
                String containmentPath = cType + "=";
                ObjectName scope = ConfigServiceHelper.createObjectName(new ConfigDataId(cfgId));
                try {
                    on = configService.resolve(this.getSession(), scope, containmentPath)[0];
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception " + e);
                    }
                }
            } else if (cfgId != null) {
                on = ConfigServiceHelper.createObjectName(new ConfigDataId(cfgId));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentObj" + on);
        }
        return on;
    }

    public boolean getValidationError() {
        return this.validationError;
    }

    public void setValidationError(boolean err) {
        this.validationError = err;
    }

    public class ConfigIdAndType {
        private ObjectName cfgId;
        private String cfgType;
        private String sectionNumber;
        private String nextSubSectionNumber;

        public ConfigIdAndType(ObjectName cfgId, String cfgType, String sectionNumber) {
            this.cfgId = cfgId;
            this.cfgType = cfgType;
            this.sectionNumber = sectionNumber;
            this.nextSubSectionNumber = "0";
        }

        public ObjectName getCfgId() {
            return this.cfgId;
        }

        public String getCfgType() {
            return this.cfgType;
        }

        public String getSectionNumber() {
            return this.sectionNumber;
        }

        public int incSubSection() {
            int subSecNum = Integer.parseInt(this.nextSubSectionNumber);
            this.nextSubSectionNumber = String.valueOf(++subSecNum);
            return subSecNum;
        }

        public String getSubSectionNumber() {
            return this.nextSubSectionNumber;
        }

        public String toString() {
            return this.cfgId + " " + this.cfgType;
        }

        public boolean equals(Object obj) {
            ConfigIdAndType obj1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "src =" + obj + " dst =" + this);
            }
            return (obj1 = (ConfigIdAndType)obj).getCfgType().equals(this.getCfgType());
        }
    }
}

