/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class RasUtils {
    private static final TraceComponent _tc = Tr.register(RasUtils.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final String DEBUG = "com.ibm.ws.management.application.debug";
    private static final boolean _debug;
    private static final Map<Throwable, Long> map;

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method, String probeId) {
        RasUtils.logException(throwable, tc, className, method, probeId, null, null, false);
    }

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method, String probeId, Object[] objectArray) {
        RasUtils.logException(throwable, tc, className, method, probeId, null, objectArray, false);
    }

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method, String probeId, Object callerThis) {
        RasUtils.logException(throwable, tc, className, method, probeId, callerThis, null, false);
    }

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method, String probeId, Object callerThis, Object[] objectArray) {
        RasUtils.logException(throwable, tc, className, method, probeId, callerThis, objectArray, false);
    }

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method, String probeId, Object callerThis, Object[] objectArray, boolean force) {
        if (force || !map.containsKey(throwable)) {
            String sourceId = className + '.' + method;
            Manager.Ffdc.log(throwable, RasUtils.class, sourceId, probeId, new Object[]{callerThis, objectArray});
            if (tc.isEventEnabled()) {
                Tr.event(tc, method, new Object[]{"FFDC: sourceId=" + sourceId + ", probeId=" + probeId, throwable});
            }
            map.put(throwable, System.currentTimeMillis());
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, method, _debug ? throwable : throwable.toString());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/admin.jmx/src/com/ibm/ws/management/util/RasUtils.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.1");
        }
        CLASS_NAME = RasUtils.class.getName();
        _debug = Boolean.getBoolean(DEBUG);
        map = Collections.synchronizedMap(new WeakHashMap());
    }
}

