/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.rsatoken.RSAPropagationManager;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AdminCertificateHelper {
    private static final TraceComponent tc = Tr.register(AdminCertificateHelper.class);
    private static AdminCertificateHelper cm = null;
    private static HashMap certCache = new HashMap();

    public boolean isRSAPropagationEnabled() {
        return RSAPropagationManager.getInstance().isRSAPropagationEnabled();
    }

    public static synchronized AdminCertificateHelper getInstance() {
        if (cm == null) {
            cm = new AdminCertificateHelper();
        }
        return cm;
    }

    public void clearCertificateFromCache(String host, String port) {
        X509Certificate cert;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearCertificateFromCache");
        }
        String cacheKey = host + ":" + port;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking up certificate from cacheKey: " + cacheKey);
        }
        if ((cert = (X509Certificate)certCache.get(cacheKey)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found certificate in cache, removing it.");
            }
            certCache.remove(cacheKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearCertificateFromCache");
        }
    }

    public X509Certificate checkCacheForCertificate(Properties connectorProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCacheForCertificate", new Object[]{connectorProps});
        }
        X509Certificate cert = null;
        try {
            if (connectorProps == null) {
                throw new IllegalArgumentException("Connector properties specified are null.");
            }
            String host = connectorProps.getProperty("host");
            String port = connectorProps.getProperty("port");
            if (host == null || port == null) {
                throw new IllegalArgumentException("Connector properties specified do not have a valid \"host\" and \"port\" property.");
            }
            String cacheKey = host + ":" + port;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking up certificate from cacheKey: " + cacheKey);
            }
            if ((cert = (X509Certificate)certCache.get(cacheKey)) != null && tc.isEntryEnabled()) {
                Tr.exit(tc, "retrieveTargetCertificate (found in cache)");
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception received: ", new Object[]{e});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.ssl.utils.AdminCertificateHelper.checkCacheForCertificate", (String)"133", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCacheForCertificate");
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate retrieveTargetCertificate(Properties connectorProps) {
        X509Certificate cert;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveTargetCertificate", new Object[]{connectorProps});
            }
            cert = null;
            try {
                if (connectorProps == null) {
                    throw new IllegalArgumentException("Connector properties specified are null.");
                }
                String host = connectorProps.getProperty("host");
                String port = connectorProps.getProperty("port");
                if (host == null || port == null) {
                    throw new IllegalArgumentException("Connector properties specified do not have a valid \"host\" and \"port\" property.");
                }
                String cacheKey = host + ":" + port;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking up certificate from cacheKey: " + cacheKey);
                }
                if ((cert = (X509Certificate)certCache.get(cacheKey)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "retrieveTargetCertificate (cache)");
                    }
                    break block18;
                }
                try {
                    Subject unauthSubject = ContextManagerFactory.getInstance().createUnauthenticatedSubject();
                    AdminClientGetMBeanAction getMBeanAction = new AdminClientGetMBeanAction(connectorProps);
                    ObjectName sslAdmin = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(unauthSubject, (PrivilegedExceptionAction)getMBeanAction);
                    AdminClientCertificateAction getCertificateAction = new AdminClientCertificateAction(connectorProps, sslAdmin);
                    cert = (X509Certificate)ContextManagerFactory.getInstance().runAsSpecified(unauthSubject, (PrivilegedExceptionAction)getCertificateAction);
                }
                catch (Exception ex) {
                    Tr.debug(tc, "Exception calling adminClientCertificateAction: " + ex.getMessage());
                    throw ex;
                }
                if (cert != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found a cert chain and adding it using cacheKey: " + cacheKey);
                    }
                    certCache.put(cacheKey, cert);
                    break block18;
                }
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "An attempt to get the target's rsa propagation public certificate failed.");
            }
            catch (Exception e) {
                try {
                    Tr.debug(tc, "Exception received: ", new Object[]{e});
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.ssl.utils.AdminCertificateHelper.retrieveTargetCertificate", (String)"223", (Object)this);
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting the following certificate on the thread for use by security.", new Object[]{cert});
                    }
                    RSATokenThreadManager.getInstance().setTargetCertificate(cert);
                    throw throwable;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting the following certificate on the thread for use by security.", new Object[]{cert});
                }
                RSATokenThreadManager.getInstance().setTargetCertificate(cert);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting the following certificate on the thread for use by security.", new Object[]{cert});
        }
        RSATokenThreadManager.getInstance().setTargetCertificate(cert);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveTargetCertificate (lookup)", new Object[]{cert});
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate retrieveTargetCertificateDuringFileTransfer(String host, String port, FileTransferClient client) {
        X509Certificate cert;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveTargetCertificateDuringFileTransfer", new Object[]{host, port});
            }
            cert = null;
            try {
                if (client == null) {
                    throw new IllegalArgumentException("File transfer client is null.");
                }
                if (host == null || port == null) {
                    throw new IllegalArgumentException("File transfer does not have valid \"host\" and \"port\" properties.");
                }
                String cacheKey = host + ":" + port;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking up certificate from cacheKey: " + cacheKey);
                }
                if ((cert = (X509Certificate)certCache.get(cacheKey)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "retrieveTargetCertificate (cache)");
                    }
                    break block18;
                }
                try {
                    cert = client.getCert();
                }
                catch (Exception ex) {
                    Tr.debug(tc, "Exception calling FileTransferClient.getCert(): " + ex.getMessage());
                    throw ex;
                }
                if (cert != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found a cert chain and adding it using cacheKey: " + cacheKey);
                    }
                    certCache.put(cacheKey, cert);
                    break block18;
                }
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "An attempt to get the target's rsa propagation public certificate failed.");
            }
            catch (Exception e) {
                try {
                    Tr.debug(tc, "Exception received: ", new Object[]{e});
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.ssl.utils.AdminCertificateHelper.retrieveTargetCertificateDuringFileTransfer", (String)"303", (Object)this);
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting the following certificate on the thread for use by security.", new Object[]{cert});
                    }
                    RSATokenThreadManager.getInstance().setTargetCertificate(cert);
                    throw throwable;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting the following certificate on the thread for use by security.", new Object[]{cert});
                }
                RSATokenThreadManager.getInstance().setTargetCertificate(cert);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting the following certificate on the thread for use by security.", new Object[]{cert});
        }
        RSATokenThreadManager.getInstance().setTargetCertificate(cert);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveTargetCertificateDuringFileTransfer (lookup)", new Object[]{cert});
        }
        return cert;
    }

    AdminCertificateHelper() {
    }

    class AdminClientGetMBeanAction
    implements PrivilegedExceptionAction {
        Properties props = null;

        public AdminClientGetMBeanAction(Properties connectorProps) {
            this.props = connectorProps;
        }

        public Object run() throws Exception {
            try {
                AdminClient adminClient = AdminClientFactory.createAdminClient(this.props);
                String processName = this.getProcessName(adminClient);
                ObjectName queryString = new ObjectName("WebSphere:type=SSLAdmin,process=" + processName + ",*");
                Set s = adminClient.queryNames(queryString, null);
                ObjectName sslAdmin = null;
                if (s.isEmpty()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "retrieveTargetCertificate (can't get SSLAdmin)");
                    }
                    throw new Exception("retrieveTargetCertificate can't get SSLAdmin MBean");
                }
                sslAdmin = (ObjectName)s.iterator().next();
                return sslAdmin;
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception received: ", new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.ssl.utils.AdminCertificateHelper.AdminClientGetMBeanAction.run", (String)"383", (Object)this);
                throw e;
            }
        }

        private String getProcessName(AdminClient client) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getProcessName");
            }
            ObjectName mbean = null;
            String name = null;
            try {
                mbean = client.getServerMBean();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.ssl.utils.AdminCertificateHelper.AdminClientCertificateAction.getProcessName", (String)"404", (Object)this);
            }
            if (mbean != null) {
                name = ObjectNameHelper.getProcessName(mbean);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getProcessName -> " + name);
            }
            return name;
        }
    }

    class AdminClientCertificateAction
    implements PrivilegedExceptionAction {
        Properties props = null;
        ObjectName sslAdminMBean = null;

        public AdminClientCertificateAction(Properties connectorProps, ObjectName sslAdmin) {
            this.props = connectorProps;
            this.sslAdminMBean = sslAdmin;
        }

        public Object run() throws Exception {
            try {
                AdminClient adminClient = AdminClientFactory.createAdminClient(this.props);
                return adminClient.invoke(this.sslAdminMBean, "getAdminRSAPropagationCertificate", new Object[0], new String[0]);
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception received: ", new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.ssl.utils.AdminCertificateHelper.AdminClientCertificateAction.run", (String)"339", (Object)this);
                throw e;
            }
        }
    }
}

