/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.NSTransformFilter;
import com.ibm.ws.management.transform.TransformFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class TransformRepository {
    private static String wasInstallRoot = null;
    private static String configRoot = null;
    private static String configRoot2 = null;
    private static final String CONFIG = "/profileTemplates/management/documents/config/";
    private static final String CONFIG2 = "/etc/config/";
    private static TraceComponent tc = Tr.register(TransformRepository.class, "Transform", "com.ibm.ws.management.resources.sync");

    protected static String[] getReleaseFolderList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReleaseFolderList");
        }
        File[] contents = null;
        int size = 0;
        String[] results = null;
        String folder = "xforms";
        File dir = new File(TransformRepository.getConfigRoot() + folder);
        if (dir != null) {
            contents = dir.listFiles();
            if (contents != null) {
                size = contents.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The number of old folders in " + dir + " = " + size);
                }
                results = new String[size];
                for (int i = 0; i < size; ++i) {
                    results[i] = contents[i].getName();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot() + " " + folder + " does not exist.");
            }
        }
        if ((dir = new File(TransformRepository.getConfigRoot2() + folder)) != null) {
            contents = dir.listFiles();
            if (contents != null) {
                size = contents.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The number of new folders in " + dir + " = " + size);
                }
                if (size > 0) {
                    String[] results2 = new String[size];
                    for (int i = 0; i < size; ++i) {
                        results2[i] = contents[i].getName();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "New folder name = " + results2[i]);
                    }
                    results = TransformRepository.mergeArrays(results, results2);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot2() + " " + folder + " does not exist.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReleaseFolderList", results);
        }
        return results;
    }

    protected static String[] mergeArrays(String[] array1, String[] array2) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeArrays");
        }
        if (array1 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeArrays", array2);
            }
            return array2;
        }
        if (array2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeArrays", array1);
            }
            return array1;
        }
        int size1 = array1.length;
        int size2 = array2.length;
        String[] results = new String[size1 + size2];
        int counter = 0;
        for (i = 0; i < size1; ++i) {
            results[counter++] = array1[i];
        }
        for (i = 0; i < size2; ++i) {
            boolean found = false;
            for (int j = 0; j < counter; ++j) {
                if (results[j].compareTo(array2[i]) != 0) continue;
                found = true;
            }
            if (!found) {
                results[counter++] = array2[i];
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Not copying duplicate element " + array2[i]);
        }
        if (counter < results.length) {
            String[] results2 = new String[counter];
            int counter2 = 0;
            for (int i2 = 0; i2 < results.length; ++i2) {
                if (results[i2] == null) continue;
                results2[counter2++] = results[i2];
            }
            results = results2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeArrays", results);
        }
        return results;
    }

    protected static String[] getExtensionMetadata(String version, String product2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExtensionMetadata", version + " " + product2);
        }
        File[] contents = null;
        int size = 0;
        String[] results = null;
        String folder = "xforms/" + version;
        File dir = new File(TransformRepository.getConfigRoot() + "/" + folder);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config root dir is " + dir);
        }
        if (dir != null) {
            contents = dir.listFiles(TransformFilter.getInstance());
            if (contents != null) {
                size = contents.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The number of old filtered extension folders in " + dir + " = " + size);
                }
                if (size > 0) {
                    results = new String[size];
                    for (int i = 0; i < size; ++i) {
                        results[i] = folder + "/" + contents[i].getName();
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot() + " " + folder + " does not exist.");
            }
        }
        folder = "xforms/" + product2 + "/" + version;
        dir = new File(TransformRepository.getConfigRoot2() + folder);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config root 2 dir is " + dir);
        }
        if (dir != null) {
            contents = dir.listFiles(TransformFilter.getInstance());
            if (contents != null) {
                size = contents.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The number of new filtered extension folders in " + dir + " = " + size);
                }
                if (size > 0) {
                    String[] results2 = new String[size];
                    for (int i = 0; i < size; ++i) {
                        results2[i] = folder + "/" + contents[i].getName();
                    }
                    results = TransformRepository.mergeArrays(results, results2);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, dir + " does not exist.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExtensionMetadata", results);
        }
        return results;
    }

    protected static String[] getNamespaceTransforms(String folder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespaceTransforms", folder);
        }
        File[] contents = null;
        int size = 0;
        String[] results = null;
        File dir = new File(TransformRepository.getConfigRoot() + folder);
        if (dir != null) {
            contents = dir.listFiles(NSTransformFilter.getInstance());
            if (contents != null) {
                size = contents.length;
                results = new String[size];
                for (int i = 0; i < size; ++i) {
                    results[i] = folder + "/" + contents[i].getName();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot() + folder + " does not exist.");
            }
        }
        if ((dir = new File(TransformRepository.getConfigRoot2() + folder)) != null) {
            contents = dir.listFiles(NSTransformFilter.getInstance());
            if (contents != null) {
                size = contents.length;
                String[] results2 = new String[size];
                for (int i = 0; i < size; ++i) {
                    results2[i] = folder + "/" + contents[i].getName();
                }
                results = TransformRepository.mergeArrays(results, results2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot2() + folder + " does not exist.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespaceTransforms", folder);
        }
        return results;
    }

    protected static InputStream extract(String uri) {
        int i;
        FileInputStream input = null;
        File f = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Extract uri = " + uri);
        }
        if ((i = uri.indexOf("/base/")) != -1) {
            StringBuffer sb = new StringBuffer(uri);
            sb.replace(i, i + 6, "/");
            uri = sb.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Revised extract uri = " + uri);
            }
        }
        try {
            f = new File(TransformRepository.getConfigRoot() + uri);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extract() looking for file " + f);
            }
            input = new FileInputStream(f);
        }
        catch (Throwable t) {
            f = new File(TransformRepository.getConfigRoot2() + uri);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrying with file " + f);
            }
            try {
                input = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformRepository.extract", (String)"84", null);
            }
        }
        return input;
    }

    protected static InputStream extract2(String uri) throws FileNotFoundException {
        FileInputStream input = null;
        File f = null;
        f = new File(TransformRepository.getConfigRoot2() + uri);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "extract2() trying file " + f);
        }
        try {
            input = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "File was not found");
            }
            throw new FileNotFoundException(e.getMessage());
        }
        return input;
    }

    protected static InputStream extract3(String uri) throws FileNotFoundException {
        FileInputStream input = null;
        File f = null;
        try {
            f = new File(TransformRepository.getConfigRoot() + uri);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extract3() trying file " + f);
            }
            input = new FileInputStream(f);
        }
        catch (Throwable t) {
            f = new File(TransformRepository.getConfigRoot2() + uri);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrying with file " + f);
            }
            try {
                input = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException(e.getMessage());
            }
        }
        return input;
    }

    private static String getConfigRoot() {
        if (configRoot == null) {
            configRoot = TransformRepository.getWasInstallRoot() + CONFIG;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configRoot: " + configRoot);
            }
        }
        return configRoot;
    }

    private static String getConfigRoot2() {
        if (configRoot2 == null) {
            configRoot2 = TransformRepository.getWasInstallRoot() + CONFIG2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configRoot2: " + configRoot2);
            }
        }
        return configRoot2;
    }

    private static String getWasInstallRoot() {
        if (wasInstallRoot == null) {
            wasInstallRoot = System.getProperty("was.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wasInstallRoot: " + wasInstallRoot);
            }
        }
        return wasInstallRoot;
    }
}

