/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.TransformRepository;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class RepositoryURIResolver
implements URIResolver {
    private String version = null;
    private String oldVersion = null;
    private static TraceComponent tc = Tr.register(RepositoryURIResolver.class, "Transform", "com.ibm.ws.management.resources.sync");

    public RepositoryURIResolver(String version) {
        this.version = version;
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resolve href = " + href);
        }
        int index = href.indexOf(47);
        String docURI = null;
        if (index != -1) {
            String product2 = href.substring(0, index);
            String remainder = href.substring(index);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "product = " + product2 + ", remainder = " + remainder);
            }
            docURI = "xforms/" + product2 + "/" + this.version + remainder;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resolve href " + href + " does not contain product");
            }
            docURI = "xforms/" + this.version + "/" + href;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "docURI for transform is " + docURI);
        }
        StreamSource source = null;
        try {
            InputStream input = TransformRepository.extract(docURI);
            source = new StreamSource(input);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.RepositoryURIResolver.resolve", (String)"73", (Object)this);
            throw new TransformerException(t);
        }
        return source;
    }

    public void replaceVersion(String version) {
        this.oldVersion = new String(this.version);
        this.version = new String(version);
    }

    public void restoreVersion() {
        this.version = new String(this.oldVersion);
    }
}

