/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentAlreadyExistsException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.DocumentTransformer;
import com.ibm.ws.management.transform.RepositoryURIResolver;
import com.ibm.ws.management.transform.TransformCacheInvalidator;
import com.ibm.ws.management.transform.TransformMetadata;
import com.ibm.ws.management.transform.VersionMetadata;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class RepositoryAdapter {
    private static Map adapters = new HashMap();
    private ConfigRepository repository;
    private String nodeCanonicalVersion;
    private static ManagedObjectMetadataHelper momHelper;
    private TransformMetadata xformMetadata;
    private DocumentTransformer transformer;
    private static ManagedObjectMetadataAccessor metadataAccessor;
    private static HashMap nodeNameMap;
    private static HashMap nodePropertiesMap;
    protected static final String BASE_PRODUCT_NAME = "base";
    private static HashMap aggregatedKeyMap;
    private String instanceNodeKey;
    private static final String PRODUCT_VERSION_SEPARATOR = "_";
    private static TraceComponent tc;

    public static synchronized RepositoryAdapter getRepositoryAdapter(ConfigRepository r, String nodeName) throws AdminException {
        Properties nodeProps;
        if (momHelper == null) {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String cellName = adminService.getCellName();
            Properties p = new Properties();
            p.setProperty("local.cell", cellName);
            momHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(p));
        }
        String dmgrNodeName = AdminServiceFactory.getAdminService().getNodeName();
        String masterVersion = momHelper.getNodeBaseProductVersion(dmgrNodeName);
        masterVersion = VersionMetadata.getCanonicalVersion(masterVersion);
        String nodeVersion = momHelper.getNodeMajorVersion(nodeName);
        nodeVersion = nodeVersion.equals("5") ? "5.0.0.0" : momHelper.getNodeBaseProductVersion(nodeName);
        nodeVersion = VersionMetadata.getCanonicalVersion(nodeVersion);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "masterVersion = " + masterVersion + " nodeVersion = " + nodeVersion);
        }
        if (!nodeNameMap.containsKey(dmgrNodeName)) {
            Properties nodeProps2 = momHelper.getNodeProductsAndVersions(dmgrNodeName);
            if (nodeProps2.getProperty("WebServicesFeaturePack") == null) {
                // empty if block
            }
            nodeProps2.setProperty("WebServicesFeaturePack", "7.0.0.0");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added to dmgr properties: WebServicesFeaturePack=7.0.0.0");
            }
            nodePropertiesMap.put(dmgrNodeName, nodeProps2);
            if (!aggregatedKeyMap.containsKey(dmgrNodeName)) {
                String dmgrKey = RepositoryAdapter.createAggregatedKey(nodeProps2);
                if ((dmgrKey = RepositoryAdapter.processAggregatedKey(dmgrKey)) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dmgrKey is null; RepositoryAdapter cannot be obtained.");
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Putting key " + dmgrKey + " for dmgr " + dmgrNodeName);
                }
                aggregatedKeyMap.put(dmgrNodeName, dmgrKey);
            }
            nodeNameMap.put(dmgrNodeName, masterVersion);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added dmgr node " + dmgrNodeName + " at version " + nodeVersion + " to node name map");
            }
        }
        String nodeKey = null;
        if (!nodeNameMap.containsKey(nodeName)) {
            nodeProps = momHelper.getNodeProductsAndVersions(nodeName);
            if (nodeVersion.startsWith("7.") && nodeProps.getProperty("WebServicesFeaturePack") == null) {
                nodeProps.setProperty("WebServicesFeaturePack", "7.0.0.0");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "(1) Added to node properties: WebServicesFeaturePack=7.0.0.0");
                }
            }
            nodePropertiesMap.put(nodeName, nodeProps);
            nodeKey = RepositoryAdapter.createAggregatedKey(nodeProps);
            nodeKey = RepositoryAdapter.processAggregatedKey(nodeKey);
            if (nodeKey == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeKey is null; RepositoryAdapter cannot be obtained.");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Putting key " + nodeKey + " for node " + nodeName);
            }
            aggregatedKeyMap.put(nodeName, nodeKey);
            nodeNameMap.put(nodeName, nodeVersion);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added node " + nodeName + " at version " + nodeVersion + " to node name map");
            }
        } else {
            nodeProps = momHelper.getNodeProductsAndVersions(nodeName);
            if (nodeVersion.startsWith("7.") && nodeProps.getProperty("WebServicesFeaturePack") == null) {
                nodeProps.setProperty("WebServicesFeaturePack", "7.0.0.0");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "(2) Added to node properties: WebServicesFeaturePack=7.0.0.0");
                }
            }
            String newNodeKey = RepositoryAdapter.createAggregatedKey(nodeProps);
            if ((newNodeKey = RepositoryAdapter.processAggregatedKey(newNodeKey)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "newNodeKey is null; RepositoryAdapter cannot be obtained.");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New node key " + newNodeKey + " for node " + nodeName);
            }
            String oldNodeKey = (String)aggregatedKeyMap.get(nodeName);
            if ((oldNodeKey = RepositoryAdapter.processAggregatedKey(oldNodeKey)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "oldNodeKey is null; RepositoryAdapter cannot be obtained.");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Previous node key " + oldNodeKey + " for node " + nodeName);
            }
            if (!oldNodeKey.equals(newNodeKey)) {
                nodePropertiesMap.put(nodeName, nodeProps);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Replacing key with " + newNodeKey + " for node " + nodeName);
                }
                aggregatedKeyMap.put(nodeName, newNodeKey);
                nodeKey = newNodeKey;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No node product changes found.");
                }
                nodeKey = oldNodeKey;
            }
        }
        RepositoryAdapter ra = (RepositoryAdapter)adapters.get(nodeKey);
        if (ra == null) {
            ra = new RepositoryAdapter(r, masterVersion, nodeVersion, dmgrNodeName, nodeName);
            adapters.put(nodeKey, ra);
        }
        return ra;
    }

    private RepositoryAdapter(ConfigRepository r, String masterCanonicalVersion, String nodeCanonicalVersion, String dmgrNodeName, String nodeName) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating RepositoryAdapter for version " + nodeCanonicalVersion);
        }
        this.repository = r;
        this.nodeCanonicalVersion = new String(nodeCanonicalVersion);
        String dmgrKey = (String)aggregatedKeyMap.get(dmgrNodeName);
        this.instanceNodeKey = (String)aggregatedKeyMap.get(nodeName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dmgrKey = " + dmgrKey + ", instanceNodeKey = " + this.instanceNodeKey + " for node " + nodeName);
        }
        if (this.instanceNodeKey.compareTo(dmgrKey) == 0) {
            this.transformer = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Versions are compatible: ", new Object[]{dmgrKey, this.instanceNodeKey});
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Versions are not compatible: ", new Object[]{dmgrKey, this.instanceNodeKey});
            }
            this.xformMetadata = TransformMetadata.getTransformMetadata(nodeCanonicalVersion, dmgrKey, this.instanceNodeKey);
            TransformCacheInvalidator.addRelease(this.instanceNodeKey);
            RepositoryURIResolver uriResolver = new RepositoryURIResolver(nodeCanonicalVersion);
            this.transformer = new DocumentTransformer(uriResolver);
        }
    }

    public DocumentDigest getDigest(String docURI) throws AdminException, RepositoryException {
        DocumentDigest digest = null;
        if (this.transformer == null) {
            digest = this.repository.getDigest(docURI);
        } else {
            List xforms = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "docURI = " + docURI);
            }
            if ((xforms = this.xformMetadata.getTransforms(docURI)) != null) {
                String xformDocURI = this.getTransformedDocURI(docURI);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "xformDocURI = " + xformDocURI);
                }
                try {
                    digest = this.repository.getDigest(xformDocURI);
                }
                catch (DocumentNotFoundException e) {
                    digest = this.transform(docURI, xforms);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating " + docURI);
                    }
                }
            } else {
                digest = this.repository.getDigest(docURI);
            }
        }
        return digest;
    }

    public DocumentContentSource extract(String docURI) throws AdminException, RepositoryException {
        DocumentContentSource dcs = null;
        if (this.transformer == null) {
            dcs = this.repository.extract(docURI);
        } else {
            List xforms = null;
            xforms = this.xformMetadata.getTransforms(docURI);
            if (xforms != null) {
                String xformDocURI = this.getTransformedDocURI(docURI);
                DocumentDigest digest = null;
                for (int attempts = 0; dcs == null && attempts < 10; ++attempts) {
                    try {
                        dcs = this.repository.extract(xformDocURI);
                        dcs.getDocument().setURI(docURI);
                        continue;
                    }
                    catch (DocumentNotFoundException e) {
                        digest = this.transform(docURI, xforms);
                    }
                }
                if (dcs == null && digest == null) {
                    AdminException ae = new AdminException("Unable to extract or create transformed version of " + docURI);
                    FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.transform.RepositoryAdapter.transform", (String)"425", (Object)this);
                }
            } else {
                dcs = this.repository.extract(docURI);
            }
        }
        return dcs;
    }

    public String[] listResourceNames(String folder, int type, int depth, ResourceNameFilter filter) {
        String[] result = null;
        if (this.transformer == null) {
            result = this.repository.listResourceNames(folder, type, depth, filter);
        } else {
            RepositoryFilter rf = new RepositoryFilter(filter);
            result = this.repository.listResourceNames(folder, type, depth, (ResourceNameFilter)rf);
        }
        return result;
    }

    private String getTransformedDocURI(String docURI) {
        String newURI = new String(this.instanceNodeKey + "/" + docURI);
        String uri = "xformed/" + newURI;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransformedDocURI returns " + uri);
        }
        return uri;
    }

    private static String processAggregatedKey(String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAggregatedKey", key);
        }
        String newURI = new String(key);
        int count = 0;
        int firstIndex = -1;
        for (int i = 0; i < newURI.length(); ++i) {
            if (newURI.charAt(i) != '+') continue;
            if (firstIndex == -1) {
                firstIndex = i;
            }
            ++count;
        }
        String product2 = null;
        if (count == 1) {
            product2 = newURI.substring(0, firstIndex);
            StringBuffer sb = new StringBuffer();
            sb.append(product2);
            sb.append(PRODUCT_VERSION_SEPARATOR);
            String cversion = newURI.substring(firstIndex + 1, newURI.length());
            cversion = VersionMetadata.getCanonicalVersion(cversion);
            sb.append(cversion);
            newURI = sb.toString();
        } else {
            StringBuffer finalURI = new StringBuffer();
            int index1 = newURI.indexOf(43);
            int index2 = newURI.indexOf(43, index1 + 1);
            int nextIndex = 0;
            String cversion = null;
            for (int i = 0; i < count - 1; i += 2) {
                block14: {
                    product2 = newURI.substring(nextIndex, index1);
                    cversion = newURI.substring(index1 + 1, index2);
                    try {
                        cversion = product2.equals(BASE_PRODUCT_NAME) ? VersionMetadata.getCanonicalVersion(cversion) : VersionMetadata.getCanonicalVersion(cversion, product2);
                        if (cversion != "NONE") {
                            finalURI.append(product2);
                            finalURI.append(PRODUCT_VERSION_SEPARATOR);
                            finalURI.append(cversion + "/");
                        }
                    }
                    catch (AdminException e) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, e.getMessage() + " occurred in " + "getTransformedDocURI when processing " + key);
                    }
                }
                nextIndex = index2 + 1;
                index1 = newURI.indexOf(43, nextIndex);
                index2 = newURI.indexOf(43, index1 + 1);
                if (index2 != -1) continue;
                product2 = newURI.substring(nextIndex, index1);
                cversion = newURI.substring(index1 + 1, newURI.length());
                try {
                    cversion = VersionMetadata.getCanonicalVersion(cversion, product2);
                    if (cversion != "NONE") {
                        finalURI.append(product2);
                        finalURI.append(PRODUCT_VERSION_SEPARATOR);
                        finalURI.append(cversion);
                    }
                    newURI = finalURI.toString();
                    continue;
                }
                catch (AdminException e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, e.getMessage() + " occurred in " + "getTransformedDocURI when processing " + key);
                }
            }
        }
        if (newURI.endsWith("/")) {
            newURI = newURI.substring(0, newURI.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAggregatedKey", newURI);
        }
        return newURI;
    }

    private DocumentDigest transform(String docURI, List xformMaps) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Transforming " + docURI);
        }
        DocumentContentSource master = null;
        try {
            master = this.repository.extract(docURI);
        }
        catch (AdminException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.transform.RepositoryAdapter.transform", (String)"242", (Object)this);
            throw e;
        }
        InputStream source = null;
        try {
            source = this.transformer.transform(master.getSource(), xformMaps, this.xformMetadata.getNamespaceTransformer(), docURI);
        }
        catch (AdminException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.transform.RepositoryAdapter.transform", (String)"260", (Object)this);
            throw e;
        }
        Document doc = new Document(this.getTransformedDocURI(docURI));
        DocumentContentSource dcs = new DocumentContentSource(doc, source);
        DocumentDigest digest = null;
        try {
            digest = this.repository.create(dcs);
        }
        catch (DocumentAlreadyExistsException e) {
        }
        catch (AdminException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.transform.RepositoryAdapter.transform", (String)"276", (Object)this);
            throw e;
        }
        return digest;
    }

    public static String[] getNodeNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeNames");
        }
        String[] names = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Size of nodeNameMap = " + nodeNameMap.size());
        }
        if (nodeNameMap.size() > 0) {
            ArrayList<String> nameList = new ArrayList<String>(nodeNameMap.size());
            Set set = nodeNameMap.keySet();
            for (String name : set) {
                nameList.add(name);
            }
            names = new String[nameList.size()];
            for (int i = 0; i < nameList.size(); ++i) {
                names[i] = new String((String)nameList.get(i));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "nodeNameMap contains node " + names[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeNames");
        }
        return names;
    }

    public static Properties getNodeFeaturePackProps(String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeFeaturePackProps", nodeName);
        }
        if (nodeName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeFeaturePackProps", nodeName);
            }
            return null;
        }
        String name = (String)nodeNameMap.get(nodeName);
        if (name == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeFeaturePackProps", "Did not find node " + nodeName);
            }
            return null;
        }
        Properties properties = (Properties)nodePropertiesMap.get(nodeName);
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)properties);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Product properties for " + nodeName + " has " + newProperties.size() + " elements");
            Enumeration<?> myEnum = newProperties.propertyNames();
            while (myEnum.hasMoreElements()) {
                String key = (String)myEnum.nextElement();
                String value = (String)newProperties.get(key);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found key " + key + " and value " + value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeFeaturePackProps", nodeName);
        }
        return newProperties;
    }

    protected static String createAggregatedKey(Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAggregatedKey", props);
        }
        if (props == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAggregatedKey");
            }
            return new String();
        }
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)props);
        StringBuffer result = new StringBuffer();
        String value = (String)newProperties.get(BASE_PRODUCT_NAME);
        result.append("base+" + value + "+");
        newProperties.remove(BASE_PRODUCT_NAME);
        TreeSet<String> set = new TreeSet<String>();
        Enumeration<?> enumerator = newProperties.propertyNames();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            value = (String)props.get(key);
            set.add(key + "+" + value);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            result.append((String)iterator.next() + "+");
        }
        int end = result.length();
        result.deleteCharAt(end - 1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAggregatedKey", result.toString());
        }
        return result.toString();
    }

    protected static String getAggregatedKey(String name) {
        if (name == null) {
            return null;
        }
        if (!aggregatedKeyMap.containsKey(name)) {
            return null;
        }
        return (String)aggregatedKeyMap.get(name);
    }

    private String replaceVersionString(String nodeCanonicalVersion, String productVersion, String xformDocURI) {
        int i = xformDocURI.indexOf(nodeCanonicalVersion);
        StringBuffer sb = new StringBuffer(xformDocURI);
        sb.replace(i, i + nodeCanonicalVersion.length(), productVersion);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing " + xformDocURI + " with " + sb.toString());
        }
        xformDocURI = sb.toString();
        return xformDocURI;
    }

    static {
        nodeNameMap = new HashMap();
        nodePropertiesMap = new HashMap();
        aggregatedKeyMap = new HashMap();
        tc = Tr.register(RepositoryAdapter.class, "Transform", "com.ibm.ws.management.resources.sync");
    }

    private class RepositoryFilter
    implements ResourceNameFilter {
        ResourceNameFilter filter;

        public RepositoryFilter(ResourceNameFilter f) {
            this.filter = f;
        }

        public boolean accept(String folder, String docName) {
            boolean result = true;
            try {
                result = RepositoryAdapter.this.xformMetadata.filteredDoc(folder, docName) ? false : this.filter.accept(folder, docName);
                if (tc.isDebugEnabled()) {
                    if (folder.equals("/")) {
                        Tr.debug(tc, "Accept preliminary result = " + result + " for " + folder + docName);
                    } else {
                        Tr.debug(tc, "Accept preliminary result = " + result + " for " + folder + "/" + docName);
                    }
                }
                if (!result) {
                    result = RepositoryAdapter.this.xformMetadata.getTransforms(folder + "/" + docName) != null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Transform precedence over filter for " + folder + "/" + docName + " = " + result);
                    }
                }
            }
            catch (AdminException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.transform.RepositoryAdapter.RepositoryFilter.accept", (String)"313", (Object)this);
            }
            return result;
        }
    }
}

