/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.WindowsService;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public abstract class WsServerController
extends AdminTool {
    private static TraceComponent tc = Tr.register(WsServerController.class, "Admin", BUNDLE_NAME);
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    protected boolean timeout = false;
    protected String serverName;
    protected boolean isNodeAgent = false;
    protected boolean isDmgr = false;
    private String exitStatusFile = null;

    protected abstract void printEnhancedErrorMessage(Throwable var1);

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected boolean parseArgs(String[] args) throws AdminException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-nodeagent")) {
                this.isNodeAgent = true;
                continue;
            }
            if (!args[i].equals("-dmgr")) continue;
            this.isDmgr = true;
        }
        return super.parseArgs(args);
    }

    protected int parseRequiredArgs(String[] args) {
        this.serverName = args[3];
        if (this.serverName == null || this.serverName.startsWith("-")) {
            this.issueMessage("ADMU3402E", null, null);
            return -1;
        }
        return 4;
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        String option = args[curOption];
        if (option.equals("-fromWinService")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.exitStatusFile = args[curOption + 1];
                this.invokedByWindowsService = true;
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-timeout")) {
            this.timeout = true;
            if (this.isValidParameter(args, curOption + 1)) {
                this.statusTimeout = Integer.parseInt(args[curOption + 1]) * 1000;
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (!option.equals("-dmgr") && !option.equals("-nodeagent")) {
            nextOption = -1;
        }
        return nextOption;
    }

    protected int executeUtilityOnWindows(String[] args) throws AdminException {
        this.parseAndSetTraceCalled = true;
        int ret = this.parseAndSetTrace(args);
        if (ret == 0) {
            Tr.event(tc, "Executing executeUtilityOnWindows with args: " + this.getUtilityArguments(args));
            WindowsService winSvc = this.getWindowsServiceIfAvailable(args);
            if (winSvc != null) {
                Tr.event(tc, "Window service status (1=stopped, 2=started, 3=not-registred) is " + winSvc.getServiceStatus());
                this.execWithWinService(winSvc);
                return 0;
            }
            return this.executeUtility(args);
        }
        if (ret == 12345) {
            return 0;
        }
        return ret;
    }

    protected WindowsService getWindowsServiceIfAvailable(String[] args) throws AdminException {
        if (this.invokedByWindowsService) {
            Tr.event(tc, "invokedByWindowsService has been set to true earlier");
            return null;
        }
        WindowsService winSvc = null;
        Tr.event(tc, "Getting WindowsService obj with: " + args[3] + " and " + this.getUtilityArguments(args));
        winSvc = WindowsService.getWindowsServiceInstance(args[3], args, null);
        return winSvc;
    }

    protected abstract void execWithWinService(WindowsService var1) throws AdminException;

    protected abstract void logUnknownException(Exception var1);

    protected abstract int getTimeoutStatus();

    protected abstract int getFailureStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getStatus(Socket s) {
        int status;
        block9: {
            status = this.getFailureStatus();
            InputStream socketInput = null;
            FilterInputStream dataInput = null;
            socketInput = s.getInputStream();
            dataInput = new DataInputStream(socketInput);
            status = ((DataInputStream)dataInput).readInt();
            Object var7_5 = null;
            try {
                dataInput.close();
                socketInput.close();
            }
            catch (IOException e2) {
                this.logUnknownException(e2);
            }
            dataInput = null;
            socketInput = null;
            {
                break block9;
                catch (IOException e) {
                    this.logUnknownException(e);
                    Object var7_6 = null;
                    try {
                        dataInput.close();
                        socketInput.close();
                    }
                    catch (IOException e2) {
                        this.logUnknownException(e2);
                    }
                    dataInput = null;
                    socketInput = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    dataInput.close();
                    socketInput.close();
                }
                catch (IOException e2) {
                    this.logUnknownException(e2);
                }
                dataInput = null;
                socketInput = null;
                throw throwable;
            }
        }
        return status;
    }

    protected int waitForServerInit() {
        Socket acceptedSocket = null;
        boolean statusReceived = false;
        boolean timedOut = false;
        int result = 0;
        while (!statusReceived && !timedOut) {
            try {
                acceptedSocket = this.statusSocket.accept();
            }
            catch (InterruptedIOException e) {
                acceptedSocket = null;
                timedOut = true;
            }
            catch (IOException ioe) {
                this.logUnknownException(ioe);
                acceptedSocket = null;
                statusReceived = true;
                result = this.getFailureStatus();
            }
            if (acceptedSocket == null) continue;
            result = this.getStatus(acceptedSocket);
            statusReceived = this.isFinalStatus(result);
        }
        if (!statusReceived) {
            result = this.getTimeoutStatus();
        }
        return result;
    }

    protected int waitForServerInit(int timeout) {
        Socket acceptedSocket = null;
        boolean statusReceived = false;
        boolean timedOut = false;
        int result = 0;
        while (!statusReceived && !timedOut) {
            try {
                this.statusSocket.setSoTimeout(timeout);
                acceptedSocket = this.statusSocket.accept();
            }
            catch (InterruptedIOException e) {
                acceptedSocket = null;
                timedOut = true;
            }
            catch (IOException ioe) {
                this.logUnknownException(ioe);
                acceptedSocket = null;
                statusReceived = true;
                result = this.getFailureStatus();
            }
            if (acceptedSocket == null) continue;
            result = this.getStatus(acceptedSocket);
            statusReceived = this.isFinalStatus(result);
        }
        if (!statusReceived) {
            result = this.getTimeoutStatus();
        }
        return result;
    }

    protected abstract boolean isFinalStatus(int var1);

    protected ServerIdentifiers createServerIdentifiers() {
        ServerIdentifiers sid = new ServerIdentifiers();
        sid.setConfigRoot(this.configRoot);
        sid.setCellName(this.cellName);
        sid.setNodeName(this.nodeName);
        sid.setServerName(this.serverName);
        return sid;
    }

    protected void writeExitCode(String[] args, int exitCode) {
        if (!this.invokedByWindowsService) {
            System.exit(exitCode);
        }
        String pipeName = this.exitStatusFile;
        try {
            FileOutputStream os = new FileOutputStream(pipeName);
            String msg = Integer.toString(exitCode);
            os.write(msg.getBytes());
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        System.exit(exitCode);
    }
}

