/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.ProblemInWASServiceException;
import com.ibm.ws.management.util.EncodingUtils;
import com.ibm.ws.management.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class WindowsService
extends AdminTool {
    public static final int STATUS_REGISTERED_STOPPED = 1;
    public static final int STATUS_REGISTERED_STARTED = 2;
    public static final int STATUS_NOT_REGISTERED = 3;
    private static final String DEFAULT_TRACE_FILE = "startServer.log";
    private static final String DEFAULT_TRACE_STRING = "*=all=enabled";
    private static TraceComponent tc = Tr.register(WindowsService.class, "Admin", BUNDLE_NAME);
    private String windowsServiceName = null;
    private String wasServerName = null;
    private List cmdLineArgs = new ArrayList();
    private String serviceLogFileName = null;
    private String wasServiceExeCmd = null;
    private String profilePath = null;

    public static WindowsService getWindowsServiceInstance(String serverName, String profPath) throws AdminException {
        WindowsService windowsService = null;
        windowsService = new WindowsService(serverName, profPath);
        if (windowsService.windowsServiceName == null) {
            windowsService = null;
        }
        return windowsService;
    }

    protected WindowsService(String serverName, String profPath) throws AdminException {
        this.wasServerName = serverName;
        this.profilePath = profPath;
        this.windowsServiceName = this.getWindowsServiceNameForServer(this.wasServerName, profPath);
    }

    public static WindowsService getWindowsServiceInstance(String serverName, String[] args, String profPath) throws AdminException {
        WindowsService windowsService = null;
        windowsService = new WindowsService(serverName, args, profPath);
        if (windowsService.windowsServiceName == null) {
            windowsService = null;
        }
        return windowsService;
    }

    private WindowsService(String serverName, String[] args, String profPath) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WindowsService for server " + serverName, profPath);
        }
        this.wasServerName = serverName;
        this.windowsServiceName = this.getWindowsServiceNameForServer(this.wasServerName, profPath);
        Tr.event(tc, "Trying to new up WindowsService using serverName=" + this.wasServerName + ", winServiceName=" + this.windowsServiceName);
        if (this.windowsServiceName == null) {
            return;
        }
        if (args.length >= 4) {
            for (int i = 4; i < args.length; ++i) {
                this.cmdLineArgs.add(args[i]);
            }
        }
        this.serviceLogFileName = this.getServiceLogName(serverName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WindowsService");
        }
    }

    protected int getServiceStatus() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceStatus");
        }
        String[] cmdArgs = new String[]{this.getWASServiceCmdPath(null), "-status", this.windowsServiceName};
        StringBuffer buff = new StringBuffer();
        int retCode = 0;
        try {
            retCode = this.executeCommand(cmdArgs, buff, false);
        }
        catch (ProblemInWASServiceException pe) {
            throw new AdminException(this.getFormattedMessage("ADMU7712E", new Object[]{this.wasServerName, pe}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceStatus");
        }
        return retCode;
    }

    private String getWindowsServiceNameForServer(String serverName, String profPath) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWindowsServiceNameForServer " + serverName, profPath);
        }
        String profilePath = null;
        profilePath = profPath != null ? profPath : System.getProperty("user.install.root").replace('/', '\\');
        String[] cmdAndArgs = new String[]{this.getWASServiceCmdPath(null), "-getServiceName", serverName, "-profilePath", profilePath};
        StringBuffer stdoutBuff = new StringBuffer();
        int retCode = 0;
        try {
            retCode = this.executeCommand(cmdAndArgs, stdoutBuff, false);
        }
        catch (Throwable t) {
            throw new AdminException(this.getFormattedMessage("ADMU7707E", new Object[]{this.wasServerName, t}, null));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stdoutBuff.toString());
        String token = null;
        while (stringTokenizer.hasMoreTokens()) {
            token = stringTokenizer.nextToken();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWindowsServiceNameForServer");
        }
        return token;
    }

    private String getServiceLogName(String serverName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceLogName for " + serverName);
        }
        int retCode = 0;
        String profilePath = System.getProperty("user.install.root").replace('/', '\\');
        String[] cmdAndArgs = new String[]{this.getWASServiceCmdPath(null), "-getServiceLogName", serverName, "-profilePath", profilePath};
        StringBuffer stdoutBuff = new StringBuffer();
        try {
            retCode = this.executeCommand(cmdAndArgs, stdoutBuff, false);
        }
        catch (ProblemInWASServiceException pe) {
            throw new AdminException(this.getFormattedMessage("ADMU7708E", new Object[]{serverName, pe}, null));
        }
        if (retCode != 0) {
            this.issueMessage("ADMU7708E", new Object[]{this.wasServerName, stdoutBuff}, null);
            System.exit(retCode);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught InterruptedException while trying to determine service name", e);
            }
            throw new AdminException(this.getFormattedMessage("ADMU7709E", new Object[]{serverName, e}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceLogName");
        }
        return stdoutBuff.toString();
    }

    private int executeCommand(String[] cmdAndArgs, StringBuffer stdoutBuff, boolean readLog) throws AdminException, ProblemInWASServiceException {
        Tr.event(tc, "In executeCommand, args are: " + this.getUtilityArguments(cmdAndArgs));
        int retCode = 0;
        StringBuffer stderrBuff = new StringBuffer();
        Runtime runtime = Runtime.getRuntime();
        try {
            Process childProcess = runtime.exec(cmdAndArgs);
            Tr.event(tc, "Runtime.exec() returned process " + childProcess);
            StreamConsumer stdoutReader = new StreamConsumer(childProcess.getInputStream(), stdoutBuff);
            StreamConsumer stderrReader = new StreamConsumer(childProcess.getErrorStream(), stderrBuff);
            stdoutReader.start();
            stderrReader.start();
            LogReader jThread = null;
            if (this.serviceLogFileName == null) {
                readLog = false;
            }
            if (readLog) {
                jThread = new LogReader(this.serviceLogFileName);
                jThread.start();
            }
            try {
                retCode = childProcess.waitFor();
                Tr.event(tc, "retCode from childProcess.waitFor() is " + retCode);
            }
            catch (InterruptedException e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught InterrupedException while waiting for child process", e2);
                }
                throw new AdminException(this.getFormattedMessage("ADMU7709E", new Object[]{this.wasServerName, e2}, null));
            }
            if (readLog) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "-- interrupt the thread that is collecting stdout");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                jThread.interrupt();
            }
            Tr.debug(tc, "exitCode = " + retCode);
        }
        catch (IOException e1) {
            throw new AdminException(this.getFormattedMessage("ADMU7709E", new Object[]{this.wasServerName, e1}, null));
        }
        if (stderrBuff != null && stderrBuff.length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stderrBuff.toString());
            }
            stdoutBuff.append("\n");
            stdoutBuff.append(stderrBuff);
        }
        return retCode;
    }

    protected void doWASServiceAction(String action, String profilePath) throws AdminException {
        int retCode;
        StringBuffer stdoutBuff;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "doWASServiceAction action " + action, profilePath);
            }
            this.doWasServiceMsg(this.wasServerName, action);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getWASServiceCmdPath(profilePath));
            arrayList.add("-" + action);
            arrayList.add(this.windowsServiceName);
            arrayList.addAll(this.cmdLineArgs);
            String[] cmdAndArgs = new String[arrayList.size()];
            cmdAndArgs = arrayList.toArray(cmdAndArgs);
            stdoutBuff = new StringBuffer();
            retCode = 0;
            try {
                retCode = this.executeCommand(cmdAndArgs, stdoutBuff, true);
            }
            catch (Throwable t) {
                if (action.equals("start")) {
                    throw new AdminException(this.getFormattedMessage("ADMU7704E", new Object[]{this.wasServerName, t}, null));
                }
                if (action.equals("stop")) {
                    throw new AdminException(this.getFormattedMessage("ADMU7705E", new Object[]{this.wasServerName, t}, null));
                }
                if (!action.equals("remove")) break block12;
                throw new AdminException(this.getFormattedMessage("ADMU7706E", new Object[]{this.wasServerName, t}, null));
            }
        }
        if (retCode != 0) {
            if (action.equals("start")) {
                this.issueMessage("ADMU7704E", new Object[]{this.wasServerName, stdoutBuff}, null);
            } else if (action.equals("stop")) {
                this.issueMessage("ADMU7705E", new Object[]{this.wasServerName, stdoutBuff}, null);
            } else if (action.equals("remove")) {
                this.issueMessage("ADMU7706E", new Object[]{this.wasServerName, stdoutBuff}, null);
            }
            System.exit(retCode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doWASServiceAction");
        }
    }

    private void doWasServiceMsg(String serverName, String action) {
        if (action.equals("start")) {
            this.issueMessage("ADMU7701I", new Object[]{serverName}, null);
        } else if (action.equals("stop")) {
            this.issueMessage("ADMU7702I", new Object[]{serverName}, null);
        } else if (action.equals("remove")) {
            this.issueMessage("ADMU7703I", new Object[]{this.windowsServiceName, serverName}, null);
        }
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + this.wasServerName;
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected int parseRequiredArgs(String[] args) throws AdminException {
        return 0;
    }

    protected void issueUsageMessage() {
    }

    protected int runTool() throws Exception {
        return 0;
    }

    protected void doStopService() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doRemoveService");
        }
        this.doWASServiceAction("stop", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doStopService");
        }
    }

    protected void doRemoveService() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doRemoveService");
        }
        this.doWASServiceAction("remove", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doRemoveService");
        }
    }

    protected void doRemoveService(String profPath) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doRemoveService", profPath);
        }
        this.doWASServiceAction("remove", profPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doRemoveService");
        }
    }

    private String getWASServiceCmdPath(String profilePath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWASServiceCmdPath ", profilePath);
        }
        StringBuffer cmd = new StringBuffer();
        if (this.wasServiceExeCmd == null) {
            cmd = profilePath == null ? cmd.append(System.getProperty("was.install.root")).append(File.separator).append("bin").append(File.separator).append("WASService.exe") : cmd.append(profilePath).append(File.separator).append("bin").append(File.separator).append("WASService.exe");
            this.wasServiceExeCmd = cmd.toString();
        }
        return this.wasServiceExeCmd;
    }

    protected String getServiceName() {
        return this.windowsServiceName;
    }

    private class LogReader
    extends Thread {
        private boolean stopFlag = false;
        private static final long tenthOfSecond = 100L;
        private static final long halfOfSecond = 500L;
        private String jserviceLogFileName = null;

        private LogReader(String logFileName) {
            this.jserviceLogFileName = logFileName;
        }

        public void run() {
            this.waitForFileExist(this.jserviceLogFileName);
            try {
                this.readAndDisplayServiceLogFile(this.jserviceLogFileName);
            }
            catch (IOException e) {
                Tr.debug(tc, "Caught IOException in run() method of LogReader.class", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void readAndDisplayServiceLogFile(String fname) throws IOException {
            FileInputStream fis;
            block17: {
                block16: {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "readAndDisplayServiceLogFile(), caught InterruptedException1");
                    }
                }
                String dosEncoding = EncodingUtils.getProperEncoding();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "*** returned readerencoding = " + dosEncoding);
                }
                fis = null;
                InputStreamReader svcLogFileStreamReader = null;
                try {
                    try {
                        fis = new FileInputStream(fname);
                        svcLogFileStreamReader = new InputStreamReader((InputStream)fis, dosEncoding);
                        int readVal = -1;
                        while (!this.stopFlag) {
                            while ((readVal = svcLogFileStreamReader.read()) >= 0) {
                                System.out.print((char)readVal);
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                Tr.debug(tc, "readAndDisplayServiceLogFile(), caught InterruptedException");
                                this.stopFlag = true;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException ee) {
                                    // empty catch block
                                }
                                while ((readVal = svcLogFileStreamReader.read()) >= 0) {
                                    System.out.print((char)readVal);
                                }
                                break block10;
                            }
                        }
                        Object var9_10 = null;
                        if (svcLogFileStreamReader == null) break block17;
                    }
                    catch (UnsupportedEncodingException e) {
                        Tr.debug(tc, "caught UnsupportedEncodingException while waiting for file to be present", e);
                        Object var9_11 = null;
                        if (svcLogFileStreamReader != null) {
                            svcLogFileStreamReader.close();
                        }
                        if (fis == null) return;
                        fis.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    if (svcLogFileStreamReader != null) {
                        svcLogFileStreamReader.close();
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                svcLogFileStreamReader.close();
            }
            if (fis == null) return;
            fis.close();
        }

        private void waitForFileExist(String fname) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "waitForFileExist(" + fname + ")");
            }
            File serviceLogFile = new File(fname);
            while (!this.stopFlag && !serviceLogFile.exists()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught InterruptedException while waiting for file to be present", e);
                    }
                    return;
                }
            }
        }
    }

    class StreamConsumer
    extends Thread {
        InputStream inputStream;
        StringBuffer oBuff;

        StreamConsumer(InputStream iStream, StringBuffer outputBuff) {
            this.inputStream = iStream;
            this.oBuff = outputBuff;
        }

        public void run() {
            String inputRec = null;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((inputRec = bufferedReader.readLine()) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "inputRec == " + inputRec);
                    }
                    this.oBuff.append(inputRec);
                }
            }
            catch (Throwable t) {
                Tr.debug(tc, "Caught Throwable", t);
            }
        }
    }
}

