/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.nodeagent.ConfigSynchronizationService;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.NodeFederationUtility;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.File;
import java.util.Properties;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeSyncUtility
extends NodeFederationUtility {
    private static TraceComponent tc = Tr.register(NodeSyncUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "syncNode.log";
    private boolean stopservers = false;
    private boolean restart = false;
    private String localUserName = null;
    private String localPassword = null;

    public static void main(String[] args) {
        Properties systemProperties = System.getProperties();
        systemProperties.put("com.ibm.WebSphere.main_class", "NodeSyncUtility");
        System.setProperties(systemProperties);
        System.exit(new NodeSyncUtility().executeUtility(args));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0400I", null, null);
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        String option = args[curOption];
        if (option.equals("-stopservers")) {
            this.stopservers = true;
        } else if (option.equals("-conntype")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.connType = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-localusername")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.localUserName = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-localpassword")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.localPassword = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-restart")) {
            this.restart = true;
        } else {
            nextOption = -1;
        }
        return nextOption;
    }

    protected int runTool() throws Exception {
        block16: {
            if (!this.isMemberOfCell()) {
                this.issueMessage("ADMU2026E", new Object[]{this.nodeName}, null);
                return -1;
            }
            ConfigService configService = ConfigServiceFactory.getConfigService();
            if (configService == null) {
                try {
                    Properties prop = new Properties();
                    prop.setProperty("location", "local");
                    configService = ConfigServiceFactory.createConfigService(true, prop);
                    Tr.debug(tc, "configService = " + configService.toString());
                }
                catch (AdminException ae) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "Exception while creating a ConfigService", ae);
                }
            }
        }
        this.adminClient = this.getAdminClient(this.getClientProperties());
        ObjectName dmgrServer = this.adminClient.getServerMBean();
        String targetCellName = dmgrServer.getKeyProperty("cell");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Local node belongs to cell " + this.cellName + ", the cell to sync from is " + targetCellName);
        }
        if (!this.cellName.equals(targetCellName)) {
            throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[0], null));
        }
        ConfigServiceProxy cs = new ConfigServiceProxy(this.adminClient);
        Session ses = new Session();
        ObjectName[] scope = cs.resolve(ses, "Node=\"" + this.nodeName + "\"");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node " + this.nodeName + " is resolved in cell " + targetCellName);
        }
        if (scope.length < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...Not!");
            }
            throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[0], null));
        }
        cs.discard(ses);
        this.collectNodeMetadata(this.adminClient);
        this.notificationService = this.getNotificationServiceMBean();
        this.issueMessage("ADMU0401I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        this.checkProductExtensions(this.getWASProduct(), this.adminClient);
        if (this.stopservers) {
            ModelMgr.initialize((String)"ws-server");
            if (this.localUserName != null && this.localPassword != null) {
                this.stopAllServers(this.localUserName, this.localPassword);
            } else {
                this.stopAllServers();
            }
        }
        if (!this.isDmgrSameOrLaterVersion()) {
            this.issueMessage("ADMU0127E", new String[]{this.getDMgrVersion(), Utils.getProductVersion()}, null);
            return -1;
        }
        if (this.isNodeAgentRunning()) {
            this.issueMessage("ADMU0403E", null, null);
            return -1;
        }
        this.syncNode(this.getSyncProperties());
        if (this.isZOS()) {
            this.transformConfig2Native(this.cellName, this.nodeName);
        }
        if (this.restart) {
            this.setupNodeAgentData(this.cellName);
            this.issueMessage("ADMU0018I", new Object[]{this.nodeName}, null);
            this.newCellName = this.cellName;
            this.launchNodeAgent();
        }
        this.issueMessage("ADMU0402I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        return 0;
    }

    private boolean isNodeAgentRunning() throws Exception {
        ObjectName name = new ObjectName("WebSphere:*,type=NodeAgent,node=" + this.nodeName);
        return !this.adminClient.queryNames(name, null).isEmpty();
    }

    private Properties getSyncProperties() throws Exception {
        Properties syncProps = this.getClientProperties();
        ConfigRoot cfgRoot = this.getLocalRepository().getConfigRoot();
        String oldServer = cfgRoot.getValue(4);
        cfgRoot.setValue(4, "nodeagent");
        Resource r = cfgRoot.getResource(4, "server.xml");
        cfgRoot.setValue(4, oldServer);
        Server rootObj = null;
        EList serverExtent = r.getContents();
        for (int i = 0; i < serverExtent.size(); ++i) {
            Object res = serverExtent.get(i);
            if (!(res instanceof Server)) continue;
            rootObj = (Server)res;
            break;
        }
        if (rootObj != null) {
            EList components = rootObj.getComponents();
            for (Component s : components) {
                if (!(s instanceof NodeAgent)) continue;
                NodeAgent na = (NodeAgent)s;
                ConfigSynchronizationService syncCfg = na.getFileSynchronizationService();
                EList props = syncCfg.getProperties();
                for (Property prop : props) {
                    syncProps.setProperty(prop.getName(), prop.getValue());
                }
            }
        }
        return syncProps;
    }

    protected void syncNode(Properties clientProps) throws Exception {
        NodeSync synch = NodeSync.createNodeSync();
        try {
            clientProps.setProperty("was.repository.root", this.configRoot);
            System.setProperty("com.ibm.ws.management.standalone", "true");
            synch.initialize(clientProps, null, this.getVariableMap());
            this.issueMessage("ADMU0016I", null, null);
            Boolean b = synch.sync();
            if (!b.booleanValue()) {
                throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[]{""}, null));
            }
        }
        catch (AdminException ae) {
            Tr.error(tc, "ADMU0005E", ae);
            throw ae;
        }
    }
}

