/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.component.NodeAgentImpl;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.status.AbstractStatusCache;
import com.ibm.ws.management.status.AppServerStatusReport;
import com.ibm.ws.management.status.NodeAgentStatusReportExt;
import com.ibm.ws.management.status.StatusCacheExtension;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.status.StatusReportExtendedData;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class NodeAgentStatusCache
extends AbstractStatusCache {
    private static final TraceComponent tc = Tr.register(NodeAgentStatusCache.class, null, null);
    private static final String CLASS_NAME = "com.ibm.ws.management.status.NodeAgentStatusCache";
    private static final String DMZ_PRODUCT_SHORT_NAME = "NDDMZ";
    private Map server_state = Collections.synchronizedMap(new HashMap());
    private Map server_reports = Collections.synchronizedMap(new HashMap());
    private AdminClient parent_ac = null;
    private String parentNodeName = null;
    private String parentProcessName = null;
    private ObjectName parentStatusCache = null;
    private StatusReport currentReport = null;
    private SecurityService securityService = null;

    protected NodeAgentStatusCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NodeAgentStatusCache(),uuid=" + this.originalUUID);
        }
        this.setDownstreamReportsForExtensions();
        this.refreshCache(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NodeAgentStatusCache");
        }
    }

    protected void createStatusCacheExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatusCacheExtensions");
        }
        this._statusCacheExtensionClasses = this.createStatusCacheExtensionClassList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numExt=" + this._statusCacheExtensionClasses.length);
        }
        this._statusCacheExtensions = new StatusCacheExtension[this._statusCacheExtensionClasses.length];
        for (int i = 0; i < this._statusCacheExtensionClasses.length; ++i) {
            String className = null;
            try {
                className = this._statusCacheExtensionClasses[i];
                Class<?> extenderClass = Class.forName(className);
                Object o = extenderClass.newInstance();
                if (o instanceof StatusCacheExtension) {
                    this._statusCacheExtensions[i] = (StatusCacheExtension)o;
                    continue;
                }
                Exception e = new Exception("Class \"" + className + "\" does not implement required interface.");
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", (String)"106", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid extension class \"" + className + "\".", e);
                }
                this._statusCacheExtensions[i] = null;
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", (String)"110", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to instantiate extension \"" + className + "\".", e);
                }
                this._statusCacheExtensions[i] = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatusCacheExtensions");
        }
    }

    protected String[] createStatusCacheExtensionClassList() {
        String[] stringArray;
        String prodShortName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatusCacheExtensionClassList");
        }
        try {
            ManagedObjectMetadataHelper metadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
            AdminService adminService = AdminServiceFactory.getAdminService();
            String thisNodeName = adminService.getNodeName();
            prodShortName = metadataHelper.getNodeBaseProductShortName(thisNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Product short name: " + prodShortName);
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.createStatusCacheExtensionClassList", (String)"128", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get product short name.  Assuming it's not NDDMZ.", th);
            }
            prodShortName = "";
        }
        if (DMZ_PRODUCT_SHORT_NAME.equals(prodShortName)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "com.ibm.ws.management.bla.runtime.NodeAgentStatusCacheExtension";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "com.ibm.ws.management.bla.runtime.NodeAgentStatusCacheExtension";
            stringArray = stringArray3;
            stringArray3[1] = "com.ibm.ws.webservices.admin.status.NodeAgentStatusCacheExtension";
        }
        String[] extClassList = stringArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatusCacheExtensionClassList", extClassList);
        }
        return extClassList;
    }

    protected void setDownstreamReportsForExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDownstreamReportsForExtensions");
        }
        for (StatusCacheExtension statusCacheExt : this._statusCacheExtensions) {
            if (statusCacheExt == null) continue;
            statusCacheExt.setDownstreamReports(this.server_reports);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDownstreamReportsForExtensions");
        }
    }

    public void registerEvents() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEvents");
        }
        this.checkAdminContext();
        this.listenForJ2EEStateNotifications();
        this.listenForCacheReportNotifications();
        for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
            if (extension2 == null) continue;
            extension2.registerEvents(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEvents");
        }
    }

    public void requestReport(Boolean force) {
        Set server;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport - force", new Object[]{force});
        }
        this.checkAdminContext();
        StringBuffer name = new StringBuffer();
        name.append("WebSphere:type=StatusCache,cell=");
        name.append(this._cellName);
        name.append(",node=");
        name.append(this._nodeName);
        name.append(",*");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RequestReport: ObjectName " + name.toString());
        }
        if ((server = super.getMBeans(name.toString())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get mbeans for All Servers");
            }
            return;
        }
        for (ObjectName serv : server) {
            if (serv == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not get mbeans for Server: " + serv);
                }
                return;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking on: " + server.toString());
                }
                if (force.equals(Boolean.TRUE)) {
                    super.invoke(serv, "sendReport", new Object[]{Boolean.TRUE}, new String[]{"java.lang.Boolean"});
                    continue;
                }
                super.invoke(serv, "sendReport", null, null);
            }
            catch (MBeanException bean) {
                FFDCFilter.processException((Throwable)bean, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", (String)"119", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not invoke function sendReport on: " + serv);
                Tr.debug(tc, "Exception: " + bean);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", (String)"126", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception in requestReport " + e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport - force");
        }
    }

    public void requestReport(String contact) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport");
        }
        this.requestReport(contact, Boolean.FALSE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void requestReport(String contact, Boolean force) {
        ObjectName server;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport - force", new Object[]{force});
        }
        this.checkAdminContext();
        StringBuffer name = new StringBuffer();
        name.append("WebSphere:type=StatusCache,cell=");
        name.append(this._cellName);
        name.append(",node=");
        name.append(this._nodeName);
        name.append(",process=");
        name.append(contact);
        name.append(",*");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RequestReport: ObjectName " + name.toString());
        }
        if ((server = super.getMBean(name.toString())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get mbean for Server: " + contact);
            }
            return;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking on: " + server.toString());
            }
            if (force.equals(Boolean.TRUE)) {
                super.invoke(server, "sendReport", new Object[]{Boolean.TRUE}, new String[]{"java.lang.Boolean"});
            } else {
                super.invoke(server, "sendReport", null, null);
            }
        }
        catch (MBeanException bean) {
            FFDCFilter.processException((Throwable)bean, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", (String)"260", (Object)this);
            Tr.debug(tc, "Could not invoke function sendReport on: " + server);
            Tr.debug(tc, "Exception: " + bean);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", (String)"264", (Object)this);
            Tr.debug(tc, "Exception in reqestReprot: " + e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport - force");
        }
    }

    public void _sendReport(Boolean force) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport - force", new Object[]{force});
        }
        if (force.equals(Boolean.TRUE)) {
            this.refreshCache(true);
        }
        this._sendReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport");
        }
    }

    public void _sendReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport");
        }
        this.checkAdminContext();
        Map server_type = this.generateServerTypes();
        NodeAgentStatusReportExt report = new NodeAgentStatusReportExt(this.server_state, this.server_reports, server_type);
        report.setCell(this._cellName);
        report.setNode(this._nodeName);
        report.setServer(this._serverName);
        report.setDeployments(this._app_deployments);
        this.server_state.put(this._serverName, "j2ee.state.running");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Local ObjectName: " + this.getObjectName());
        }
        if (this.getObjectName() == null) {
            return;
        }
        for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
            StatusReportExtendedData extendedData;
            if (extension2 == null || (extendedData = extension2.getExtendedData(report)) == null) continue;
            report.setExtendedData(extendedData);
        }
        this.currentReport = report;
        String uuid = AdminContext.peek();
        if (uuid != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeAgentStatus sending new report for admin subsystem " + uuid);
            }
            report.generate();
            if (AdminHelper.getPlatformHelper().isZOS()) {
                Notification notif = new Notification("websphere.status.report", this.getObjectName(), this._notif_num++);
                notif.setUserData(report);
                super.sendReportNotification(notif);
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "Going direct");
                }
                StatusCacheFactory.setReport(report);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport");
        }
    }

    public String dumpCache() {
        StringBuffer buff = new StringBuffer();
        buff.append("Node: ");
        buff.append(this._nodeName);
        buff.append("\n");
        buff.append("---------------------\n");
        Set entrySet = this.server_state.entrySet();
        for (Map.Entry me : entrySet) {
            buff.append("Server: ");
            buff.append(me.getKey());
            buff.append("\nState: ");
            buff.append(me.getValue());
            buff.append("\nReport: ");
            buff.append(this.server_reports.get(me.getKey()));
            if (this.server_reports.get(me.getKey()) != null) {
                StatusReport serverReport = (StatusReport)this.server_reports.get(me.getKey());
                buff.append(serverReport.print());
            }
            buff.append("\n");
            buff.append("\n");
        }
        buff.append("END OF DUMP");
        return buff.toString();
    }

    public void handleNotification(Notification notification, Object handback) {
        String threadUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NodeAgentStatusCache.handleNotification", new Object[]{notification, handback, threadUUID, this.originalUUID});
        }
        this.checkAdminContext();
        String notificationType = notification.getType();
        if (handback.equals(STATUS_CACHE_LISTENER)) {
            if (notificationType.equals("websphere.status.report")) {
                String state;
                ObjectName source = (ObjectName)notification.getSource();
                String sname = source.getKeyProperty("process");
                if (sname.equals(this._serverName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Received a report from : " + sname + "  Ignoring");
                    }
                    this.server_state.put(sname, "j2ee.state.running");
                    return;
                }
                AppServerStatusReport report = (AppServerStatusReport)notification.getUserData();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received a report from : " + sname + "  Report: " + report);
                }
                if ((state = (String)this.server_state.get(sname)) == null || !state.equals("j2ee.state.stopping") && !state.equals("j2ee.state.stopped") && !state.equals("j2ee.state.failed")) {
                    this.server_state.put(sname, "j2ee.state.running");
                }
                this.server_reports.put(sname, report);
                this.sendReport();
                return;
            }
        } else if (handback.equals(SERVER_LISTENER)) {
            ObjectName source = (ObjectName)notification.getSource();
            String sname = source.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server changed is: " + sname);
            }
            if (notificationType.equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + sname + " is now STOPPING");
                }
                this.server_state.put(sname, "j2ee.state.stopping");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server is stopped, deleting report");
                }
                this.server_reports.remove(sname);
            } else if (notificationType.equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + sname + " is now STOPPED");
                }
                this.server_state.put(sname, "j2ee.state.stopped");
            } else if (notificationType.equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + sname + " is now STARTING");
                }
                this.server_state.put(sname, "j2ee.state.starting");
            } else if (notificationType.equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + sname + " is now RUNNING");
                }
                this.server_state.put(sname, "j2ee.state.running");
            } else if (notificationType.equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + sname + " is now FAILED");
                }
                this.server_state.put(sname, "j2ee.state.failed");
            }
            this.sendReport();
        } else {
            boolean handled = false;
            for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
                if (extension2 == null) continue;
                handled |= extension2.handleNotification(notification, handback);
            }
            if (handled) {
                this.sendReport();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NodeAgentStatusCache.handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshCache(boolean force_refresh) {
        String threadUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshCache", new Object[]{threadUUID, this.originalUUID});
        }
        this.checkAdminContext();
        if (this._servers == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not refreshCache, _servers was null");
            }
            return;
        }
        Set cache_servers = this.server_state.keySet();
        Iterator cache_it = cache_servers.iterator();
        while (cache_it.hasNext()) {
            String serv = (String)cache_it.next();
            if (this._servers.contains(serv)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove Server: " + serv + " from Cache as it is no longer on the HFS");
            }
            force_refresh = true;
            cache_it.remove();
        }
        for (String serv : this._servers) {
            if (cache_servers.contains(serv)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add Server: " + serv + " to Cache as it is new on the HFS");
            }
            force_refresh = true;
            this.server_state.put(serv, "j2ee.state.stopped");
        }
        if (force_refresh) {
            StringBuffer name = new StringBuffer("WebSphere:type=Server,node=");
            name.append(this._nodeName);
            name.append(",*");
            Set active = this.getMBeans(name.toString());
            Iterator act = active.iterator();
            while (act.hasNext()) {
                String server = null;
                String state = null;
                try {
                    block23: {
                        Object var15_16;
                        Subject savedSubject = null;
                        Subject ownSubject = null;
                        ownSubject = SecurityHelper.getOwnedSubject();
                        try {
                            try {
                                if (ownSubject != null) {
                                    savedSubject = SecurityHelper.pushInvocationSubject(ownSubject);
                                }
                                ObjectName bean = (ObjectName)act.next();
                                server = bean.getKeyProperty("process");
                                state = (String)AdminServiceFactory.getAdminService().getAttribute(bean, "state");
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.refreshCache", (String)"385", (Object)this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception getting mbean attributes", e);
                                }
                                var15_16 = null;
                                if (ownSubject != null) {
                                    SecurityHelper.popInvocationSubject(savedSubject);
                                }
                                break block23;
                            }
                            var15_16 = null;
                            if (ownSubject == null) break block23;
                        }
                        catch (Throwable throwable) {
                            var15_16 = null;
                            if (ownSubject != null) {
                                SecurityHelper.popInvocationSubject(savedSubject);
                            }
                            throw throwable;
                        }
                        SecurityHelper.popInvocationSubject(savedSubject);
                    }
                    if (state.equals("STARTED")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding Server: " + server + " to Cache as it is: " + state);
                        }
                        this.server_state.put(server, "j2ee.state.running");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Server: " + server + " to Cache as it is: " + state);
                    }
                    this.server_state.put(server, "j2ee.state.stopped");
                }
                catch (Exception mbe) {
                    FFDCFilter.processException((Throwable)mbe, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.refreshCache", (String)"400", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in refreshCache ", mbe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCache");
        }
    }

    public void addToCache(int type, String server, String state) {
        String threadUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToCache", new Object[]{server, state, threadUUID, this.originalUUID});
        }
        this.checkAdminContext();
        if (tc.isDebugEnabled()) {
            try {
                throw new Exception("addtoCache: ");
            }
            catch (Exception ex) {
                Tr.debug(tc, "addToCache Stack Trace", ex);
            }
        }
        if (type == 0) {
            this.server_state.put(server, state);
            this.requestReport(server);
            this.sendReport(new Boolean(false));
        } else if (type == 2) {
            this.refreshCache(true);
            this.requestReport(Boolean.FALSE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToCache");
        }
    }

    public synchronized void removeFromCache(int type, String server) {
        String threadUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromCache", new Object[]{server, threadUUID, this.originalUUID});
        }
        this.checkAdminContext();
        if (type == 0) {
            this.server_state.put(server, "j2ee.state.stopped");
            this.server_reports.remove(server);
            this.sendReport(new Boolean(true));
        } else if (type == 2) {
            this.refreshCache(true);
            this.requestReport(Boolean.TRUE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromCache");
        }
    }

    protected void listenForMessageListenerNotifications() {
    }

    protected void listenForLocalApplicationNotifications() {
    }

    protected void listenForJ2EEStateNotifications() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForJ2EEStateNotifications");
            }
            try {
                String uuid = AdminContext.peek();
                String processType = uuid == null ? "ManagedProcess" : "UnManagedProcess";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using processType: " + processType + ", uuid=" + uuid);
                }
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName appserver = new ObjectName("WebSphere:*,type=Server,processType=" + processType);
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("j2ee.state.stopping");
                filter.enableType("j2ee.state.stopped");
                filter.enableType("j2ee.state.starting");
                filter.enableType("j2ee.state.running");
                filter.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(appserver, this, filter, SERVER_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.listenForJ2EEStateNotifications", (String)"470", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "JMX Exception in listenForJ2EEStateNotifications ", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForJ2EEStateNotifications");
        }
    }

    protected void listenForCacheReportNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForCacheReportNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName appserver = new ObjectName("WebSphere:*,type=StatusCache,node=" + this._nodeName);
                adminService.addNotificationListenerExtended(appserver, this, null, STATUS_CACHE_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.listenForCacheReportNotifications", (String)"485", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForCacheReportNotifications ", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForCacheReportNotifications");
        }
    }

    public void childAdded(ServerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childAdded");
        }
        this.checkAdminContext();
        this.addToCache(0, info.getName(), "j2ee.state.running");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childAdded");
        }
    }

    public void childRemoved(ServerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childRemoved");
        }
        this.checkAdminContext();
        this.removeFromCache(0, info.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childRemoved");
        }
    }

    public void parentAdded(ServerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentAdded");
        }
        this.checkAdminContext();
        StatusCacheTimedThread sctt = new StatusCacheTimedThread(this, 60000L, true);
        sctt.setDaemon(true);
        sctt.start();
        StatusCacheTimedThread sctt2 = new StatusCacheTimedThread(this, 3000L, false);
        sctt2.setDaemon(true);
        sctt2.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentAdded");
        }
    }

    class StatusCacheTimedThread
    extends Thread {
        boolean sendData;
        StatusReport lastReport;
        NodeAgentStatusCache cache;
        long sleep;
        boolean active;

        public StatusCacheTimedThread(NodeAgentStatusCache c, long s, boolean ac) {
            super("StatusCacheTimedThread:" + ac);
            this.sendData = true;
            this.lastReport = null;
            this.cache = null;
            this.sleep = 120000L;
            this.active = false;
            Tr.debug(tc, "Creating StatusCacheTimedThread");
            this.cache = c;
            this.sleep = s;
            this.active = ac;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StatusCacheTimedThread run");
            }
            while (this.sendData) {
                block27: {
                    try {
                        Thread.sleep(this.sleep);
                    }
                    catch (InterruptedException ie) {
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug(tc, "StatusCacheTimedThread InterruptException", ie);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Active: " + this.active);
                }
                if (this.active) {
                    Object var9_11;
                    Subject savedSubject = null;
                    Subject ownSubject = null;
                    ownSubject = SecurityHelper.getOwnedSubject();
                    NodeAgentImpl nodeAgentImpl = new NodeAgentImpl();
                    SecurityHelper sh = SecurityHelper.getHelper();
                    if (sh != null) {
                        NodeAgentStatusCache.this.securityService = nodeAgentImpl.registerSecurityService();
                        if (NodeAgentStatusCache.this.securityService != null) {
                            sh.setSecurityService(NodeAgentStatusCache.this.securityService);
                            NodeAgentStatusCache.this.securityService.addListener((SecurityServiceListener)sh);
                        }
                    }
                    try {
                        block28: {
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Parent AdminClient: " + NodeAgentStatusCache.this.parent_ac);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ownSubject ", ownSubject);
                                }
                                if (ownSubject != null) {
                                    savedSubject = SecurityHelper.pushInvocationSubject(ownSubject);
                                }
                                if (NodeAgentStatusCache.this.parent_ac == null) {
                                    NodeAgentStatusCache.this.parent_ac = RoutingTable.getInstance().getParent();
                                    if (NodeAgentStatusCache.this.parentStatusCache == null) {
                                        ObjectName server = NodeAgentStatusCache.this.parent_ac.getServerMBean();
                                        NodeAgentStatusCache.this.parentNodeName = server.getKeyProperty("node");
                                        NodeAgentStatusCache.this.parentProcessName = server.getKeyProperty("process");
                                        ObjectName parentSCQuery = new ObjectName("WebSphere:*,type=StatusCache,node=" + NodeAgentStatusCache.this.parentNodeName + ",process=" + NodeAgentStatusCache.this.parentProcessName);
                                        Set results = NodeAgentStatusCache.this.parent_ac.queryNames(parentSCQuery, null);
                                        NodeAgentStatusCache.this.parentStatusCache = (ObjectName)results.iterator().next();
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Parent StatusCache: " + NodeAgentStatusCache.this.parentStatusCache);
                                        }
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "AdminClient / StatusCache ", new Object[]{NodeAgentStatusCache.this.parent_ac, NodeAgentStatusCache.this.parentStatusCache});
                                }
                                if (!sh.isSecurityServiceStarted() || sh.isSecurityServiceStopped() || NodeAgentStatusCache.this.parent_ac == null || NodeAgentStatusCache.this.parentStatusCache == null) break block28;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Invoking placeReport: " + NodeAgentStatusCache.this.parentStatusCache);
                                }
                                this.lastReport = NodeAgentStatusCache.this.currentReport;
                                NodeAgentStatusCache.this.parent_ac.invoke(NodeAgentStatusCache.this.parentStatusCache, "placeReport", new Object[]{NodeAgentStatusCache.this.currentReport}, new String[]{"com.ibm.ws.management.status.StatusReport"});
                            }
                            catch (InstanceNotFoundException infe) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Clearing cached parent status object, instance not found: " + NodeAgentStatusCache.this.parentStatusCache.toString());
                                }
                                NodeAgentStatusCache.this.parentStatusCache = null;
                                NodeAgentStatusCache.this.parent_ac = null;
                                var9_11 = null;
                                if (ownSubject == null) continue;
                                SecurityHelper.popInvocationSubject(savedSubject);
                                continue;
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.NodeAgentStatusCache$StatusCacheTimedThread.run", (String)"1371", (Object)this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception in AbstractStatusCache:" + e);
                                }
                                var9_11 = null;
                                if (ownSubject == null) continue;
                                SecurityHelper.popInvocationSubject(savedSubject);
                                continue;
                            }
                        }
                        var9_11 = null;
                        if (ownSubject == null) continue;
                    }
                    catch (Throwable throwable) {
                        var9_11 = null;
                        if (ownSubject != null) {
                            SecurityHelper.popInvocationSubject(savedSubject);
                        }
                        throw throwable;
                    }
                    SecurityHelper.popInvocationSubject(savedSubject);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Last / Current ", new Object[]{this.lastReport, NodeAgentStatusCache.this.currentReport});
                }
                if (this.lastReport == NodeAgentStatusCache.this.currentReport) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending Notification");
                }
                this.lastReport = NodeAgentStatusCache.this.currentReport;
                Notification notif = new Notification("websphere.status.report", NodeAgentStatusCache.this.getObjectName(), NodeAgentStatusCache.this._notif_num++);
                notif.setUserData(NodeAgentStatusCache.this.currentReport);
                this.cache.sendReportNotification(notif);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatusCacheTimedThread run");
            }
        }
    }
}

