/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.AbstractStatusReport;
import com.ibm.ws.management.status.ExecutionState;
import com.ibm.ws.management.status.NodeAgentStatusReport;
import com.ibm.ws.management.status.StatusReport;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeploymentManagerStatusReport
extends AbstractStatusReport
implements Serializable {
    private static final long serialVersionUID = 31678516957423592L;
    protected Map node_states;
    protected Map node_reports;
    protected Map cluster_states;
    protected static final TraceComponent tc = Tr.register(DeploymentManagerStatusReport.class.getName(), null, null);

    public DeploymentManagerStatusReport(Map nodeagents, Map reports, Map clust) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentManagerStatusReport", new Object[]{nodeagents, reports, clust});
        }
        this.type = 2;
        this.node_states = new Hashtable(nodeagents);
        this.node_reports = new Hashtable(reports);
        this.cluster_states = new Hashtable(clust);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Building list of backlevel nodes for use by app_state", nodeagents);
        }
        Set entrySet = nodeagents.entrySet();
        for (Map.Entry ent : entrySet) {
            String node = (String)ent.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node: ", node);
            }
            String trans = ExecutionState.transition((String)((String)ent.getValue()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "State for Node: ", trans);
            }
            Object rep = reports.get(node);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Report for Node: ", rep);
            }
            if (!"ExecutionState.STARTED".equals(trans) || rep != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node: " + node + " + is backlevel");
            }
            this.node_states.put(ent.getKey(), "BACK_LEVEL");
            this._back_level_nodes.add(ent.getKey());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentManagerStatusReport", new Object[]{this.timestamp});
        }
    }

    public Map getNodeReports() {
        return this.node_reports;
    }

    public String getClusterState(String clust) {
        String state;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterState", new Object[]{clust});
        }
        if ("ExecutionState.UNKNOWN".equals(state = ExecutionState.transition((String)((String)this.cluster_states.get(clust))))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterState", "ExecutionState.UNAVAILABLE");
            }
            return "ExecutionState.UNAVAILABLE";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterState", state);
        }
        return state;
    }

    public String getApplicationState(String application, String node, String server) {
        String trans;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationState", new Object[]{application, node, server});
        }
        if ("BACK_LEVEL".equals(trans = ExecutionState.transition((String)((String)this.node_states.get(node))))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node is backlevel", node);
            }
            StringBuffer name = new StringBuffer("WebSphere:type=Application");
            name.append(",name=");
            name.append(application);
            name.append(",node=");
            name.append(node);
            name.append(",process=");
            name.append(server);
            name.append(",*");
            ObjectName app = this.getMBean(name.toString());
            if (app != null) {
                return "ExecutionState.STARTED";
            }
            return "ExecutionState.STOPPED";
        }
        NodeAgentStatusReport report = (NodeAgentStatusReport)this.node_reports.get(node);
        if (report == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationState", new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        String state = report.getApplicationState(application, node, server);
        if (state.equals("ExecutionState.UNAVAILABLE")) {
            String serverState = report.getServerState(node, server);
            if (serverState == null) {
                serverState = "ExecutionState.STOPPED";
            }
            if (serverState.equals("ExecutionState.STOPPED")) {
                state = "ExecutionState.STOPPED";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Stopped implies Application Stopped - " + application);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationState", new Object[]{state});
        }
        return state;
    }

    public String getMessageListenerState(String port, String node, String server) {
        String state;
        block13: {
            String trans;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMessageListenerState", new Object[]{port, node, server});
            }
            if ("BACK_LEVEL".equals(trans = ExecutionState.transition((String)((String)this.node_states.get(node))))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node is backlevel", node);
                }
                StringBuffer name = new StringBuffer("WebSphere:type=ListenerPort,node=");
                name.append(node);
                name.append(",name=");
                name.append(port);
                name.append(",process=");
                name.append(server);
                name.append(",*");
                ObjectName portON = this.getMBean(name.toString());
                if (portON != null) {
                    Boolean bool = (Boolean)this.getMBeanAttribute(portON, "started");
                    if (bool != null) {
                        if (bool.booleanValue()) {
                            return "ExecutionState.STARTED";
                        }
                        return "ExecutionState.STOPPED";
                    }
                    return "ExecutionState.STARTED";
                }
                return "ExecutionState.STOPPED";
            }
            NodeAgentStatusReport report = (NodeAgentStatusReport)this.node_reports.get(node);
            if (report == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMessageListenerState", new Object[]{"ExecutionState.UNAVAILABLE"});
                }
                return "ExecutionState.UNAVAILABLE";
            }
            state = null;
            try {
                state = report.getMessageListenerState(port, node, server);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMessageListenerState", (String)"176", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception was thrown found", e);
                }
            }
            catch (Error err) {
                FFDCFilter.processException((Throwable)err, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMessageListenerState", (String)"181", (Object)this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Error occured", err);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageListenerState", new Object[]{state});
        }
        return state;
    }

    public String getServerType(String node, String server) {
        String trans;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType", new Object[]{node, server});
        }
        if ("BACK_LEVEL".equals(trans = ExecutionState.transition((String)((String)this.node_states.get(node))))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Back Level node - returning  " + trans, node);
            }
            return trans;
        }
        NodeAgentStatusReport report = (NodeAgentStatusReport)this.node_reports.get(node);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NodeAgentStatusReport", report);
        }
        if (report == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerType", null);
            }
            return null;
        }
        String type = report.getServerType(node, server);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", type);
        }
        return type;
    }

    public String getServerState(String node, String server) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerState", new Object[]{node, server});
        }
        if (server.equals("nodeagent")) {
            return this.getNodeState(node);
        }
        String trans = ExecutionState.transition((String)((String)this.node_states.get(node)));
        if ("BACK_LEVEL".equals(trans)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node is backlevel", node);
            }
            StringBuffer name = new StringBuffer("WebSphere:type=Server");
            name.append(",process=" + server);
            name.append(",node=" + node);
            name.append(",*");
            ObjectName serverON = this.getMBean(name.toString());
            Tr.debug(tc, "ServerON", serverON);
            if (serverON != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.STARTED"});
                }
                return "ExecutionState.STARTED";
            }
            String nodeState = this.getNodeState(node);
            if ("ExecutionState.STARTED".equals(nodeState)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.STOPPED"});
                }
                return "ExecutionState.STOPPED";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        NodeAgentStatusReport report = (NodeAgentStatusReport)this.node_reports.get(node);
        if (report == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        String trans2 = report.getServerState(node, server);
        if (trans2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.STOPPED"});
            }
            return "ExecutionState.STOPPED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerState", new Object[]{trans2});
        }
        return trans2;
    }

    public String print() {
        StringBuffer buff = new StringBuffer();
        buff.append("Deployment Manager: ");
        buff.append("\n");
        buff.append("---------------------\n");
        Set entrySet = this.cluster_states.entrySet();
        for (Map.Entry me : entrySet) {
            buff.append("App: ");
            buff.append(me.getKey());
            buff.append("\nState: ");
            buff.append(me.getValue());
            buff.append("\n");
            buff.append("\n");
        }
        Set nodeEntrySet = this.node_states.entrySet();
        for (Map.Entry me : nodeEntrySet) {
            buff.append("\nNode: ");
            buff.append(me.getKey());
            buff.append("\nState: ");
            buff.append(me.getValue());
            buff.append("\nReport: ");
            buff.append(this.node_reports.get(me.getKey()));
            if (this.node_reports.get(me.getKey()) != null) {
                buff.append(((StatusReport)this.node_reports.get(me.getKey())).print());
            }
            buff.append("\n");
            buff.append("\n");
        }
        buff.append("END OF DUMP");
        return buff.toString();
    }

    public String getNodeState(String node) {
        String trans;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeState", new Object[]{node});
        }
        if ("BACK_LEVEL".equals(trans = ExecutionState.transition((String)((String)this.node_states.get(node))))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node is backlevel", node);
            }
            StringBuffer name = new StringBuffer("WebSphere:type=Server");
            name.append(",process=nodeagent");
            name.append(",node=" + node);
            name.append(",*");
            ObjectName nodeON = this.getMBean(name.toString());
            if (nodeON != null) {
                return "ExecutionState.STARTED";
            }
            return "ExecutionState.STOPPED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeState", new Object[]{trans});
        }
        return trans;
    }

    public String[] getNodes() {
        String[] nds = this.node_states.keySet().toArray(new String[0]);
        return nds;
    }

    public String[] getServers(String node) {
        String METHOD = "getServers";
        String[] servlist = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServers", new Object[]{node});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node_reports = " + this.node_reports);
        }
        NodeAgentStatusReport report = (NodeAgentStatusReport)this.node_reports.get(node);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "report = " + report);
        }
        if (report == null) {
            Tr.debug(tc, "NO REPORT FOUND for node " + node);
            servlist = new String[]{};
        } else {
            servlist = report.getServers(node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServers", servlist);
        }
        return servlist;
    }

    public ObjectName getMBean(String filterString) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMBean", new Object[]{filterString});
            }
            try {
                ObjectName name = new ObjectName(filterString);
                Iterator iter = AdminServiceFactory.getAdminService().queryNames(name, null).iterator();
                if (iter.hasNext()) {
                    ObjectName objectName = (ObjectName)iter.next();
                    if (iter.hasNext() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Multiple MBeans found when only one was expected");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMBean", new Object[]{objectName});
                    }
                    return objectName;
                }
            }
            catch (MalformedObjectNameException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", (String)"371", (Object)this);
                Tr.error(tc, "Invalid MBean filter passed to getMBean: " + filterString);
            }
            catch (OutOfMemoryError oom) {
                FFDCFilter.processException((Throwable)oom, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", (String)"374", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Target Server is out of memory!", oom);
                }
            }
            catch (Exception gen) {
                FFDCFilter.processException((Throwable)gen, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", (String)"377", (Object)this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Exception occured", gen);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean - null");
        }
        return null;
    }

    public Object getMBeanAttribute(ObjectName on, String attr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanAttribute", new Object[]{on, attr});
        }
        Object ret = null;
        try {
            ret = AdminServiceFactory.getAdminService().getAttribute(on, attr);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", (String)"393", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanAttribute", ret);
        }
        return ret;
    }
}

