/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.nodeagent;

import com.ibm.wsspi.runtime.config.ConfigObject;

class MonitorConfig {
    String pid = null;
    int pingInterval = 60;
    int pingTimeout = 300;
    int maximumStartupAttempts = 3;
    boolean autoRestart = true;
    int nodeRestartState = 2;
    int previousState = -1;

    MonitorConfig(ConfigObject policy) {
        if (policy != null) {
            this.pingInterval = policy.getInt("pingInterval", 0);
            this.pingTimeout = policy.getInt("pingTimeout", 0);
            this.maximumStartupAttempts = policy.getInt("maximumStartupAttempts", 0);
            String nodeRestartStateString = policy.getString("nodeRestartState", "STOPPED");
            if (nodeRestartStateString.equals("RUNNING")) {
                this.nodeRestartState = 1;
            } else if (nodeRestartStateString.equals("PREVIOUS")) {
                this.nodeRestartState = 2;
            } else if (nodeRestartStateString.equals("STOPPED")) {
                this.nodeRestartState = 0;
            }
            this.autoRestart = policy.getBoolean("autoRestart", true);
            if (this.autoRestart && this.maximumStartupAttempts < 0) {
                this.maximumStartupAttempts = 1;
            }
        }
    }

    int getMaximumStartupAttempts() {
        return this.maximumStartupAttempts;
    }

    int getPingInterval() {
        return this.pingInterval;
    }

    int getPingTimeout() {
        return this.pingTimeout;
    }

    boolean getAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(boolean autoRestart) {
        this.autoRestart = autoRestart;
    }

    int getNodeRestartState() {
        return this.nodeRestartState;
    }

    public void setNodeRestartState(int nodeRestartState) {
        this.nodeRestartState = nodeRestartState;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(int previousState) {
        this.previousState = previousState;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String toString() {
        return "PingInterval: " + this.pingInterval + "\r\n" + "PingTimeout: " + this.pingTimeout + "\r\n" + "MaximumStartupAttempts: " + this.maximumStartupAttempts + "\r\n" + "NodeRestartState: " + this.nodeRestartState + "\r\n" + "PreviousState: " + this.previousState + "\r\n" + "AutoRestart: " + this.autoRestart + "\r\n";
    }
}

