/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import java.util.Properties;

public class ManagedObjectMetadataCommandProvider
extends SimpleCommandProvider {
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataCommandProvider.class, "Admin", null);
    private ManagedObjectMetadataAccessor _metadataAccessor = null;
    private ManagedObjectMetadataHelper _metadataHelper = null;

    public Properties getMetadataProperties(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getMetadataProperties", "nodeName=" + nodeName);
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        Properties nodeData = accessor.getMetadataProperties(nodeName);
        return nodeData;
    }

    public String getMetadataProperty(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        String propName = (String)cmd.getParameter("propertyName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getMetadataProperty", new String[]{"nodeName=" + nodeName, "propName=" + propName});
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        String metadata2 = accessor.getMetadataProperty(nodeName, propName);
        return metadata2;
    }

    public String getNodeMajorVersion(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNodeMajorVersion", "nodeName=" + nodeName);
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
        String majorVersion = helper.getNodeMajorVersion(nodeName);
        return majorVersion;
    }

    public String getNodeMinorVersion(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNodeMinorVersion", "nodeName=" + nodeName);
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
        String minorVersion = helper.getNodeMinorVersion(nodeName);
        return minorVersion;
    }

    public String getNodeBaseProductVersion(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNodeBaseProductVersion", "nodeName=" + nodeName);
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
        String baseProdVersion = helper.getNodeBaseProductVersion(nodeName);
        return baseProdVersion;
    }

    public Integer compareNodeVersion(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        String version = (String)cmd.getParameter("version");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "compareNodeVersion", new String[]{"nodeName=" + nodeName, "version=" + version});
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
        int result = helper.compareNodeVersion(nodeName, version);
        return new Integer(result);
    }

    public Boolean isNodeZOS(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isNodeZOS", "nodeName=" + nodeName);
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
        boolean nodeIsZOS = helper.isNodeZOS(nodeName);
        return new Boolean(nodeIsZOS);
    }

    public String getNodePlatformOS(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNodePlatformOS", "nodeName=" + nodeName);
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
        String nodeOS = helper.getNodePlatformOS(nodeName);
        return nodeOS;
    }

    public String getNodeSysplexName(AbstractAdminCommand cmd) throws AdminException {
        String nodeName = (String)cmd.getParameter("nodeName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNodeSysplexName", "nodeName=" + nodeName);
        }
        ManagedObjectMetadataAccessor accessor = this.createAccessor(cmd);
        ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
        String nodeOS = helper.getNodeSysplexName(nodeName);
        return nodeOS;
    }

    private ManagedObjectMetadataAccessor createAccessor(AbstractAdminCommand cmd) throws AdminException {
        String configSession = cmd.getConfigSession().toString();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "createAccessor", "configSession=" + configSession);
        }
        Properties props = new Properties();
        props.setProperty("CONFIG_SESSION", configSession);
        ManagedObjectMetadataAccessor accessor = ManagedObjectMetadataAccessorFactory.createAccessor(props);
        return accessor;
    }
}

