/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.NoServerDefinedException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.util.List;
import java.util.StringTokenizer;

public class ProcessTerminator {
    private static TraceComponent tc = Tr.register(ProcessTerminator.class, "Terminator");
    private StopParams stopParams = null;
    private ConfigObject processDef = null;

    public ProcessTerminator(ServerIdentifiers sid) throws Exception {
        ConfigObject server = null;
        this.stopParams = new StopParams();
        ConfigService configService = ConfigServiceFactory.createConfigService((String)sid.getConfigRoot(), (String)sid.getCellName(), (String)sid.getNodeName(), (String)sid.getServerName());
        try {
            List resContents = configService.getDocumentObjects(configService.getScope(4), "server.xml");
            server = (ConfigObject)resContents.get(0);
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        if (!server.getUnexpandedString("name", "__null__").equals(sid.getServerName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server name: " + sid.getServerName() + " - Server name from config: " + server.getUnexpandedString("name", "__null__"));
            }
            throw new NoServerDefinedException(sid.getServerName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server);
        }
        List processDefs = server.getObjectList("processDefinitions");
        int defSize = processDefs.size();
        String processType = null;
        for (int i = 0; i < defSize; ++i) {
            this.processDef = (ConfigObject)processDefs.get(i);
            processType = this.processDef.getUnexpandedString("processType", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processType: " + processType);
            }
            if (processType != null && processType.equalsIgnoreCase("Control")) break;
        }
        if (GenericServerProcHelper.isServerAWebServer(sid)) {
            this.setWebserverStopParams(sid, configService);
        } else {
            this.setStopParams();
        }
    }

    public void setStopMode(boolean stopMode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStopMode", new Boolean(stopMode));
        }
        if (stopMode) {
            this.setImmediateStopParams();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStopMode");
        }
    }

    public void setForceMode(boolean forceMode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setForceMode", new Boolean(forceMode));
        }
        if (forceMode) {
            this.setForceParams();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setForceMode");
        }
    }

    public void terminate() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminate");
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String zosCommand = this.stopParams.getZOSCommand();
            if (zosCommand != null && zosCommand.trim().length() != 0) {
                ProcessFactory.terminate((StopParams)this.stopParams);
            }
        } else {
            ProcessFactory.terminate((StopParams)this.stopParams);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminate");
        }
    }

    private void setStopParams() {
        StringTokenizer token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStopParams");
        }
        String cmd = "";
        String stop = null;
        String cancel = null;
        String jobId = null;
        if (this.processDef != null) {
            String stopCmd = null;
            stopCmd = this.processDef.getUnexpandedString("stopCommand", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stopCmd: " + stopCmd);
            }
            if (stopCmd != null && stopCmd.length() > 0) {
                cmd = stopCmd;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setStopParams", cmd);
        }
        if ((token = new StringTokenizer(cmd, ";")).countTokens() == 2) {
            stop = token.nextToken().trim();
            cancel = token.nextToken().trim();
        } else {
            stop = cmd;
        }
        if (stop != null) {
            StringTokenizer jobToken = new StringTokenizer(stop, " ");
            if (jobToken.countTokens() == 2) {
                stop = jobToken.nextToken();
                jobId = jobToken.nextToken();
            }
            this.stopParams.setProcessID(jobId);
            this.stopParams.setStopMode(0);
            this.stopParams.setZOSCommand(stop);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStopParams", stop);
        }
    }

    private void setWebserverStopParams(ServerIdentifiers sid, ConfigService configService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWebserverStopParams");
        }
        String cmd = "";
        String stop = null;
        Object cancel = null;
        String jobId = null;
        if (this.processDef != null) {
            String stopCmd = null;
            stopCmd = this.processDef.getUnexpandedString("stopCommand", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stopCmd: " + stopCmd);
            }
            if (stopCmd != null && stopCmd.length() > 0) {
                cmd = stopCmd;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setWebserverstopParams", cmd);
        }
        if ((stop = cmd) != null) {
            block14: {
                List stopCmdArgs = this.processDef.getUnexpandedStringList("stopCommandArgs");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopCmdArgs: " + stopCmdArgs);
                }
                String stringCmdArg = null;
                for (int i = 0; i < stopCmdArgs.size(); ++i) {
                    stringCmdArg = (String)stopCmdArgs.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setWebserverstopParams stringCmdArg ", stringCmdArg);
                    }
                    stop = stop.concat("," + stringCmdArg);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "setWebserverstopParams stopCommandArg ", stop);
                }
                try {
                    String stopCmd = stop;
                    stop = this.expand(stopCmd, sid, configService);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setWebserverStopParams", stop);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "ProcessTerminator  stopWebserverStopParms exception on expanding " + stop);
                }
            }
            StringTokenizer jobToken = new StringTokenizer(stop, " ");
            if (jobToken.countTokens() == 2) {
                stop = jobToken.nextToken();
                jobId = jobToken.nextToken();
            }
            this.stopParams.setProcessID(jobId);
            this.stopParams.setStopMode(0);
            this.stopParams.setZOSCommand(stop);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWebserverStopParams");
        }
    }

    private void setForceParams() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setForceParams");
        }
        String force = null;
        String jobId = null;
        if (this.processDef != null) {
            String forceCmd = this.processDef.getUnexpandedString("terminateCommand", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "forceCmd: " + forceCmd);
            }
            if (forceCmd != null) {
                StringTokenizer jobToken = new StringTokenizer(forceCmd, " ");
                if (jobToken.countTokens() == 2) {
                    force = jobToken.nextToken();
                    jobId = jobToken.nextToken();
                }
                this.stopParams.setProcessID(jobId);
                this.stopParams.setStopMode(1);
                this.stopParams.setZOSCommand(force);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setForceParams", this.stopParams);
            }
        }
    }

    private void setImmediateStopParams() {
        StringTokenizer token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setImmediateStopParams");
        }
        String cmd = "";
        String stop = null;
        String cancel = null;
        String jobId = null;
        if (this.processDef != null) {
            String stopCmd = null;
            stopCmd = this.processDef.getUnexpandedString("stopCommand", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stopCmd: " + stopCmd);
            }
            if (stopCmd != null && stopCmd.length() > 0) {
                cmd = stopCmd;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setImmediateStopParams", cmd);
        }
        if ((token = new StringTokenizer(cmd, ";")).countTokens() == 2) {
            stop = token.nextToken().trim();
            cancel = token.nextToken().trim();
        } else {
            cancel = cmd;
        }
        if (cancel != null) {
            StringTokenizer jobToken = new StringTokenizer(cancel, " ");
            if (jobToken.countTokens() == 2) {
                cancel = jobToken.nextToken();
                jobId = jobToken.nextToken();
            }
            this.stopParams.setProcessID(jobId);
            this.stopParams.setStopMode(2);
            this.stopParams.setZOSCommand(cancel);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setImmediateStopParams");
        }
    }

    private VariableMap getVariableMap(ServerIdentifiers sid, ConfigService configService) throws AdminException {
        VariableMap variableMap = VariableMapFactory.createVariableMap((ConfigService)configService);
        try {
            variableMap.initialize(null);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getVariableMap " + sid.getServerName(), t);
            }
            throw new AdminException(sid.getServerName());
        }
        return variableMap;
    }

    private String expand(String source, ServerIdentifiers sid, ConfigService configService) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ProcessTerminator expand entry: ", source);
        }
        VariableMap vars = null;
        String expanded = source;
        try {
            vars = this.getVariableMap(sid, configService);
            expanded = vars.expand(source);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in stopArgs expand " + source, t);
            }
            throw new AdminException(source);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ProcessTerminator expand exit", expanded);
        }
        return expanded;
    }
}

