/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.NoServerDefinedException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.util.List;
import java.util.StringTokenizer;

public class ProcessStopper {
    private static TraceComponent tc = Tr.register(ProcessStopper.class, "ProcessStopper");
    private StopParams stopParams = new StopParams();
    private boolean stopImmediate = false;
    private ConfigObject processDef = null;

    public ProcessStopper(ServerIdentifiers sid, boolean stopImmediate) throws NoServerDefinedException, AdminException {
        ConfigObject server = null;
        this.stopImmediate = stopImmediate;
        ConfigService configService = ConfigServiceFactory.createConfigService((String)sid.getConfigRoot(), (String)sid.getCellName(), (String)sid.getNodeName(), (String)sid.getServerName());
        try {
            List resContents = configService.getDocumentObjects(configService.getScope(4), "server.xml");
            server = (ConfigObject)resContents.get(0);
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        if (!server.getString("name", "__null__").equals(sid.getServerName())) {
            throw new NoServerDefinedException(sid.getServerName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server.toString());
        }
        List processDefs = server.getObjectList("processDefinitions");
        String processType = null;
        for (int i = 0; i < processDefs.size(); ++i) {
            this.processDef = (ConfigObject)processDefs.get(i);
            processType = this.processDef.getString("processType", "__null__");
            if (processType != null && processType.equalsIgnoreCase("Control")) break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ProcessDef: " + this.processDef);
        }
        this.stopParams = this.setStopParams(this.processDef);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process StopParams: " + this.stopParams.toString());
        }
    }

    public void setStopImmediate(boolean value) {
        if (value != this.stopImmediate) {
            this.stopImmediate = value;
            this.stopParams = this.setStopParams(this.processDef);
        }
    }

    public void stop() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop process");
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String zosCommand = this.stopParams.getZOSCommand();
            if (zosCommand != null && zosCommand.trim().length() != 0) {
                ProcessFactory.terminate((StopParams)this.stopParams);
            }
        } else {
            ProcessFactory.terminate((StopParams)this.stopParams);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop process");
        }
    }

    private StopParams setStopParams(ConfigObject processDef) {
        StringTokenizer token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStopParams");
        }
        String stop = "";
        String cancel = "";
        String cmd = "";
        String jobId = "";
        if (processDef != null) {
            String stopCmd = null;
            stopCmd = processDef.getString("stopCommand", "__null__");
            if (stopCmd != null) {
                cmd = stopCmd;
            }
        }
        if ((token = new StringTokenizer(cmd, ";")).countTokens() == 2) {
            stop = token.nextToken().trim();
            cancel = token.nextToken().trim();
        }
        if (this.stopImmediate) {
            StringTokenizer jobToken = new StringTokenizer(cancel, " ");
            if (jobToken.countTokens() == 2) {
                cancel = jobToken.nextToken();
                jobId = jobToken.nextToken();
            }
            this.stopParams.setProcessID(jobId);
            this.stopParams.setZOSCommand(cancel);
            this.stopParams.setStopMode(2);
        } else {
            StringTokenizer jobToken = new StringTokenizer(stop, " ");
            if (jobToken.countTokens() == 2) {
                stop = jobToken.nextToken();
                jobId = jobToken.nextToken();
            }
            this.stopParams.setProcessID(jobId);
            this.stopParams.setStopMode(0);
            this.stopParams.setZOSCommand(stop);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStopParams", this.stopParams);
        }
        return this.stopParams;
    }
}

