/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.LaunchParams;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import java.io.PrintStream;
import java.util.Vector;

public class ProcessLauncher {
    private static TraceComponent tc = Tr.register(ProcessLauncher.class, "Launcher");
    private static boolean debug = false;
    private static PrintStream out = System.out;
    private CreationParams params;
    private String parms = ",PARMS='";
    private String separator = ",";

    public ProcessLauncher(LaunchParams launchParams) {
        this.params = this.setCreationParams(launchParams);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process CreationParams: " + this.params.toString());
        }
    }

    public Process launch() throws Exception {
        Process p = ProcessFactory.create((CreationParams)this.params);
        return p;
    }

    private CreationParams setCreationParams(LaunchParams launchParams) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCreationParams", launchParams);
        }
        CreationParams params = new CreationParams();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.processFor_zOS(launchParams, params);
        } else {
            this.processForDistributed(launchParams, params);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCreationParams", params);
        }
        return params;
    }

    private void processForDistributed(LaunchParams launchParams, CreationParams params) {
        boolean useStartCommand = true;
        String nameOfExecutable = launchParams.getStartCommand();
        if (nameOfExecutable == null || nameOfExecutable.length() == 0) {
            useStartCommand = false;
            nameOfExecutable = launchParams.getExecutableName();
            if (nameOfExecutable == null || nameOfExecutable.length() == 0) {
                try {
                    throw new AdminException("Name of executable not found!");
                }
                catch (AdminException e) {
                    e.printStackTrace();
                }
            }
            useStartCommand = false;
        }
        if (useStartCommand) {
            params.setExecutable(launchParams.getStartCommand());
        } else {
            params.setExecutable(launchParams.getExecutableName());
        }
        params.setProcessName(launchParams.getServerIds().getServerName());
        params.setWorkingDirectory(launchParams.getWorkingDirectory());
        String stdoutFile = launchParams.getStdoutFileName();
        params.setStdFileName(0, launchParams.getStdinFileName());
        params.setStdFileName(1, launchParams.getStdoutFileName());
        params.setStdFileName(2, launchParams.getStderrFileName());
        if (stdoutFile == null || stdoutFile.equals("") || stdoutFile.equals("stdout") || stdoutFile.equals("console")) {
            params.setInheritParentStreams(true);
        }
        params.setUserId(launchParams.getUserId());
        params.setGroupId(launchParams.getGroupId());
        params.setProcessGroupId(launchParams.getProcessGroupId());
        params.setProcessPriority(launchParams.getProcessPriority());
        params.setUmask(launchParams.getUmask());
        Vector vec = launchParams.getCommandLineArguments();
        Object[] cargs = new String[vec.size()];
        vec.copyInto(cargs);
        params.setCommandLineArgs((String[])cargs);
        vec = launchParams.getEnvironment();
        Object[] envs = new String[vec.size()];
        vec.copyInto(envs);
        params.setEnvironment((String[])envs);
    }

    private void processFor_zOS(LaunchParams launchParams, CreationParams params) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processFor_zOS", params);
        }
        params.setClusterName(launchParams.getClusterShortName());
        params.setExecutable(launchParams.getStartCommand());
        params.setProcessName(launchParams.getServerShortName());
        Vector vec = launchParams.getStartCommandArgs();
        StringBuffer cmd = new StringBuffer();
        if (vec != null) {
            String serverMode;
            String statusPort;
            if (vec.size() > 0) {
                cmd.append((String)vec.get(0));
            }
            if ((statusPort = launchParams.getStatusSocketPort()) != null && statusPort.length() > 0) {
                cmd.append(this.parms);
                cmd.append(statusPort);
                cmd.append("'");
            }
            if ((serverMode = launchParams.getServerMode()) != null && serverMode.length() > 0) {
                cmd.append(this.separator);
                cmd.append(serverMode);
            }
        }
        params.setCommandLineArgs(new String[]{cmd.toString()});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processFor_zOS", cmd);
        }
    }
}

