/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.NoServerDefinedException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.LaunchBinaryScriptWriter;
import com.ibm.ws.management.launcher.LaunchParams;
import com.ibm.ws.management.launcher.LaunchPlatformHelper;
import com.ibm.ws.management.launcher.LaunchScriptWriter;
import com.ibm.ws.management.launcher.ProcessLauncher;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.process.Process;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class LaunchCommand {
    private static TraceComponent tc = Tr.register(LaunchCommand.class, "Launcher", "com.ibm.ws.management.resources.launcher");
    private ConfigService configService = null;
    private LaunchParams params = null;
    private VariableMap vars = null;
    private ServerIdentifiers serverId = null;
    private LaunchPlatformHelper platform = null;
    private boolean debugMode = false;
    private boolean zOS = false;
    private Vector gatheredClasspath = new Vector();
    private Vector gatheredBootclasspath = new Vector();
    private Vector gatheredWsExtDirs = new Vector();
    private Vector gatheredMiscCommandLineArgs = new Vector();
    private Properties gatheredSecurityProperties = new Properties();
    private Vector gatheredJavaLibPath = new Vector();
    private static final int COMPRESSED_REFS_THRESHOLD = 25600;
    private static final String DEF_JREEXECNAME_PROP = "com.ibm.websphere.management.launcher.defaultJreExecutableName";
    private static final String NDDMZ_PROP = "com.ibm.websphere.nddmz";
    private static final String DEF_EXECNAME_PROP = "com.ibm.websphere.management.launcher.defaultExecutableName";
    private static final String DEF_MINHEAPSIZE_PROP = "com.ibm.websphere.management.launcher.defaultMinHeapSize";
    private static final String DEF_MAXHEAPSIZE_PROP = "com.ibm.websphere.management.launcher.defaultMaxHeapSize";
    private static final String JAVA2_SECURITY_PROP = "enableJava2Security";
    private static final String SECURITY_POLICY_PROP = "java.security.policy";
    private static final String SECURITY_AUTH_LOGIN_PROP = "java.security.auth.login.config";
    private static final String WSLAUNCHER_CLASS = "com.ibm.ws.bootstrap.WSLauncher";
    private static final String WSSERVER_CLASS = "com.ibm.ws.runtime.WsServer";
    private boolean devOption = false;
    protected static final String DEF_DEVELOPMENT_MODE = "com.ibm.websphere.management.launcher.developmentMode";
    private boolean developmentMode = false;
    private HashMap cleanedArguments = new HashMap(10);

    public LaunchCommand(Repository repository2, VariableMap map, ServerIdentifiers sid) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor 2");
        }
        ConfigService cfgService = ConfigServiceFactory.createConfigService((String)repository2.getRootURI(), (String)repository2.getCellName(), (String)repository2.getNodeName(), (String)repository2.getServerName(), (String)repository2.getClusterName());
        ConfigObject processDef = null;
        this.configService = cfgService;
        this.serverId = sid;
        this.vars = map;
        try {
            this.platform = (LaunchPlatformHelper)ImplFactory.loadImplFromKey((String)"com.ibm.ws.management.launcher.LaunchPlatformHelper");
        }
        catch (Throwable e) {
            throw new AdminException(e);
        }
        ConfigObject server = this.getServer(cfgService, 4, "server.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server);
        }
        if (!server.getUnexpandedString("name", "__null__").equals(sid.getServerName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server name: " + sid.getServerName() + " - Server name from config: " + server.getUnexpandedString("name", "__null__"));
            }
            throw new NoServerDefinedException(sid.getServerName());
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zOS = true;
        }
        List processDefs = server.getObjectList("processDefinitions");
        String processType = null;
        for (int i = 0; i < processDefs.size(); ++i) {
            processDef = (ConfigObject)processDefs.get(i);
            processType = processDef.getUnexpandedString("processType", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processType: " + processType);
            }
            if (this.zOS ? processType != null && processType.equalsIgnoreCase("Control") : processType != null && processType.equalsIgnoreCase("Distributed")) break;
        }
        if (processDef == null) {
            processDef = server.getObject("processDefinition");
        }
        if (processDef == null) {
            throw new AdminException("new message: config bad - invalid process data");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ProcessDef: " + processDef);
        }
        this.params = new LaunchParams();
        this.params.setServerIds(this.serverId);
        this.setParamsFromServer(server);
        this.setParamsFromProcessDef(processDef);
        if (this.zOS) {
            ConfigObject serverEntry = this.getServerEntry(cfgService, sid.getServerName());
            this.processShortNames(server, serverEntry);
        }
        Tr.debug(tc, "this1", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor 2", this.params);
        }
    }

    public LaunchCommand(ConfigService cfgService, VariableMap map, ServerIdentifiers sid) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        ConfigObject processDef = null;
        this.configService = cfgService;
        this.serverId = sid;
        this.vars = map;
        try {
            this.platform = (LaunchPlatformHelper)ImplFactory.loadImplFromKey((String)"com.ibm.ws.management.launcher.LaunchPlatformHelper");
        }
        catch (Throwable e) {
            throw new AdminException(e);
        }
        ConfigObject server = this.getServer(cfgService, 4, "server.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server);
        }
        if (!server.getUnexpandedString("name", "__null__").equals(sid.getServerName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server name: " + sid.getServerName() + " - Server name from config: " + server.getUnexpandedString("name", "__null__"));
            }
            throw new NoServerDefinedException(sid.getServerName());
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zOS = true;
        }
        List processDefs = server.getObjectList("processDefinitions");
        String processType = null;
        for (int i = 0; i < processDefs.size(); ++i) {
            processDef = (ConfigObject)processDefs.get(i);
            processType = processDef.getUnexpandedString("processType", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processType: " + processType);
            }
            if (this.zOS ? processType != null && processType.equalsIgnoreCase("Control") : processType != null && processType.equalsIgnoreCase("Distributed")) break;
        }
        if (processDef == null) {
            processDef = server.getObject("processDefinition");
        }
        if (processDef == null) {
            throw new AdminException("new message: config bad - invalid process data");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ProcessDef: " + processDef);
        }
        this.params = new LaunchParams();
        this.params.setServerIds(this.serverId);
        this.setParamsFromServer(server);
        this.setParamsFromProcessDef(processDef);
        if (this.zOS) {
            ConfigObject serverEntry = this.getServerEntry(cfgService, sid.getServerName());
            this.processShortNames(server, serverEntry);
        }
        Tr.debug(tc, "this1", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor", this.params);
        }
    }

    public Process launchProcess() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "launching process with parameters: " + this.params.toString());
        }
        ProcessLauncher launcher2 = new ProcessLauncher(this.params);
        Process p = launcher2.launch();
        return p;
    }

    public Vector getLaunchCommand() throws Exception {
        Vector v = null;
        v = (Vector)this.params.getCommandLineArguments().clone();
        if (this.params.getJvmModeString().length() > 0) {
            v.add(0, this.params.getJvmModeString());
        }
        v.add(0, this.params.getExecutableName());
        return v;
    }

    public LaunchParams getLaunchParams() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLaunchParams");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLaunchParams", this.params);
        }
        return this.params;
    }

    public void createLaunchScript(String platformType, String scriptName, boolean backgroundScript) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writing script with parameters: " + this.params.toString());
        }
        this.params.setDevOption(this.devOption);
        LaunchScriptWriter writer = new LaunchScriptWriter(this.params);
        writer.writeScript(platformType, scriptName, backgroundScript);
    }

    public void createBinaryData(String scriptName) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writing script with parameters: " + this.params.toString());
        }
        LaunchBinaryScriptWriter writer = new LaunchBinaryScriptWriter(this.params);
        writer.writeScript(scriptName);
    }

    private ConfigObject getServer(ConfigService cs, int cscope, String relPath) throws Exception {
        List contents = cs.getDocumentObjects(cs.getScope(cscope), relPath);
        return (ConfigObject)contents.get(0);
    }

    private void setParamsFromProcessDef(ConfigObject processDef) throws Exception {
        ConfigObject redir;
        boolean javaExecutable = true;
        boolean genericExecutable = false;
        if (this.zOS) {
            this.process390Commands(processDef);
        }
        String defExecName = System.getProperty(DEF_EXECNAME_PROP);
        String defJreExecName = System.getProperty(DEF_JREEXECNAME_PROP);
        String nddmz = System.getProperty(NDDMZ_PROP);
        String cmdToXqt = null;
        String startCmd = processDef.getUnexpandedString("startCommand", "__null__");
        String execName = processDef.getUnexpandedString("executableName", "__null__");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "startCmd: " + startCmd + " execName: " + execName);
        }
        if (!this.zOS && startCmd != null && startCmd.length() > 0) {
            cmdToXqt = this.expand(startCmd);
        } else if (execName != null) {
            cmdToXqt = this.expand(execName);
        }
        if (cmdToXqt != null) {
            this.params.setExecutableName(cmdToXqt);
            if (cmdToXqt.indexOf("java") < 0) {
                javaExecutable = false;
            }
            if (this.isGenericServer(processDef)) {
                genericExecutable = true;
            }
        } else if (nddmz == null && defExecName != null) {
            this.params.setExecutableName(this.expand(defExecName));
        } else if (nddmz != null && nddmz.equals("true") && defJreExecName != null) {
            this.params.setExecutableName(this.expand(defJreExecName));
        }
        this.params.setCommandLineArguments(new Vector());
        this.params.setEnvironment(this.createEnvironment(processDef));
        String wd = processDef.getUnexpandedString("workingDirectory", "__null__");
        if (wd != null && wd.equals("")) {
            wd = null;
        }
        this.params.setWorkingDirectory(this.expand(wd));
        ConfigObject processExecution = processDef.getObject("execution");
        this.params.setUserId(this.expand(processExecution.getUnexpandedString("runAsUser", "__null__")));
        this.params.setGroupId(this.expand(processExecution.getUnexpandedString("runAsGroup", "__null__")));
        this.params.setProcessPriority(processExecution.getInt("processPriority", 20));
        String umaskString = processExecution.getUnexpandedString("umask", "022");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set Working Dir to: " + this.expand(wd));
            Tr.debug(tc, "set UserId to: " + this.expand(processExecution.getUnexpandedString("runAsUser", "__null__")));
            Tr.debug(tc, "set GroupId to: " + this.expand(processExecution.getUnexpandedString("runAsGroup", "__null__")));
            Tr.debug(tc, "set Umask to: " + umaskString);
        }
        if (umaskString != null && umaskString.length() > 0) {
            try {
                int umask = Integer.parseInt(umaskString, 8);
                this.params.setUmask(umask);
            }
            catch (NumberFormatException e) {
                Tr.service(tc, "ADML0003E", umaskString);
            }
        }
        if ((redir = processDef.getObject("ioRedirect")) != null) {
            String infile = redir.getUnexpandedString("stdinFilename", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpanded infile: " + infile);
            }
            if (infile != null) {
                infile = this.expand(infile);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expanded infile: " + infile);
                }
                this.createParentDir(infile);
            }
            String errfile = redir.getUnexpandedString("stderrFilename", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpanded errfile: " + errfile);
            }
            if (errfile != null) {
                errfile = this.expand(errfile);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expanded errfile: " + errfile);
                }
                this.createParentDir(errfile);
            }
            String outfile = redir.getUnexpandedString("stdoutFilename", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpanded outfile: " + outfile);
            }
            if (outfile != null) {
                outfile = this.expand(outfile);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expanded outfile: " + outfile);
                }
                this.createParentDir(outfile);
            }
            this.params.setStdinFileName(infile);
            this.params.setStderrFileName(errfile);
            this.params.setStdoutFileName(outfile);
        }
        ConfigObject monitoringPolicy = processDef.getObject("monitoringPolicy");
        if (processDef.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/processexec.xmi", "JavaProcessDef") && javaExecutable) {
            ConfigObject jDef = processDef;
            if (genericExecutable) {
                this.setGenericServerParamsFromJavaProcessDef(jDef);
            } else {
                this.setParamsFromJavaProcessDef(jDef);
            }
        }
        List execArgs = null;
        if (!this.zOS) {
            execArgs = processDef.getUnexpandedStringList("startCommandArgs");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "execArgs: " + execArgs);
            }
        }
        if (execArgs == null || execArgs.size() == 0) {
            execArgs = processDef.getUnexpandedStringList("executableArguments");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "execArgs : " + execArgs);
            }
        }
        for (int i = 0; i < execArgs.size(); ++i) {
            this.params.getCommandLineArguments().add(this.expand((String)execArgs.get(i)));
        }
    }

    private boolean isGenericServer(ConfigObject processDef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenericServer");
        }
        boolean result = false;
        String executableName = processDef.getUnexpandedString("executableName", "__null__");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "executableName: " + executableName);
        }
        if (executableName != null) {
            if ((executableName = executableName.trim()).indexOf("java") < 0) {
                return true;
            }
            if (processDef.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/processexec.xmi", "JavaProcessDef")) {
                ConfigObject javaProcessDef = processDef;
                String executableTarget = javaProcessDef.getUnexpandedString("executableTarget", "__null__");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "executableTarget: " + executableTarget);
                }
                if (executableTarget != null && !executableTarget.equals(WSSERVER_CLASS)) {
                    return true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGenericServer");
        }
        return result;
    }

    private void processCommandLineArguments(String argsString) {
        StringTokenizer tokenizer = new StringTokenizer(argsString);
        while (tokenizer.hasMoreTokens()) {
            String value;
            String cltoken = tokenizer.nextToken();
            if (cltoken.equals("-classpath") || cltoken.equals("-cp")) {
                this.gatheredClasspath.add(tokenizer.nextToken());
                continue;
            }
            if (cltoken.startsWith("-Djava.library.path")) {
                this.gatheredJavaLibPath.add(cltoken.substring(cltoken.lastIndexOf("=") + 1));
                continue;
            }
            if (cltoken.startsWith("-Xbootclasspath")) {
                this.gatheredBootclasspath.add(cltoken.substring(cltoken.indexOf(":") + 1));
                continue;
            }
            if (cltoken.startsWith("-Dws.ext.dirs")) {
                this.gatheredWsExtDirs.add(cltoken.substring(cltoken.lastIndexOf("=") + 1));
                continue;
            }
            if (cltoken.startsWith("-DenableJava2Security")) {
                value = this.expand(cltoken.substring(cltoken.lastIndexOf("=") + 1));
                this.gatheredSecurityProperties.setProperty(JAVA2_SECURITY_PROP, value);
                continue;
            }
            if (cltoken.startsWith("-Djava.security.policy")) {
                value = this.expand(cltoken.substring(cltoken.lastIndexOf("=") + 1));
                this.gatheredSecurityProperties.setProperty(SECURITY_POLICY_PROP, value);
                continue;
            }
            if (cltoken.startsWith("-Djava.security.auth.login.config")) {
                value = this.expand(cltoken.substring(cltoken.lastIndexOf("=") + 1));
                this.gatheredSecurityProperties.setProperty(SECURITY_AUTH_LOGIN_PROP, value);
                continue;
            }
            if (cltoken.equals("-server") || cltoken.equals("-client")) {
                this.params.setJvmMode("HOTSPOT");
                this.params.setJvmModeString(cltoken);
                this.params.getCommandLineArguments().add(0, cltoken);
                continue;
            }
            if (cltoken.equals("-classic")) {
                this.params.setJvmMode("CLASSIC");
                this.params.setJvmModeString(cltoken);
                this.params.getCommandLineArguments().add(0, cltoken);
                continue;
            }
            this.gatheredMiscCommandLineArgs.add(this.expand(cltoken));
        }
    }

    private void processSystemProperty(String cltoken) {
        if (cltoken.startsWith("-Dws.ext.dirs")) {
            this.gatheredWsExtDirs.add(cltoken.substring(cltoken.lastIndexOf("=") + 1));
        } else if (cltoken.startsWith("-DenableJava2Security")) {
            String value = this.expand(cltoken.substring(cltoken.lastIndexOf("=") + 1));
            this.gatheredSecurityProperties.setProperty(JAVA2_SECURITY_PROP, value);
        } else if (cltoken.startsWith("-Djava.security.policy")) {
            String value = this.expand(cltoken.substring(cltoken.lastIndexOf("=") + 1));
            this.gatheredSecurityProperties.setProperty(SECURITY_POLICY_PROP, value);
        } else if (cltoken.startsWith("-Djava.security.auth.login.config")) {
            String value = this.expand(cltoken.substring(cltoken.lastIndexOf("=") + 1));
            this.gatheredSecurityProperties.setProperty(SECURITY_AUTH_LOGIN_PROP, value);
        } else if (cltoken.startsWith("-Djava.library.path")) {
            this.gatheredJavaLibPath.add(cltoken.substring(cltoken.lastIndexOf("=") + 1));
        } else {
            this.gatheredMiscCommandLineArgs.add(this.expand(cltoken));
        }
    }

    private Vector createEnvironment(ConfigObject processDef) throws Exception {
        Vector<String> args = new Vector<String>();
        Properties defaultEnv = this.platform.getDefaultEnvironment();
        if (defaultEnv != null) {
            Enumeration<?> envVars = defaultEnv.propertyNames();
            while (envVars.hasMoreElements()) {
                String envVar = (String)envVars.nextElement();
                if (envVar.equals("CLASSPATH")) {
                    this.gatheredClasspath.add(defaultEnv.getProperty(envVar));
                    continue;
                }
                args.add(this.expand(envVar + "=" + defaultEnv.getProperty(envVar)));
            }
        }
        List envs = processDef.getObjectList("environment");
        for (int i = 0; i < envs.size(); ++i) {
            ConfigObject property = (ConfigObject)envs.get(i);
            String pName = property.getUnexpandedString("name", "__null__");
            String pVal = property.getUnexpandedString("value", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pName: " + pName + " pVal: " + pVal);
            }
            if (pName == null || pVal == null) continue;
            if (pName.equals("CLASSPATH")) {
                this.gatheredClasspath.add(pVal);
                continue;
            }
            args.add(this.expand(pName + "=" + pVal));
        }
        return args;
    }

    private void setParamsFromJavaProcessDef(ConfigObject javaProcessDef) throws Exception {
        ConfigObject jvm = null;
        List jvms = javaProcessDef.getObjectList("jvmEntries");
        String os = System.getProperty("os.name");
        for (int i = 0; i < jvms.size(); ++i) {
            ConfigObject j = (ConfigObject)jvms.get(i);
            String osName = j.getUnexpandedString("osName", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "osName: " + osName);
            }
            if (osName == null || !osName.equalsIgnoreCase(os)) continue;
            jvm = j;
            break;
        }
        if (jvm == null && jvms.size() > 0) {
            jvm = (ConfigObject)jvms.get(0);
        }
        if (jvm != null) {
            this.processCellLevelCustomProp();
            this.processDefaultJvmOptions();
            this.processSystemProperties(jvm);
            String genJvmArgs = jvm.getUnexpandedString("genericJvmArguments", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "genJvmArgs: " + genJvmArgs);
            }
            if (genJvmArgs != null && genJvmArgs.length() > 0) {
                this.processCommandLineArguments(genJvmArgs);
            }
            this.processDebugAndJitSettings(jvm);
            this.processBootstrapClasspathInfo(jvm);
            this.processClasspathInfo(jvm);
            this.processInternalClassAccessMode(jvm);
            this.processMiscJVMSettings(jvm);
            this.processWsExtDirsInfo();
            this.processJavaLibraryPathInfo();
            if (this.gatheredMiscCommandLineArgs.size() > 0) {
                for (int i = 0; i < this.gatheredMiscCommandLineArgs.size(); ++i) {
                    this.handleExtraneousArguments(this.expand((String)this.gatheredMiscCommandLineArgs.get(i)));
                }
            }
            this.processSecurityProperties();
        }
        this.processExecutionTargetInfo(javaProcessDef);
    }

    private void processDefaultJvmOptions() {
        Vector options = this.platform.getDefaultJVMOptions();
        if (options != null) {
            for (int i = 0; i < options.size(); ++i) {
                this.handleExtraneousArguments(this.expand((String)options.get(i)));
            }
        }
    }

    private void processDebugAndJitSettings(ConfigObject jvm) {
        Vector disableJit;
        if (Boolean.getBoolean("com.ibm.ws.management.launcher.ignoreDebug")) {
            return;
        }
        if (jvm != null && jvm.getBoolean("debugMode", false)) {
            this.debugMode = true;
            this.params.getCommandLineArguments().add("-Dwas.debug.mode=true");
            String dbgArgs = jvm.getUnexpandedString("debugArgs", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dbgArgs: " + dbgArgs);
            }
            if (dbgArgs != null && dbgArgs.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(dbgArgs);
                while (tokenizer.hasMoreTokens()) {
                    this.params.getCommandLineArguments().add(this.expand(tokenizer.nextToken()));
                }
            }
        }
        if (jvm.getBoolean("disableJIT", false) && (disableJit = this.platform.getDisableJitc(this.debugMode, this.params.getJvmMode())) != null && disableJit.size() > 0) {
            for (int i = 0; i < disableJit.size(); ++i) {
                this.params.getCommandLineArguments().add((String)disableJit.get(i));
            }
        }
    }

    private void processSystemProperties(ConfigObject jvm) throws Exception {
        Properties defaultProps = this.platform.getDefaultSystemProperties();
        if (defaultProps != null) {
            Enumeration<?> keys = defaultProps.propertyNames();
            while (keys.hasMoreElements()) {
                String propKey = (String)keys.nextElement();
                propKey = propKey.trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default system property: " + propKey + "=" + defaultProps.getProperty(propKey));
                }
                this.processSystemProperty("-D" + propKey + "=" + defaultProps.getProperty(propKey).trim());
            }
        }
        List sysProps = jvm.getObjectList("systemProperties");
        for (int i = 0; i < sysProps.size(); ++i) {
            ConfigObject p = (ConfigObject)sysProps.get(i);
            String pName = p.getUnexpandedString("name", "__null__");
            String pVal = p.getUnexpandedString("value", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pName: " + pName + " pVal: " + pVal);
            }
            if (pName == null || pVal == null) continue;
            this.processSystemProperty("-D" + pName + "=" + pVal);
        }
    }

    private void processClasspathInfo(ConfigObject jvm) throws Exception {
        int i;
        Vector classpaths = this.platform.getDefaultClasspath();
        String classpath = null;
        List list = jvm.getUnexpandedStringList("classpath");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "list: " + list);
        }
        for (i = 0; i < list.size(); ++i) {
            classpath = (String)list.get(i);
            if (classpath == null || classpath.length() <= 0) continue;
            classpaths.add(classpath);
        }
        if (this.gatheredClasspath.size() > 0) {
            for (i = 0; i < this.gatheredClasspath.size(); ++i) {
                classpaths.add((String)this.gatheredClasspath.get(i));
            }
        }
        if (classpaths.size() > 0) {
            classpath = (String)classpaths.get(0);
            for (i = 1; i < classpaths.size(); ++i) {
                classpath = classpath + File.pathSeparator + (String)classpaths.get(i);
            }
        }
        if (classpath != null) {
            this.params.getCommandLineArguments().add("-classpath");
            this.params.getCommandLineArguments().add(this.expand(classpath));
        }
    }

    private void processJavaLibraryPathInfo() throws Exception {
        String path = System.getProperty("java.library.path");
        if (this.gatheredJavaLibPath.size() > 0) {
            for (int i = 0; i < this.gatheredJavaLibPath.size(); ++i) {
                path = path + File.pathSeparator + (String)this.gatheredJavaLibPath.get(i);
            }
            path = "-Djava.library.path=" + path;
            this.gatheredMiscCommandLineArgs.add(this.expand(path));
        }
    }

    private void processBootstrapClasspathInfo(ConfigObject jvm) throws Exception {
        int i;
        Vector bootClasspaths = this.platform.getDefaultBootclasspath(this.debugMode);
        String bootClasspath = null;
        List list = jvm.getUnexpandedStringList("bootClasspath");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "list: " + list);
        }
        for (i = 0; i < list.size(); ++i) {
            bootClasspath = (String)list.get(i);
            if (bootClasspath == null || bootClasspath.length() <= 0) continue;
            bootClasspaths.add(bootClasspath);
        }
        if (this.gatheredBootclasspath.size() > 0) {
            for (i = 0; i < this.gatheredBootclasspath.size(); ++i) {
                bootClasspaths.add((String)this.gatheredBootclasspath.get(i));
            }
        }
        if (bootClasspaths.size() > 0) {
            bootClasspath = (String)bootClasspaths.get(0);
            for (i = 1; i < bootClasspaths.size(); ++i) {
                bootClasspath = bootClasspath + File.pathSeparator + (String)bootClasspaths.get(i);
            }
        }
        if (bootClasspath != null) {
            this.params.getCommandLineArguments().add("-Xbootclasspath/p:" + this.expand(bootClasspath));
        }
    }

    private void processWsExtDirsInfo() throws Exception {
        int i;
        Vector wsExtDirs = this.platform.getDefaultWsExtDirs();
        String wsExtDir = null;
        if (this.gatheredWsExtDirs.size() > 0) {
            for (i = 0; i < this.gatheredWsExtDirs.size(); ++i) {
                try {
                    this.vars.expand((String)this.gatheredWsExtDirs.get(i));
                    wsExtDirs.addElement((String)this.gatheredWsExtDirs.get(i));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Warning: Invalid ws.ext.dir value " + this.gatheredWsExtDirs.get(i) + " found and will not be used to start this server. Correct this value and restart the server. Could not expand variable specified.");
                    Tr.audit(tc, "Cannot expand variable in " + this.gatheredWsExtDirs.get(i) + " skipping this part of ws.ext.dirs");
                }
            }
        }
        if (wsExtDirs.size() > 0) {
            wsExtDir = (String)wsExtDirs.get(0);
            for (i = 1; i < wsExtDirs.size(); ++i) {
                wsExtDir = wsExtDir + File.pathSeparator + (String)wsExtDirs.get(i);
            }
        }
        if (wsExtDir != null) {
            this.params.getCommandLineArguments().add("-Dws.ext.dirs=" + this.expand(wsExtDir));
        }
    }

    private void processExecutionTargetInfo(ConfigObject javaProcessDef) throws Exception {
        String execTarget = javaProcessDef.getUnexpandedString("executableTarget", "__null__");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "execTarget: " + execTarget);
        }
        if (execTarget == null || execTarget.length() < 1) {
            execTarget = WSSERVER_CLASS;
        }
        String targetKind = javaProcessDef.getUnexpandedString("executableTargetKind", "JAVA_CLASS");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetKind: " + targetKind);
        }
        if (targetKind == null) {
            targetKind = "JAVA_CLASS";
        }
        if (targetKind.equals("JAVA_CLASS")) {
            if (execTarget.equals(WSSERVER_CLASS)) {
                this.params.getCommandLineArguments().add("com.ibm.wsspi.bootstrap.WSPreLauncher");
                this.params.getCommandLineArguments().add("-nosplash");
                this.params.getCommandLineArguments().add("-application");
                this.params.getCommandLineArguments().add(WSLAUNCHER_CLASS);
                this.params.getCommandLineArguments().add(WSSERVER_CLASS);
            } else {
                this.params.getCommandLineArguments().add(this.expand(execTarget));
            }
        } else if (targetKind.equals("EXECUTABLE_JAR")) {
            this.params.getCommandLineArguments().add("-jar");
            this.params.getCommandLineArguments().add(this.expand(execTarget));
        } else {
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML0031E", new Object[]{targetKind}, null));
        }
        if (this.serverId != null && execTarget.equals(WSSERVER_CLASS)) {
            this.params.getCommandLineArguments().add(this.serverId.getConfigRoot());
            this.params.getCommandLineArguments().add(this.serverId.getCellName());
            this.params.getCommandLineArguments().add(this.serverId.getNodeName());
            this.params.getCommandLineArguments().add(this.serverId.getServerName());
        }
    }

    private void processSecurityProperties() throws Exception {
        Enumeration<?> keys = this.gatheredSecurityProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String propKey = (String)keys.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security property: " + propKey + "=" + this.gatheredSecurityProperties.getProperty(propKey));
            }
            this.params.addCommandLineArgument("-D" + propKey + "=" + this.gatheredSecurityProperties.getProperty(propKey));
        }
    }

    private void processInternalClassAccessMode(ConfigObject jvm) {
        String icam = jvm.getUnexpandedString("internalClassAccessMode", "ALLOW");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "icam: " + icam);
        }
        if (icam.equals("RESTRICT")) {
            this.params.getCommandLineArguments().add("-Dibm.websphere.internalClassAccessMode=restrict");
        } else if (icam.equals("ALLOW")) {
            this.params.getCommandLineArguments().add("-Dibm.websphere.internalClassAccessMode=allow");
        }
    }

    private void processMiscJVMSettings(ConfigObject jvm) {
        String developmentString;
        boolean verbosegc = false;
        boolean verboseclass = false;
        if (jvm.getBoolean("verboseModeJNI", false)) {
            this.params.getCommandLineArguments().add("-verbose:jni");
        }
        if (jvm.getBoolean("verboseModeGarbageCollection", false)) {
            verbosegc = true;
        }
        if (jvm.getBoolean("verboseModeClass", false)) {
            verboseclass = true;
        }
        if (verbosegc && verboseclass) {
            this.params.getCommandLineArguments().add("-verbose:class,gc");
        } else if (verbosegc) {
            this.params.getCommandLineArguments().add("-verbose:gc");
        } else if (verboseclass) {
            this.params.getCommandLineArguments().add("-verbose:class");
        }
        String defMinHeapSize = System.getProperty(DEF_MINHEAPSIZE_PROP);
        int ihs = jvm.getInt("initialHeapSize", 0);
        if (ihs > 0) {
            this.handleExtraneousArguments("-Xms" + ihs + "m");
        } else if (defMinHeapSize != null) {
            this.handleExtraneousArguments(defMinHeapSize);
        }
        String defMaxHeapSize = System.getProperty(DEF_MAXHEAPSIZE_PROP);
        int mhs = jvm.getInt("maximumHeapSize", 0);
        if (mhs > 0) {
            this.handleExtraneousArguments("-Xmx" + mhs + "m");
        } else if (defMaxHeapSize != null) {
            this.handleExtraneousArguments(defMaxHeapSize);
            try {
                mhs = Integer.parseInt(defMaxHeapSize.substring(4, defMaxHeapSize.length() - 1));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.zOS) {
            this.processJavaCompressedRefs(mhs);
        }
        if (jvm.getBoolean("runHProf", false)) {
            String hprofArgs = jvm.getUnexpandedString("hprofArguments", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hprofArgs: " + hprofArgs);
            }
            if (hprofArgs != null && hprofArgs.length() > 0) {
                this.params.getCommandLineArguments().add("-Xrunhprof:" + this.expand(hprofArgs));
            }
        }
        if (this.developmentMode && !this.zOS && !PlatformHelperFactory.getPlatformHelper().isOS400() && (developmentString = System.getProperty(DEF_DEVELOPMENT_MODE)) != null && developmentString.length() != 0) {
            String[] devModeParms = developmentString.split(" ");
            for (int i = 0; i < devModeParms.length; ++i) {
                this.params.getCommandLineArguments().add(devModeParms[i].trim());
            }
        }
    }

    private void processJavaCompressedRefs(int maxHeapSizeInMegaBytes) {
        if (!this.params.getCommandLineArguments().contains("-Xcompressedrefs") && !this.params.getCommandLineArguments().contains("-Xnocompressedrefs") && maxHeapSizeInMegaBytes < 25600 && this.isCompressedRefsSupported()) {
            this.params.getCommandLineArguments().add("-Xcompressedrefs");
        }
    }

    private boolean isCompressedRefsSupported() {
        boolean supportedOption = false;
        try {
            boolean jvmBitMode64 = false;
            String propertyName = "com.ibm.vm.bitmode";
            String bitMode = System.getProperty(propertyName);
            if (bitMode != null) {
                jvmBitMode64 = bitMode.equals("64");
            } else {
                Properties p = new Properties();
                p.setProperty("local.cell", this.configService.getCellName());
                p.setProperty("was.repository.root", this.configService.getPath());
                ManagedObjectMetadataAccessor accessor = ManagedObjectMetadataAccessorFactory.createAccessor(p);
                ManagedObjectMetadataHelper metadataHelper = new ManagedObjectMetadataHelper(accessor);
                String nodeVersion = metadataHelper.getNodeBaseProductVersion(this.configService.getNodeName());
                boolean bl = nodeVersion.startsWith("6.1") ? metadataHelper.compareNodeVersion(this.configService.getNodeName(), "6.1.0.4") >= 0 : (jvmBitMode64 = !nodeVersion.startsWith("6.0") && !nodeVersion.startsWith("5"));
            }
            if (jvmBitMode64) {
                String osName = System.getProperty("os.name");
                String osArch = System.getProperty("os.arch");
                if (osName != null && osArch != null) {
                    if (osName.startsWith("Linux")) {
                        supportedOption = osArch.equalsIgnoreCase("IA64") || osArch.equalsIgnoreCase("AMD64") || osArch.equalsIgnoreCase("x86_64") || osArch.equalsIgnoreCase("ppc64") || osArch.equalsIgnoreCase("s390x");
                    } else if (osName.startsWith("Windows")) {
                        supportedOption = osArch.equalsIgnoreCase("IA64") || osArch.equalsIgnoreCase("AMD64");
                    } else if (osName.startsWith("AIX")) {
                        supportedOption = osArch.equalsIgnoreCase("POWER_PC");
                        supportedOption = false;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return supportedOption;
    }

    public void setStatusSocketPort(Integer port) {
        if (port != null) {
            if (this.zOS) {
                String property = "-Dwas.status.socket=" + port.toString();
                this.params.setStatusSocketPort(property);
            } else {
                String property = "-Dwas.status.socket=" + port.toString();
                Tr.debug(tc, "this2", this);
                Tr.debug(tc, "property", property);
                Tr.debug(tc, "parms", this.params);
                Vector vec = this.params.getCommandLineArguments();
                Tr.debug(tc, "vector", vec);
                if (vec.isEmpty()) {
                    vec.add(0, property);
                } else {
                    vec.add(1, property);
                }
            }
        }
    }

    public void addSystemProperty(String propertyString) {
        if (propertyString != null) {
            if (propertyString.startsWith("-Ddb2j.system.home")) {
                Vector args = this.params.getCommandLineArguments();
                for (int i = 0; i < args.size(); ++i) {
                    String arg = (String)args.get(i);
                    if (!arg.startsWith("-Ddb2j.system.home")) continue;
                    args.remove(i);
                }
            }
            this.params.getCommandLineArguments().add(1, propertyString);
            if (propertyString.equals("-Dcom.ibm.ws.server.mode=recovery") && this.zOS) {
                this.params.setServerMode("REC=Y");
            }
        }
    }

    private String expand(String source) {
        String expanded;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "expand", source);
            }
            expanded = source;
            try {
                expanded = this.vars.expand(source);
            }
            catch (Throwable t) {
                Tr.service(tc, "ADML0004E", new Object[]{source, t});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "exception expanding " + source, t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expand exit", expanded);
        }
        return expanded;
    }

    private boolean createParentDir(String filename) {
        File f;
        File parent = null;
        boolean ret = false;
        if (filename != null && (parent = (f = new File(filename)).getParentFile()) != null) {
            ret = parent.mkdirs();
        }
        return ret;
    }

    public void processShortNames(ConfigObject server, ConfigObject serverEntry) {
        ConfigObject applicationServer = null;
        String clusterShortName = "";
        String serverShortName = "";
        List components = server.getObjectList("components");
        for (ConfigObject component2 : components) {
            if (!component2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi", "ApplicationServer")) continue;
            applicationServer = component2;
            break;
        }
        if (applicationServer != null) {
            List props = applicationServer.getObjectList("properties");
            for (int i = 0; i < props.size(); ++i) {
                ConfigObject property = (ConfigObject)props.get(i);
                String pName = property.getUnexpandedString("name", "__null__");
                String pVal = property.getUnexpandedString("value", "__null__");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pName: " + pName + " pVal: " + pVal);
                }
                if (pName == null || pVal == null || !pName.equals("ClusterTransitionName")) continue;
                clusterShortName = pVal;
                this.params.setClusterShortName(clusterShortName);
                break;
            }
        }
        if (clusterShortName.equals("")) {
            clusterShortName = serverEntry.getUnexpandedString("genericShortName", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterShortName: " + clusterShortName);
            }
            this.params.setClusterShortName(clusterShortName);
        }
        serverShortName = server.getUnexpandedString("shortName", "__null__");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverShortName: " + serverShortName);
        }
        if (serverShortName != null && !serverShortName.equals("")) {
            this.params.setServerShortName(serverShortName);
        } else {
            serverShortName = serverEntry.getUnexpandedString("serverShortName", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverShortName : " + serverShortName);
            }
            if (serverShortName != null && !serverShortName.equals("")) {
                this.params.setServerShortName(serverShortName);
            }
        }
    }

    public void processShortNames(Server server, ServerEntry entry) {
        Component as = null;
        String clusterShortName = "";
        String serverShortName = "";
        EList components = server.getComponents();
        for (Component comp : components) {
            if (!(comp instanceof ApplicationServer)) continue;
            as = (ApplicationServer)comp;
            break;
        }
        if (as != null) {
            EList props = as.getProperties();
            int propsSize = props.size();
            for (int i = 0; i < propsSize; ++i) {
                Property p = (Property)props.get(i);
                if (p.getName() == null || p.getValue() == null || !p.getName().equals("ClusterTransitionName")) continue;
                clusterShortName = p.getValue();
                this.params.setClusterShortName(clusterShortName);
                break;
            }
        }
        if (clusterShortName.equals("")) {
            clusterShortName = entry.getGenericShortName();
            this.params.setClusterShortName(clusterShortName);
        }
        if ((serverShortName = server.getShortName()) != null && !serverShortName.equals("")) {
            this.params.setServerShortName(serverShortName);
        } else {
            serverShortName = entry.getServerShortName();
            if (serverShortName != null && !serverShortName.equals("")) {
                this.params.setServerShortName(serverShortName);
            }
        }
    }

    public void process390Commands(ConfigObject processDef) {
        boolean addRoute = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process390Commands", processDef);
        }
        String profilesystem = null;
        AdminService as = AdminServiceFactory.getAdminService();
        if (as != null && AdminHelper.getPlatformHelper().isZOS()) {
            String localServerType = as.getServerType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "localServerType: " + localServerType);
            }
            if (localServerType != null && localServerType.equals("ADMIN_AGENT")) {
                String aasystem = AdminHelper.getPlatformHelper().getSystemName();
                profilesystem = this.getwasConfiguredSystemName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AdminAgent system: " + aasystem + " Profile system: " + profilesystem);
                }
                if (!aasystem.equals(profilesystem)) {
                    addRoute = true;
                }
            }
        }
        String startCmd = processDef.getUnexpandedString("startCommand", "__null__");
        if (addRoute) {
            startCmd = "ROUTE " + profilesystem + "," + startCmd;
        }
        this.params.setStartCommand(startCmd);
        List startCmdArgs = processDef.getUnexpandedStringList("startCommandArgs");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set start command to: " + startCmd);
            Tr.debug(tc, "start command args: " + startCmdArgs);
        }
        String stringCmd = null;
        for (int i = 0; i < startCmdArgs.size(); ++i) {
            stringCmd = (String)startCmdArgs.get(i);
            this.params.getStartCommandArgs().add(stringCmd);
        }
        String stopCmd = processDef.getUnexpandedString("stopCommand", "__null__");
        if (addRoute) {
            stopCmd = "ROUTE " + profilesystem + "," + stopCmd;
        }
        this.params.setStopCommand(stopCmd);
        List stopCmdArgs = processDef.getUnexpandedStringList("stopCommandArgs");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set stop command to: " + stopCmd);
            Tr.debug(tc, "stop command args: " + stopCmdArgs);
        }
        for (int i = 0; i < stopCmdArgs.size(); ++i) {
            stringCmd = (String)stopCmdArgs.get(i);
            this.params.getStopCommandArgs().add(stringCmd);
        }
        String termCmd = processDef.getUnexpandedString("terminateCommand", "__null__");
        if (addRoute) {
            termCmd = "ROUTE " + profilesystem + "," + termCmd;
        }
        this.params.setTerminateCommand(termCmd);
        List terminateCmdArgs = processDef.getUnexpandedStringList("terminateCommandArgs");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set terminate command to: " + termCmd);
            Tr.debug(tc, "terminate command args: " + terminateCmdArgs);
        }
        for (int i = 0; i < terminateCmdArgs.size(); ++i) {
            stringCmd = (String)stopCmdArgs.get(i);
            this.params.getTerminateCommandArgs().add(stringCmd);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process390Commands");
        }
    }

    public void process390Commands(ProcessDef processDef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process390Commands", processDef);
        }
        this.params.setStartCommand(processDef.getStartCommand());
        EList startCmdArgs = processDef.getStartCommandArgs();
        int startArgsSize = startCmdArgs.size();
        String stringCmd = null;
        for (int i = 0; i < startArgsSize; ++i) {
            stringCmd = (String)startCmdArgs.get(i);
            this.params.getStartCommandArgs().add(stringCmd);
        }
        this.params.setStopCommand(processDef.getStopCommand());
        EList stopCmdArgs = processDef.getStopCommandArgs();
        int stopArgsSize = stopCmdArgs.size();
        stringCmd = null;
        for (int i = 0; i < stopArgsSize; ++i) {
            stringCmd = (String)stopCmdArgs.get(i);
            this.params.getStopCommandArgs().add(stringCmd);
        }
        this.params.setTerminateCommand(processDef.getTerminateCommand());
        EList terminateCmdArgs = processDef.getTerminateCommandArgs();
        int terminateArgsSize = terminateCmdArgs.size();
        stringCmd = null;
        for (int i = 0; i < terminateArgsSize; ++i) {
            stringCmd = (String)terminateCmdArgs.get(i);
            this.params.getTerminateCommandArgs().add(stringCmd);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process390Commands");
        }
    }

    private String getwasConfiguredSystemName() {
        String ownConfiguredSystemName;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getwasConfiguredSystemName");
            }
            ownConfiguredSystemName = null;
            try {
                List list = this.configService.getDocumentObjects(this.configService.getScope(4), "server.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configservice list has size: " + list.size());
                }
                ConfigObject object = (ConfigObject)list.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using server.xml for server: " + object.getString("name", "__null__"));
                }
                List services = object.getObjectList("services");
                for (ConfigObject service : services) {
                    String typeName = service.getTypeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying services config type: " + typeName);
                    }
                    if (!typeName.equals("AdminService")) continue;
                    List properties = service.getObjectList("properties");
                    for (ConfigObject property : properties) {
                        if (!"was.ConfiguredSystemName".equals(property.getString("name", ""))) continue;
                        ownConfiguredSystemName = property.getString("value", null);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "found was.ConfiguredSystemName:" + ownConfiguredSystemName);
                    }
                }
                if (ownConfiguredSystemName != null) break block12;
                List components = object.getObjectList("components");
                for (ConfigObject component2 : components) {
                    String typeName = component2.getTypeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying component config type: " + typeName);
                    }
                    if (!typeName.equals("ApplicationServer")) continue;
                    List properties = component2.getObjectList("properties");
                    for (ConfigObject property : properties) {
                        if (!"was.ConfiguredSystemName".equals(property.getString("name", ""))) continue;
                        ownConfiguredSystemName = property.getString("value", null);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "found was.ConfiguredSystemName:" + ownConfiguredSystemName);
                    }
                    break;
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.launcher.LaunchCommand.getwasConfiguredSystemName", (String)"1479", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getwasConfiguredSystemName", ownConfiguredSystemName);
        }
        return ownConfiguredSystemName;
    }

    private ConfigObject getServerEntry(ConfigService cfgService, String serverName) throws Exception {
        ConfigObject serverEntry = null;
        String server = null;
        List l = cfgService.getDocumentObjects(cfgService.createScope(3), "serverindex.xml");
        ConfigObject serverIndex = (ConfigObject)l.get(0);
        List entries = serverIndex.getObjectList("serverEntries");
        for (int i = 0; i < entries.size(); ++i) {
            serverEntry = (ConfigObject)entries.get(i);
            server = serverEntry.getUnexpandedString("serverName", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server name: " + server);
            }
            if (server.equals(serverName)) break;
        }
        return serverEntry;
    }

    public void setDevOption(boolean opt) {
        this.devOption = opt;
    }

    public boolean getDevOption() {
        return this.devOption;
    }

    public void setParamsFromServer(Server server) {
        this.developmentMode = server.isSetDevelopmentMode() && server.isDevelopmentMode();
    }

    public void setParamsFromServer(ConfigObject server) {
        this.developmentMode = server.isSet("developmentMode") && server.getBoolean("developmentMode", false);
    }

    private void setGenericServerParamsFromJavaProcessDef(ConfigObject javaProcessDef) throws Exception {
        ConfigObject jvm = null;
        List jvms = javaProcessDef.getObjectList("jvmEntries");
        String os = System.getProperty("os.name");
        for (int i = 0; i < jvms.size(); ++i) {
            ConfigObject javaVirtualMachine = (ConfigObject)jvms.get(i);
            String osName = javaVirtualMachine.getUnexpandedString("osName", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "osName: " + osName);
            }
            if (osName == null || !osName.equalsIgnoreCase(os)) continue;
            jvm = javaVirtualMachine;
            break;
        }
        if (jvm != null) {
            int i;
            int maxHeapSize;
            int initHeapSize;
            int i2;
            int i3;
            Properties defaultProps = new Properties();
            if (defaultProps != null) {
                Enumeration<?> keys = defaultProps.propertyNames();
                while (keys.hasMoreElements()) {
                    String propKey = (String)keys.nextElement();
                    propKey = propKey.trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Default system property: " + propKey + "=" + defaultProps.getProperty(propKey));
                    }
                    this.processSystemProperty("-D" + propKey + "=" + defaultProps.getProperty(propKey).trim());
                }
            }
            List sysProps = jvm.getObjectList("systemProperties");
            for (int i4 = 0; i4 < sysProps.size(); ++i4) {
                ConfigObject property = (ConfigObject)sysProps.get(i4);
                String pName = property.getUnexpandedString("name", "__null__");
                String pVal = property.getUnexpandedString("value", "__null__");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pName: " + pName + " pVal: " + pVal);
                }
                if (pName == null || pVal == null) continue;
                this.processSystemProperty("-D" + pName + "=" + pVal);
            }
            String genArgs = jvm.getUnexpandedString("genericJvmArguments", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "genArgs: " + genArgs);
            }
            if (genArgs != null && genArgs.length() > 0) {
                this.processCommandLineArguments(genArgs);
            }
            Vector<String> bootClasspaths = new Vector<String>();
            List list = jvm.getUnexpandedStringList("bootClasspath");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list: " + list);
            }
            String bootClasspath = null;
            for (i3 = 0; i3 < list.size(); ++i3) {
                bootClasspath = (String)list.get(i3);
                if (bootClasspath == null || bootClasspath.length() <= 0) continue;
                bootClasspaths.add(bootClasspath);
            }
            if (bootClasspath != null && bootClasspath.length() > 0) {
                bootClasspaths.add(bootClasspath);
            }
            if (this.gatheredBootclasspath.size() > 0) {
                for (i3 = 0; i3 < this.gatheredBootclasspath.size(); ++i3) {
                    bootClasspaths.add((String)this.gatheredBootclasspath.get(i3));
                }
            }
            if (bootClasspaths.size() > 0) {
                bootClasspath = (String)bootClasspaths.get(0);
                for (i3 = 1; i3 < bootClasspaths.size(); ++i3) {
                    bootClasspath = bootClasspath + File.pathSeparator + (String)bootClasspaths.get(i3);
                }
            }
            if (bootClasspath != null) {
                this.params.getCommandLineArguments().add("-Xbootclasspath/p:" + this.expand(bootClasspath));
            }
            Vector<String> classpaths = new Vector<String>();
            String classpath = null;
            list = jvm.getUnexpandedStringList("classpath");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list: " + list);
            }
            for (i2 = 0; i2 < list.size(); ++i2) {
                classpath = (String)list.get(i2);
                if (classpath == null || classpath.length() <= 0) continue;
                classpaths.add(classpath);
            }
            if (this.gatheredClasspath.size() > 0) {
                for (i2 = 0; i2 < this.gatheredClasspath.size(); ++i2) {
                    classpaths.add((String)this.gatheredClasspath.get(i2));
                }
            }
            if (classpaths.size() > 0) {
                classpath = (String)classpaths.get(0);
                for (i2 = 1; i2 < classpaths.size(); ++i2) {
                    classpath = classpath + File.pathSeparator + (String)classpaths.get(i2);
                }
            }
            if (classpath != null) {
                this.params.getCommandLineArguments().add("-classpath");
                this.params.getCommandLineArguments().add(this.expand(classpath));
            }
            if (jvm.getBoolean("verboseModeJNI", false)) {
                this.params.getCommandLineArguments().add("-verbose:jni");
            }
            if (jvm.getBoolean("verboseModeGarbageCollection", false)) {
                this.params.getCommandLineArguments().add("-verbose:gc");
            }
            if (jvm.getBoolean("verboseModeClass", false)) {
                this.params.getCommandLineArguments().add("-verbose:class");
            }
            if ((initHeapSize = jvm.getInt("initialHeapSize", 0)) > 0) {
                this.params.getCommandLineArguments().add("-Xms" + initHeapSize + "m");
            }
            if ((maxHeapSize = jvm.getInt("maximumHeapSize", 0)) > 0) {
                this.params.getCommandLineArguments().add("-Xmx" + maxHeapSize + "m");
            }
            if (!this.zOS) {
                this.processJavaCompressedRefs(maxHeapSize);
            }
            if (jvm.getBoolean("runHProf", false)) {
                String hprofArgs = jvm.getUnexpandedString("hprofArguments", "__null__");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hprofArgs: " + hprofArgs);
                }
                if (hprofArgs != null && hprofArgs.length() > 0) {
                    this.params.getCommandLineArguments().add("-Xrunhprof:" + this.expand(hprofArgs));
                }
            }
            Vector<String> wsExtDirs = new Vector<String>();
            String wsExtDir = null;
            if (this.gatheredWsExtDirs.size() > 0) {
                for (i = 0; i < this.gatheredWsExtDirs.size(); ++i) {
                    wsExtDirs.addElement((String)this.gatheredWsExtDirs.get(i));
                }
            }
            if (wsExtDirs.size() > 0) {
                wsExtDir = (String)wsExtDirs.get(0);
                for (i = 1; i < wsExtDirs.size(); ++i) {
                    wsExtDir = wsExtDir + File.pathSeparator + (String)wsExtDirs.get(i);
                }
            }
            if (wsExtDir != null) {
                this.params.getCommandLineArguments().add("-Dws.ext.dirs=" + this.expand(wsExtDir));
            }
            this.processJavaLibraryPathInfo();
            if (this.gatheredMiscCommandLineArgs.size() > 0) {
                for (i = 0; i < this.gatheredMiscCommandLineArgs.size(); ++i) {
                    this.params.getCommandLineArguments().add(this.expand((String)this.gatheredMiscCommandLineArgs.get(i)));
                }
            }
            this.processSecurityProperties();
        }
        this.processExecutionTargetInfo(javaProcessDef);
    }

    private void handleExtraneousArguments(String arg) {
        String key = null;
        String value = null;
        boolean isNumeric = false;
        boolean equalSign = false;
        if (arg == null) {
            return;
        }
        if (arg.length() == 0) {
            return;
        }
        int colonIndex = arg.indexOf(58);
        int equalIndex = arg.indexOf(61);
        boolean is_HPUX_XX_Arg = this.isHPUX_XX(arg);
        if (colonIndex == -1) {
            if (equalIndex == -1) {
                boolean done = false;
                int index = arg.length();
                int counter = 0;
                while (!done) {
                    char character = arg.charAt(counter);
                    if (character >= '0' && character <= '9') {
                        key = arg.substring(0, counter);
                        value = arg.substring(counter);
                        done = true;
                        isNumeric = true;
                        continue;
                    }
                    if (++counter != index) continue;
                    done = true;
                }
                if (counter == index) {
                    key = new String(arg);
                }
            } else {
                key = arg.substring(0, equalIndex);
                value = arg.substring(equalIndex + 1);
                equalSign = true;
            }
        } else if (is_HPUX_XX_Arg) {
            key = this.parseHPUX_XX(arg);
        } else if (equalIndex == -1) {
            key = arg.substring(0, colonIndex);
            value = arg.substring(colonIndex + 1);
        } else if (colonIndex < equalIndex) {
            if (arg.startsWith("-XX:")) {
                key = arg.substring(0, equalIndex);
                value = arg.substring(equalIndex + 1);
            } else {
                key = arg.substring(0, colonIndex);
                value = arg.substring(colonIndex + 1);
            }
        } else {
            key = arg.substring(0, equalIndex);
            value = arg.substring(equalIndex + 1);
        }
        if (this.cleanedArguments.containsKey(key)) {
            if (!is_HPUX_XX_Arg) {
                if (isNumeric) {
                    String oldValue = (String)this.cleanedArguments.get(key);
                    this.cleanedArguments.remove(key);
                    this.cleanedArguments.put(key, value);
                    this.params.getCommandLineArguments().remove(key + oldValue);
                    this.params.getCommandLineArguments().add(arg);
                } else if (arg.startsWith("-D") || arg.startsWith("-XX:")) {
                    if (this.cleanedArguments.containsKey(key)) {
                        String oldValue = (String)this.cleanedArguments.get(key);
                        String oldArgument = (String)this.cleanedArguments.get(key + oldValue);
                        this.cleanedArguments.remove(key);
                        this.cleanedArguments.remove(key + oldValue);
                        this.cleanedArguments.put(key, value);
                        this.cleanedArguments.put(key + value, arg);
                        this.params.getCommandLineArguments().remove(oldArgument);
                        this.params.getCommandLineArguments().add(arg);
                    }
                } else if (!this.cleanedArguments.containsKey(arg)) {
                    this.cleanedArguments.put(arg, null);
                    this.params.getCommandLineArguments().add(arg);
                }
            }
        } else {
            if (is_HPUX_XX_Arg) {
                this.cleanedArguments.put(key, null);
            } else if (isNumeric) {
                this.cleanedArguments.put(key, value);
            } else if (arg.startsWith("-D") || arg.startsWith("-XX:")) {
                this.cleanedArguments.put(key, value);
                this.cleanedArguments.put(key + value, arg);
            } else {
                this.cleanedArguments.put(key, null);
                this.cleanedArguments.put(arg, null);
            }
            this.params.getCommandLineArguments().add(arg);
        }
    }

    private boolean isHPUX_XX(String arg) {
        if (arg.startsWith("-XX:+")) {
            return true;
        }
        if (arg.startsWith("-XX:-")) {
            return true;
        }
        return arg.startsWith("-XX:OnError");
    }

    private String parseHPUX_XX(String arg) {
        if (arg.startsWith("-XX:+")) {
            return arg;
        }
        if (arg.startsWith("-XX:-")) {
            return arg;
        }
        if (arg.startsWith("-XX:OnError")) {
            return arg;
        }
        return null;
    }

    private ConfigObject getCell(ConfigService cs, int cscope, String relPath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCell");
        }
        List contents = cs.getDocumentObjects(cs.getScope(cscope), relPath);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCell");
        }
        return (ConfigObject)contents.get(0);
    }

    private void processCellLevelCustomProp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCellLevelCustomProp");
        }
        try {
            ConfigObject cell = this.getCell(this.configService, 0, "cell.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cell: " + cell);
            }
            List properties = cell.getObjectList("properties");
            ConfigObject prop = null;
            String propertyName = null;
            String propertyValue = null;
            for (int i = 0; i < properties.size(); ++i) {
                prop = (ConfigObject)properties.get(i);
                propertyName = prop.getUnexpandedString("name", "__null__");
                propertyValue = prop.getUnexpandedString("value", "__null__");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Property name " + propertyName);
                    Tr.debug(tc, "Property value " + propertyValue);
                }
                if (!propertyName.equals("com.ibm.websphere.management.launcher.options") || !propertyValue.equals("displayServerInFront")) continue;
                String arg = "-Dwas.launcher.server=" + this.serverId.getCellName() + ":" + this.serverId.getNodeName() + ":" + this.serverId.getServerName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Argument constructed " + arg);
                }
                this.params.getCommandLineArguments().add(0, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCellLevelCustomProp");
        }
    }
}

