/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.launcher.LaunchPlatformHelper;
import com.ibm.ws.management.tools.LaunchUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DefaultLaunchPlatformHelper
implements LaunchPlatformHelper {
    private static TraceComponent tc = Tr.register(DefaultLaunchPlatformHelper.class, "Launcher", "com.ibm.ws.management.resources.launcher");
    private Properties defaultSettings = null;
    private static final String[] KEYS = new String[]{"com.ibm.websphere.nddmz", "com.ibm.websphere.management.launcher.defaultJreExecutableName", "com.ibm.websphere.management.launcher.defaultExecutableName", "com.ibm.websphere.management.launcher.defaultMinHeapSize", "com.ibm.websphere.management.launcher.defaultMaxHeapSize", "com.ibm.websphere.management.launcher.developmentMode"};

    public DefaultLaunchPlatformHelper() throws Exception {
        try {
            block22: {
                String arch;
                String os;
                this.defaultSettings = new Properties();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = DefaultLaunchPlatformHelper.class.getClassLoader();
                }
                if ((os = System.getProperty("os.name").toLowerCase()).startsWith("hp")) {
                    os = os.substring(0, 2);
                    arch = System.getProperty("os.arch");
                    if (arch.startsWith("IA64")) {
                        os = os + "IA64";
                    }
                } else if (os.startsWith("sun")) {
                    os = os.substring(0, 3);
                    arch = System.getProperty("os.arch");
                    if (arch.startsWith("x86") || arch.startsWith("amd64")) {
                        os = os + "x64";
                    } else if (arch.startsWith("sparcv9")) {
                        os = os + "sparc64";
                    }
                } else if (os.equalsIgnoreCase("OS/400")) {
                    os = System.getProperty("os400.use.j9", "false").equals("true") ? "os400j9" : "os400";
                } else if (os.startsWith("lin")) {
                    os = System.getProperty("linux.use.wrt", "false").equals("true") ? "linwrt" : "lin";
                } else if (os.length() > 3) {
                    os = os.substring(0, 3);
                }
                String defaultLaunchPropertiesFile = "properties/systemlaunch/systemlaunch.properties";
                String osLaunchPropertiesFile = "properties/systemlaunch/" + os + ".systemlaunch.properties";
                String nddmzPropertiesFile = "/properties/nddmz.properties";
                String wasinstallroot = System.getProperty("was.install.root");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the nddmz properties file path is: " + wasinstallroot + nddmzPropertiesFile);
                }
                InputStream in = cl.getResourceAsStream(defaultLaunchPropertiesFile);
                this.defaultSettings.load(in);
                in = cl.getResourceAsStream(osLaunchPropertiesFile);
                if (in != null) {
                    this.defaultSettings.load(in);
                }
                try {
                    if (wasinstallroot != null) {
                        this.defaultSettings.load(new FileInputStream(wasinstallroot + nddmzPropertiesFile));
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug(tc, "this is not an nddmz image");
                }
            }
            for (int i = 0; i < KEYS.length; ++i) {
                if (this.defaultSettings.getProperty(KEYS[i]) == null) continue;
                System.setProperty(KEYS[i], this.defaultSettings.getProperty(KEYS[i]));
            }
        }
        catch (Throwable th) {
            Tr.warning(tc, "ADML3000E", th);
        }
    }

    public Vector getDefaultBootclasspath(boolean debugMode) throws Exception {
        Vector<String> v = new Vector<String>();
        String prop = null;
        if (debugMode) {
            prop = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.debugJar");
            if (prop != null) {
                v.add(prop);
            } else {
                Tr.info(tc, "ADML3001W", new Object[]{"debugJar"});
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"debugJar"}, null));
            }
        }
        if ((prop = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.orbBootstrapJar")) == null) {
            Tr.info(tc, "ADML3001W", new Object[]{"orbBootstrapJar"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"orbBootstrapJar"}, null));
        }
        v.add(prop);
        prop = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.extBootstrapJar");
        if (prop == null) {
            Tr.info(tc, "ADML3001W", new Object[]{"extBootstrapJar"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"extBootstrapJar"}, null));
        }
        v.add(prop);
        return v;
    }

    public Vector getDefaultClasspath() throws Exception {
        Vector<String> v = new Vector<String>();
        String classpath = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultClasspath");
        if (classpath != null) {
            StringTokenizer s = new StringTokenizer(classpath, ":");
            while (s.hasMoreElements()) {
                v.add(s.nextToken());
            }
        } else {
            Tr.info(tc, "ADML3001W", new Object[]{"defaultClasspath"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"defaultClasspath"}, null));
        }
        return v;
    }

    public Properties getDefaultEnvironment() throws Exception {
        Properties defaultEnvironment = new Properties();
        String environment = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultEnvironment");
        if (environment != null) {
            StringTokenizer s = new StringTokenizer(environment, ":");
            while (s.hasMoreElements()) {
                String sysprop = s.nextToken();
                String key = sysprop.substring(0, sysprop.indexOf("="));
                String value = sysprop.substring(sysprop.indexOf("=") + 1, sysprop.length());
                defaultEnvironment.put(key, value);
            }
        } else {
            Tr.info(tc, "ADML3001W", new Object[]{"defaultEnvironment"});
        }
        return defaultEnvironment;
    }

    public Vector getDisableJitc(boolean debugMode, String jvmMode) {
        Vector<String> disableJit = new Vector<String>();
        disableJit.add("-Djava.compiler=NONE");
        if (jvmMode.equals("HOTSPOT")) {
            if (!debugMode && System.getProperty("os.name").toLowerCase().startsWith("sun")) {
                disableJit.add("-Xint");
            }
        } else if (System.getProperty("os.name").toLowerCase().startsWith("hp")) {
            disableJit.add("-Xnojit");
        }
        return disableJit;
    }

    public Properties getDefaultSystemProperties() throws Exception {
        Properties defaultProps = new Properties();
        Enumeration<Object> e = this.defaultSettings.keys();
        String key = null;
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (key.startsWith("com.ibm.websphere.management.launcher.")) continue;
            defaultProps.put(key, this.defaultSettings.getProperty(key));
        }
        return defaultProps;
    }

    public Vector getDefaultWsExtDirs() throws Exception {
        Vector<String> v = new Vector<String>();
        String wasextdirs = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultWsExtDirs");
        if (wasextdirs != null) {
            StringTokenizer s = new StringTokenizer(wasextdirs, ":");
            while (s.hasMoreElements()) {
                v.add(s.nextToken());
            }
        } else {
            Tr.info(tc, "ADML3001W", new Object[]{"defaultWsExtDirs"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"defaultWsExtDirs"}, null));
        }
        return v;
    }

    public Vector getDefaultJVMOptions() {
        Vector<String> v = new Vector<String>();
        String jvmOptions = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultJvmOptions");
        if (jvmOptions != null) {
            StringTokenizer s = new StringTokenizer(jvmOptions, " ");
            while (s.hasMoreElements()) {
                v.add(s.nextToken());
            }
        }
        return v;
    }
}

