/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.FilterElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ConsolidatedFilter
implements NotificationFilter {
    private static final long serialVersionUID = 8448046386485560623L;
    private static TraceComponent tc = Tr.register(ConsolidatedFilter.class, "Admin", "com.ibm.ws.management.resources.event");
    private Set filters = Collections.synchronizedSet(new HashSet());

    public boolean addFilter(NotificationListener listener, ObjectName name, NotificationFilter filter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFilter", new Object[]{listener, name, filter});
        }
        this.filters.add(new FilterElement(listener, name, filter));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "filter is now " + this.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFilter");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilter(ObjectName name, NotificationListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFilter", listener);
        }
        boolean result = false;
        Set set = this.filters;
        synchronized (set) {
            Iterator i = this.filters.iterator();
            while (i.hasNext()) {
                if (!((FilterElement)i.next()).matches(name, listener)) continue;
                i.remove();
                result = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "filter is now " + this.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFilter", new Boolean(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled(Notification ntfyObj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNotificationEnabled", ntfyObj.toString());
        }
        boolean enabled = false;
        Set set = this.filters;
        synchronized (set) {
            Iterator i = this.filters.iterator();
            while (i.hasNext()) {
                if (!((FilterElement)i.next()).isNotificationEnabled(ntfyObj)) continue;
                enabled = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNotificationEnabled", new Boolean(enabled));
        }
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendFilterEntries(ConsolidatedFilter sourceFilter, ServerInfo serverInfo) {
        boolean modified = false;
        boolean zos = AdminHelper.getPlatformHelper().isZOS();
        Set set = sourceFilter.filters;
        synchronized (set) {
            for (FilterElement e : sourceFilter.filters) {
                String node;
                ObjectName name = e.info.getName();
                String cell = name.getKeyProperty("cell");
                if (cell != null && !cell.equals(serverInfo.getCell()) || (node = name.getKeyProperty("node")) != null && !node.equals(serverInfo.getNode())) continue;
                if (zos) {
                    this.filters.add(e.elementWithOutFilter());
                } else {
                    this.filters.add(e);
                }
                modified = true;
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendAllFilterEntries(ConsolidatedFilter sourceFilter) {
        Set set = sourceFilter.filters;
        synchronized (set) {
            Iterator i = sourceFilter.filters.iterator();
            while (i.hasNext()) {
                this.filters.add(((FilterElement)i.next()).elementWithOutFilter());
            }
        }
    }

    public String toString() {
        return "ConsolidatedFilter: " + this.filters;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsolidatedFilter)) {
            return false;
        }
        ConsolidatedFilter cf = (ConsolidatedFilter)o;
        return ((Object)cf.filters).equals(this.filters);
    }

    Set getFiltersForUnitTest() {
        return this.filters;
    }
}

