/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.transport.UdpConnection;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class UdpServer
implements Runnable {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(UdpServer.class, "Admin", "com.ibm.ws.management.resources.discovery");
    protected ThreadPool threadPool = null;
    protected ObjectPool connectionPool = null;
    protected int port;
    protected int bufSize = 16384;
    protected boolean alive;
    protected Thread acceptThread = null;
    protected Endpoint endpoint;
    private DatagramSocket serverSocket;
    private int retryLimit = 4;
    private int retryInterval = 1000;

    public UdpServer() {
    }

    public UdpServer(Endpoint endpoint) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UdpServer");
        }
        this.endpoint = endpoint;
        ThreadPoolMgr tpMgr = endpoint.getThreadPoolMgr();
        int maxThreads = 2;
        String threadString = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (threadString != null) {
            maxThreads = new Integer(threadString);
        }
        this.threadPool = this.getThreadPool(tpMgr, "ProcessDiscovery", maxThreads);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return UdpServer.this.createUdpConnection();
            }
        };
        this.retryLimit = Integer.getInteger("com.ibm.websphere.management.discovery.udp.retryLimit", 4);
        this.retryInterval = Integer.getInteger("com.ibm.websphere.management.discovery.udp.retryInterval", 1000);
        if (this.retryInterval > 30000) {
            this.retryInterval = 30000;
        }
        if (this.retryInterval < 1000) {
            this.retryInterval = 1000;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UdpServer");
        }
    }

    public void initialize(int port) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize @" + port);
        }
        this.alive = true;
        Boolean useMultiHome = AdminHelper.getInstance().useMultiHome();
        if (useMultiHome == null) {
            this.serverSocket = new DatagramSocket(port);
        } else if (useMultiHome.booleanValue()) {
            this.serverSocket = new DatagramSocket(port, null);
        } else {
            InetAddress ia = InetAddress.getByName(this.endpoint.getEndpointAddress().getProtocolHost());
            this.serverSocket = new DatagramSocket(port, ia);
        }
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize - successful");
        }
    }

    public void shutdown(boolean force) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        this.alive = false;
        try {
            try {
                this.serverSocket.close();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", (String)"124", (Object)this);
                this.acceptThread.interrupt();
            }
            this.acceptThread.join(10000L);
        }
        catch (InterruptedException ie) {
            FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", (String)"129", (Object)this);
            Tr.warning(tc, "ADMD0016W", ie.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    protected UdpConnection createUdpConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createUdpConnection");
        }
        return new UdpConnection();
    }

    public void handleConnection(UdpConnection c) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleConnection");
        }
        try {
            this.threadPool.execute((Runnable)c);
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.handleConnection", (String)"148", (Object)this);
        }
    }

    public UdpConnection allocateConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allocateConnection");
        }
        return (UdpConnection)this.connectionPool.remove();
    }

    public boolean freeConnection(UdpConnection conn) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "freeConnection");
        }
        return !this.connectionPool.add((Object)conn);
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        int retryCount = 0;
        DatagramPacket dp = null;
        while (this.alive) {
            if (retryCount >= this.retryLimit) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Retry Count is: " + retryCount + " shutdown() called");
                }
                this.alive = false;
                break;
            }
            if (this.acceptThread.isInterrupted()) break;
            try {
                byte[] buffer = new byte[this.bufSize];
                dp = new DatagramPacket(buffer, buffer.length);
                this.serverSocket.receive(dp);
                retryCount = 0;
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.run", (String)"170", (Object)this);
                if (this.alive) {
                    Tr.warning(tc, "ADMD0017W", ioe.getMessage());
                }
                ++retryCount;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sleeping for: " + this.retryLimit + " milliseconds...");
                    }
                    Thread.sleep(this.retryLimit);
                }
                catch (InterruptedException ie) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Thread Interrupted.. shutting down");
                    break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Datagram packet(port, length): ", new Object[]{new Integer(dp.getPort()), new Integer(dp.getLength())});
            }
            if (!this.alive) continue;
            UdpConnection conn = null;
            try {
                conn = this.allocateConnection();
                conn.init(this.endpoint, dp);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the connection is initialized");
                }
                this.handleConnection(conn);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.run", (String)"185", (Object)this);
                if (conn != null) {
                    this.freeConnection(conn);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "connection handling failure: " + t.getMessage());
            }
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    protected ThreadPool getThreadPool(ThreadPoolMgr tpMgr, String name, int maxThreads) {
        ThreadPool pool = null;
        pool = tpMgr.getThreadPool(name, null);
        pool.setMinimumPoolSize(1);
        pool.setMaximumPoolSize(maxThreads);
        pool.setGrowAsNeeded(true);
        return pool;
    }
}

