/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;

public class Message {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(Message.class, "Admin", "com.ibm.ws.management.resources.discovery");
    public static final String XMLEncoding = "<?xml version=\"1.0\"  standalone='yes'?>";
    public static final String DestinationTagStart = "<JxtaMessageDest>";
    public static final String DestinationTagEnd = "</JxtaMessageDest>";
    public static final String SourceTagStart = "<JxtaMessageSrc>";
    public static final String SourceTagEnd = "</JxtaMessageSrc>";
    public static final String DigestTagStart = "<JxtaMessageDigest>";
    public static final String DigestTagEnd = "</JxtaMessageDigest>";
    private InputStream stream;
    private InputStream headerStream;
    private InputStream dataStream;
    private EndpointAddress source;
    private EndpointAddress destination;

    public Message(InputStream data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Message(InputStream)");
        }
        this.dataStream = data;
        this.headerStream = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Message(InputStream)");
        }
    }

    public Message(InputStream data, EndpointAddress source, EndpointAddress destination) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Message(InputStream, EndpointAddress, EndpointAddress)");
        }
        this.source = source;
        this.destination = destination;
        this.dataStream = data;
        this.pushHeader(this.source, this.destination);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Message(InputStream,EndpointAddress, EndpointAddress)");
        }
    }

    public Message(byte[] array) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Message(byte[])");
        }
        this.stream = new ByteArrayInputStream(array);
        this.extractHeader(array);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Message(byte[])");
        }
    }

    public Message(byte[] array, int offset, int len) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Message(byte[], int, int)");
        }
        this.stream = new ByteArrayInputStream(array, offset, len);
        this.extractHeader(array, offset, len);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Message(byte[], int, int)");
        }
    }

    private void pushHeader(EndpointAddress source, EndpointAddress destination) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushHeader(source, destination)", new Object[]{source, destination});
        }
        String header = "<?xml version=\"1.0\"  standalone='yes'?><JxtaMessageDest>" + destination.toString() + DestinationTagEnd + SourceTagStart + source.toString() + SourceTagEnd;
        this.headerStream = new ByteArrayInputStream(header.getBytes());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "header byte size: " + header.getBytes().length);
        }
        this.stream = new SequenceInputStream(this.headerStream, this.dataStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushHeader(source, destination)");
        }
    }

    private void extractHeader(byte[] messageBytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractHeader(byte[])");
        }
        this.extractHeader(messageBytes, 0, messageBytes.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractHeader(byte[])");
        }
    }

    private void extractHeader(byte[] messageBytes, int offset, int len) {
        int j;
        String tmp;
        int i;
        block34: {
            block33: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "extractHeader(byte[], int, int)");
                }
                i = -1;
                for (int k = offset; k < messageBytes.length; ++k) {
                    if (messageBytes[k] != 60) continue;
                    i = k;
                    break;
                }
                if (i == -1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No XML tag within the message");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractHeader - incomplete");
                    }
                    return;
                }
                tmp = new String(messageBytes, i, XMLEncoding.length());
                if (!tmp.equals(XMLEncoding)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "only XML encoding accepted");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractHeader - incomplete");
                    }
                    return;
                }
                tmp = new String(messageBytes, i += XMLEncoding.length(), DestinationTagStart.length());
                if (!tmp.equals(DestinationTagStart)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid message: Destination Start Tag not found");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractHeader - incomplete");
                    }
                    return;
                }
                j = i += DestinationTagStart.length();
                for (j = i; j < messageBytes.length && messageBytes[j] != 60; ++j) {
                }
                if (j == messageBytes.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid message; Destination End Tag not found");
                    }
                    return;
                }
                try {
                    this.destination = new EndpointAddress(new String(messageBytes, i, j - i));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "message targeting", this.destination);
                    }
                }
                catch (InvalidEndpointAddressException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.Message.extractHeader", (String)"161", (Object)this);
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug(tc, "Invalid message: destination address format error", ex);
                }
            }
            i = j;
            tmp = new String(messageBytes, i, DestinationTagEnd.length());
            if (!tmp.equals(DestinationTagEnd)) {
                this.destination = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid message: Destination End Tag not found");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractHeader - incomplete");
                }
                return;
            }
            tmp = new String(messageBytes, i += DestinationTagEnd.length(), SourceTagStart.length());
            if (!tmp.equals(SourceTagStart)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid message : Source Start Tag not found");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractHeader - incomplete");
                }
                return;
            }
            j = i += SourceTagStart.length();
            for (j = i; j < messageBytes.length && messageBytes[j] != 60; ++j) {
            }
            if (j == messageBytes.length) {
                Tr.warning(tc, "ADMD0013W");
                return;
            }
            try {
                this.source = new EndpointAddress(new String(messageBytes, i, j - i));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "message coming from", this.source);
                }
            }
            catch (InvalidEndpointAddressException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.Message.extractHeader", (String)"204", (Object)this);
                if (!tc.isDebugEnabled()) break block34;
                Tr.debug(tc, "Invalid message: source address format error", ex);
            }
        }
        i = j;
        tmp = new String(messageBytes, i, SourceTagEnd.length());
        if (!tmp.equals(SourceTagEnd)) {
            this.source = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid message invalid : not Source End Tag");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extractHeader - incomplete");
            }
            return;
        }
        i += SourceTagEnd.length();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "data stream starting at " + (i - offset));
        }
        this.dataStream = new ByteArrayInputStream(messageBytes, i, len + offset - i);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractHeader(byte[], int, int)");
        }
    }

    public InputStream getInputStream() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInputStream");
        }
        if (this.headerStream == null) {
            this.pushHeader(this.source, this.destination);
        }
        return this.stream;
    }

    public InputStream getDataInputStream() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDataInputStream");
        }
        return this.dataStream;
    }

    public EndpointAddress getDestinationAddress() {
        return this.destination;
    }

    public EndpointAddress getSourceAddress() {
        return this.source;
    }

    public void setDestinationAddress(EndpointAddress destination) {
        this.destination = destination;
    }

    public void setSourceAddress(EndpointAddress source) {
        this.source = source;
    }
}

