/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;

public class DiscoveryMBean
extends RuntimeCollaborator
implements RoutingListener {
    private static TraceComponent tc = Tr.register(DiscoveryMBean.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private static long ntfySeqNum = 0L;
    private String childType;
    private String parentType;
    private String myType;
    private ServerInfo parent;
    private ArrayList children = new ArrayList();

    public DiscoveryMBean() {
        this.myType = AdminServiceFactory.getAdminService().getProcessType();
        if (this.myType.equals("DeploymentManager")) {
            this.childType = "NodeAgent";
        } else if (this.myType.equals("NodeAgent")) {
            this.childType = "ManagedProcess";
            this.parentType = "DeploymentManager";
        } else if (this.myType.equals("ManagedProcess")) {
            this.parentType = "NodeAgent";
        } else if (this.myType.equals("AdminAgent")) {
            this.childType = "UnManagedProcess";
        } else if (this.myType.equals("UnManagedProcess")) {
            this.parentType = "AdminAgent";
        }
    }

    public ServerInfo getParent() {
        return this.parent;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Properties getParentConnectorProperties() {
        if (this.parent == null) {
            return null;
        }
        RoutingTable rt = RoutingTable.getInstance();
        if (rt == null) {
            return null;
        }
        try {
            AdminClient adminClient = rt.getParent();
            if (adminClient == null) {
                return null;
            }
            Properties props = adminClient.getConnectorProperties();
            if ((props = (Properties)props.clone()).get("password") != null) {
                props.put("password", "*****");
            }
            return props;
        }
        catch (ConnectorException ex) {
            return null;
        }
    }

    public Properties getChildConnectorProperties(String name) {
        RoutingTable rt = RoutingTable.getInstance();
        if (rt == null) {
            return null;
        }
        try {
            AdminClient adminClient = rt.getAdminClient(name);
            if (adminClient == null) {
                return null;
            }
            Properties props = adminClient.getConnectorProperties();
            if ((props = (Properties)props.clone()).get("password") != null) {
                props.put("password", "*****");
            }
            return props;
        }
        catch (ConnectorException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childAdded");
        }
        String name = serverInfo.getName();
        String pid = serverInfo.getPid();
        String version = serverInfo.getVersion();
        Notification ntfyObj = new Notification("websphere.discovery.process.found", this.getObjectName(), ntfySeqNum++);
        Properties props = new Properties();
        props.setProperty("processName", name);
        props.setProperty("nodeName", serverInfo.getNode());
        props.setProperty("processId", pid);
        props.setProperty("version", version);
        ntfyObj.setUserData(props);
        if (this.childType.equals("NodeAgent")) {
            name = serverInfo.getNode();
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            if (!this.children.contains(name)) {
                this.children.add(name);
            }
        }
        Tr.info(tc, "ADMD0023I", new Object[]{name, this.childType, pid});
        try {
            this.sendNotification(ntfyObj);
        }
        catch (MBeanException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.childAdded", (String)"86", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childAdded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childRemoved");
        }
        String name = serverInfo.getName();
        Notification ntfyObj = new Notification("websphere.discovery.process.lost", this.getObjectName(), ntfySeqNum++);
        Properties props = new Properties();
        props.setProperty("processName", name);
        props.setProperty("nodeName", serverInfo.getNode());
        ntfyObj.setUserData(props);
        if (this.childType.equals("NodeAgent")) {
            name = serverInfo.getNode();
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.remove(name);
        }
        try {
            this.sendNotification(ntfyObj);
        }
        catch (MBeanException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.childRemoved", (String)"115", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childRemoved");
        }
    }

    public void parentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentAdded");
        }
        this.parent = serverInfo;
        String name = serverInfo.getName();
        String pid = RoutingTable.getInstance().getPid(name);
        Notification ntfyObj = new Notification("websphere.discovery.agent.found", this.getObjectName(), ntfySeqNum++);
        ntfyObj.setUserData(serverInfo);
        Tr.info(tc, "ADMD0023I", new Object[]{name, this.parentType, pid});
        try {
            this.sendNotification(ntfyObj);
        }
        catch (MBeanException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.parentAdded", (String)"109", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentAdded");
        }
    }

    public void parentRemoved(ServerInfo serverInfo) {
    }

    public void query(ServerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "query", info);
        }
        String sourceType = info.getRole();
        if (this.myType.equals("ManagedProcess") && sourceType.equals("NodeAgent")) {
            RoutingTable.getInstance().addParent(info);
            this.answerDiscovery(info);
        } else if (this.myType.equals("NodeAgent") && sourceType.equals("ManagedProcess")) {
            RoutingTable.getInstance().addChild(info);
            this.answerDiscovery(info);
        } else if (this.myType.equals("AdminAgent") && sourceType.equals("UnManagedProcess")) {
            RoutingTable.getInstance().addChild(info);
            this.answerDiscovery(info);
        } else if (this.myType.equals("UnManagedProcess") && sourceType.equals("AdminAgent")) {
            RoutingTable.getInstance().addParent(info);
            this.answerDiscovery(info);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "query");
        }
    }

    public void respond(ServerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "respond", info);
        }
        String sourceType = info.getRole();
        if (this.myType.equals("NodeAgent")) {
            if (sourceType.equals("ManagedProcess")) {
                RoutingTable.getInstance().addChild(info);
            }
        } else if (this.myType.equals("ManagedProcess")) {
            if (sourceType.equals("NodeAgent")) {
                RoutingTable.getInstance().addParent(info);
            }
        } else if (this.myType.equals("AdminAgent")) {
            if (sourceType.equals("UnManagedProcess")) {
                RoutingTable.getInstance().addChild(info);
            }
        } else if (this.myType.equals("UnManagedProcess") && sourceType.equals("AdminAgent")) {
            RoutingTable.getInstance().addParent(info);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "respond");
        }
    }

    private void answerDiscovery(ServerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "answerDiscovery " + info);
        }
        AdminClient client = null;
        try {
            client = info.getAdminClient();
        }
        catch (ConnectorException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.answerDiscovery", (String)"227", (Object)this);
            Tr.warning(tc, "ADMD0024W", info.getName());
        }
        if (client != null) {
            ObjectName discoveryMBean = null;
            ObjectName query = null;
            try {
                String name = info.getName();
                query = new ObjectName("*:*,type=Discovery,process=" + name);
            }
            catch (MalformedObjectNameException ex) {
                // empty catch block
            }
            try {
                Set s = client.queryNames(query, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "info passed to respond " + RoutingTable.getInstance().getOwnInfo());
                }
                if (s.iterator().hasNext()) {
                    discoveryMBean = (ObjectName)s.iterator().next();
                    client.invoke(discoveryMBean, "respond", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{ServerInfo.class.getName()});
                } else {
                    Tr.warning(tc, "ADMD0024W", info.getName());
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.answerDiscovery", (String)"259", (Object)this);
                Tr.warning(tc, "ADMD0024W", info.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "answerDiscovery");
        }
    }
}

