/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.management.connector.AdminServiceDelegator;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.ipc.IPCConnectorClient;
import com.ibm.ws.management.connector.soap.AdminServiceSMR;
import com.ibm.ws.management.connector.soap.SOAPConnection;
import com.ibm.ws.management.connector.soap.SOAPRequest;
import com.ibm.ws.management.connector.soap.SOAPResponse;
import com.ibm.ws.management.connector.soap.SOAPUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.security.auth.Subject;
import org.apache.soap.Constants;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.xml.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SOAPConnector {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPConnector.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private static AdminServiceDelegator targetObject = new AdminServiceDelegator();
    private static SOAPMappingRegistry smr = AdminServiceSMR.getInstance();
    private boolean securityEnabled = SecurityHelper.getHelper().isSecurityEnabled();
    private String profileKey = null;

    public SOAPConnector() {
    }

    public SOAPConnector(String profileKey) {
        this.profileKey = profileKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(SOAPConnection conn) throws HttpException, IOException {
        Stack currentStack2;
        Stack savedStack;
        boolean pushed;
        block45: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "service");
            }
            pushed = false;
            savedStack = null;
            boolean secPushed = false;
            try {
                String remoteVersion;
                Throwable faultSeed;
                boolean isInFault;
                Response resp;
                Call call;
                int status;
                SOAPContext resCtx;
                SOAPResponse response;
                SOAPRequest request;
                block44: {
                    savedStack = AdminContext.exportStack();
                    if (this.profileKey != AdminContext.peek()) {
                        pushed = AdminContext.push((String)this.profileKey);
                    }
                    secPushed = SecurityObjectLocator.getThreadLocal().pushResource(new SecurityConfigResource("SOAPConnector", "admin"));
                    request = conn.getSOAPRequest();
                    response = conn.getSOAPResponse();
                    SOAPContext reqCtx = new SOAPContext();
                    resCtx = new SOAPContext();
                    status = SOAPResponse.SC_OK;
                    call = null;
                    resp = null;
                    Header header = null;
                    isInFault = false;
                    faultSeed = null;
                    Subject authSubject = null;
                    remoteVersion = "1.0.0";
                    try {
                        call = SOAPUtils.extractSoapCall(request.getInputStream(), request.getContentLength(), request.getContentType(), reqCtx, smr);
                        header = call.getHeader();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Header: " + header);
                        }
                        if (header != null) {
                            JMXVersionValidation.setClientVersion(header.getAttribute(new QName("admin", "WASRemoteRuntimeVersion")));
                        } else {
                            JMXVersionValidation.setClientVersion("5");
                        }
                        if (this.securityEnabled) {
                            String enabled = null;
                            if (header != null) {
                                enabled = header.getAttribute(SOAPUtils.securityEnabled);
                            }
                            if (enabled != null) {
                                String username = null;
                                String password = null;
                                String loginMethod = null;
                                String token = null;
                                String subst = null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Security Enabled: " + new Boolean(enabled));
                                }
                                Vector vec = header.getHeaderEntries();
                                Enumeration e = vec.elements();
                                while (e.hasMoreElements()) {
                                    Element headerEntryEl = (Element)e.nextElement();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "nodeName", headerEntryEl.getNodeName());
                                    }
                                    NodeList children = headerEntryEl.getChildNodes();
                                    int numChildren = children.getLength();
                                    subst = null;
                                    for (int i = 0; i < numChildren; ++i) {
                                        if (headerEntryEl.getNodeName().equals("password")) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "node value", "*******");
                                            }
                                        } else if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "node value", children.item(i).getNodeValue());
                                        }
                                        subst = children.item(i).getNodeValue();
                                    }
                                    if (headerEntryEl.getNodeName().equals("username")) {
                                        username = subst;
                                        continue;
                                    }
                                    if (headerEntryEl.getNodeName().equals("password")) {
                                        password = subst;
                                        continue;
                                    }
                                    if (headerEntryEl.getNodeName().equals("LoginMethod")) {
                                        loginMethod = subst;
                                        continue;
                                    }
                                    if (!headerEntryEl.getNodeName().equals("token")) continue;
                                    token = subst;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "username: " + username);
                                }
                                if (loginMethod.equals("BasicAuth")) {
                                    if (username != null && password != null && username.length() > 0 && password.length() > 0) {
                                        authSubject = this.basicAuth(username, password);
                                    }
                                } else if (loginMethod.equals("TokenBased") && token != null && token.length() > 0) {
                                    authSubject = this.tokenBasedAuth(token);
                                }
                            }
                        }
                        this.checkURI(call);
                        remoteVersion = JMXVersionValidation.getRemoteVersion((RPCMessage)call);
                        resCtx.setProperty("JMXRemoteVersion", (Object)remoteVersion);
                        if (this.securityEnabled) {
                            SecurityHelper.resetContext();
                            if (authSubject != null) {
                                SecurityHelper.setReceivedSubject(authSubject);
                                SecurityHelper.pushInvocationSubject(authSubject);
                            }
                            resp = this.invoke(call, resCtx);
                        } else {
                            resp = this.invoke(call, resCtx);
                        }
                        resp.setHeader(JMXVersionValidation.getJmxVersionHeader(resp.getHeader(), remoteVersion));
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.service", (String)"212", (Object)this);
                        isInFault = true;
                        faultSeed = t;
                        if (!tc.isDebugEnabled()) break block44;
                        Tr.debug(tc, "Caught exception", t);
                    }
                }
                if (isInFault) {
                    Fault fault = new Fault(new SOAPException(Constants.FAULT_CODE_SERVER, faultSeed.getMessage()));
                    try {
                        fault.setFaultString(SOAPUtils.convertObjectToString(faultSeed, remoteVersion));
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.service", (String)"228", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "error occurs when serializing the exception", ex);
                        }
                        throw new HttpException(SOAPResponse.SC_INTERNAL_SERVER_ERROR);
                    }
                    String requestURI = request.getURI();
                    String faultActorURI = null;
                    faultActorURI = requestURI != null && (requestURI.indexOf("<SCRIPT>") != -1 || requestURI.indexOf("<script>") != -1) ? "some_script" : SOAPUtils.encodeDataString(request.getURI());
                    fault.setFaultActorURI(faultActorURI);
                    status = SOAPResponse.SC_INTERNAL_SERVER_ERROR;
                    String respEncStyle = null;
                    if (call != null) {
                        respEncStyle = call.getEncodingStyleURI();
                    }
                    if (respEncStyle == null) {
                        respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
                    }
                    resCtx = new SOAPContext();
                    resp = new Response(null, null, fault, null, null, respEncStyle, resCtx);
                    resp.setHeader(JMXVersionValidation.getJmxVersionHeader(resp.getHeader(), remoteVersion));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the response object = " + resp);
                }
                response.writeSOAPResponse(resp, resCtx, smr, status);
                Object var30_31 = null;
                if (!secPushed) break block45;
            }
            catch (Throwable throwable) {
                Stack currentStack2;
                Object var30_32 = null;
                if (secPushed) {
                    SecurityObjectLocator.getThreadLocal().popResource();
                }
                if (pushed) {
                    AdminContext.pop();
                }
                if (savedStack != null && !savedStack.equals(currentStack2 = AdminContext.exportStack())) {
                    AdminContext.importStack((Stack)savedStack);
                    Tr.error(tc, "AdminContext Stack incorrectly used in SOAPconnector", new Object[]{savedStack, currentStack2});
                    Exception ex = new Exception("AdminContext Stack incorrectly used in SOAPconnector");
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"437", (Object)this);
                }
                throw throwable;
            }
            SecurityObjectLocator.getThreadLocal().popResource();
        }
        if (pushed) {
            AdminContext.pop();
        }
        if (savedStack != null && !savedStack.equals(currentStack2 = AdminContext.exportStack())) {
            AdminContext.importStack((Stack)savedStack);
            Tr.error(tc, "AdminContext Stack incorrectly used in SOAPconnector", new Object[]{savedStack, currentStack2});
            Exception ex = new Exception("AdminContext Stack incorrectly used in SOAPconnector");
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"437", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "service");
        }
    }

    private void checkURI(Call call) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkURI", call);
        }
        String uri = call.getTargetObjectURI();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Soap Call URI: " + uri);
        }
        if (uri == null || !uri.equalsIgnoreCase("urn:AdminService")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkURI", call);
            }
            throw new AdminException(nls.getString("ADMC0005E", "SOAP URI Violation"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkURI", call);
        }
    }

    private Response invoke(Call call, SOAPContext resCtx) throws AdminException, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", call);
        }
        String respEncStyle = call.getEncodingStyleURI();
        Vector params = call.getParams();
        Object[] args = null;
        Class[] argTypes = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Method Name: " + call.getMethodName());
        }
        if (params != null) {
            int paramsCount = params.size();
            args = new Object[paramsCount];
            argTypes = new Class[paramsCount];
            for (int i = 0; i < paramsCount; ++i) {
                Parameter param = (Parameter)params.elementAt(i);
                args[i] = param.getValue();
                argTypes[i] = param.getType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parameter: " + args[i] + "(type: " + argTypes[i] + ")");
                }
                if (respEncStyle != null) continue;
                respEncStyle = param.getEncodingStyleURI();
            }
        }
        if (respEncStyle == null) {
            respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        Bean result = null;
        try {
            Method m = null;
            targetObject = new AdminServiceDelegator();
            m = MethodUtils.getMethod((Object)targetObject, (String)call.getMethodName(), (Class[])argTypes);
            result = new Bean(m.getReturnType(), m.invoke((Object)targetObject, args));
        }
        catch (InvocationTargetException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"351", (Object)this);
            Throwable t = e.getTargetException();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke");
            }
            throw t;
        }
        catch (NoSuchMethodException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"358", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke");
            }
            throw new AdminException(e, nls.getString("ADMC0007E"));
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"365", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke");
            }
            throw new AdminException(e, nls.getString("ADMC0007E"));
        }
        Parameter ret = null;
        if (result.type != Void.TYPE) {
            if (result.value != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "return object type = " + result.value.getClass() + "; value = " + result.value);
                }
                ret = new Parameter(RPCConstants.ELEM_RETURN, result.value.getClass(), result.value, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "return object type = " + result.type + "; value = " + result.value);
                }
                ret = new Parameter(RPCConstants.ELEM_RETURN, result.type, result.value, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return new Response(call.getTargetObjectURI(), call.getMethodName(), ret, null, null, respEncStyle, resCtx);
    }

    private Subject basicAuth(String username, String password) {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "basicAuth");
            }
            subject = null;
            try {
                if (username.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                    username = RealmSecurityName.getSecurityName((String)username);
                }
                subject = SecurityHelper.authenticate(username, password);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"406", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "unable to authenticate incoming request", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "basicAuth");
        }
        return subject;
    }

    private Subject tokenBasedAuth(String token) throws Exception {
        Subject subject;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "tokenBasedAuth");
            }
            byte[] bytes = Base64.decode((String)token);
            WSSecurityContext ctx = SecurityHelper.getHelper().getWSSecurityContext();
            subject = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attemping to extract subject from a V6+ token.");
                }
                WSSecurityContextResult result = ctx.acceptSecContext(bytes);
                subject = result.getSubject();
            }
            catch (Exception ex) {
                if (IPCConnectorClient.isCertPathValidatorException(ex)) {
                    throw ex;
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to extract subject from V6+ token, attempting to extract using the pre-V6 format.");
                    }
                    subject = SecurityHelper.validate(bytes);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to extract subject using the pre-V6 format.");
                    }
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.tokenBasedAuth", (String)"415", (Object)this);
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "unable to authenticate incoming request", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "tokenBasedAuth");
        }
        return subject;
    }
}

