/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.websphere.pmi.stat.EJBStatsImpl;
import com.ibm.websphere.pmi.stat.EntityBeanStatsImpl;
import com.ibm.websphere.pmi.stat.JCAConnectionPoolStatsImpl;
import com.ibm.websphere.pmi.stat.JCAConnectionStatsImpl;
import com.ibm.websphere.pmi.stat.JCAStatsImpl;
import com.ibm.websphere.pmi.stat.JDBCConnectionPoolStatsImpl;
import com.ibm.websphere.pmi.stat.JDBCConnectionStatsImpl;
import com.ibm.websphere.pmi.stat.JDBCStatsImpl;
import com.ibm.websphere.pmi.stat.JTAStatsImpl;
import com.ibm.websphere.pmi.stat.JVMStatsImpl;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.MessageBeanStatsImpl;
import com.ibm.websphere.pmi.stat.ServletStatsImpl;
import com.ibm.websphere.pmi.stat.SessionBeanStatsImpl;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatefulSessionBeanStatsImpl;
import com.ibm.websphere.pmi.stat.StatelessSessionBeanStatsImpl;
import com.ibm.websphere.pmi.stat.StatsImpl;
import com.ibm.ws.management.connector.interop.JMXTransformException;
import com.ibm.ws.management.event.FilterElement;
import com.ibm.ws.management.event.NotificationInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.Descriptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidApplicationException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.StringValueExp;
import javax.management.ValueExp;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.XMLParseException;
import javax.management.monitor.MonitorSettingException;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleInfoException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;

public class JMXTransform {
    public static Hashtable transformers = new Hashtable();
    public static String objectString;
    private int level = 0;

    public Object transform(Object tmx4jObject) throws JMXTransformException {
        Object mx4jObject = null;
        if (tmx4jObject == null) {
            return null;
        }
        ++this.level;
        Class<?> tmx4jObjectClass = tmx4jObject.getClass();
        String name = tmx4jObjectClass.getName();
        String transformer = (String)transformers.get(name);
        mx4jObject = transformer != null ? JMXTransform.invoke(this, transformer, new Class[]{Object.class}, new Object[]{tmx4jObject}) : (name.startsWith("[L") && tmx4jObjectClass.isArray() ? this.transformObjectArray(tmx4jObject) : tmx4jObject);
        if (mx4jObject == null) {
            --this.level;
            throw new JMXTransformException("Tranformation failed for " + name);
        }
        --this.level;
        return mx4jObject;
    }

    private Object transformArray(Object[] tmx4jObject) throws JMXTransformException {
        Object[] mx4jObject = null;
        String name = tmx4jObject.getClass().getName();
        mx4jObject = name.indexOf("Ljava.lang.Object") > 0 || name.indexOf("Ljavax.management.") > 0 ? this.transformObjectArray(tmx4jObject) : tmx4jObject;
        return mx4jObject;
    }

    private Object[] transformObjectArray(Object[] tmx4jObject) throws JMXTransformException {
        try {
            String memberClassName = tmx4jObject.getClass().getComponentType().getName();
            Class<?> memberClass = Class.forName(memberClassName);
            Object[] mx4jObject = (Object[])Array.newInstance(memberClass, tmx4jObject.length);
            for (int i = 0; i < tmx4jObject.length; ++i) {
                Object obj = tmx4jObject[i];
                Object newObj = this.transform(obj);
                Array.set(mx4jObject, i, newObj);
            }
            return mx4jObject;
        }
        catch (Throwable ex) {
            throw new JMXTransformException("unable to transform array", ex);
        }
    }

    private static Object invoke(Object obj, String methodName) throws JMXTransformException {
        Class[] paramTypes = new Class[]{};
        Object[] params = new Object[]{};
        return JMXTransform.invoke(obj, methodName, paramTypes, params);
    }

    private static Object invoke(Object obj, String methodName, Class[] paramTypes, Object[] params) throws JMXTransformException {
        Object object = null;
        try {
            Class<?> cls = obj.getClass();
            Method method = cls.getMethod(methodName, paramTypes);
            object = method.invoke(obj, params);
        }
        catch (Exception e) {
            if (e instanceof JMXTransformException) {
                throw (JMXTransformException)e;
            }
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return object;
    }

    public Object AttributeTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        Object value = this.transform(JMXTransform.invoke(tmx4jObject, "getValue"));
        return new Attribute(name, value);
    }

    public Object AttributeChangeNotificationTransformer(Object tmx4jObject) throws JMXTransformException {
        Object source = JMXTransform.invoke(tmx4jObject, "getSource");
        Long sequenceNumber = (Long)JMXTransform.invoke(tmx4jObject, "getSequenceNumber");
        Long timeStamp = (Long)JMXTransform.invoke(tmx4jObject, "getTimeStamp");
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        String attributeName = (String)JMXTransform.invoke(tmx4jObject, "getAttributeName");
        String attributeType = (String)JMXTransform.invoke(tmx4jObject, "getAttributeType");
        Object oldValue = JMXTransform.invoke(tmx4jObject, "getOldValue");
        Object newValue = JMXTransform.invoke(tmx4jObject, "getNewValue");
        AttributeChangeNotification mx4jObject = new AttributeChangeNotification(source, sequenceNumber, timeStamp, message, attributeName, attributeType, oldValue, newValue);
        Object userData = JMXTransform.invoke(tmx4jObject, "getUserData");
        userData = this.transform(userData);
        mx4jObject.setUserData(userData);
        return mx4jObject;
    }

    public Object AttributeChangeNotificationFilterTransformer(Object tmx4jObject) throws JMXTransformException {
        AttributeChangeNotificationFilter mx4jObject = null;
        Vector attributes = (Vector)JMXTransform.invoke(tmx4jObject, "getEnabledAttributes");
        mx4jObject = new AttributeChangeNotificationFilter();
        Enumeration elements = attributes.elements();
        while (elements.hasMoreElements()) {
            mx4jObject.enableAttribute((String)elements.nextElement());
        }
        return mx4jObject;
    }

    public Object AttributeListTransformer(Object tmx4jObject) throws JMXTransformException {
        AttributeList mx4jObject = null;
        int size = (Integer)JMXTransform.invoke(tmx4jObject, "size");
        Iterator iterator = (Iterator)JMXTransform.invoke(tmx4jObject, "iterator");
        try {
            AttributeList attributes = new AttributeList(size);
            if (iterator != null) {
                for (int i = 0; i < size; ++i) {
                    Object object = iterator.next();
                    String objectName = object.getClass().getName();
                    attributes.add((Attribute)this.transform(object));
                }
            }
            mx4jObject = attributes;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return mx4jObject;
    }

    public Object AttributeValueExpTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getAttributeName");
        return new AttributeValueExp(name);
    }

    public Object DescriptorSupportTransformer(Object tmx4jObject) throws JMXTransformException {
        String[] names = (String[])JMXTransform.invoke(tmx4jObject, "getFieldNames");
        Class[] paramTypes = new Class[]{String[].class};
        Object[] params = new Object[]{names};
        Object[] values = (Object[])JMXTransform.invoke(tmx4jObject, "getFieldValues", paramTypes, params);
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.transform(values[i]);
        }
        DescriptorSupport object = new DescriptorSupport(names, values);
        return object;
    }

    public Object NotificationInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        Object name = JMXTransform.invoke(tmx4jObject, "getName");
        Object filter = JMXTransform.invoke(tmx4jObject, "getFilter");
        ObjectName xformedObjName = (ObjectName)this.transform(name);
        NotificationFilter xformedFilter = (NotificationFilter)this.transform(filter);
        NotificationInfo object = new NotificationInfo(xformedObjName, xformedFilter);
        return object;
    }

    public Object MBeanAttributeInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String type = (String)JMXTransform.invoke(tmx4jObject, "getType");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        boolean transformable = (Boolean)JMXTransform.invoke(tmx4jObject, "isReadable");
        boolean writable = (Boolean)JMXTransform.invoke(tmx4jObject, "isWritable");
        boolean is = (Boolean)JMXTransform.invoke(tmx4jObject, "isIs");
        return new MBeanAttributeInfo(name, type, description, transformable, writable, is);
    }

    public Object MBeanConstructorInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        Object[] mbpi = (Object[])JMXTransform.invoke(tmx4jObject, "getSignature");
        MBeanParameterInfo[] signature = new MBeanParameterInfo[mbpi.length];
        if (mbpi.length > 0) {
            for (int i = 0; i < mbpi.length; ++i) {
                signature[i] = (MBeanParameterInfo)this.transform(mbpi[i]);
            }
        }
        return new MBeanConstructorInfo(name, description, signature);
    }

    public Object MBeanFeatureInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        return new MBeanFeatureInfo(name, description);
    }

    public Object MBeanInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String className = (String)JMXTransform.invoke(tmx4jObject, "getClassName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        Object[] mbai = (Object[])JMXTransform.invoke(tmx4jObject, "getAttributes");
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{};
        if (mbai != null) {
            attributes = new MBeanAttributeInfo[mbai.length];
            for (int i = 0; i < mbai.length; ++i) {
                attributes[i] = (MBeanAttributeInfo)this.transform(mbai[i]);
            }
        }
        Object[] mbci = (Object[])JMXTransform.invoke(tmx4jObject, "getConstructors");
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{};
        if (mbci != null) {
            constructors = new MBeanConstructorInfo[mbci.length];
            for (int i = 0; i < mbci.length; ++i) {
                constructors[i] = (MBeanConstructorInfo)this.transform(mbci[i]);
            }
        }
        Object[] mboi = (Object[])JMXTransform.invoke(tmx4jObject, "getOperations");
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{};
        if (mboi != null) {
            operations = new MBeanOperationInfo[mboi.length];
            for (int i = 0; i < mboi.length; ++i) {
                operations[i] = (MBeanOperationInfo)this.transform(mboi[i]);
            }
        }
        Object[] mbni = (Object[])JMXTransform.invoke(tmx4jObject, "getNotifications");
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{};
        if (mbni != null) {
            notifications = new MBeanNotificationInfo[mbni.length];
            for (int i = 0; i < mbni.length; ++i) {
                notifications[i] = (MBeanNotificationInfo)this.transform(mbni[i]);
            }
        }
        return new MBeanInfo(className, description, attributes, constructors, operations, notifications);
    }

    public Object MBeanOperationInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        Object[] mbpi = (Object[])JMXTransform.invoke(tmx4jObject, "getSignature");
        MBeanParameterInfo[] signature = new MBeanParameterInfo[mbpi.length];
        if (mbpi != null) {
            for (int i = 0; i < mbpi.length; ++i) {
                signature[i] = (MBeanParameterInfo)this.transform(mbpi[i]);
            }
        }
        String returnType = (String)JMXTransform.invoke(tmx4jObject, "getReturnType");
        int impact = (Integer)JMXTransform.invoke(tmx4jObject, "getImpact");
        return new MBeanOperationInfo(name, description, signature, returnType, impact);
    }

    public Object MBeanParameterInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String type = (String)JMXTransform.invoke(tmx4jObject, "getType");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        return new MBeanParameterInfo(name, type, description);
    }

    public Object ModelMBeanInfoSupportTransformer(Object tmx4jObject) throws JMXTransformException {
        String className = (String)JMXTransform.invoke(tmx4jObject, "getClassName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        Object[] mbai = (Object[])JMXTransform.invoke(tmx4jObject, "getAttributes");
        ModelMBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[]{};
        if (mbai != null) {
            attributes = new ModelMBeanAttributeInfo[mbai.length];
            for (int i = 0; i < mbai.length; ++i) {
                attributes[i] = (ModelMBeanAttributeInfo)this.transform(mbai[i]);
            }
        }
        Object[] mbci = (Object[])JMXTransform.invoke(tmx4jObject, "getConstructors");
        ModelMBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[]{};
        if (mbci != null) {
            constructors = new ModelMBeanConstructorInfo[mbci.length];
            for (int i = 0; i < mbci.length; ++i) {
                constructors[i] = (ModelMBeanConstructorInfo)this.transform(mbci[i]);
            }
        }
        Object[] mboi = (Object[])JMXTransform.invoke(tmx4jObject, "getOperations");
        ModelMBeanOperationInfo[] operations = new ModelMBeanOperationInfo[]{};
        if (mboi != null) {
            operations = new ModelMBeanOperationInfo[mboi.length];
            for (int i = 0; i < mboi.length; ++i) {
                operations[i] = (ModelMBeanOperationInfo)this.transform(mboi[i]);
            }
        }
        Object[] mbni = (Object[])JMXTransform.invoke(tmx4jObject, "getNotifications");
        ModelMBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[]{};
        if (mbni != null) {
            notifications = new ModelMBeanNotificationInfo[mbni.length];
            for (int i = 0; i < mbni.length; ++i) {
                notifications[i] = (ModelMBeanNotificationInfo)this.transform(mbni[i]);
            }
        }
        Object des = JMXTransform.invoke(tmx4jObject, "getMBeanDescriptor");
        Descriptor descriptor = (Descriptor)this.transform(des);
        return new ModelMBeanInfoSupport(className, description, attributes, constructors, operations, notifications, descriptor);
    }

    public Object ModelMBeanAttributeInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String type = (String)JMXTransform.invoke(tmx4jObject, "getType");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        boolean transformable = (Boolean)JMXTransform.invoke(tmx4jObject, "isReadable");
        boolean writable = (Boolean)JMXTransform.invoke(tmx4jObject, "isWritable");
        boolean is = (Boolean)JMXTransform.invoke(tmx4jObject, "isIs");
        Object des = JMXTransform.invoke(tmx4jObject, "getDescriptor");
        Descriptor descriptor = (Descriptor)this.transform(des);
        return new ModelMBeanAttributeInfo(name, type, description, transformable, writable, is, descriptor);
    }

    public Object ModelMBeanConstructorInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        Object[] mbpi = (Object[])JMXTransform.invoke(tmx4jObject, "getSignature");
        MBeanParameterInfo[] signature = new MBeanParameterInfo[mbpi.length];
        if (mbpi != null) {
            for (int i = 0; i < mbpi.length; ++i) {
                signature[i] = (MBeanParameterInfo)this.transform(mbpi[i]);
            }
        }
        Object des = JMXTransform.invoke(tmx4jObject, "getDescriptor");
        Descriptor descriptor = (Descriptor)this.transform(des);
        return new ModelMBeanConstructorInfo(name, description, signature, descriptor);
    }

    public Object ModelMBeanOperationInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        Object[] mbpi = (Object[])JMXTransform.invoke(tmx4jObject, "getSignature");
        MBeanParameterInfo[] signature = new MBeanParameterInfo[]{};
        if (mbpi != null && mbpi.length > 0) {
            signature = new MBeanParameterInfo[mbpi.length];
            for (int i = 0; i < mbpi.length; ++i) {
                signature[i] = (MBeanParameterInfo)this.transform(mbpi[i]);
            }
        }
        String returnType = (String)JMXTransform.invoke(tmx4jObject, "getReturnType");
        int impact = (Integer)JMXTransform.invoke(tmx4jObject, "getImpact");
        Object des = JMXTransform.invoke(tmx4jObject, "getDescriptor");
        Descriptor descriptor = (Descriptor)this.transform(des);
        return new ModelMBeanOperationInfo(name, description, signature, returnType, impact, descriptor);
    }

    public Object ModelMBeanNotificationInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String[] types = (String[])JMXTransform.invoke(tmx4jObject, "getNotifTypes");
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        Object des = JMXTransform.invoke(tmx4jObject, "getDescriptor");
        Descriptor descriptor = (Descriptor)this.transform(des);
        return new ModelMBeanNotificationInfo(types, name, description, descriptor);
    }

    public Object MBeanNotificationInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        String[] types = (String[])JMXTransform.invoke(tmx4jObject, "getNotifTypes");
        String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
        String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
        return new MBeanNotificationInfo(types, name, description);
    }

    public Object MBeanServerNotificationTransformer(Object tmx4jObject) throws JMXTransformException {
        String type = (String)JMXTransform.invoke(tmx4jObject, "getType");
        Object source = JMXTransform.invoke(tmx4jObject, "getSource");
        source = this.transform(source);
        long sequenceNumber = (Long)JMXTransform.invoke(tmx4jObject, "getSequenceNumber");
        long timeStamp = (Long)JMXTransform.invoke(tmx4jObject, "getTimeStamp");
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        Object objName = JMXTransform.invoke(tmx4jObject, "getMBeanName");
        ObjectName objectName = (ObjectName)this.transform(objName);
        MBeanServerNotification notification = new MBeanServerNotification(type, source, sequenceNumber, objectName);
        Object userData = JMXTransform.invoke(tmx4jObject, "getUserData");
        userData = this.transform(userData);
        notification.setUserData(userData);
        return notification;
    }

    public Object NotificationTransformer(Object tmx4jObject) throws JMXTransformException {
        String type = (String)JMXTransform.invoke(tmx4jObject, "getType");
        Object object = JMXTransform.invoke(tmx4jObject, "getSource");
        object = this.transform(object);
        long sequenceNumber = (Long)JMXTransform.invoke(tmx4jObject, "getSequenceNumber");
        long timeStamp = (Long)JMXTransform.invoke(tmx4jObject, "getTimeStamp");
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        Notification notification = new Notification(type, object, sequenceNumber, timeStamp, message);
        Object userData = JMXTransform.invoke(tmx4jObject, "getUserData");
        userData = this.transform(userData);
        notification.setUserData(userData);
        return notification;
    }

    public Object NotificationFilterSupportTransformer(Object tmx4jObject) throws JMXTransformException {
        Vector types = (Vector)JMXTransform.invoke(tmx4jObject, "getEnabledTypes");
        NotificationFilterSupport notification = new NotificationFilterSupport();
        Enumeration list = types.elements();
        while (list.hasMoreElements()) {
            notification.enableType((String)list.nextElement());
        }
        return notification;
    }

    public Object ObjectInstanceTransformer(Object tmx4jObject) throws JMXTransformException {
        ObjectName objectName = (ObjectName)this.transform(JMXTransform.invoke(tmx4jObject, "getObjectName"));
        String className = (String)JMXTransform.invoke(tmx4jObject, "getClassName");
        return new ObjectInstance(objectName, className);
    }

    public Object ObjectNameTransformer(Object tmx4jObject) throws JMXTransformException {
        ObjectName mx4jObject = null;
        try {
            String canonicalName = (String)JMXTransform.invoke(tmx4jObject, "getCanonicalName");
            mx4jObject = new ObjectName(canonicalName);
        }
        catch (Exception e) {
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return mx4jObject;
    }

    public Object RelationTypeSupportTransformer(Object tmx4jObject) throws JMXTransformException {
        RelationTypeSupport mx4jObject = null;
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getRelationTypeName");
            List list = (List)JMXTransform.invoke(tmx4jObject, "getRoleInfos");
            RoleInfo[] roleInfos = new RoleInfo[list.size()];
            if (list != null) {
                Iterator iterator = list.iterator();
                for (int i = 0; i < list.size(); ++i) {
                    roleInfos[i] = (RoleInfo)this.transform(iterator.next());
                }
            }
            mx4jObject = new RelationTypeSupport(name, roleInfos);
        }
        catch (Exception e) {
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return mx4jObject;
    }

    public Object RoleTransformer(Object tmx4jObject) throws JMXTransformException {
        Role mx4jObject = null;
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getRoleName");
            List list = (List)JMXTransform.invoke(tmx4jObject, "getRoleValue");
            ArrayList<Object> roles = new ArrayList<Object>();
            if (list != null) {
                for (Object role : list) {
                    if (role == null) continue;
                    roles.add(this.transform(role));
                }
            }
            mx4jObject = new Role(name, roles);
        }
        catch (Exception e) {
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return mx4jObject;
    }

    public Object RoleInfoTransformer(Object tmx4jObject) throws JMXTransformException {
        RoleInfo mx4jObject = null;
        try {
            String roleName = (String)JMXTransform.invoke(tmx4jObject, "getName");
            String mbeanClassName = (String)JMXTransform.invoke(tmx4jObject, "getRefMBeanClassName");
            boolean isReadable = (Boolean)JMXTransform.invoke(tmx4jObject, "isReadable");
            boolean isWritable = (Boolean)JMXTransform.invoke(tmx4jObject, "isWritable");
            int minNumber = (Integer)JMXTransform.invoke(tmx4jObject, "getMinDegree");
            int maxNumber = (Integer)JMXTransform.invoke(tmx4jObject, "getMaxDegree");
            String description = (String)JMXTransform.invoke(tmx4jObject, "getDescription");
            mx4jObject = new RoleInfo(roleName, mbeanClassName, isReadable, isWritable, minNumber, maxNumber, description);
        }
        catch (Exception e) {
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return mx4jObject;
    }

    public Object RoleListTransformer(Object tmx4jObject) throws JMXTransformException {
        RoleList mx4jObject = null;
        try {
            List list = (List)tmx4jObject;
            ArrayList<Object> roles = new ArrayList<Object>();
            if (list != null) {
                for (Object roleUnresolved : list) {
                    if (roleUnresolved == null) continue;
                    roles.add(this.transform(roleUnresolved));
                }
            }
            mx4jObject = new RoleList(roles);
        }
        catch (Exception e) {
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return mx4jObject;
    }

    public Object RoleResultTransformer(Object tmx4jObject) throws JMXTransformException {
        RoleResult mx4jObject = null;
        try {
            RoleList roleList = (RoleList)this.transform(JMXTransform.invoke(tmx4jObject, "getRoles"));
            RoleUnresolvedList unresolvedList = (RoleUnresolvedList)this.transform(JMXTransform.invoke(tmx4jObject, "getRolesUnresolved"));
            mx4jObject = new RoleResult(roleList, unresolvedList);
        }
        catch (Exception e) {
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return mx4jObject;
    }

    public Object RoleUnresolvedTransformer(Object tmx4jObject) throws JMXTransformException {
        RoleUnresolved mx4jObject = null;
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getRoleName");
            List list = (List)JMXTransform.invoke(tmx4jObject, "getRoleValue");
            int problemType = (Integer)JMXTransform.invoke(tmx4jObject, "getProblemType");
            ArrayList<Object> roles = new ArrayList<Object>();
            if (list != null) {
                for (Object roleUnresolved : list) {
                    if (roleUnresolved == null) continue;
                    roles.add(this.transform(roleUnresolved));
                }
            }
            mx4jObject = new RoleUnresolved(name, roles, problemType);
        }
        catch (Exception e) {
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return mx4jObject;
    }

    public Object RoleUnresolvedListTransformer(Object tmx4jObject) throws JMXTransformException {
        RoleUnresolvedList mx4jObject = null;
        try {
            List list = (List)tmx4jObject;
            ArrayList<Object> roles = new ArrayList<Object>();
            if (list != null) {
                for (Object roleUnresolved : list) {
                    if (roleUnresolved == null) continue;
                    roles.add(this.transform(roleUnresolved));
                }
            }
            mx4jObject = new RoleUnresolvedList(roles);
        }
        catch (Exception e) {
            throw new JMXTransformException(e.getLocalizedMessage(), e);
        }
        return mx4jObject;
    }

    public Object StringValueExpTransformer(Object tmx4jObject) throws JMXTransformException {
        String name = (String)JMXTransform.invoke(tmx4jObject, "getValue");
        return new StringValueExp(name);
    }

    public Object FilterElementTransformer(Object tmx4jObject) throws JMXTransformException {
        Object id = JMXTransform.invoke(tmx4jObject, "getListenerId");
        Object notificationInfo = JMXTransform.invoke(tmx4jObject, "getInfo");
        notificationInfo = this.transform(notificationInfo);
        NotificationInfo newNotificationInfo = (NotificationInfo)notificationInfo;
        FilterElement obj = new FilterElement((int)((Integer)id), newNotificationInfo);
        return obj;
    }

    public Object AppNotificationFilterTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String appName = (String)JMXTransform.invoke(tmx4jObject, "getAppName");
            String relevantType = (String)JMXTransform.invoke(tmx4jObject, "getRelevantType");
            Class<?> cls = Class.forName("com.ibm.ws.scripting.AppNotificationFilter");
            Constructor<?> constructor = cls.getConstructor(String.class, String.class);
            Object obj = constructor.newInstance(appName, relevantType);
            return obj;
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object MBeanStatDescriptorTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            Object o1 = JMXTransform.invoke(tmx4jObject, "getObjectName");
            Object o2 = JMXTransform.invoke(tmx4jObject, "getStatDescriptor");
            ObjectName on = (ObjectName)this.transform(o1);
            StatDescriptor sd = (StatDescriptor)this.transform(o2);
            return new MBeanStatDescriptor(on, sd);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object StatDescriptorTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String[] path = (String[])JMXTransform.invoke(tmx4jObject, "getPath");
            int dataId = (Integer)JMXTransform.invoke(tmx4jObject, "getDataId");
            return new StatDescriptor(path, dataId);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object MBeanLevelSpecTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            Object o1 = JMXTransform.invoke(tmx4jObject, "getObjectName");
            Object o2 = JMXTransform.invoke(tmx4jObject, "getStatDescriptor");
            ObjectName on = (ObjectName)this.transform(o1);
            StatDescriptor sd = (StatDescriptor)this.transform(o2);
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            return new MBeanLevelSpec(on, sd, level);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object StatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            String st = (String)JMXTransform.invoke(tmx4jObject, "getStatsType");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new StatsImpl(st, name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object JCAConnectionStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            JCAConnectionStatsImpl jca = new JCAConnectionStatsImpl(name, type, level, dm, sc);
            Object obj = JMXTransform.invoke(tmx4jObject, "getConnectionFactory");
            ObjectName on = (ObjectName)this.transform(obj);
            jca.setConnectionFactory(on);
            obj = JMXTransform.invoke(tmx4jObject, "getManagedConnectionFactory");
            on = (ObjectName)this.transform(obj);
            jca.setManagedConnectionFactory(on);
            return jca;
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object JDBCConnectionStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            JDBCConnectionStatsImpl jdbc = new JDBCConnectionStatsImpl(name, type, level, dm, sc);
            Object obj = JMXTransform.invoke(tmx4jObject, "getJdbcDataSource");
            ObjectName on = (ObjectName)this.transform(obj);
            jdbc.setJdbcDataSource(on);
            return jdbc;
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object JCAConnectionPoolStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            JCAConnectionPoolStatsImpl jca = new JCAConnectionPoolStatsImpl(name, type, level, dm, sc);
            Object obj = JMXTransform.invoke(tmx4jObject, "getConnectionFactory");
            ObjectName on = (ObjectName)this.transform(obj);
            jca.setConnectionFactory(on);
            obj = JMXTransform.invoke(tmx4jObject, "getManagedConnectionFactory");
            on = (ObjectName)this.transform(obj);
            jca.setManagedConnectionFactory(on);
            return jca;
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object JDBCConnectionPoolStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            JDBCConnectionPoolStatsImpl jdbc = new JDBCConnectionPoolStatsImpl(name, type, level, dm, sc);
            Object obj = JMXTransform.invoke(tmx4jObject, "getJdbcDataSource");
            ObjectName on = (ObjectName)this.transform(obj);
            jdbc.setJdbcDataSource(on);
            return jdbc;
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object JCAStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new JCAStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object JDBCStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new JDBCStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object JVMStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new JVMStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object JTAStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new JTAStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object ServletStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new ServletStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object EJBStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new EJBStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object EntityBeanStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new EntityBeanStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object MessageBeanStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new MessageBeanStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object SessionBeanStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new SessionBeanStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object StatefulSessionBeanStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new StatefulSessionBeanStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object StatelessSessionBeanStatsImplTransformer(Object tmx4jObject) throws JMXTransformException {
        try {
            String name = (String)JMXTransform.invoke(tmx4jObject, "getName");
            int type = (Integer)JMXTransform.invoke(tmx4jObject, "getType");
            int level = (Integer)JMXTransform.invoke(tmx4jObject, "getLevel");
            ArrayList dm = (ArrayList)JMXTransform.invoke(tmx4jObject, "dataMembers");
            ArrayList sc = (ArrayList)JMXTransform.invoke(tmx4jObject, "subCollections");
            return new StatelessSessionBeanStatsImpl(name, type, level, dm, sc);
        }
        catch (Throwable ex) {
            throw new JMXTransformException(ex.getLocalizedMessage(), ex);
        }
    }

    public Object AttributeNotFoundExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        AttributeNotFoundException jmxException = new AttributeNotFoundException(message);
        return jmxException;
    }

    public Object BadAttributeValueExpExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "toString");
        BadAttributeValueExpException jmxException = message.startsWith("The value in argument") ? new BadAttributeValueExpException((Object)null) : new BadAttributeValueExpException((Object)message);
        return jmxException;
    }

    public Object BadBinaryOpValueExpExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        Object valueExp = JMXTransform.invoke(tmx4jObject, "getExp");
        ValueExp newValueExp = (ValueExp)this.transform(valueExp);
        BadBinaryOpValueExpException jmxException = new BadBinaryOpValueExpException(newValueExp);
        return jmxException;
    }

    public Object BadStringOperationExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String op = (String)JMXTransform.invoke(tmx4jObject, "toString");
        BadStringOperationException jmxException = op == null ? new BadStringOperationException(null) : new BadStringOperationException(op);
        return jmxException;
    }

    public Object InstanceAlreadyExistsExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InstanceAlreadyExistsException jmxException = new InstanceAlreadyExistsException(message);
        return jmxException;
    }

    public Object InstanceNotFoundExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InstanceNotFoundException jmxException = new InstanceNotFoundException(message);
        return jmxException;
    }

    public Object IntrospectionExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        IntrospectionException jmxException = new IntrospectionException(message);
        return jmxException;
    }

    public Object InvalidApplicationExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "toString");
        InvalidApplicationException jmxException = message.startsWith("The value in argument") ? new InvalidApplicationException((Object)null) : new InvalidApplicationException((Object)message);
        return jmxException;
    }

    public Object InvalidAttributeValueExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InvalidAttributeValueException jmxException = new InvalidAttributeValueException(message);
        return jmxException;
    }

    public Object JMRuntimeExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        JMRuntimeException jmxException = new JMRuntimeException(message);
        return jmxException;
    }

    public Object ListenerNotFoundExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        ListenerNotFoundException jmxException = new ListenerNotFoundException(message);
        return jmxException;
    }

    public Object MalformedObjectNameExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        MalformedObjectNameException jmxException = new MalformedObjectNameException(message);
        return jmxException;
    }

    public Object JMExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        JMException jmxException = new JMException(message);
        return jmxException;
    }

    public Object MBeanExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String msg = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        Object targetEx = JMXTransform.invoke(tmx4jObject, "getTargetException");
        Exception newTargetEx = (Exception)this.transform(targetEx);
        MBeanException newEx = new MBeanException(newTargetEx, msg);
        return newEx;
    }

    public Object MBeanRegistrationExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String msg = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        Object targetEx = JMXTransform.invoke(tmx4jObject, "getTargetException");
        Exception newTargetEx = (Exception)this.transform(targetEx);
        MBeanRegistrationException newEx = new MBeanRegistrationException(newTargetEx, msg);
        return newEx;
    }

    public Object NotCompliantMBeanExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        NotCompliantMBeanException jmxException = new NotCompliantMBeanException(message);
        return jmxException;
    }

    public Object OperationsExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        OperationsException jmxException = new OperationsException(message);
        return jmxException;
    }

    public Object ReflectionExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String msg = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        Object targetEx = JMXTransform.invoke(tmx4jObject, "getTargetException");
        Exception newTargetEx = (Exception)this.transform(targetEx);
        ReflectionException newEx = new ReflectionException(newTargetEx, msg);
        return newEx;
    }

    public Object RuntimeErrorExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String msg = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        Object targetEx = JMXTransform.invoke(tmx4jObject, "getTargetError");
        Error newTargetEx = (Error)this.transform(targetEx);
        RuntimeErrorException newEx = new RuntimeErrorException(newTargetEx, msg);
        return newEx;
    }

    public Object RuntimeMBeanExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String msg = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        Object targetEx = JMXTransform.invoke(tmx4jObject, "getTargetException");
        RuntimeException newTargetEx = (RuntimeException)this.transform(targetEx);
        RuntimeMBeanException newEx = new RuntimeMBeanException(newTargetEx, msg);
        return newEx;
    }

    public Object RuntimeOperationsExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String msg = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        Object targetEx = JMXTransform.invoke(tmx4jObject, "getTargetException");
        RuntimeException newTargetEx = (RuntimeException)this.transform(targetEx);
        RuntimeOperationsException newEx = new RuntimeOperationsException(newTargetEx, msg);
        return newEx;
    }

    public Object ServiceNotFoundExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        ServiceNotFoundException jmxException = new ServiceNotFoundException(message);
        return jmxException;
    }

    public Object InvalidTargetObjectTypeExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InvalidTargetObjectTypeException jmxException = new InvalidTargetObjectTypeException(message);
        return jmxException;
    }

    public Object XMLParseExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        XMLParseException jmxException = new XMLParseException(message);
        return jmxException;
    }

    public Object MonitorSettingExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        MonitorSettingException jmxException = new MonitorSettingException(message);
        return jmxException;
    }

    public Object InvalidRelationIdExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InvalidRelationIdException jmxException = new InvalidRelationIdException(message);
        return jmxException;
    }

    public Object InvalidRelationServiceExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InvalidRelationServiceException jmxException = new InvalidRelationServiceException(message);
        return jmxException;
    }

    public Object InvalidRelationTypeExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InvalidRelationTypeException jmxException = new InvalidRelationTypeException(message);
        return jmxException;
    }

    public Object InvalidRoleInfoExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InvalidRoleInfoException jmxException = new InvalidRoleInfoException(message);
        return jmxException;
    }

    public Object InvalidRoleValueExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        InvalidRoleValueException jmxException = new InvalidRoleValueException(message);
        return jmxException;
    }

    public Object RelationExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        RelationException jmxException = new RelationException(message);
        return jmxException;
    }

    public Object RelationNotFoundExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        RelationNotFoundException jmxException = new RelationNotFoundException(message);
        return jmxException;
    }

    public Object RelationServiceNotRegisteredExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        RelationServiceNotRegisteredException jmxException = new RelationServiceNotRegisteredException(message);
        return jmxException;
    }

    public Object RelationTypeNotFoundExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        RelationTypeNotFoundException jmxException = new RelationTypeNotFoundException(message);
        return jmxException;
    }

    public Object RoleInfoNotFoundExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        RoleInfoNotFoundException jmxException = new RoleInfoNotFoundException(message);
        return jmxException;
    }

    public Object RoleNotFoundExceptionTransformer(Object tmx4jObject) throws JMXTransformException {
        String message = (String)JMXTransform.invoke(tmx4jObject, "getMessage");
        RoleNotFoundException jmxException = new RoleNotFoundException(message);
        return jmxException;
    }

    static {
        transformers.put("javax.management.Attribute", "AttributeTransformer");
        transformers.put("javax.management.AttributeChangeNotification", "AttributeChangeNotificationTransformer");
        transformers.put("javax.management.AttributeChangeNotificationFilter", "AttributeChangeNotificationFilterTransformer");
        transformers.put("javax.management.AttributeList", "AttributeListTransformer");
        transformers.put("javax.management.AttributeValueExp", "AttributeValueExpTransformer");
        transformers.put("javax.management.MBeanAttributeInfo", "MBeanAttributeInfoTransformer");
        transformers.put("javax.management.MBeanConstructorInfo", "MBeanConstructorInfoTransformer");
        transformers.put("javax.management.MBeanFeatureInfo", "MBeanFeatureInfoTransformer");
        transformers.put("javax.management.MBeanInfo", "MBeanInfoTransformer");
        transformers.put("javax.management.MBeanNotificationInfo", "MBeanNotificationInfoTransformer");
        transformers.put("javax.management.MBeanOperationInfo", "MBeanOperationInfoTransformer");
        transformers.put("javax.management.MBeanParameterInfo", "MBeanParameterInfoTransformer");
        transformers.put("javax.management.MBeanServerNotification", "MBeanServerNotificationTransformer");
        transformers.put("javax.management.Notification", "NotificationTransformer");
        transformers.put("javax.management.NotificationFilterSupport", "NotificationFilterSupportTransformer");
        transformers.put("javax.management.ObjectName", "ObjectNameTransformer");
        transformers.put("javax.management.modelmbean.ModelMBeanAttributeInfo", "ModelMBeanAttributeInfoTransformer");
        transformers.put("javax.management.modelmbean.ModelMBeanConstructorInfo", "ModelMBeanConstructorInfoTransformer");
        transformers.put("javax.management.modelmbean.DescriptorSupport", "DescriptorSupportTransformer");
        transformers.put("javax.management.modelmbean.ModelMBeanInfoSupport", "ModelMBeanInfoSupportTransformer");
        transformers.put("javax.management.modelmbean.ModelMBeanNotificationInfo", "ModelMBeanNotificationInfoTransformer");
        transformers.put("javax.management.modelmbean.ModelMBeanOperationInfo", "ModelMBeanOperationInfoTransformer");
        transformers.put("javax.management.ObjectInstance", "ObjectInstanceTransformer");
        transformers.put("javax.management.relation.RelationTypeSupport", "RelationTypeSupportTransformer");
        transformers.put("javax.management.relation.Role", "RoleTransformer");
        transformers.put("javax.management.relation.RoleInfo", "RoleInfoTransformer");
        transformers.put("javax.management.relation.RoleList", "RoleListTransformer");
        transformers.put("javax.management.relation.RoleResult", "RoleResultTransformer");
        transformers.put("javax.management.relation.RoleUnresolved", "RoleUnresolvedTransformer");
        transformers.put("javax.management.relation.RoleUnresolvedList", "RoleUnresolvedListTransformer");
        transformers.put("javax.management.StringValueExp", "StringValueExpTransformer");
        transformers.put("javax.management.AttributeNotFoundException", "AttributeNotFoundExceptionTransformer");
        transformers.put("javax.management.BadAttributeValueExpException", "BadAttributeValueExpExceptionTransformer");
        transformers.put("javax.management.BadBinaryOpValueExpException", "BadBinaryOpValueExpExceptionTransformer");
        transformers.put("javax.management.BadStringOperationException", "BadStringOperationExceptionTransformer");
        transformers.put("javax.management.InstanceAlreadyExistsException", "InstanceAlreadyExistsExceptionTransformer");
        transformers.put("javax.management.InstanceNotFoundException", "InstanceNotFoundExceptionTransformer");
        transformers.put("javax.management.IntrospectionException", "IntrospectionExceptionTransformer");
        transformers.put("javax.management.InvalidApplicationException", "InvalidApplicationExceptionTransformer");
        transformers.put("javax.management.InvalidAttributeValueException", "InvalidAttributeValueExceptionTransformer");
        transformers.put("javax.management.JMException", "JMExceptionTransformer");
        transformers.put("javax.management.JMRuntimeException", "JMRuntimeExceptionTransformer");
        transformers.put("javax.management.ListenerNotFoundException", "ListenerNotFoundExceptionTransformer");
        transformers.put("javax.management.MalformedObjectNameException", "MalformedObjectNameExceptionTransformer");
        transformers.put("javax.management.MBeanException", "MBeanExceptionTransformer");
        transformers.put("javax.management.MBeanRegistrationException", "MBeanRegistrationExceptionTransformer");
        transformers.put("javax.management.NotCompliantMBeanException", "NotCompliantMBeanExceptionTransformer");
        transformers.put("javax.management.OperationsException", "OperationsExceptionTransformer");
        transformers.put("javax.management.ReflectionException", "ReflectionExceptionTransformer");
        transformers.put("javax.management.RuntimeErrorException", "RuntimeErrorExceptionTransformer");
        transformers.put("javax.management.RuntimeMBeanException", "RuntimeMBeanExceptionTransformer");
        transformers.put("javax.management.RuntimeOperationsException", "RuntimeOperationsExceptionTransformer");
        transformers.put("javax.management.ServiceNotFoundException", "ServiceNotFoundExceptionTransformer");
        transformers.put("javax.management.modelmbean.InvalidTargetObjectTypeException", "InvalidTargetObjectTypeExceptionTransformer");
        transformers.put("javax.management.modelmbean.XMLParseException", "XMLParseExceptionTransformer");
        transformers.put("javax.management.monitor.MonitorSettingException", "MonitorSettingExceptionTransformer");
        transformers.put("javax.management.relation.InvalidRelationIdException", "InvalidRelationIdExceptionTransformer");
        transformers.put("javax.management.relation.InvalidRelationServiceException", "InvalidRelationServiceExceptionTransformer");
        transformers.put("javax.management.relation.InvalidRelationTypeException", "InvalidRelationTypeExceptionTransformer");
        transformers.put("javax.management.relation.InvalidRoleInfoException", "InvalidRoleInfoExceptionTransformer");
        transformers.put("javax.management.relation.InvalidRoleValueException", "InvalidRoleValueExceptionTransformer");
        transformers.put("javax.management.relation.RelationException", "RelationExceptionTransformer");
        transformers.put("javax.management.relation.RelationNotFoundException", "RelationNotFoundExceptionTransformer");
        transformers.put("javax.management.relation.RelationServiceNotRegisteredException", "RelationServiceNotRegisteredExceptionTransformer");
        transformers.put("javax.management.relation.RelationTypeNotFoundException", "RelationTypeNotFoundExceptionTransformer");
        transformers.put("javax.management.relation.RoleInfoNotFoundException", "RoleInfoNotFoundExceptionTransformer");
        transformers.put("javax.management.relation.RoleNotFoundException", "RoleNotFoundExceptionTransformer");
        transformers.put("com.ibm.ws.management.event.NotificationInfo", "NotificationInfoTransformer");
        transformers.put("com.ibm.ws.management.event.FilterElement", "FilterElementTransformer");
        transformers.put("com.ibm.ws.scripting.AppNotificationFilter", "AppNotificationFilterTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.MBeanStatDescriptor", "MBeanStatDescriptorTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.StatDescriptor", "StatDescriptorTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.MBeanLevelSpec", "MBeanLevelSpecTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.StatsImpl", "StatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.JCAConnectionStatsImpl", "JCAConnectionStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.JDBCConnectionStatsImpl", "JDBCConnectionStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.JCAConnectionPoolStatsImpl", "JCAConnectionPoolStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.JDBCConnectionPoolStatsImpl", "JDBCConnectionPoolStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.JCAStatsImpl", "JCAStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.JDBCStatsImpl", "JDBCStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.JVMStatsImpl", "JVMStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.JTAStatsImpl", "JTAStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.ServletStatsImpl", "ServletStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.EJBStatsImpl", "EJBStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.EntityBeanStatsImpl", "EntityBeanStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.MessageBeanStatsImpl", "MessageBeanStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.SessionBeanStatsImpl", "SessionBeanStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.StatefulSessionBeanStatsImpl", "StatefulSessionBeanStatsImplTransformer");
        transformers.put("com.ibm.websphere.pmi.stat.StatelessSessionBeanStatsImpl", "StatelessSessionBeanStatsImplTransformer");
        objectString = "READING tmx4j OBJECT ";
    }
}

