/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.configdiff.SPXId;
import com.ibm.ws.management.configservice.configdiff.TimeLine;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegment;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegmentImpl;
import com.ibm.ws.management.configservice.schemadiff.ChangedObject;
import com.ibm.ws.management.configservice.schemadiff.ConfigChange;
import com.ibm.ws.management.configservice.schemadiff.ProductCapability;
import com.ibm.ws.management.configservice.schemadiff.ProductProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;

public class TimeLineImpl
implements TimeLine {
    private static TraceComponent tc = Tr.register(TimeLineImpl.class, "management", "com.ibm.ws.management.resources.configservice");
    private String schemaType = null;
    private String versionKey = null;
    private SPXId id = null;
    private Properties prodCap = new Properties();
    private TreeSet segments = new TreeSet();
    private ChangedObject changedObject = null;

    protected TimeLineImpl(String schemaType, ProductCapability p, ConfigChange obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TimeLineImpl", new Object[]{schemaType, p, obj});
        }
        this.schemaType = schemaType;
        this.versionKey = p.getVersionKey();
        this.changedObject = obj.getChangedObject();
        EList prodProp = p.getProductProperty();
        for (ProductProperty pp : prodProp) {
            this.prodCap.put(pp.getName(), pp);
        }
        this.id = new SPXId(p);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Product capabilities", new Object[]{this.prodCap});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TimeLineImpl");
        }
    }

    public boolean sameProductCapability(String newSchemaType, ProductCapability productCap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameProductCapability", new Object[]{newSchemaType, productCap});
        }
        if (!newSchemaType.equals(this.schemaType)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "schemaType mismatch", this.schemaType, newSchemaType});
            }
            return false;
        }
        if (!this.versionKey.equals(productCap.getVersionKey())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "versionKey mismatch", this.versionKey, productCap.getVersionKey()});
            }
            return false;
        }
        EList productProps = productCap.getProductProperty();
        Properties existingProps = this.getProductCapabilities();
        if (productProps.size() != existingProps.size()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "property size mismatch", new Integer(existingProps.size()), new Integer(productProps.size())});
            }
            return false;
        }
        for (ProductProperty pp : productProps) {
            String name = pp.getName();
            if (name.equals(this.versionKey)) {
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "sameProductCapability", "skipping versionKey: " + this.versionKey);
                continue;
            }
            ProductProperty existingProp = (ProductProperty)existingProps.get(name);
            if (existingProp == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "property " + name + " does not exist"});
                }
                return false;
            }
            if (!existingProp.getValue().equals(pp.getValue())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "property value mismatch for " + name, existingProp.getValue(), pp.getValue()});
                }
                return false;
            }
            String existingOperator = existingProp.getOperator();
            String otherOperator = pp.getOperator();
            if ((existingOperator == null || existingOperator.equals(otherOperator)) && (otherOperator == null || otherOperator.equals(existingOperator))) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "operator mismatch for " + name, existingOperator, otherOperator});
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameProductCapability", new Object[]{new Boolean(true)});
        }
        return true;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public Properties getProductCapabilities() {
        return this.prodCap;
    }

    public String getVersionKey() {
        return this.versionKey;
    }

    public ChangedObject getChangedObject() {
        return this.changedObject;
    }

    public Iterator getTimeLineSegments() {
        return this.segments.iterator();
    }

    public TimeLineSegment getFirst() {
        return (TimeLineSegment)this.segments.first();
    }

    public TimeLineSegment getLast() {
        return (TimeLineSegment)this.segments.last();
    }

    public TimeLineSegment getClosestSegment(String version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClosestSegment", version);
        }
        TimeLineSegmentImpl s = new TimeLineSegmentImpl(version, null, null);
        ArrayList list = new ArrayList(this.segments);
        int index = Collections.binarySearch(list, s);
        TimeLineSegment result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClosestSegment list size is " + list.size() + " index is " + index);
        }
        if (index >= 0) {
            result = (TimeLineSegment)list.get(index);
        } else {
            if ((index = (index + 1) * -1 - 1) < 0) {
                index = 0;
            }
            result = (TimeLineSegment)list.get(index);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClosestSegment", result);
        }
        return result;
    }

    protected void setSchemaType(String s) {
        this.schemaType = s;
    }

    protected void addProductCapabilities(ProductProperty p) {
        this.prodCap.put(p.getName(), p);
    }

    protected void setVersionKey(String key) {
        this.versionKey = key;
    }

    protected void setConfigChange(ConfigChange co) {
        this.changedObject = co.getChangedObject();
    }

    protected void addTimeLineSegment(TimeLineSegment t) {
        this.segments.add(t);
    }

    protected boolean containsTimeLineSegment(TimeLineSegment t) {
        return this.segments.contains(t);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeLineImpl) {
            TimeLineImpl other = (TimeLineImpl)obj;
            if (this.getChangedObject().equals(other.getChangedObject()) && this.getProductCapabilities().equals(other.getProductCapabilities())) {
                return true;
            }
        }
        return false;
    }

    protected SPXId getSPXId() {
        return this.id;
    }

    public String toString() {
        String ret = "TimeLine: " + this.id + " changedObject: " + this.changedObject + "  segments: ";
        Iterator it = this.getTimeLineSegments();
        while (it.hasNext()) {
            TimeLineSegment segment = (TimeLineSegment)it.next();
            String version = segment.getVersion();
            Properties changedData = segment.getChangedData();
            ret = ret + "[" + version + "," + changedData + "]";
        }
        return ret;
    }

    public boolean match(Properties nodeProperties) {
        return this.id.match(nodeProperties);
    }
}

