/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.management.configarchive.ConfigArchiveComposer;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configarchive.EARFileAccessor;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ApplicationConfigurator;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class EnhancedEarConfigurator {
    private static TraceComponent tc = Tr.register(EnhancedEarConfigurator.class, "EnhancedEarConfigurator", "com.ibm.ws.management.resources.configarchive");
    private static char URI_SEPARATOR = (char)47;
    private WorkSpace workspace;
    private WorkSpace earWorkspace = null;
    private EARFile earFile;
    private EARFileAccessor earFileAccessor = null;
    private String expandedEarFileLocation;
    private DefaultFileAccessor expandedEarFileAccessor = null;
    private WorkSpace expandedEarWorkspace = null;
    private RepositoryMetaData metadata = null;
    private boolean overWriteConfig;
    private String cellName = null;
    private String appName = null;
    private String binName = null;

    private void init(WorkSpace workspace, EARFile earFile, String expandedEarFileLocation, boolean overWriteConfig, String cellName, String appName, String binName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{workspace, earFile, expandedEarFileLocation, new Boolean(overWriteConfig), cellName, appName, binName});
        }
        this.appName = appName;
        this.binName = binName;
        this.cellName = cellName;
        this.overWriteConfig = overWriteConfig;
        this.workspace = workspace;
        if (expandedEarFileLocation != null) {
            this.expandedEarFileLocation = expandedEarFileLocation;
            String loc = ApplicationConfigurator.getConfigBundleLocation();
            loc = expandedEarFileLocation + File.separator + loc.replace(URI_SEPARATOR, File.separatorChar);
            this.expandedEarFileAccessor = new DefaultFileAccessor(new File(loc));
            try {
                this.expandedEarWorkspace = ConfigArchiveComposer.createConfigArchive(null, (FileAccessor)this.expandedEarFileAccessor);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to create config archive composer");
                }
                e.printStackTrace();
            }
        }
        if (earFile != null) {
            this.earFile = earFile;
            this.earFileAccessor = new EARFileAccessor(earFile);
            try {
                this.earWorkspace = ConfigArchiveComposer.createConfigArchive(null, this.earFileAccessor);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to create config archive composer");
                }
                e.printStackTrace();
            }
        }
        this.metadata = RepositoryMetaDataFactory.getRepositoryMetaData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public EnhancedEarConfigurator(WorkSpace workspace, String expandedEarFileLocation, String cellName, String appName, String binName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EnhancedEarConfigurator", new Object[]{workspace, expandedEarFileLocation, cellName, appName, binName});
        }
        this.init(workspace, null, expandedEarFileLocation, false, cellName, appName, binName);
        try {
            if (this.expandedEarFileAccessor != null) {
                this.expandedEarFileAccessor.makeDir("");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to create root context");
            }
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EnhancedEarConfigurator");
        }
    }

    public EnhancedEarConfigurator(WorkSpace workspace, EARFile earFile, boolean overWriteConfig, String cellName, String appName, String binName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EnhancedEarConfigurator", new Object[]{workspace, earFile, new Boolean(overWriteConfig), cellName, appName, binName});
        }
        this.init(workspace, earFile, null, overWriteConfig, cellName, appName, binName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EnhancedEarConfigurator");
        }
    }

    public void importApplicationConfiguration() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importApplicationConfiguration");
        }
        try {
            if (this.earWorkspace == null) {
                throw new ConfigArchiveException("ear file is not specified for the Enhanced Ear Configurator");
            }
            RepositoryContext earRootContext = this.earWorkspace.getRootContext();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found root context in workspace", earRootContext);
            }
            if (earRootContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importApplicationConfiguration", "No rootcontext found in the enhanced ear");
                }
                return;
            }
            RepositoryContext earCellContext = null;
            RepositoryContextType type = this.metadata.getContextType("cells");
            Collection match = earRootContext.findContext(type);
            if (match == null || match.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importApplicationConfiguration", "No cell context found in ear file. Nothing to import");
                }
                return;
            }
            earCellContext = (RepositoryContext)match.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found cell context in ear", earCellContext);
            }
            RepositoryContext earAppContext = null;
            type = this.metadata.getContextType("applications");
            match = earCellContext.findContext(type);
            if (match == null || match.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importApplicationConfiguration", "No application context found in ear file. Nothing to import");
                }
                return;
            }
            earAppContext = (RepositoryContext)match.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found application context in ear", earAppContext);
            }
            RepositoryContext earDepContext = null;
            type = this.metadata.getContextType("deployments");
            match = earAppContext.findContext(type);
            if (match == null || match.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importApplicationConfiguration", "No deployment context fond. Nothing to import");
                }
                return;
            }
            earDepContext = (RepositoryContext)match.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found deployment context in ear", earDepContext);
            }
            RepositoryContext rootContext = this.workspace.getRootContext();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found root context in workspace", rootContext);
            }
            RepositoryContext cellContext = ConfigArchiveUtils.createContextIfNeeded(rootContext, "cells", this.cellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "created/found cells context in workspace", cellContext);
            }
            RepositoryContext applicationContext = ConfigArchiveUtils.createContextIfNeeded(cellContext, "applications", this.binName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "created/found applications context in workspace", applicationContext);
            }
            RepositoryContext appDepContext = ConfigArchiveUtils.createContextIfNeeded(applicationContext, "deployments", this.appName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "created/found deployments context in workspace", appDepContext);
            }
            Resource res = null;
            try {
                res = EnhancedEarConfigurator.getResource(earDepContext, "deployment.xml");
            }
            catch (Exception e) {
                res = null;
            }
            if (res != null && res.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(appDepContext, earDepContext, this.appName, "deployment.xml");
            }
            try {
                res = EnhancedEarConfigurator.getResource(earDepContext, "resources.xml");
            }
            catch (Exception e) {
                res = null;
            }
            if (res != null && res.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(appDepContext, earDepContext, this.appName, "resources.xml");
            }
            try {
                res = EnhancedEarConfigurator.getResource(earDepContext, "variables.xml");
            }
            catch (Exception e) {
                res = null;
            }
            if (res != null && res.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(appDepContext, earDepContext, this.appName, "variables.xml");
            }
        }
        catch (Throwable e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importApplicationConfiguration failed", e.getMessage());
            }
            throw new ConfigArchiveException(e, "importApplicationConfiguration failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importApplicationConfiguration");
        }
    }

    public void updateApplicationConfiguration(List deploymentTargets) throws ConfigArchiveException {
        block73: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateApplicationConfiguration");
            }
            try {
                RepositoryContext earRootContext = null;
                if (this.earWorkspace != null) {
                    earRootContext = this.earWorkspace.getRootContext();
                } else if (this.expandedEarWorkspace != null) {
                    earRootContext = this.expandedEarWorkspace.getRootContext();
                } else {
                    throw new ConfigArchiveException("ear file is not specified for the Enhanced Ear Configurator");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found root context in workspace", earRootContext);
                }
                if (earRootContext == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateApplicationConfiguration ", "No rootcontext found in the enhanced ear");
                    }
                    return;
                }
                RepositoryContext earCellContext = null;
                RepositoryContextType type = this.metadata.getContextType("cells");
                Collection match = this.findContext(earRootContext, type);
                if (match == null || match.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateApplicationConfiguration ", "No cell context found in ear file. Nothing to import");
                    }
                    return;
                }
                earCellContext = (RepositoryContext)match.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found cell context in ear", earCellContext);
                }
                RepositoryContext rootContext = this.workspace.getRootContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found root context in workspace", rootContext);
                }
                RepositoryContext cellContext = ConfigArchiveUtils.createContextIfNeeded(rootContext, "cells", this.cellName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "created/found cells context in workspace", cellContext);
                }
                Resource res = null;
                try {
                    res = EnhancedEarConfigurator.getResource(earCellContext, "virtualhosts.xml");
                }
                catch (Exception e) {
                    res = null;
                }
                EList content = null;
                VirtualHost earVirtHost = null;
                if (res != null && (content = res.getContents()) != null && content.size() > 0) {
                    earVirtHost = (VirtualHost)content.get(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear virutal hosts", earVirtHost);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear virutal hosts", earVirtHost);
                }
                Resource res1 = null;
                try {
                    res1 = EnhancedEarConfigurator.getResource(cellContext, "virtualhosts.xml");
                }
                catch (Exception e) {
                    res1 = null;
                }
                EList content1 = null;
                VirtualHost workspaceVirtHost = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear virutal hosts", earVirtHost);
                }
                if (res1 != null && earVirtHost != null && (content1 = res1.getContents()) != null) {
                    for (int i = 0; i < content1.size(); ++i) {
                        VirtualHost vHost = (VirtualHost)content1.get(i);
                        if (!vHost.getName().equals(earVirtHost.getName())) continue;
                        workspaceVirtHost = vHost;
                        break;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "workspace virutal hosts", workspaceVirtHost);
                }
                if (earVirtHost != null) {
                    if (res1 == null) {
                        ConfigArchiveUtils.copyFile(cellContext, earCellContext, this.cellName, "virtualhosts.xml");
                    } else if (workspaceVirtHost != null) {
                        ConfigArchiveUtils.mergeList(workspaceVirtHost.getAliases(), earVirtHost.getAliases(), "port", this.overWriteConfig);
                    } else if (earVirtHost != null) {
                        res1.getContents().add(earVirtHost);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "merged list = ", res1.getContents());
                    }
                    if (res1 != null) {
                        res1.save(new HashMap());
                    }
                }
                Security earSecurity = null;
                try {
                    res = EnhancedEarConfigurator.getResource(earCellContext, "security.xml");
                }
                catch (Exception e) {
                    res = null;
                }
                content = null;
                if (res != null) {
                    content = res.getContents();
                }
                if (content != null && content.size() > 0) {
                    earSecurity = (Security)content.get(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wear security ", earSecurity);
                }
                Security workspaceSecurity = null;
                try {
                    res1 = EnhancedEarConfigurator.getResource(cellContext, "security.xml");
                }
                catch (Exception e) {
                    res1 = null;
                }
                content1 = null;
                if (res1 != null) {
                    content1 = res1.getContents();
                }
                if (content1 != null && content1.size() > 0) {
                    workspaceSecurity = (Security)content1.get(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "workspace security ", workspaceSecurity);
                }
                if (earSecurity != null) {
                    if (res1 == null) {
                        ConfigArchiveUtils.copyFile(cellContext, earCellContext, this.cellName, "security.xml");
                    } else {
                        ConfigArchiveUtils.mergeList(workspaceSecurity.getAuthDataEntries(), earSecurity.getAuthDataEntries(), "alias", this.overWriteConfig);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "merged list = ", workspaceSecurity.getAuthDataEntries());
                    }
                    if (res1 != null) {
                        res1.save(new HashMap());
                    }
                }
                RepositoryContext earNodeContext = null;
                type = this.metadata.getContextType("nodes");
                match = this.findContext(earCellContext, type);
                if (match == null || match.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateApplicationConfiguration ", "No node context found in ear file. Nothing to import");
                    }
                } else {
                    earNodeContext = (RepositoryContext)match.iterator().next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node context in ear ", earNodeContext);
                }
                res = null;
                RepositoryContext earServerContext = null;
                type = this.metadata.getContextType("servers");
                match = this.findContext(earCellContext, type);
                if (match == null || match.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateApplicationConfiguration ", "No server context found in ear file. Nothing to import");
                    }
                } else {
                    earServerContext = (RepositoryContext)match.iterator().next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server context in ear ", earServerContext);
                }
                if (earServerContext != null) {
                    try {
                        res = EnhancedEarConfigurator.getResource(earServerContext, "libraries.xml");
                    }
                    catch (Exception e) {
                        res = null;
                    }
                }
                Library libraries = null;
                content = null;
                if (res != null) {
                    content = res.getContents();
                }
                if (content != null && content.size() > 0) {
                    libraries = (Library)content.get(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "libraries in ear ", libraries);
                }
                RepositoryContext serverCtx = null;
                String server = null;
                if (libraries == null) break block73;
                for (DeploymentTarget tgt : deploymentTargets) {
                    if (tgt instanceof ServerTarget) {
                        String node = ((ServerTarget)tgt).getNodeName();
                        server = ((ServerTarget)tgt).getName();
                        Collection matches = cellContext.findContext("nodes", node);
                        RepositoryContext nodeCtx = (RepositoryContext)matches.iterator().next();
                        matches = nodeCtx.findContext("servers", server);
                        serverCtx = (RepositoryContext)matches.iterator().next();
                    } else if (tgt instanceof ClusteredTarget) {
                        server = ((ClusteredTarget)tgt).getName();
                        Collection matches = cellContext.findContext("clusters", server);
                        serverCtx = (RepositoryContext)matches.iterator().next();
                    }
                    try {
                        res1 = EnhancedEarConfigurator.getResource(serverCtx, "libraries.xml");
                    }
                    catch (Exception e) {
                        res1 = null;
                    }
                    Library libraries1 = null;
                    content1 = null;
                    if (res1 != null) {
                        content1 = res1.getContents();
                    }
                    if (content1 != null && content1.size() > 0) {
                        libraries1 = (Library)content1.get(0);
                    }
                    if (content1 != null && content1.size() > 0) {
                        ConfigArchiveUtils.mergeList(content1, content, "name", this.overWriteConfig);
                        res1.save(new HashMap());
                        continue;
                    }
                    ConfigArchiveUtils.copyFile(serverCtx, earServerContext, server, "libraries.xml");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!tc.isDebugEnabled()) break block73;
                Tr.debug(tc, "updateApplicationConfiguration failed");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateApplicationConfiguration");
        }
    }

    public void exportApplicationConfiguration() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportApplicationConfiguration");
        }
        try {
            RepositoryContext earCellContext;
            RepositoryContext earRootContext;
            RepositoryContext depContext;
            block33: {
                if (this.expandedEarWorkspace == null) {
                    throw new ConfigArchiveException("Expanded ear file location is not specified for the Enhanced Ear Configurator");
                }
                RepositoryContext rootContext = this.workspace.getRootContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found root context in workspace", rootContext);
                }
                RepositoryContext cellContext = null;
                Collection match = rootContext.findContext("cells", this.cellName);
                if (match == null || match.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "exportApplicationConfiguration");
                    }
                    throw new ConfigArchiveException("Cell Context not found");
                }
                cellContext = (RepositoryContext)match.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found cell context in workspace", cellContext);
                }
                RepositoryContext appContext = null;
                match = cellContext.findContext("applications", this.binName);
                if (match == null || match.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "exportApplicationConfiguration");
                    }
                    throw new ConfigArchiveException("Application Context not found");
                }
                appContext = (RepositoryContext)match.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found application context in workspace", appContext);
                }
                depContext = null;
                match = appContext.findContext("deployments", this.appName);
                if (match == null || match.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "exportApplicationConfiguration");
                    }
                    throw new ConfigArchiveException("Application Context not found");
                }
                depContext = (RepositoryContext)match.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found deployment context in workspace", depContext);
                }
                earRootContext = this.expandedEarWorkspace.getRootContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found root context in ear", earRootContext);
                }
                earCellContext = ConfigArchiveUtils.createContextIfNeeded(earRootContext, "cells", "defaultCell");
                try {
                    if (earCellContext != null) {
                        earCellContext.delete(true);
                        if (earRootContext != null) {
                            earRootContext.synch(new HashMap());
                        }
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug(tc, "Cleanup of enhanced ear config information present in META-INF/ibmconfig directory failed");
                }
            }
            earCellContext = ConfigArchiveUtils.createContextIfNeeded(earRootContext, "cells", "defaultCell");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found cells context in ear", earCellContext);
            }
            RepositoryContext earApplicationContext = ConfigArchiveUtils.createContextIfNeeded(earCellContext, "applications", "defaultApp");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found applications context in ear", earApplicationContext);
            }
            RepositoryContext earAppDepContext = ConfigArchiveUtils.createContextIfNeeded(earApplicationContext, "deployments", "defaultApp");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found deployments context in ear", earAppDepContext);
            }
            Resource res = null;
            try {
                res = EnhancedEarConfigurator.getResource(depContext, "deployment.xml");
            }
            catch (Exception e) {
                res = null;
            }
            if (res != null && res.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(earAppDepContext, depContext, this.appName, "deployment.xml");
            }
            try {
                res = EnhancedEarConfigurator.getResource(depContext, "resources.xml");
            }
            catch (Exception e) {
                res = null;
            }
            if (res != null && res.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(earAppDepContext, depContext, this.appName, "resources.xml");
            }
            try {
                res = EnhancedEarConfigurator.getResource(depContext, "variables.xml");
            }
            catch (Exception e) {
                res = null;
            }
            if (res != null && res.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(earAppDepContext, depContext, this.appName, "variables.xml");
            }
        }
        catch (Throwable e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportApplicationConfiguration failed", e.getMessage());
            }
            throw new ConfigArchiveException(e, "exportAppplicationConfiguration failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportApplicationConfiguration");
        }
    }

    public Resource getDeploymentResource(String resourceName) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentResource");
        }
        try {
            RepositoryContext earRootContext = null;
            if (this.earWorkspace != null) {
                earRootContext = this.earWorkspace.getRootContext();
            } else if (this.expandedEarWorkspace != null) {
                earRootContext = this.expandedEarWorkspace.getRootContext();
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentResource", "EarFile not specified");
                }
                return null;
            }
            RepositoryContextType type = this.metadata.getContextType("cells");
            Collection match = this.findContext(earRootContext, type);
            if (match == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentResource", "Cell context not found in ear file");
                }
                return null;
            }
            RepositoryContext cellContext = (RepositoryContext)match.iterator().next();
            if ((match = this.findContext(cellContext, type = this.metadata.getContextType("applications"))) == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentResource", "application context not found in ear file");
                }
                return null;
            }
            RepositoryContext appContext = (RepositoryContext)match.iterator().next();
            if ((match = this.findContext(appContext, type = this.metadata.getContextType("deployments"))) == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentResource", "application delployment context not found in ear file");
                }
                return null;
            }
            RepositoryContext depContext = (RepositoryContext)match.iterator().next();
            Resource res = null;
            try {
                res = EnhancedEarConfigurator.getResource(depContext, resourceName);
            }
            catch (Exception e) {
                res = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDeploymentResource");
            }
            if (res != null && res.getContents().size() == 0) {
                return null;
            }
            return res;
        }
        catch (Throwable e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDeploymentResource failed", e.getMessage());
            }
            return null;
        }
    }

    public Resource getDeployment() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeployment");
        }
        Resource res = this.getDeploymentResource("deployment.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeployment");
        }
        return res;
    }

    public Resource getVariables() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariables");
        }
        Resource res = this.getDeploymentResource("variables.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariables");
        }
        return res;
    }

    public Resource getResources() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResources");
        }
        Resource res = this.getDeploymentResource("resources.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResources");
        }
        return res;
    }

    public List getDeploymentResources() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentResources");
        }
        ArrayList<Resource> resList = new ArrayList<Resource>(3);
        Resource res1 = this.getResources();
        Resource res2 = this.getVariables();
        Resource res3 = this.getDeployment();
        if (res1 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding resources.xml");
            }
            resList.add(res1);
        }
        if (res2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding variables.xml");
            }
            resList.add(res2);
        }
        if (res3 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding deployment.xml");
            }
            resList.add(res3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeploymentResources");
        }
        return resList;
    }

    public boolean isEnhancedEar() {
        try {
            Resource res = this.getResources();
            if (res != null && res.getContents().size() > 0) {
                return true;
            }
            res = this.getVariables();
            if (res != null && res.getContents().size() > 0) {
                return true;
            }
            res = this.getDeployment();
            if (res != null && res.getContents().size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnhancedEar(WorkSpace ws, EARFile ear) {
        EnhancedEarConfigurator enc = null;
        try {
            enc = new EnhancedEarConfigurator(ws, ear, false, "defaultCell", "defaultApp", "defaultApp");
            boolean bl = enc.isEnhancedEar();
            Object var5_4 = null;
            if (enc != null) {
                enc.cleanup();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (enc == null) break block3;
                enc.cleanup();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnhancedEar(WorkSpace ws, String earLocation) {
        EnhancedEarConfigurator enc = null;
        try {
            enc = new EnhancedEarConfigurator(ws, earLocation, "defaultCell", "defaultApp", "defaultApp");
            boolean bl = enc.isEnhancedEar();
            Object var5_4 = null;
            if (enc != null) {
                enc.cleanup();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (enc == null) break block3;
                enc.cleanup();
            }
            throw throwable;
        }
    }

    public static boolean isEnhancedEar(EARFile ear) {
        boolean res = false;
        try {
            EARFileAccessor fa = new EARFileAccessor(ear);
            List fils = fa.listFolders("cells");
            return fils.size() > 0;
        }
        catch (Exception e) {
            return res;
        }
    }

    public static boolean isEnhancedEar(String earLocation) {
        boolean res = false;
        try {
            DefaultFileAccessor fa = new DefaultFileAccessor(new File(earLocation));
            List fils = fa.listFolders("cells");
            return fils.size() > 0;
        }
        catch (Exception e) {
            return res;
        }
    }

    private Collection findContext(RepositoryContext parent, RepositoryContextType type) {
        ArrayList<RepositoryContext> lst;
        block5: {
            lst = new ArrayList<RepositoryContext>();
            try {
                Collection match = parent.findContext(type);
                if (match == null || match.size() == 0) {
                    return lst;
                }
                block2: for (RepositoryContext ctx : match) {
                    List files = ctx.getAllList(true);
                    for (WorkSpaceFile file : files) {
                        if (!file.getFileName().endsWith(".xml")) continue;
                        lst.add(ctx);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Failed to find any context");
            }
        }
        return lst;
    }

    public void cleanup() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanup");
            }
            WorkSpace ws = null;
            if (this.earWorkspace != null) {
                ws = this.earWorkspace;
            } else if (this.expandedEarWorkspace != null) {
                ws = this.expandedEarWorkspace;
            }
            if (ws != null) {
                try {
                    WorkSpaceManager workspaceMan = WorkSpaceManagerFactory.getManager();
                    ValidationManagerRegistry registry = ValidationHelper.getRegistry();
                    registry.release(ws);
                    workspaceMan.removeWorkSpace(ws.getUserName());
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "failed to cleanup config archive workspace");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
    }

    private static Resource getResource(RepositoryContext context, String fileName) throws Exception {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResource", new Object[]{context, fileName});
            }
            try {
                WorkspaceHelper.getDocAccessorNoCreate(context, fileName);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getDocAccessor failed");
            }
        }
        Resource res = context.getResourceSet().getResource(URI.createURI(fileName), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", res);
        }
        return res;
    }
}

