/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.ws.pmi.dynamicproxy.MBeanStatsAggregationHandler;

public class JVMMBeanAggregationHandler
extends MBeanStatsAggregationHandler {
    private static final TraceComponent tc = Tr.register(JVMMBeanAggregationHandler.class, "JVM", null);

    public Object aggregateResults(String methodName, Object[] params, String[] signatures, ServantMBeanResult[] servantMBeanResults, StateObject stateObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregateResults", new Object[]{methodName, params, signatures, servantMBeanResults, stateObject});
        }
        Object retval = null;
        if (methodName.equals("getTotalMemory")) {
            StringBuffer stateBuf = new StringBuffer();
            stateBuf.append("Controller: " + Long.toString(Runtime.getRuntime().totalMemory()) + ";");
            for (int i = 0; i < servantMBeanResults.length; ++i) {
                stateBuf.append("\nServant " + servantMBeanResults[i].getStoken() + ": " + servantMBeanResults[i].getResult() + ";");
            }
            retval = stateBuf.toString();
        } else if (methodName.equals("getFreeMemory")) {
            StringBuffer stateBuf = new StringBuffer();
            stateBuf.append("Controller: " + Long.toString(Runtime.getRuntime().freeMemory()) + ";");
            for (int i = 0; i < servantMBeanResults.length; ++i) {
                stateBuf.append("\nServant " + servantMBeanResults[i].getStoken() + ": " + servantMBeanResults[i].getResult() + ";");
            }
            retval = stateBuf.toString();
        } else if (methodName.equals("getProperty")) {
            StringBuffer stateBuf = new StringBuffer();
            boolean sameValues = true;
            String controlValue = null;
            if (servantMBeanResults.length > 0) {
                controlValue = (String)servantMBeanResults[0].getResult();
            }
            String servantVal = null;
            for (int i = 1; i < servantMBeanResults.length; ++i) {
                servantVal = (String)servantMBeanResults[i].getResult();
                if (controlValue != null && servantVal == null) {
                    sameValues = false;
                } else if (controlValue == null && servantVal != null) {
                    sameValues = false;
                } else if (controlValue != null) {
                    sameValues = controlValue.equals(servantVal);
                }
                stateBuf.append("Servant " + servantMBeanResults[i].getStoken() + ": " + servantVal + ";\n");
            }
            retval = sameValues ? controlValue : stateBuf.toString();
        } else if (methodName.equals("getStats")) {
            retval = super.aggregateResults(methodName, params, signatures, servantMBeanResults, stateObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aggregateResults", retval);
        }
        return retval;
    }
}

