/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

class ConfigChangeHandler
implements ConfigRepositoryListener,
AlarmListener,
NotificationListener {
    private static final TraceComponent tc = Tr.register(ConfigChangeHandler.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private List listeners = new ArrayList();
    private boolean holdEvents = false;
    private List heldEvents = new ArrayList();

    ConfigChangeHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigChangeListener(ConfigChangeListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addConfigChangeListener", listener);
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addConfigChangeListener", listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigChangeListener(ConfigChangeListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeConfigChangeListener", listener);
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeConfigChangeListener", listener);
        }
    }

    public void handleNotification(Notification notification, Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        if (notification.getType().equals("websphere.nodesync.initiated")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node sync initiated");
            }
            this.holdEvents = true;
        } else if (notification.getType().equals("websphere.nodesync.complete")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node sync complete");
            }
            ConfigRepository configRepository = null;
            ArrayList<ConfigChangeNotifier> notifiers = new ArrayList<ConfigChangeNotifier>();
            for (ConfigRepositoryEvent e : this.heldEvents) {
                if (configRepository == null) {
                    configRepository = (ConfigRepository)e.getSource();
                }
                notifiers.addAll(Arrays.asList(e.getChanges()));
            }
            if (notifiers.size() > 0) {
                ConfigChangeNotifier[] packedNotifiers = new ConfigChangeNotifier[notifiers.size()];
                notifiers.toArray(packedNotifiers);
                ConfigRepositoryEvent packedEvent = new ConfigRepositoryEvent(configRepository, ConfigRepositoryEvent.generateId(), packedNotifiers);
                this.sendEvent(packedEvent);
                this.heldEvents.clear();
            }
            this.holdEvents = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configrepositoryevent) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent configrepositoryevent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onChangeCompletion");
        }
        if (this.holdEvents) {
            this.heldEvents.add(configrepositoryevent);
        } else {
            this.sendEvent(configrepositoryevent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onChangeCompletion");
        }
    }

    public void onRepositoryEpochRefresh() {
    }

    public void configChanged(ConfigRepositoryEvent e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged");
        }
        this.sendEvent(e);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    public void alarm(Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", obj);
        }
        ConfigChangeEventDispatcher dispatcher = (ConfigChangeEventDispatcher)obj;
        dispatcher.run();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm", obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(ConfigRepositoryEvent e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendEvent," + e.getId());
        }
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                AlarmManager.createNonDeferrable((long)0L, (AlarmListener)this, (Object)new ConfigChangeEventDispatcher(e, (ConfigChangeListener)iter.next()));
            }
        }
        String pKey = AdminContext.peek();
        new Thread(new ConfigChangeEventWorker(e, pKey)).start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendEvent");
        }
    }

    private class ConfigChangeEventDispatcher
    implements Runnable {
        private ConfigRepositoryEvent e;
        private ConfigChangeListener l = null;
        private ObjectName adminOperation = null;
        private String profileKey = null;

        ConfigChangeEventDispatcher(ConfigRepositoryEvent event2, ConfigChangeListener listener) {
            this.e = event2;
            this.l = listener;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Dispatcher created for listener " + listener);
            }
        }

        ConfigChangeEventDispatcher(ConfigRepositoryEvent event2, ObjectName adminOperation, String pKey) {
            this.e = event2;
            this.adminOperation = adminOperation;
            this.profileKey = pKey;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Dispatcher created for " + adminOperation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block23: {
                boolean pushed;
                block21: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                    }
                    pushed = false;
                    Subject savedSubject = null;
                    Subject ownSubject = null;
                    try {
                        try {
                            if (this.profileKey != null) {
                                pushed = AdminContext.push((String)this.profileKey);
                            }
                            if ((ownSubject = SecurityHelper.getOwnedSubject()) != null) {
                                savedSubject = SecurityHelper.pushInvocationSubject(ownSubject);
                            }
                            if (this.l != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Notifying local listener", this.l);
                                }
                                this.l.configChanged(this.e);
                            } else if (this.adminOperation != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Notifying remote listener", this.adminOperation);
                                }
                                try {
                                    AdminService adminService = AdminServiceFactory.getAdminService();
                                    adminService.invoke(this.adminOperation, "configChanged", new Object[]{this.e}, new String[]{"com.ibm.websphere.management.repository.ConfigRepositoryEvent"});
                                }
                                catch (Throwable th) {
                                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.component.ConfigChangeHandler.run", (String)"186", (Object)this);
                                    Tr.warning(tc, "ADMN0014W", new Object[]{this.adminOperation, this.e});
                                }
                            }
                            Object var6_7 = null;
                            if (ownSubject == null) break block21;
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"ibm.ws.management.component.ConfigChangeHandler", (String)"8888", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception in ConfigChangeHandler run method:" + e);
                            }
                            Object var6_8 = null;
                            if (ownSubject != null) {
                                SecurityHelper.popInvocationSubject(savedSubject);
                            }
                            if (pushed) {
                                AdminContext.pop();
                            }
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        if (ownSubject != null) {
                            SecurityHelper.popInvocationSubject(savedSubject);
                        }
                        if (pushed) {
                            AdminContext.pop();
                        }
                        throw throwable;
                    }
                    SecurityHelper.popInvocationSubject(savedSubject);
                }
                if (pushed) {
                    AdminContext.pop();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }

    private class ConfigChangeEventWorker
    implements Runnable {
        private ConfigRepositoryEvent e;
        private String profileKey = null;

        ConfigChangeEventWorker(ConfigRepositoryEvent event2, String pKey) {
            this.e = event2;
            this.profileKey = pKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block22: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "ConfigChangeEventWorker started," + this.e.getId());
                }
                boolean pushed = false;
                try {
                    block21: {
                        try {
                            Subject ownSubject;
                            Subject savedSubject;
                            block20: {
                                if (this.profileKey != null) {
                                    pushed = AdminContext.push((String)this.profileKey);
                                }
                                savedSubject = null;
                                ownSubject = null;
                                ownSubject = SecurityHelper.getOwnedSubject();
                                if (ownSubject != null) {
                                    savedSubject = SecurityHelper.pushInvocationSubject(ownSubject);
                                }
                                AdminService adminService = AdminServiceFactory.getAdminService();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, adminService.getProcessType());
                                }
                                if (adminService.getProcessType().equals("NodeAgent") || adminService.getProcessType().equals("AdminAgent")) {
                                    ObjectName pattern;
                                    block19: {
                                        pattern = null;
                                        try {
                                            pattern = new ObjectName("*:type=AdminOperations,*");
                                        }
                                        catch (MalformedObjectNameException ex) {
                                            ex.printStackTrace();
                                            if (!tc.isDebugEnabled()) break block19;
                                            Tr.debug(tc, "There was an error forming object name for AdminOpeartions mbean");
                                        }
                                    }
                                    try {
                                        Set adminOperations = adminService.queryNames(pattern, null);
                                        for (ObjectName target : adminOperations) {
                                            String process = ObjectNameHelper.getProcessName(target);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "AdminOperations mbean " + target);
                                                Tr.debug(tc, "AdminOperations mbean for process " + process);
                                            }
                                            if (process.equals(adminService.getProcessName())) continue;
                                            String pKey = AdminContext.peek();
                                            new Thread(new ConfigChangeEventDispatcher(this.e, target, pKey)).start();
                                        }
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                        if (!tc.isDebugEnabled()) break block20;
                                        Tr.debug(tc, "There was an error querying AdminOpeartions mbeans, config changes event may not be sent to downstream servers.");
                                    }
                                }
                            }
                            if (ownSubject == null) break block21;
                            SecurityHelper.popInvocationSubject(savedSubject);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "There was an error running configChangeEventWorker.");
                            }
                            Object var12_15 = null;
                            if (pushed) {
                                AdminContext.pop();
                            }
                            break block22;
                        }
                    }
                    Object var12_14 = null;
                    if (!pushed) break block22;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (pushed) {
                        AdminContext.pop();
                    }
                    throw throwable;
                }
                AdminContext.pop();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConfigChangeEventWorker done");
            }
        }
    }
}

