/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class GenerateTemplatesCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(GenerateTemplatesCommand.class, "TemplateConfig", BUNDLE_NAME);

    public GenerateTemplatesCommand(TaskCommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
    }

    public GenerateTemplatesCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            String[] featureTemplateNames = (String[])this.getParameter("featureTemplateNames");
            String serverType = (String)this.getParameter("serverType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", serverType);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateNames", featureTemplateNames);
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; featureTemplateNames != null && i < featureTemplateNames.length; ++i) {
                    Tr.debug(tc, "featureTemplateName", featureTemplateNames[i]);
                }
            }
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            List featureNames = null;
            if (serverType != null && ((featureNames = TemplateConfigHelper.getFeatureNames(cs, session, serverType)) == null || featureNames.size() == 0)) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0620E", new Object[]{this.getName(), serverType});
                throw new CommandValidationException(msg);
            }
            if (featureTemplateNames != null && featureTemplateNames.length > 0) {
                if (serverType == null) {
                    String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0621E", new Object[]{this.getName()});
                    throw new CommandValidationException(msg);
                }
                for (int i = 0; i < featureTemplateNames.length; ++i) {
                    if (featureNames.contains(featureTemplateNames[i])) continue;
                    String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0622E", new Object[]{this.getName(), featureTemplateNames[i]});
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (CommandValidationException cve) {
            throw cve;
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0623E", new Object[]{this.getName()});
            throw new CommandValidationException(e, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        List newTemplates = null;
        try {
            String[] featureTemplateNames = (String[])this.getParameter("featureTemplateNames");
            String serverType = (String)this.getParameter("serverType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", serverType);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateNames", featureTemplateNames);
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; featureTemplateNames != null && i < featureTemplateNames.length; ++i) {
                    Tr.debug(tc, "featureTemplateName", featureTemplateNames[i]);
                }
            }
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            newTemplates = serverType != null && featureTemplateNames != null && featureTemplateNames.length > 0 ? this.generateTemplates(cs, session, serverType, featureTemplateNames) : (serverType == null ? this.generateTemplates(cs, session) : this.generateTemplates(cs, session, serverType));
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0624E", new Object[]{this.getName()});
            ((CommandResultImpl)((Object)result)).setException(e);
            ((CommandResultImpl)((Object)result)).setResult(msg);
        }
        ((CommandResultImpl)((Object)result)).setResult(newTemplates);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted", newTemplates);
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private List generateTemplates(ConfigService cs, Session session) throws Exception {
        List serverTypes;
        ArrayList templates = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateTemplates", new Object[]{cs, session});
        }
        if ((serverTypes = TemplateConfigHelper.getServerTypes(cs, session)) == null) {
            return templates;
        }
        for (String serverType : serverTypes) {
            List newTemplates = this.generateTemplates(cs, session, serverType);
            templates.addAll(newTemplates);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateTemplates", templates);
        }
        return templates;
    }

    private List generateTemplates(ConfigService cs, Session session, String serverType) throws Exception {
        List featureNames;
        ArrayList templates = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateTemplates", new Object[]{cs, session, serverType});
        }
        if ((featureNames = TemplateConfigHelper.getFeatureNames(cs, session, serverType)) == null || featureNames.size() < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateTemplates", "no feature packs");
            }
            return templates;
        }
        for (String featureName : featureNames) {
            List newTemplates = this.generateTemplates(cs, session, serverType, featureName);
            templates.addAll(newTemplates);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateTemplates", templates);
        }
        return templates;
    }

    private List generateTemplates(ConfigService cs, Session session, String serverType, String[] featureTemplateNames) throws Exception {
        ArrayList templates = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateTemplates", new Object[]{cs, session, serverType, featureTemplateNames});
        }
        if (featureTemplateNames == null || featureTemplateNames.length < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateTemplates", "no feature packs");
            }
            return templates;
        }
        for (int i = 0; i < featureTemplateNames.length; ++i) {
            String featureName = featureTemplateNames[i];
            List newTemplates = this.generateTemplates(cs, session, serverType, featureName);
            templates.addAll(newTemplates);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateTemplates", templates);
        }
        return templates;
    }

    private List generateTemplates(ConfigService cs, Session session, String serverType, String featureTemplateName) throws Exception {
        ArrayList<ObjectName> newTemplates = new ArrayList<ObjectName>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateTemplates", new Object[]{cs, session, serverType, featureTemplateName});
        }
        ObjectName[] templates = TemplateConfigHelper.getTemplateMetadataForServerType(cs, session, serverType);
        PropertySet featurePs = TemplateConfigHelper.getFeatureTemplateMetadata(cs, session, serverType, featureTemplateName);
        for (int i = 0; i < templates.length; ++i) {
            PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, templates[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + set);
            }
            if (TemplateConfigHelper.alreadyExists(cs, session, set, featurePs, templates) || !TemplateConfigHelper.canCombine(cs, session, set, featurePs)) continue;
            ObjectName newTemp = TemplateConfigHelper.createTemplate(cs, session, set, featurePs, serverType);
            newTemplates.add(newTemp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateTemplates", newTemplates);
        }
        return newTemplates;
    }
}

