/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.HashSet;
import javax.management.ObjectName;

public class GetServerType
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetServerType.class, "GetServerType", "com.ibm.ws.management.commands.server");
    private ObjectName server = null;

    public GetServerType(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetServerType(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        String nodeName = (String)this.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        String serverName = (String)this.getParameter("serverName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverName", serverName);
        }
        try {
            ObjectName[] match = cs.resolve(session, "Node=" + nodeName + ":Server=" + serverName);
            if (match.length != 1) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0005E", new Object[]{nodeName, serverName}, null);
                throw new CommandValidationException(msg);
            }
            this.server = match[0];
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.server.validate", (String)"77");
            throw new CommandValidationException(th, "validation for command GetServerType failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            String serverType = this.getServerType();
            result.setResult(serverType);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.server.validate", (String)"94");
            result.setException(new CommandException(th, "GetServerType command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public Object[] getChoices(String paramName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", paramName);
        }
        Object[] result = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (paramName.equals("serverName")) {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server");
                ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
                result = new String[match.length];
                for (int i = 0; i < match.length; ++i) {
                    result[i] = ConfigServiceHelper.getDisplayName(match[i]);
                }
            } else if (paramName.equals("nodeName")) {
                HashSet<String> nodes = new HashSet<String>();
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server", (String)this.getParameter("serverName"));
                ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < match.length; ++i) {
                    String nodeName = ConfigServiceHelper.getObjectLocation(match[i]).getProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeName", nodeName);
                    }
                    nodes.add(nodeName);
                }
                result = nodes.toArray();
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.GetServerType.getChoices", (String)"111");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices");
        }
        return result;
    }

    public void setConfigSession(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigSession", session);
        }
        super.setConfigSession(session);
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
            if (match.length == 1) {
                this.setParameter("nodeName", ConfigServiceHelper.getDisplayName(match[0]));
                pattern = ConfigServiceHelper.createObjectName(null, "Server");
                match = cs.queryConfigObjects(session, match[0], pattern, null);
                if (match.length == 1) {
                    this.setParameter("serverName", ConfigServiceHelper.getDisplayName(match[0]));
                }
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.server.setConfigSession", (String)"160");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigSession");
        }
    }

    public void setParameter(String paramName, Object value) throws InvalidParameterValueException, InvalidParameterNameException {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setParameter", new Object[]{paramName, value});
            }
            super.setParameter(paramName, value);
            if (paramName.equals("serverName") && this.getParameter("nodeName") == null) {
                try {
                    ConfigService cs = ConfigServiceFactory.getConfigService();
                    ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server", (String)value);
                    ObjectName[] match = cs.queryConfigObjects(this.getConfigSession(), null, pattern, null);
                    if (match.length == 1) {
                        String nodeName = ConfigServiceHelper.getObjectLocation(match[0]).getProperty("node");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nodeName", nodeName);
                        }
                        this.setParameter("nodeName", nodeName);
                    }
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "unexpected exception", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    private String getServerType() throws Exception {
        WorkSpace ws;
        boolean is5Node;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GetServerType", this.server);
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session s = this.getConfigSession();
        String result = (String)cs.getAttribute(s, this.server, "serverType");
        String nodeName = (String)this.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        if ((is5Node = (ws = WorkspaceHelper.getWorkspace(s)).getMetadataHelper().getNodeMajorVersion(nodeName).equals("5")) && "APPLICATION_SERVER".equals(result) && this.is5XGenericServer(this.server)) {
            result = "GENERIC_SERVER";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GetServerType", result);
        }
        return result;
    }

    private boolean is5XGenericServer(ObjectName server) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is5XGenericServer", server);
        }
        boolean isGenericSvr = false;
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session s = this.getConfigSession();
        ObjectName processDef = (ObjectName)cs.getAttribute(s, server, "processDefinition", false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processDef", processDef);
        }
        if (processDef != null) {
            String processDefType = ConfigServiceHelper.getConfigDataType(server);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processDefType", processDefType);
            }
            if (processDefType.equals("ProcessDef")) {
                isGenericSvr = true;
            } else {
                String cmdToXqt = (String)cs.getAttribute(s, processDef, "executableName");
                if (cmdToXqt != null && cmdToXqt.indexOf("java") < 0 && !cmdToXqt.equals("/QSYS.LIB/QEJBAS5.LIB/QEJBSVR.PGM")) {
                    isGenericSvr = true;
                } else {
                    String executableTarget = (String)cs.getAttribute(s, processDef, "executableTarget");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "executableTarget", executableTarget);
                    }
                    if (executableTarget != null && !executableTarget.equals("com.ibm.ws.runtime.WsServer")) {
                        isGenericSvr = true;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is5XGenericServer" + isGenericSvr);
        }
        return isGenericSvr;
    }
}

