/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

public class ResourceValidationCommands
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(ResourceValidationCommands.class, "management", "com.ibm.ws.management.resources.configservice");

    public List lookupResources(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupResources", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName scope = (ObjectName)cmd.getParameter("scope");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scope", scope);
        }
        String jndiName = (String)cmd.getParameter("jndiName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jndiName", jndiName);
        }
        Boolean currentScopeOnly = (Boolean)cmd.getParameter("currentScopeOnly");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentScopeOnly", currentScopeOnly);
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "J2EEResourceFactory");
        ObjectName[][] matchesAll = new ObjectName[3][];
        matchesAll[0] = configService.queryConfigObjects(session, scope, pattern, null);
        pattern = ConfigServiceHelper.createObjectName(null, "J2CAdminObject");
        matchesAll[1] = configService.queryConfigObjects(session, scope, pattern, null);
        pattern = ConfigServiceHelper.createObjectName(null, "J2CActivationSpec");
        matchesAll[2] = configService.queryConfigObjects(session, scope, pattern, null);
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        ConfigDataId scopeId = ConfigServiceHelper.getConfigDataId(scope);
        String scopeContext = scopeId.getContextUri();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeContext");
        }
        for (int j = 0; j < matchesAll.length; ++j) {
            ObjectName[] matches = matchesAll[j];
            if (matches == null) continue;
            for (int i = 0; i < matches.length; ++i) {
                if (currentScopeOnly.booleanValue()) {
                    ConfigDataId matchId = ConfigServiceHelper.getConfigDataId(matches[i]);
                    String matchContext = matchId.getContextUri();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "matchContext", matchContext);
                    }
                    if (!matchContext.equals(scopeContext)) continue;
                }
                String thisJndi = (String)configService.getAttribute(session, matches[i], "jndiName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "thisJndi", thisJndi);
                }
                if (!jndiName.equals(thisJndi)) continue;
                result.add(matches[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupResources", result);
        }
        return result;
    }
}

