/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ResourcePropertyCommandsProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(ResourcePropertyCommandsProvider.class, "management", "com.ibm.ws.management.resources.cmdframework");

    public Object showResourceProperties(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showResourceProperties", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName target = (ObjectName)cmd.getTargetObject();
        String propertyName = (String)cmd.getParameter("propertyName");
        Object results = null;
        if (propertyName == null || propertyName.equals("")) {
            results = new AttributeList();
        }
        List properties = this.getProperties(configService, session, target);
        for (ObjectName resourceProperty : properties) {
            String value;
            String name = (String)configService.getAttribute(session, resourceProperty, "name");
            if (propertyName == null || propertyName.equals("")) {
                value = (String)configService.getAttribute(session, resourceProperty, "value");
                ConfigServiceHelper.setAttributeValue((AttributeList)results, name, value);
                continue;
            }
            if (!name.equalsIgnoreCase(propertyName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found property " + propertyName);
            }
            value = (String)configService.getAttribute(session, resourceProperty, "value");
            results = value;
            break;
        }
        Tr.exit(tc, "showResourceProperties", results);
        return results;
    }

    public boolean setResourceProperty(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showResourceProperties", cmd);
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService configService = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName target = (ObjectName)cmd.getTargetObject();
        String propertyName = (String)cmd.getParameter("propertyName");
        String propertyValue = (String)cmd.getParameter("propertyValue");
        ArrayList setParameters = (ArrayList)cmd.listSetParams();
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "name", propertyName);
        ConfigServiceHelper.setAttributeValue(attrList, "value", propertyValue);
        if (setParameters.contains("propertyType")) {
            String propertyTypeValue = (String)cmd.getParameter("propertyType");
            ConfigServiceHelper.setAttributeValue(attrList, "type", propertyTypeValue);
        }
        if (setParameters.contains("propertyDescription")) {
            String propertyDescriptionValue = (String)cmd.getParameter("propertyDescription");
            ConfigServiceHelper.setAttributeValue(attrList, "description", propertyDescriptionValue);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Property Attributes are " + attrList);
        }
        List properties = this.getProperties(configService, session, target);
        boolean propExist = false;
        for (ObjectName resourceProperty : properties) {
            String name = (String)configService.getAttribute(session, resourceProperty, "name");
            if (!name.equalsIgnoreCase(propertyName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found property " + propertyName);
            }
            configService.setAttributes(session, resourceProperty, attrList);
            propExist = true;
            break;
        }
        if (!propExist) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find the property name " + propertyName + ".  Create a new one");
            }
            AttributeList propSets = configService.getAttributes(session, target, new String[]{"propertySet"}, false);
            ObjectName propSet = (ObjectName)ConfigServiceHelper.getAttributeValue(propSets, "propertySet");
            configService.addElement(session, propSet, "resourceProperties", attrList, -1);
        }
        Tr.exit(tc, "setResourceProperty");
        return true;
    }

    private List getProperties(ConfigService configService, Session session, ObjectName resourceObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showResourceProperties", new Object[]{configService, session, resourceObj});
        }
        AttributeList attrList = configService.getAttributes(session, resourceObj, new String[]{"propertySet"}, false);
        ObjectName propSet = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "propertySet");
        attrList = configService.getAttributes(session, propSet, new String[]{"resourceProperties"}, false);
        List props = (List)ConfigServiceHelper.getAttributeValue(attrList, "resourceProperties");
        Tr.exit(tc, "setResourceProperty", props);
        return props;
    }
}

