/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.properties;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Props {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(Props.class, "Props", "com.ibm.ws.management.resources.configservice");
    private String name;
    private String value;

    public Props() {
    }

    public Props(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValue", this.value);
        }
        String val = new String(this.value);
        if ((val = this.getValuePart(val)).contains("&#xA;")) {
            val = val.replaceAll("&#xA;", "\n");
        }
        if (val.contains("&#x9;")) {
            val = val.replaceAll("&#x9;", "\t");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValue ", val);
        }
        return val;
    }

    public boolean isArray() {
        return this.value.startsWith("{") && this.value.indexOf(125) > 0;
    }

    public boolean isVariable() {
        return this.value.startsWith("!");
    }

    public List getValues() {
        String val;
        int inx;
        ArrayList<String> vals = new ArrayList<String>();
        if (this.value.startsWith("{") && (inx = (val = new String(this.value)).lastIndexOf(125)) > 0) {
            val = val.substring(1, inx);
            StringTokenizer st = new StringTokenizer(val, ",");
            while (st.hasMoreTokens()) {
                String v = st.nextToken();
                vals.add(v);
            }
        }
        return vals;
    }

    public String getType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType", this.value);
        }
        String type = "String";
        String val = new String(this.value);
        val = this.getDescriptionPart(val);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "val is ", val);
        }
        if (val != null) {
            StringTokenizer st = new StringTokenizer(val, "#, ");
            if (st.hasMoreTokens()) {
                type = st.nextToken();
            }
            if (type.equals("required") && st.hasMoreTokens()) {
                type = st.nextToken();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType", type);
        }
        return type;
    }

    public boolean isRequired() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRequired", this.value);
        }
        boolean result = false;
        String reqd = "false";
        String val = new String(this.value);
        val = this.getDescriptionPart(val);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "val = ", val);
        }
        if (val != null) {
            StringTokenizer st = new StringTokenizer(val, "#, ");
            if (st.hasMoreTokens()) {
                reqd = st.nextToken();
            }
            if (!reqd.equals("required") && st.hasMoreTokens()) {
                reqd = st.nextToken();
            }
        }
        if (reqd.equals("required")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRequired", "true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRequired", "false");
        }
        return false;
    }

    private String getValuePart(String val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValuePart", this.value);
        }
        val.trim();
        if (val.startsWith("{")) {
            String val1 = new String(val);
            int inx = val1.lastIndexOf(125);
            if (inx > 0) {
                val = val1.substring(0, inx + 1);
            }
            return val;
        }
        if (val.startsWith("\"")) {
            val = val.substring(1, val.lastIndexOf("\""));
            return val;
        }
        int inx = val.lastIndexOf("#");
        if (inx != -1) {
            String res = val.substring(0, inx).trim();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getValuePart", res);
            }
            return res;
        }
        String res = val.trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValuePart", res);
        }
        return res;
    }

    private String getDescriptionPart(String val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescriptionPart", this.value);
        }
        int valEndIndex = -1;
        if (val.startsWith("\"")) {
            valEndIndex = val.lastIndexOf("\"");
            val = val.substring(1, valEndIndex);
        }
        int inx = -1;
        inx = valEndIndex != -1 ? val.indexOf("#", valEndIndex) : val.lastIndexOf("#");
        if (inx != -1) {
            String res = val.substring(inx).trim();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDescriptionPart", res);
            }
            return res;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescriptionPart", null);
        }
        return null;
    }
}

