/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.properties;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.commands.properties.resources.common.APropertiesParser;
import com.ibm.ws.management.commands.properties.resources.properties.PropertiesFileData;
import com.ibm.ws.management.commands.properties.resources.properties.Props;
import com.ibm.ws.management.commands.properties.resources.properties.Section;
import com.ibm.ws.management.commands.properties.resources.properties.UserDefinedVariableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class PropertiesFileParser
extends APropertiesParser {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(PropertiesFileParser.class, "PropertiesFileParser", "com.ibm.ws.management.resources.configservice");
    private String lastLine = null;
    private PropertiesFileData propertiesFileData = null;
    private UserDefinedVariableMap userDefinedVariableMap = null;

    public PropertiesFileParser() {
    }

    public PropertiesFileParser(PropertiesFileData propertiesFileData, UserDefinedVariableMap userDefinedVariableMap) {
        this.propertiesFileData = propertiesFileData;
        this.userDefinedVariableMap = userDefinedVariableMap;
    }

    public PropertiesFileData getPropertiesFileData() {
        return this.propertiesFileData;
    }

    public UserDefinedVariableMap getUserDefinedVariableMap() {
        return this.userDefinedVariableMap;
    }

    public void parse(InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", new Object[]{in});
        }
        this.processSections(in);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    private void processSections(InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSections", new Object[]{in});
        }
        while (this.lastLine != null || !this.eof(in)) {
            Section s = null;
            if (this.lastLine != null) {
                String line = this.lastLine;
                this.lastLine = null;
                s = this.processSection(in, line);
                continue;
            }
            Section section = this.processSection(in);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSections");
        }
    }

    private Section processSection(InputStream in) throws Exception {
        return this.processSection(in, null);
    }

    private Section processSection(InputStream in, String lastLine) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSection", new Object[]{in});
        }
        boolean done = false;
        String configType = null;
        String implementingType = null;
        String cfgId = null;
        String extensionId = null;
        String skip = null;
        String skipSubSections = null;
        String deleteWholeSection = null;
        String createTemplate = null;
        String deleteTemplate = null;
        String createDeleteCommandProperties = null;
        String attrName = null;
        String nameField = null;
        String valueField = null;
        Props[] props = null;
        boolean foundSection = false;
        while (lastLine != null || !this.eof(in) && !done) {
            String line = null;
            if (lastLine != null) {
                line = lastLine;
                lastLine = null;
            } else {
                line = this.readln(in);
            }
            String savedLine = new String(line);
            StringTokenizer st = new StringTokenizer(line, "=");
            if (!st.hasMoreTokens()) continue;
            String tok = st.nextToken();
            if (tok.equals("EnvironmentVariablesSection")) {
                while (!this.eof(in)) {
                    this.readln(in);
                }
            }
            if (tok.equals("ResourceType")) {
                if (!foundSection) {
                    foundSection = true;
                    configType = st.nextToken();
                    continue;
                }
                this.lastLine = line;
                done = true;
                continue;
            }
            if (tok.equals("ImplementingResourceType")) {
                implementingType = st.nextToken();
                continue;
            }
            if (tok.equals("AttributeInfo")) {
                String attrInfo = st.nextToken();
                List pData = this.getPropData(new String(attrInfo));
                if (pData == null || pData.size() != 3) continue;
                attrName = (String)pData.get(0);
                nameField = (String)pData.get(1);
                valueField = (String)pData.get(2);
                continue;
            }
            if (tok.equals("ResourceId")) {
                cfgId = savedLine.substring(tok.length() + 1);
                if (this.userDefinedVariableMap == null) continue;
                cfgId = this.userDefinedVariableMap.expand(cfgId);
                continue;
            }
            if (tok.equals("ExtensionId")) {
                extensionId = st.nextToken();
                continue;
            }
            if (tok.equals("SKIP")) {
                skip = st.nextToken();
                if (this.userDefinedVariableMap == null) continue;
                skip = this.userDefinedVariableMap.expand(skip);
                continue;
            }
            if (tok.equals("DELETE")) {
                deleteWholeSection = st.nextToken();
                if (this.userDefinedVariableMap == null) continue;
                deleteWholeSection = this.userDefinedVariableMap.expand(deleteWholeSection);
                continue;
            }
            if (tok.equals("SKIPSUBSECTIONS")) {
                skipSubSections = st.nextToken();
                if (this.userDefinedVariableMap == null) continue;
                skipSubSections = this.userDefinedVariableMap.expand(skipSubSections);
                continue;
            }
            if (tok.startsWith("CreateTemplate")) {
                createTemplate = st.nextToken();
                continue;
            }
            if (tok.startsWith("DeleteTemplate")) {
                deleteTemplate = st.nextToken();
                continue;
            }
            if (tok.startsWith("CreateDeleteCommandProperties")) {
                createDeleteCommandProperties = st.nextToken();
                continue;
            }
            if (tok.startsWith("#") || tok.equals("") || tok.equals("\n") || tok.startsWith(" ")) continue;
            if (tok.equals("EndSectionHeader")) {
                done = true;
                continue;
            }
            if (tok.equals("StartSectionHeader")) continue;
            props = this.processProperties(in, line);
            done = true;
        }
        Section section = null;
        if (configType != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configType = " + configType + " configId = " + cfgId + " implementingType=" + implementingType + " attrName =" + attrName);
            }
            section = new Section(configType, implementingType, skip, skipSubSections, deleteWholeSection, createTemplate, deleteTemplate, cfgId, null, attrName, nameField, valueField);
            if (extensionId != null) {
                section.setExtensionId(extensionId);
            }
            if (createDeleteCommandProperties != null) {
                section.setCreateDeleteCommandProperties(createDeleteCommandProperties);
            }
            if (implementingType != null) {
                this.propertiesFileData.addSection(implementingType, section);
            }
            this.propertiesFileData.addSection(section);
            section.setProps(props);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSection", section);
        }
        return section;
    }

    private Props[] processProperties(InputStream in) throws Exception {
        return this.processProperties(in, null);
    }

    private Props[] processProperties(InputStream in, String lastLine) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processProperties", new Object[]{in});
        }
        ArrayList<Props> propertiesList = new ArrayList<Props>();
        Props[] properties = null;
        boolean done = false;
        while (lastLine != null || !this.eof(in) && !done) {
            String tok;
            String line = null;
            if (lastLine != null) {
                line = lastLine;
                lastLine = null;
            } else {
                line = this.readln(in);
            }
            String name = null;
            String value = null;
            String savedLine = new String(line);
            StringTokenizer st = new StringTokenizer(line, "=");
            if (st.hasMoreTokens() && !(tok = st.nextToken()).equals("") && !tok.startsWith("#")) {
                if (tok.startsWith("StartSectionHeader")) {
                    this.lastLine = line;
                    done = true;
                } else if (tok.startsWith("EnvironmentVariablesSection")) {
                    while (!this.eof(in)) {
                        this.readln(in);
                    }
                    this.lastLine = null;
                    done = true;
                } else if (tok.startsWith("ResourceType")) {
                    this.lastLine = line;
                    done = true;
                } else if (!(tok.equals("") || tok.equals("\n") || tok.startsWith(" "))) {
                    name = tok;
                    if (name.equals("password") || name.equals("serverPassword")) {
                        value = savedLine.length() > name.length() ? savedLine.substring(name.length() + 1) : null;
                    } else {
                        if (st.hasMoreTokens()) {
                            value = st.nextToken();
                        }
                        while (st.hasMoreTokens()) {
                            value = value.concat("=") + st.nextToken();
                        }
                    }
                }
            }
            if (name == null || value == null) continue;
            if (this.userDefinedVariableMap != null) {
                value = this.userDefinedVariableMap.expand(value);
            }
            Props pData = new Props(name, value);
            propertiesList.add(pData);
        }
        properties = propertiesList.toArray(new Props[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processProperties", properties);
        }
        return properties;
    }

    private String readln(InputStream in) throws Exception {
        char[] charr = new char[2046];
        String str = null;
        try {
            int ch = 0;
            int i = 0;
            while (ch != 10 && (ch = in.read()) != -1) {
                if (ch == 10 || ch == 13) continue;
                charr[i] = (char)ch;
                ++i;
            }
            str = new String(charr, 0, i);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Line read ", str);
        }
        return str;
    }

    private boolean eof(InputStream in) throws Exception {
        return in.available() <= 0;
    }

    private List getPropData(String cfgId) {
        ArrayList<String> pData = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(cfgId, ",()");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            pData.add(tok);
        }
        return pData;
    }
}

