/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.mapping;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.commands.properties.resources.common.APropertiesParser;
import com.ibm.ws.management.commands.properties.resources.mapping.CommandInfo;
import com.ibm.ws.management.commands.properties.resources.mapping.GlobalMappingFileData;
import com.ibm.ws.management.commands.properties.resources.mapping.MappingFileData;
import com.ibm.ws.management.commands.properties.resources.mapping.PropertyData;
import com.ibm.ws.management.commands.properties.resources.mapping.SectionData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class PropertiesMappingFileParser
extends APropertiesParser {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(PropertiesMappingFileParser.class, "PropertiesMappingFileParser", "com.ibm.ws.management.resources.configservice");
    private String configType;
    private List subTypesList = null;
    private MappingFileData mappingData;
    private String commentsSaved = null;
    private int inx = 0;

    public PropertiesMappingFileParser(String configType) {
        this.configType = configType;
        this.subTypesList = new ArrayList();
    }

    public void parse(InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", new Object[]{in});
        }
        this.processTopSection(in);
        String[] subTypes = this.subTypesList.toArray(new String[0]);
        this.mappingData = new MappingFileData(this.configType, subTypes);
        GlobalMappingFileData.add(this.configType, this.mappingData);
        this.processSections(in);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    private void processSections(InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSections", new Object[]{in});
        }
        while (!this.eof(in)) {
            if (this.commentsSaved != null) {
                String comments = this.commentsSaved;
                this.commentsSaved = null;
                this.processSection(in, comments);
                continue;
            }
            this.processSection(in);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSections");
        }
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public void addSubType(String subType) {
        this.subTypesList.add(subType);
    }

    private void processTopSection(InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTopSection", new Object[]{in});
        }
        boolean done = false;
        block0: while (!this.eof(in) && !done) {
            String line = this.readln(in);
            StringTokenizer st = new StringTokenizer(line, "=,|");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.equals("Type")) {
                    String configType = st.nextToken();
                    this.setConfigType(configType);
                    continue block0;
                }
                if (tok.equals("SubTypes")) {
                    while (st.hasMoreTokens()) {
                        String subType = st.nextToken();
                        this.addSubType(subType);
                    }
                    done = true;
                    continue block0;
                }
                if (!tok.startsWith("#") && !tok.equals("") && !tok.equals("\n") && !tok.startsWith(" ")) continue;
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTopSection");
        }
    }

    private void processSection(InputStream in) throws Exception {
        this.processSection(in, null);
    }

    private void processSection(InputStream in, String comment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSection", new Object[]{in, comment});
        }
        String comments = null;
        String type = null;
        String containingType = null;
        String attrName = null;
        Boolean isNested = null;
        Boolean isCollection = null;
        String collectionType = null;
        ArrayList<String> collectionAttrs = null;
        String propType = null;
        String propRequired = null;
        PropertyData[] properties = null;
        boolean done = false;
        String name = null;
        String value = null;
        ArrayList<CommandInfo> cmds = new ArrayList<CommandInfo>();
        comments = comment;
        while (!this.eof(in) && !done) {
            StringTokenizer s;
            String l;
            CommandInfo cmd;
            String commandName;
            String line = this.readln(in);
            StringTokenizer st = new StringTokenizer(line, "=,|");
            if (!st.hasMoreTokens()) continue;
            String tok = st.nextToken();
            if (tok.equals("Type")) {
                type = st.nextToken();
                continue;
            }
            if (tok.equals("Nested")) {
                isNested = new Boolean(st.nextToken());
                continue;
            }
            if (tok.equals("Collection")) {
                isCollection = new Boolean(st.nextToken());
                continue;
            }
            if (tok.equals("AttributeName")) {
                attrName = st.nextToken();
                continue;
            }
            if (tok.equals("ContainingType")) {
                containingType = st.nextToken();
                continue;
            }
            if (tok.equals("GetCommandName")) {
                commandName = st.nextToken();
                cmd = this.getCommandInfo("get", commandName, in);
                cmds.add(cmd);
                continue;
            }
            if (tok.equals("SetCommandName")) {
                commandName = st.nextToken();
                cmd = this.getCommandInfo("set", commandName, in);
                cmds.add(cmd);
                continue;
            }
            if (tok.equals("NameValuePair")) {
                l = this.readln(in);
                while (l.startsWith("#")) {
                    l = this.readln(in);
                }
                s = new StringTokenizer(l, "=,|");
                name = s.nextToken();
                if (!name.equals("Name")) {
                    throw new Exception("Parsing error");
                }
                name = s.nextToken();
                l = this.readln(in);
                while (l.startsWith("#")) {
                    l = this.readln(in);
                }
                s = new StringTokenizer(l, "=,|");
                value = s.nextToken();
                if (!value.equals("Value")) {
                    throw new Exception("Parsing error");
                }
                value = s.nextToken();
                if (s.hasMoreTokens()) {
                    propType = s.nextToken();
                }
                if (s.hasMoreTokens()) {
                    propRequired = s.nextToken();
                }
                l = this.readln(in);
                while (l.startsWith("#")) {
                    l = this.readln(in);
                }
                s = new StringTokenizer(l, "=,|");
                String coll = s.nextToken();
                if (!coll.equals("CollectionType")) {
                    throw new Exception("Parsing error");
                }
                collectionType = s.nextToken();
                done = true;
                continue;
            }
            if (tok.equals("Comments")) {
                comments = st.nextToken();
                continue;
            }
            if (tok.startsWith("#") || tok.equals("") || tok.equals("\n") || tok.startsWith(" ")) continue;
            if (tok.equals("CollectionType")) {
                collectionType = st.nextToken();
                collectionAttrs = new ArrayList<String>();
                l = this.readln(in);
                s = new StringTokenizer(l, "=,|");
                String attrs = s.nextToken();
                while (s.hasMoreTokens()) {
                    collectionAttrs.add(s.nextToken());
                }
                done = true;
                continue;
            }
            properties = this.processProperties(line, in);
            done = true;
        }
        SectionData section = null;
        if (type != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " propType " + propType + " required " + propRequired);
            }
            section = new SectionData(comments, type, containingType, this.configType, attrName, isCollection, name, value, properties, isNested, collectionType, collectionAttrs);
            if (propType != null) {
                section.setPropType(propType);
            }
            if (propRequired != null) {
                section.setPropRequired(propRequired);
            }
            if (cmds.size() > 0) {
                section.setCommands(cmds);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Section created ", section);
        }
        if (section != null) {
            this.mappingData.addSection(section);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSection");
        }
    }

    private PropertyData[] procesProperties(InputStream in) throws Exception {
        return this.processProperties(null, in);
    }

    private PropertyData[] processProperties(String firstLine, InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processProperties", new Object[]{firstLine, in});
        }
        String propName = null;
        String attrName = null;
        String type = null;
        boolean readOnly = false;
        boolean propRequired = false;
        boolean propType = false;
        boolean createParam = false;
        String variableName = null;
        ArrayList<PropertyData> propertiesList = new ArrayList<PropertyData>();
        PropertyData[] properties = null;
        ArrayList<String> enumValList = new ArrayList<String>();
        String[] enumVals = null;
        boolean done = false;
        while (!(this.eof(in) && firstLine == null || done)) {
            String tok;
            boolean foundNewProperty = false;
            String line = null;
            if (firstLine != null) {
                line = firstLine;
                firstLine = null;
            } else {
                line = this.readln(in);
            }
            line = line.trim();
            if (line.startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(line, "=,|() #");
            type = "String";
            if (st.hasMoreTokens() && !(tok = st.nextToken()).equals("")) {
                if (tok.equals("EndOfCommand")) {
                    done = true;
                } else if (tok.equals("Comments")) {
                    this.commentsSaved = st.nextToken("=\n");
                    done = true;
                } else if (!tok.equals("\n") && !tok.startsWith(" ") && st.hasMoreTokens()) {
                    foundNewProperty = true;
                    attrName = tok;
                    propName = st.nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pname and attrName ", new Object[]{propName, attrName});
                    }
                    while (st.hasMoreTokens()) {
                        tok = st.nextToken();
                        if (tok.equals("ENUM")) {
                            type = tok;
                            if (st.hasMoreTokens()) {
                                String enumStr = st.nextToken("#");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "enum str", enumStr);
                                }
                                StringTokenizer est = null;
                                est = enumStr != null && !enumStr.equals("") ? new StringTokenizer(enumStr, "=,|() #") : st;
                                while (est.hasMoreTokens()) {
                                    String etok = est.nextToken();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "etok", etok);
                                    }
                                    if (etok.equals("")) break;
                                    enumValList.add(etok);
                                }
                            }
                            if (st.hasMoreTokens()) {
                                tok = st.nextToken("=,|() #");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "tok", tok);
                                }
                            }
                        }
                        if (tok.startsWith("int")) {
                            type = tok;
                            continue;
                        }
                        if (tok.startsWith("long")) {
                            type = tok;
                            continue;
                        }
                        if (tok.startsWith("boolean")) {
                            type = tok;
                            continue;
                        }
                        if (tok.startsWith("ObjectName")) {
                            type = tok;
                            continue;
                        }
                        if (tok.startsWith("String")) {
                            type = tok;
                            continue;
                        }
                        if (tok.equals("readonly")) {
                            readOnly = true;
                            continue;
                        }
                        if (tok.equals("createparam")) {
                            createParam = true;
                            continue;
                        }
                        if (tok.equals("required")) {
                            propRequired = true;
                            continue;
                        }
                        if (tok.startsWith("variablize")) {
                            int vi = tok.indexOf("_");
                            variableName = tok.substring(vi + 1);
                            continue;
                        }
                        if (tok.equals("type")) {
                            propType = true;
                            continue;
                        }
                        if (!tok.equals("")) continue;
                    }
                }
            }
            if (!foundNewProperty) continue;
            enumVals = enumValList.toArray(new String[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property processed = ", new Object[]{propName, attrName, type, enumVals});
            }
            PropertyData pData = new PropertyData(propName, attrName, type, enumVals, createParam, readOnly, propRequired, propType);
            pData.setVariableName(variableName);
            propertiesList.add(pData);
            readOnly = false;
            createParam = false;
            propRequired = false;
            propType = false;
            enumVals = null;
            propName = null;
            attrName = null;
            type = null;
            variableName = null;
        }
        properties = propertiesList.toArray(new PropertyData[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processProperties", properties);
        }
        return properties;
    }

    private String readln(InputStream in) throws Exception {
        char[] charr = new char[2046];
        String str = null;
        try {
            int ch = 0;
            int i = 0;
            while (ch != 10 && (ch = in.read()) != -1) {
                if (ch == 10 || ch == 13) continue;
                charr[i] = (char)ch;
                ++i;
            }
            str = new String(charr, 0, i);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Line read ", str);
        }
        return str;
    }

    private boolean eof(InputStream in) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "eof ", new Integer(in.available()));
        }
        return in.available() <= 0;
    }

    private CommandInfo getCommandInfo(String commandType, String commandName, InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandInfo", commandName);
        }
        boolean done = false;
        String commandResult = null;
        PropertyData[] propData = null;
        while (!this.eof(in) && !done) {
            String line = this.readln(in);
            StringTokenizer st = new StringTokenizer(line, "=,|");
            if (!st.hasMoreTokens()) continue;
            String tok = st.nextToken();
            if (tok.equals("CommandResult")) {
                commandResult = st.nextToken();
                continue;
            }
            if (tok.equals("EndOfCommand")) {
                done = true;
                continue;
            }
            propData = this.processProperties(line, in);
            done = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandName=" + commandName + " commandResult=" + commandResult);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "propertyData=" + propData);
        }
        CommandInfo cmdInfo = new CommandInfo(commandType, commandName, commandResult, propData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandInfo", cmdInfo);
        }
        return cmdInfo;
    }
}

