/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.ApplyProperties;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.wasresource.common.PropWASResource;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wasresource.common.WASResourceUtilities;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.xml.namespace.QName;

public class AuthorizationGroup
extends PropWASResource {
    private static final TraceComponent tc = Tr.register(AuthorizationGroup.class, null, null);

    public String getResourceType() {
        return "AuthorizationGroup";
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{scope, containmentPath, this});
        }
        List result = null;
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = this.getResourceType();
        }
        if (containmentPath.equals("NONEXISTENTRESOURCE")) {
            result = super.getConfigResourceInstanceForCreate(containmentPath, false, this.getResourceType());
        } else {
            result = super.getConfigResourceInstances(session, scope, containmentPath, false);
            if (containmentPath.equals(this.getResourceType())) {
                result.addAll(this.getConfigResourceInstanceForCellAuthorizationGroup(containmentPath, false, this.getResourceType()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", result);
        }
        return result;
    }

    private List getConfigResourceInstanceForCellAuthorizationGroup(String containmentPath, boolean resolveMbeanID, String resType) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigResourceInstanceForCellLevelAuthorizationGroup", new Object[]{containmentPath, resolveMbeanID, resType});
        }
        ArrayList<WASResourceReferenceParameters> result = new ArrayList<WASResourceReferenceParameters>();
        try {
            HashMap<QName, String> refProps = new HashMap<QName, String>();
            refProps.put(WASResourcesConstants.WAS_WSDM_Resource_Type, resType);
            refProps.put(WASResourcesConstants.WAS_WSDM_Resource_MRID, WASResourceUtilities.constructMRID(resType, "CellAuthorizationGroup"));
            refProps.put(WASResourcesConstants.WAS_WSDM_Resource_ConfigID, "CellAuthorizationGroup");
            WASResourceReferenceParameters resourceEpr = new WASResourceReferenceParameters("", refProps);
            result.add(resourceEpr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigResourceInstanceForCellLevelAuthorizationGroup", result);
        }
        return result;
    }

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        String configId = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
        boolean restore = false;
        if (configId != null && configId.equals("CellAuthorizationGroup")) {
            eprRefProps.remove(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
            restore = true;
        }
        super.initialize(eprRefProps);
        if (restore) {
            this.getReferenceProperties().put(WASResourcesConstants.WAS_WSDM_Resource_ConfigID, "CellAuthorizationGroup");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public SectionedProperties[] getCreateTemplateProperties() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateTemplateProperties");
        }
        SectionedProperties[] props = null;
        try {
            Boolean create = (Boolean)this.getReferenceProperties().get("CREATERESOURCE");
            ArrayList<SectionedProperties> allProps = new ArrayList<SectionedProperties>();
            if (create != null && create.booleanValue()) {
                String configType;
                String resType = this.getCurrentResourceType();
                String string = configType = this.getConfigData() != null ? ConfigServiceHelper.getConfigDataType(this.getConfigData()) : null;
                if (resType != null && resType.equals(this.getResourceType()) && (configType == null || configType != null && configType.equals(resType))) {
                    SectionedProperties[] props1 = ConfigPropertiesHelper.getPropertiesForCommand("createAuthorizationGroup", this, true);
                    for (int i = 0; props1 != null && i < props1.length; ++i) {
                        allProps.add(props1[i]);
                    }
                }
            }
            if (allProps.size() > 0) {
                props = allProps.toArray(new SectionedProperties[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateTemplateProperties", props);
        }
        return props;
    }

    public SectionedProperties[] getDeleteTemplateProperties() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeleteTemplateProperties");
        }
        SectionedProperties[] props = null;
        try {
            Boolean delete = (Boolean)this.getReferenceProperties().get("DELETERESOURCE");
            ArrayList<SectionedProperties> allProps = new ArrayList<SectionedProperties>();
            if (delete != null && delete.booleanValue()) {
                String configType;
                String resType = this.getCurrentResourceType();
                String string = configType = this.getConfigData() != null ? ConfigServiceHelper.getConfigDataType(this.getConfigData()) : null;
                if (resType != null && resType.equals(this.getResourceType()) && (configType == null || configType != null && configType.equals(resType))) {
                    SectionedProperties[] props1 = ConfigPropertiesHelper.getPropertiesForCommand("deleteAuthorizationGroup", this, false);
                    for (int i = 0; props1 != null && i < props1.length; ++i) {
                        allProps.add(props1[i]);
                    }
                }
            }
            if (allProps.size() > 0) {
                SectionedProperties sp = (SectionedProperties)allProps.get(0);
                String comments = sp.getComments();
                StringBuffer sb = new StringBuffer(comments);
                sb = sb.append("\n# Update ResourceId field with actual authorizationGroupName ( ResourceId=AuthorizationGroup=agName ) \n#\n");
                sp.setComments(sb.toString());
                props = allProps.toArray(new SectionedProperties[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeleteTemplateProperties", props);
        }
        return props;
    }

    public Properties getProperties() throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", this);
        }
        Properties props = new Properties();
        List allPropNames = this.getAllPropertyNames();
        for (int i = 0; i < allPropNames.size(); ++i) {
            String pName = (String)allPropNames.get(i);
            props.setProperty(pName, this.getProperty(pName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public String getProperty(String name) throws UnknownResourceTypeException, WASResourceException {
        String propValue = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", name);
        }
        try {
            propValue = this.getPropertyValue(name);
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", propValue);
        }
        return propValue;
    }

    public void setProperty(String name, String value) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", new Object[]{name, value});
        }
        try {
            this.setPropertyValue(name, value);
        }
        catch (Exception e) {
            throw new WASResourceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public String[] validateProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        String[] result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateProperties", props);
        }
        this.setProperties(props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateProperties");
        }
        return result;
    }

    public void setProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        Boolean useCommands;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", props);
        }
        String cId = (String)this.getReferenceProperties().get("CURRENTCONFIGID");
        ObjectName on = null;
        if (cId != null && (cId.indexOf("|") > 0 || cId.indexOf("=") > 0)) {
            try {
                if (ConfigPropertiesHelper.isScopeId(cId)) {
                    on = PropertiesUtils.convertConfigScopeToConfigObject(null, cId, this.getSession(), this.getConfigService());
                } else {
                    String displayName = cId.substring(cId.lastIndexOf("/") + 1, cId.lastIndexOf("|"));
                    on = ConfigServiceHelper.createObjectName(new ConfigDataId(cId), "AuthorizationGroup", displayName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.setConfigData(on);
        if (on == null) {
            this.getReferenceProperties().put(WASResourcesConstants.WAS_WSDM_Resource_ConfigID, "CellAuthorizationGroup");
        }
        if ((useCommands = (Boolean)this.getReferenceProperties().get("USECOMMANDS")) != null && useCommands.booleanValue()) {
            super.setProperties(props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperties");
            }
            return;
        }
        Boolean create = (Boolean)this.getReferenceProperties().get("CREATERESOURCE");
        Boolean delete = (Boolean)this.getReferenceProperties().get("DELETERESOURCE");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create and delete ", new Object[]{create, delete});
        }
        if (create != null || delete != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperties cannot handle create and delete sections");
            }
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String pName = (String)e.nextElement();
            this.setProperty(pName, props.getProperty(pName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public List getRelationships(int type, boolean recursive) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{new Integer(type), new Boolean(recursive)});
        }
        ArrayList result = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", result);
        }
        return result;
    }

    public List getAllPropertyNames() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPropertyNames");
        }
        List result = super.getAllPropertyNames();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPropertyNames", result);
        }
        return result;
    }

    private String getPropertyValue(String pName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyValue", pName);
        }
        String result = null;
        boolean cellAuthGroup = false;
        String configId = (String)this.getReferenceProperties().get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
        if (configId.equals("CellAuthorizationGroup")) {
            cellAuthGroup = true;
        }
        result = pName.equals("name") ? (cellAuthGroup ? "CellAuthorizationGroup" : ConfigServiceHelper.getDisplayName(this.getConfigData())) : (pName.equals("resources") ? this.getMappedResources() : (pName.equals("administrators") ? this.getMappedUsers("administrator") : (pName.equals("configurators") ? this.getMappedUsers("configurator") : (pName.equals("operators") ? this.getMappedUsers("operator") : (pName.equals("monitors") ? this.getMappedUsers("monitor") : (pName.equals("deployers") ? this.getMappedUsers("deployer") : (pName.equals("adminsecuritymanagers") ? this.getMappedUsers("adminsecuritymanager") : (pName.equals("auditors") ? this.getMappedUsers("auditor") : this.getMappedUsers(pName)))))))));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyValue", result);
        }
        return result;
    }

    private void setPropertyValue(String pName, String pValue) throws Exception {
        Boolean deleteObj;
        boolean delete;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropertyValue", new Object[]{pName, pValue});
        }
        boolean bl = delete = (deleteObj = (Boolean)this.getReferenceProperties().get("DELETERESOURCE")) == null ? false : deleteObj;
        if (!pName.equals("name")) {
            if (pName.equals("resources")) {
                this.setResources(pValue, delete);
            } else if (pName.equals("administrators")) {
                this.setUsers(pValue, "administrator", delete);
            } else if (pName.equals("configurators")) {
                this.setUsers(pValue, "configurator", delete);
            } else if (pName.equals("operators")) {
                this.setUsers(pValue, "operator", delete);
            } else if (pName.equals("monitors")) {
                this.setUsers(pValue, "monitor", delete);
            } else if (pName.equals("deployers")) {
                this.setUsers(pValue, "deployer", delete);
            } else if (pName.equals("adminsecuritymanagers")) {
                this.setUsers(pValue, "adminsecuritymanager", delete);
            } else if (pName.equals("auditors")) {
                this.setUsers(pValue, "auditor", delete);
            } else {
                this.setUsers(pValue, pName, delete);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropertyValue");
        }
    }

    private String getMappedUsers(String roleName) throws Exception {
        String result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMappedUsers", roleName);
        }
        boolean cellAuthGroup = false;
        String groupName = null;
        String configId = (String)this.getReferenceProperties().get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
        if (configId.equals("CellAuthorizationGroup")) {
            groupName = "CellAuthorizationGroup";
            cellAuthGroup = true;
        } else {
            groupName = ConfigServiceHelper.getDisplayName(this.getConfigData());
        }
        CommandMgr cmdMgr = this.getCmdMgr(this.getConfigService());
        AdminCommand cmd = null;
        cmd = roleName.equals("auditor") ? cmdMgr.createCommand("listAuditUserIDsOfAuthorizationGroup") : cmdMgr.createCommand("listUserIDsOfAuthorizationGroup");
        cmd.setParameter("authorizationGroupName", groupName);
        cmd.setConfigSession(this.getSession());
        cmd.execute();
        HashMap users = null;
        CommandResult res = cmd.getCommandResult();
        if (res.isSuccessful()) {
            users = (HashMap)res.getResult();
        }
        String userString = AuthorizationGroup.convertHashMapToString(users, roleName, "user");
        cmd = roleName.equals("auditor") ? cmdMgr.createCommand("listAuditGroupIDsOfAuthorizationGroup") : cmdMgr.createCommand("listGroupIDsOfAuthorizationGroup");
        cmd.setParameter("authorizationGroupName", groupName);
        cmd.setConfigSession(this.getSession());
        cmd.execute();
        res = cmd.getCommandResult();
        HashMap groups = null;
        if (res.isSuccessful()) {
            groups = (HashMap)res.getResult();
        }
        String groupString = AuthorizationGroup.convertHashMapToString(groups, roleName, "group");
        result = userString.substring(0, userString.length() - 1) + groupString.substring(1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMappedUsers", result);
        }
        return result;
    }

    private String getMappedResources() throws Exception {
        String result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMappedResources");
        }
        boolean cellAuthGroup = false;
        String groupName = null;
        String configId = (String)this.getReferenceProperties().get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
        if (configId.equals("CellAuthorizationGroup")) {
            groupName = "CellAuthorizationGroup";
            cellAuthGroup = true;
        } else {
            groupName = ConfigServiceHelper.getDisplayName(this.getConfigData());
        }
        CommandMgr cmdMgr = this.getCmdMgr(this.getConfigService());
        AdminCommand cmd = cmdMgr.createCommand("listResourcesOfAuthorizationGroup");
        cmd.setParameter("authorizationGroupName", groupName);
        cmd.setConfigSession(this.getSession());
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        List resources = null;
        if (res.isSuccessful()) {
            resources = (List)res.getResult();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AuthorizationGroup.getMappedResources(): Before remove resources.size()=" + resources.size());
        }
        if (resources != null && resources.size() > 0) {
            String selfId = ConfigServiceHelper.getConfigDataId(this.getConfigData()).toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "self id " + selfId);
            }
            Iterator itr = resources.iterator();
            while (itr.hasNext()) {
                int lastIndex;
                String resId = (String)itr.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AuthorizationGroup.getMappedResources(): resId=" + resId);
                }
                if (resId.equals(selfId)) {
                    itr.remove();
                    break;
                }
                if (!ConfigServiceHelper.getConfigDataType(this.getConfigData()).equals("AuthorizationGroup") || (lastIndex = resId.lastIndexOf(35)) <= 0) continue;
                String resIdMinusAuthGrpIdNum = resId.substring(0, lastIndex);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AuthorizationGroup.getMappedResources(): resIdMinusAuthGrpIdNum=" + resIdMinusAuthGrpIdNum);
                }
                if (null == resIdMinusAuthGrpIdNum || !resIdMinusAuthGrpIdNum.equals(selfId)) continue;
                itr.remove();
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthorizationGroup.getMappedResources(): After remove resources.size()=" + resources.size());
            }
        }
        result = AuthorizationGroup.convertListToString(resources);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMappedResources", result);
        }
        return result;
    }

    private CommandMgr getCmdMgr(ConfigService configService) throws Exception {
        CommandMgr cmdMgr = null;
        cmdMgr = configService instanceof ConfigServiceProxy ? CommandMgr.getCommandMgr(((ConfigServiceProxy)configService).getAdminClient()) : CommandMgr.getCommandMgr();
        return cmdMgr;
    }

    private static String convertHashMapToString(HashMap map, String roleName, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertHashMapToString", map);
        }
        String result = "{";
        List users = (List)map.get(roleName);
        for (int i = 0; users != null && i < users.size(); ++i) {
            String userName;
            if (i != 0) {
                result = result + ",";
            }
            result = !AuthorizationGroup.specialSubject(userName = (String)users.get(i)) ? result + type + ":" + userName : result + "special:" + userName;
        }
        result = result + "}";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertHashMapToString", result);
        }
        return result;
    }

    private static String convertListToString(List lst) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertListToString", lst);
        }
        String result = "{";
        for (int i = 0; lst != null && i < lst.size(); ++i) {
            if (i != 0) {
                result = result + ",";
            }
            String resName = (String)lst.get(i);
            result = result + resName;
        }
        result = result + "}";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertListToString", result);
        }
        return result;
    }

    private static boolean specialSubject(String name) {
        return name.equals("ALLAUTHENTICATEDINTRUSTEDREALMS") || name.equals("EVERYONE") || name.equals("ALLAUTHENTICATED") || name.equals("SERVERID") || name.equals("PRIMARYADMINID");
    }

    private void setResources(String resources, boolean delete) throws Exception {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setResources", new Object[]{resources, new Boolean(delete)});
        }
        boolean cellAuthGroup = false;
        String groupName = null;
        String configId = (String)this.getReferenceProperties().get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
        if (configId.equals("CellAuthorizationGroup")) {
            groupName = "CellAuthorizationGroup";
            cellAuthGroup = true;
        } else {
            groupName = ConfigServiceHelper.getDisplayName(this.getConfigData());
        }
        List newResourceLst = this.getValues(resources);
        String existingResources = this.getMappedResources();
        List existingResourceList = this.getValues(existingResources);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AuthorizationGroup.setResources(): existingResources=" + existingResources);
            Tr.debug(tc, "AuthorizationGroup.setResources(): existingResourceList.size()=" + existingResourceList.size());
            Tr.debug(tc, "AuthorizationGroup.resources(): resources=" + resources);
            Tr.debug(tc, "AuthorizationGroup.newResourceLst.size()=" + newResourceLst.size());
        }
        Object[] oldResources = new String[existingResourceList.size()];
        Object[] newResources = new String[newResourceLst.size()];
        for (int i2 = 0; i2 < existingResourceList.size(); ++i2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthorizationGroup.setResources(): existingResourceList.get(" + i2 + ")=" + existingResourceList.get(i2));
            }
            oldResources[i2] = (String)existingResourceList.get(i2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AuthorizationGroup.setResources(): oldResources.length=" + oldResources.length);
        }
        Arrays.sort(oldResources);
        StringBuffer oldResourcesStrBuf = new StringBuffer("{");
        for (i = 0; i < oldResources.length; ++i) {
            oldResourcesStrBuf.append((String)oldResources[i]);
        }
        oldResourcesStrBuf.append("}");
        if (!delete) {
            Tr.debug(tc, "!delete is true");
            if (newResourceLst.containsAll(existingResourceList) && newResourceLst.size() == existingResourceList.size()) {
                ApplyProperties.logReport(this, "ADMG0810I", new Object[]{"resources", oldResourcesStrBuf.toString()});
                return;
            }
            for (i = 0; existingResourceList != null && i < existingResourceList.size(); ++i) {
                String resourceName = (String)existingResourceList.get(i);
                this.addRemoveResource(resourceName, groupName, true);
            }
        } else {
            for (i = 0; newResourceLst != null && i < newResourceLst.size(); ++i) {
                String resourceName = (String)newResourceLst.get(i);
                newResources[i] = resourceName;
                this.addRemoveResource(resourceName, groupName, delete);
            }
            Arrays.sort(newResources);
            StringBuffer newResourcesStrBuf = new StringBuffer("{");
            for (int i3 = 0; i3 < newResources.length; ++i3) {
                newResourcesStrBuf.append((String)newResources[i3]);
            }
            newResourcesStrBuf.append("}");
            ApplyProperties.logReport(this, "ADMG0811I", new Object[]{"resources", newResourcesStrBuf.toString(), oldResourcesStrBuf.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setResources");
        }
    }

    private void setUsers(String users, String roleName, boolean delete) throws Exception {
        ArrayList<String> specialList;
        ArrayList<String> groupList;
        ArrayList<String> userList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUsers", new Object[]{users, roleName});
        }
        boolean cellAuthGroup = false;
        String groupName = null;
        String configId = (String)this.getReferenceProperties().get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID);
        if (configId.equals("CellAuthorizationGroup")) {
            groupName = "CellAuthorizationGroup";
            cellAuthGroup = true;
        } else {
            groupName = ConfigServiceHelper.getDisplayName(this.getConfigData());
        }
        List newUsersLst = this.getValues(users);
        String existingUsers = this.getMappedUsers(roleName);
        List existingUserList = this.getValues(existingUsers);
        Object[] oldUsersAdded = new String[existingUserList.size()];
        if (!delete) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthorizationGroup.setUsers(): existingUserList.size()=" + existingUserList.size());
            }
            if (newUsersLst.containsAll(existingUserList) && newUsersLst.size() == existingUserList.size()) {
                ApplyProperties.logReport(this, "ADMG0810I", new Object[]{roleName, users});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setUsers no change");
                }
                return;
            }
            userList = new ArrayList();
            groupList = new ArrayList();
            specialList = new ArrayList();
            String uName = "";
            for (int i = 0; existingUserList != null && i < existingUserList.size(); ++i) {
                String userName = (String)existingUserList.get(i);
                if (userName.startsWith("user:")) {
                    uName = userName.substring(5);
                    userList.add(uName);
                    oldUsersAdded[i] = uName;
                    continue;
                }
                if (userName.startsWith("group:")) {
                    uName = userName.substring(6);
                    groupList.add(uName);
                    oldUsersAdded[i] = uName;
                    continue;
                }
                if (!userName.startsWith("special:")) continue;
                uName = userName.substring(8);
                specialList.add(uName);
                oldUsersAdded[i] = uName;
            }
            Arrays.sort(oldUsersAdded);
            this.addRemoveUsers(userList, groupName, roleName, true);
            this.addRemoveGroups(groupList, specialList, groupName, roleName, true);
        }
        userList = new ArrayList<String>();
        groupList = new ArrayList<String>();
        specialList = new ArrayList<String>();
        Object[] newUsersAdded = new String[newUsersLst.size()];
        String uName = "";
        for (int i = 0; newUsersLst != null && i < newUsersLst.size(); ++i) {
            String userName = (String)newUsersLst.get(i);
            if (userName.startsWith("user:")) {
                uName = userName.substring(5);
                userList.add(uName);
                newUsersAdded[i] = uName;
                continue;
            }
            if (userName.startsWith("group:")) {
                uName = userName.substring(6);
                groupList.add(uName);
                newUsersAdded[i] = uName;
                continue;
            }
            if (userName.startsWith("special:")) {
                uName = userName.substring(8);
                specialList.add(uName);
                newUsersAdded[i] = uName;
                continue;
            }
            ApplyProperties.logReport(this, "ADMG0833I", new Object[]{users});
        }
        Arrays.sort(newUsersAdded);
        this.addRemoveUsers(userList, groupName, roleName, delete);
        this.addRemoveGroups(groupList, specialList, groupName, roleName, delete);
        if (!delete) {
            int i;
            StringBuffer newUsersStrBuf = new StringBuffer("{");
            StringBuffer oldUsersStrBuf = new StringBuffer("{");
            for (i = 0; i < newUsersAdded.length; ++i) {
                newUsersStrBuf.append((String)newUsersAdded[i]);
                if (i == newUsersAdded.length - 1) continue;
                newUsersStrBuf.append(",");
            }
            newUsersStrBuf.append("}");
            for (i = 0; i < oldUsersAdded.length; ++i) {
                oldUsersStrBuf.append((String)oldUsersAdded[i]);
                if (i == oldUsersAdded.length - 1) continue;
                oldUsersStrBuf.append(",");
            }
            oldUsersStrBuf.append("}");
            ApplyProperties.logReport(this, "ADMG0811I", new Object[]{roleName, newUsersStrBuf.toString(), oldUsersStrBuf.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUsers");
        }
    }

    private List getValues(String value) {
        String val;
        int inx;
        ArrayList<String> vals = new ArrayList<String>();
        if (value.startsWith("{") && (inx = (val = new String(value)).indexOf(125)) > 0) {
            val = val.substring(0, val.indexOf(125));
            StringTokenizer st = new StringTokenizer(val, "{,}");
            while (st.hasMoreTokens()) {
                String v = st.nextToken();
                vals.add(v);
            }
        }
        return vals;
    }

    private void addRemoveResource(String resourceName, String groupName, boolean delete) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoveResource", new Object[]{resourceName, groupName, new Boolean(delete)});
        }
        CommandMgr cmdMgr = this.getCmdMgr(this.getConfigService());
        AdminCommand cmd = null;
        cmd = !delete ? cmdMgr.createCommand("addResourceToAuthorizationGroup") : cmdMgr.createCommand("removeResourceFromAuthorizationGroup");
        cmd.setConfigSession(this.getSession());
        cmd.setParameter("authorizationGroupName", groupName);
        cmd.setParameter("resourceName", resourceName);
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        if (res.isSuccessful()) {
            String msg = null;
            msg = delete ? "deleted resource " : "added resource ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + resourceName + " to authorization group " + groupName);
            }
        } else {
            String msg = null;
            msg = delete ? "failed to delete resource " : "failed to add resource ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + resourceName + " to authorization group " + groupName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoveResource");
        }
    }

    private void addRemoveUsers(List userList, String groupName, String roleName, boolean delete) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoveUsers", new Object[]{userList, roleName, groupName, new Boolean(delete)});
        }
        CommandMgr cmdMgr = this.getCmdMgr(this.getConfigService());
        AdminCommand cmd = null;
        cmd = !delete ? (roleName.equals("auditor") ? cmdMgr.createCommand("mapUsersToAuditRole") : cmdMgr.createCommand("mapUsersToAdminRole")) : (roleName.equals("auditor") ? cmdMgr.createCommand("removeUsersFromAuditRole") : cmdMgr.createCommand("removeUsersFromAdminRole"));
        cmd.setConfigSession(this.getSession());
        cmd.setParameter("authorizationGroupName", groupName);
        cmd.setParameter("roleName", roleName);
        cmd.setParameter("userids", userList.toArray(new String[0]));
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        if (res.isSuccessful()) {
            String msg = null;
            msg = delete ? "deleted userids " : "added userids ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + userList + " to authorization group " + groupName);
            }
        } else {
            String msg = null;
            msg = delete ? "failed to delete userids " : "failed to add userids ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + userList + " to authorization group " + groupName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoveUsers");
        }
    }

    private void addRemoveGroups(List groupList, List specialList, String groupName, String roleName, boolean delete) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoveGroups", new Object[]{groupList, specialList, roleName, groupName, new Boolean(delete)});
        }
        CommandMgr cmdMgr = this.getCmdMgr(this.getConfigService());
        AdminCommand cmd = null;
        cmd = !delete ? (roleName.equals("auditor") ? cmdMgr.createCommand("mapGroupsToAuditRole") : cmdMgr.createCommand("mapGroupsToAdminRole")) : (roleName.equals("auditor") ? cmdMgr.createCommand("removeGroupsFromAuditRole") : cmdMgr.createCommand("removeGroupsFromAdminRole"));
        cmd.setConfigSession(this.getSession());
        cmd.setParameter("authorizationGroupName", groupName);
        cmd.setParameter("roleName", roleName);
        cmd.setParameter("groupids", groupList.toArray(new String[0]));
        cmd.setParameter("specialSubjects", specialList.toArray(new String[0]));
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        if (res.isSuccessful()) {
            String msg = null;
            msg = delete ? "deleted groupids " : "added groupids ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + groupList + " to authorization group " + groupName);
            }
        } else {
            String msg = null;
            msg = delete ? "failed to delete groupids " : "failed to add groupids ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg + groupList + " to authorization group " + groupName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoveGroups");
        }
    }
}

