/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.EnvVariables;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class DeleteConfigPropertiesCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(DeleteConfigPropertiesCommand.class, "PropertiesConfig", BUNDLE_NAME);

    public DeleteConfigPropertiesCommand(TaskCommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
    }

    public DeleteConfigPropertiesCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            String reportFileName;
            Object fName = this.getParameter("propertiesFileName");
            Object rName = this.getParameter("reportFileName");
            String fileName = fName != null ? fName.toString() : null;
            String string = reportFileName = rName != null ? rName.toString() : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "propertiesFileName", fileName);
            }
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            File f = new File(fileName);
            if (!f.exists()) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0656E", new Object[]{this.getName(), fileName});
                throw new CommandValidationException(msg);
            }
            if (reportFileName != null) {
                f = new File(reportFileName);
                f.createNewFile();
                if (!f.canWrite()) {
                    String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0656E", new Object[]{this.getName(), reportFileName});
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (CommandValidationException cve) {
            throw cve;
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0658E", new Object[]{this.getName()});
            throw new CommandValidationException(e, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void beforeStepsExecuted() {
        block34: {
            FileOutputStream out;
            InputStream in;
            ConfigService cs;
            Session vSession;
            String deleteVarMapFile;
            TaskCommandResult result;
            block31: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "beforeStepsExecuted");
                }
                result = this.getTaskCommandResult();
                deleteVarMapFile = null;
                vSession = null;
                cs = null;
                in = null;
                out = null;
                Object fName = this.getParameter("propertiesFileName");
                Object vName = this.getParameter("variablesMapFileName");
                Object rName = this.getParameter("reportFileName");
                String filter = (String)this.getParameter("reportFilterMechanism");
                Boolean validate = (Boolean)this.getParameter("validate");
                String fileName = fName != null ? fName.toString() : null;
                String reportFileName = rName != null ? rName.toString() : null;
                String varMapFileName = vName != null ? vName.toString() : null;
                Properties varMap = (Properties)this.getParameter("variablesMap");
                CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
                cs = ch.getConfigService();
                Session session = this.getConfigSession();
                Properties vMap = PropertiesUtils.getVariables(fileName);
                if (vMap.isEmpty() && varMap == null && varMapFileName == null) {
                    EnvVariables varObject = PropertiesUtils.createDefaultVariables(cs, session);
                    vMap = varObject.getVariables();
                }
                if (varMap != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " user defined variables = " + varMap);
                    }
                    vMap.putAll((Map<?, ?>)varMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " all variables = " + vMap);
                    }
                } else if (varMapFileName != null) {
                    Properties p1 = new Properties();
                    in = new FileInputStream(new File(varMapFileName));
                    p1.load(in);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " user defined variables = " + p1);
                    }
                    vMap.putAll((Map<?, ?>)p1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " all variables = " + p1);
                    }
                }
                out = new FileOutputStream(new File(fileName + ".vars"));
                vMap.store(out, "Environment Variables");
                deleteVarMapFile = varMapFileName = fileName + ".vars";
                if (validate.booleanValue() && !ConfigPropertiesHelper.validateAndReportError(vSession = new Session(), cs, fileName, varMapFileName, varMap, reportFileName, filter, true)) {
                    String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0660E", new Object[]{this.getName()});
                    throw new Exception(msg);
                }
                ConfigPropertiesHelper.deleteProperties(session, cs, fileName, varMapFileName, varMap, reportFileName, filter);
                Object var21_22 = null;
                try {
                    if (vSession != null) {
                        cs.discard(vSession);
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e2) {
                    if (!tc.isDebugEnabled()) break block31;
                    Tr.debug(tc, "beforeStepsExecuted method received exception that will be swallowed - " + e2.getMessage());
                }
            }
            if (deleteVarMapFile != null) {
                File f = new File(deleteVarMapFile);
                f.delete();
            }
            break block34;
            {
                catch (Exception e) {
                    block32: {
                        ((CommandResultImpl)((Object)result)).setException(e);
                        String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0659E", new Object[]{this.getName()});
                        ((CommandResultImpl)((Object)result)).setResult(msg);
                        Object var21_23 = null;
                        try {
                            if (vSession != null) {
                                cs.discard(vSession);
                            }
                            if (in != null) {
                                in.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception e2) {
                            if (!tc.isDebugEnabled()) break block32;
                            Tr.debug(tc, "beforeStepsExecuted method received exception that will be swallowed - " + e2.getMessage());
                        }
                    }
                    if (deleteVarMapFile != null) {
                        File f = new File(deleteVarMapFile);
                        f.delete();
                    }
                }
            }
            catch (Throwable throwable) {
                block33: {
                    Object var21_24 = null;
                    try {
                        if (vSession != null) {
                            cs.discard(vSession);
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception e2) {
                        if (!tc.isDebugEnabled()) break block33;
                        Tr.debug(tc, "beforeStepsExecuted method received exception that will be swallowed - " + e2.getMessage());
                    }
                }
                if (deleteVarMapFile != null) {
                    File f = new File(deleteVarMapFile);
                    f.delete();
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

