/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.genericserver;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.genericserver.GenericServerHelper;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.wsspi.management.commands.server.CreateServer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;

public class CreateGenericServer
extends CreateServer {
    private static TraceComponent tc = Tr.register(CreateGenericServer.class, "admin", "com.ibm.ws.management.resources.genericserver");

    public CreateGenericServer(TaskCommandMetadata taskcommandmetadata) throws CommandNotFoundException {
        super(taskcommandmetadata);
    }

    public CreateGenericServer(CommandData commanddata) throws CommandNotFoundException, CommandLoadException {
        super(commanddata);
    }

    protected void taskCommandExecuted(boolean success) {
        CommandResult result = this.getCommandResult();
        CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
        ConfigService cs = ch.getConfigService();
        Session session = this.getConfigSession();
        WorkSpace workSpace = null;
        try {
            workSpace = WorkspaceHelper.getWorkspace(session);
        }
        catch (ConfigServiceException e) {
            e.printStackTrace();
        }
        try {
            String nodeName = (String)this.getTargetObject();
            String serverName = (String)this.getParameter("name");
            CommandStep step = this.getCommandStep("ConfigProcDef");
            String cellName = GenericServerHelper.getTheCellName(workSpace);
            String startCommand = (String)step.getParameter("startCommand");
            String startCommandArgs = (String)step.getParameter("startCommandArgs");
            String executableTargetKind = (String)step.getParameter("executableTargetKind");
            String executableTarget = (String)step.getParameter("executableTarget");
            String workingDirectory = (String)step.getParameter("workingDirectory");
            String stopCommand = (String)step.getParameter("stopCommand");
            String stopCommandArgs = (String)step.getParameter("stopCommandArgs");
            try {
                GenericServerHelper.setProcDefValues(workSpace, cellName, nodeName, serverName, startCommand, startCommandArgs, executableTargetKind, executableTarget, workingDirectory, stopCommand, stopCommandArgs);
            }
            catch (WorkSpaceException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            super.taskCommandExecuted(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object[] getTargetObjectChoices() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetObjectChoices");
        }
        Object[] choices = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        try {
            AdminCommand cmd = cmdMgr.createCommand("listManagedNodes");
            cmd.setConfigSession(this.getConfigSession());
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (result.isSuccessful()) {
                List nodes = (List)result.getResult();
                Iterator iter = nodes.iterator();
                while (iter.hasNext()) {
                    Object nodeName = iter.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeName");
                    }
                    cmd = cmdMgr.createCommand("getNodeMajorVersion");
                    cmd.setConfigSession(this.getConfigSession());
                    cmd.setParameter("nodeName", nodeName);
                    cmd.execute();
                    result = cmd.getCommandResult();
                    if (result.isSuccessful()) {
                        Object version = result.getResult();
                        if (!version.toString().equals("5")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "5.x node", nodeName);
                        }
                        iter.remove();
                        continue;
                    }
                    FFDCFilter.processException((Throwable)result.getException(), (String)"com.ibm.ws.management.commands.server.CreateGenericServer.getTargetObjectChoices", (String)"99");
                }
                choices = nodes.toArray();
            } else {
                FFDCFilter.processException((Throwable)result.getException(), (String)"com.ibm.ws.management.commands.server.CreateGenericServer.getTargetObjectChoices", (String)"104");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.server.CreateGenericServer.getTargetObjectChoices", (String)"104");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetObjectChoices", choices);
        }
        return choices;
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        String nodeName = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName node = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "Node", nodeName), null)[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node", node);
            }
            ObjectName cell = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "Cell"), null)[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell", cell);
            }
            if (!cs.getAttribute(session, cell, "cellType").equals("STANDALONE") && System.getProperties().get("ConfigService.TestMode") == null && cs.queryConfigObjects(session, node, ConfigServiceHelper.createObjectName(null, "NodeAgent"), null).length == 0) {
                throw new InvalidParameterValueException(this.getName(), "nodeName", nodeName);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.server.CreateApplicationServer.validate", (String)"118");
            throw new CommandValidationException(ex, "unexpected exception");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }
}

