/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.authzgroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AuditAuthzCommandProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(AuditAuthzCommandProvider.class, "management", "com.ibm.ws.management.resources.configservice");

    public boolean mapUsersToAuditRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapUsersToAuditRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String roleName = (String)cmd.getParameter("roleName");
            String[] userids = (String[])cmd.getParameter("userids");
            String[] accessIds = (String[])cmd.getParameter("accessids");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (!(lst = this.addRemoveRoleOrGroupID(session, configService, cmd.getName(), authzGrpName, roleName, userids, null, accessIds)).isEmpty()) {
                StringBuffer msg = new StringBuffer("Invalid userids are : ");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                throw new InvalidParameterValueException(cmd.getName(), "userids", msg.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.mapUsersToAuditRole", (String)"200");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapUsersToAuditRole");
            }
        }
    }

    public boolean mapGroupsToAuditRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapGroupsToAuditRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String roleName = (String)cmd.getParameter("roleName");
            String[] gids = (String[])cmd.getParameter("groupids");
            String[] accessIds = (String[])cmd.getParameter("accessids");
            String[] specialSubjects = (String[])cmd.getParameter("specialSubjects");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (!(lst = this.addRemoveRoleOrGroupID(session, configService, cmd.getName(), authzGrpName, roleName, gids, specialSubjects, accessIds)).isEmpty()) {
                StringBuffer msg = new StringBuffer("Invalid groupids are : ");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                throw new InvalidParameterValueException(cmd.getName(), "groupids", msg.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.mapGroupsToAuditRole", (String)"241");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapGroupsToAuditRole");
            }
        }
    }

    public boolean removeUsersFromAuditRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUsersFromAuditRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String roleName = (String)cmd.getParameter("roleName");
            String[] userids = (String[])cmd.getParameter("userids");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (!(lst = this.addRemoveRoleOrGroupID(session, configService, cmd.getName(), authzGrpName, roleName, userids, null, null)).isEmpty()) {
                StringBuffer msg = new StringBuffer("Invalid userids are : ");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                throw new InvalidParameterValueException(cmd.getName(), "userids", msg.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.removeUsersFromAuditRole", (String)"242");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeUsersFromAuditRole");
            }
        }
    }

    public boolean removeGroupsFromAuditRole(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroupsFromAuditRole", new Object[]{cmd});
        }
        try {
            List lst;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            String roleName = (String)cmd.getParameter("roleName");
            String[] gids = (String[])cmd.getParameter("groupids");
            String[] specialSubjects = (String[])cmd.getParameter("specialSubjects");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + authzGrpName);
            }
            if (!(lst = this.addRemoveRoleOrGroupID(session, configService, cmd.getName(), authzGrpName, roleName, gids, specialSubjects, null)).isEmpty()) {
                StringBuffer msg = new StringBuffer("Invalid groupids are : ");
                for (String id : lst) {
                    msg.append(id);
                    msg.append(" ");
                }
                throw new InvalidParameterValueException(cmd.getName(), "groupids", msg.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.removeGroupsFromAuditRole", (String)"258");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeGroupsFromAuditRole");
            }
        }
    }

    private ObjectName resolveRoleNameToRoleID(Session session, ConfigService configService, ObjectName authzTable, String roleName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveRoleNameToRoleID", roleName);
        }
        ObjectName result = null;
        ArrayList roleList = (ArrayList)configService.getAttribute(session, authzTable, "roles", false);
        for (int i = 0; i < roleList.size(); ++i) {
            ObjectName roles = (ObjectName)roleList.get(i);
            String roleRoleName = (String)configService.getAttribute(session, roles, "roleName", false);
            if (!roleRoleName.equalsIgnoreCase(roleName)) continue;
            result = roles;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveRoleNameToRoleID", result);
        }
        return result;
    }

    private String resolveRoleIDToRoleName(Session session, ConfigService configService, ObjectName authzTable, ObjectName roleID) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveRoleIDToRoleName", roleID);
        }
        String result = null;
        ArrayList roleList = (ArrayList)configService.getAttribute(session, authzTable, "roles", false);
        for (int i = 0; i < roleList.size(); ++i) {
            ObjectName roles = (ObjectName)roleList.get(i);
            if (!roles.equals(roleID)) continue;
            result = (String)configService.getAttribute(session, roles, "roleName", false);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveRoleIDToRoleName", result);
        }
        return result;
    }

    private List addRemoveRoleOrGroupID(Session session, ConfigService configService, String cmdName, String authzGrpName, String roleName, String[] ids, String[] specialSubjects, String[] aIds) throws ConfigServiceException, ConnectorException, InvalidParameterValueException {
        ObjectName authorizationRole;
        ObjectName authorization;
        int i;
        ObjectName predefinedRoleObjectName;
        ObjectName authzGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRoleOrGroupID", new Object[]{cmdName, authzGrpName, roleName, ids});
        }
        ArrayList<String> failedList = new ArrayList<String>();
        if (authzGrpName == null || authzGrpName.equals("CellAuthorizationGroup")) {
            authzGroup = this.getCellObjectName(session, configService);
        } else {
            ObjectName[] authzGrps = this.getAuthzGroupObjectName(session, configService, authzGrpName);
            if (authzGrps == null || authzGrps.length != 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization Group: " + authzGrpName + " does not exist");
                }
                throw new InvalidParameterValueException(cmdName, "authorizationGroupName", authzGrpName);
            }
            authzGroup = authzGrps[0];
        }
        ObjectName[] authzTables = this.getAuditAuthzTables(session, configService, authzGroup);
        ObjectName authzTable = null;
        if (authzTables != null && authzTables.length == 0) {
            authzTable = this.createAuthzTableDocument(session, configService, authzGroup);
        } else {
            for (int i2 = 0; i2 < authzTables.length; ++i2) {
                String authzFileName = ConfigServiceHelper.getDisplayName(authzTables[i2]);
                if (!authzFileName.equals("audit-authz.xml")) continue;
                authzTable = authzTables[i2];
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found : " + authzFileName);
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "audit-authz.xml name is " + authzTable.getCanonicalName());
        }
        if ((predefinedRoleObjectName = this.resolveRoleNameToRoleID(session, configService, authzTable, roleName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role " + roleName + " does not exist");
            }
            throw new InvalidParameterValueException(cmdName, "roleName", roleName);
        }
        ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
        boolean found = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authorizations is " + authorizationsList);
        }
        for (i = 0; i < authorizationsList.size(); ++i) {
            authorization = (ObjectName)authorizationsList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorizations is " + authorization);
            }
            if (!(authorizationRole = (ObjectName)configService.getAttribute(session, authorization, "role", false)).equals(predefinedRoleObjectName)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorization not found ");
            }
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("role", predefinedRoleObjectName));
            configService.createConfigDataByTemplate(session, authzTable, "authorizations", attrList, null);
            authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
        }
        for (i = 0; i < authorizationsList.size(); ++i) {
            authorization = (ObjectName)authorizationsList.get(i);
            authorizationRole = (ObjectName)configService.getAttribute(session, authorization, "role", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorizationRole is " + authorizationRole);
            }
            if (!authorizationRole.equals(predefinedRoleObjectName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorizationRole found" + authorizationRole.getCanonicalName());
            }
            if (ids != null) {
                for (int j = 0; j < ids.length; ++j) {
                    ObjectName roleToDelete;
                    String id = ids[j];
                    String aId = aIds != null ? aIds[j] : null;
                    AttributeList roleAttrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(roleAttrList, "name", id);
                    if (aId != null) {
                        ConfigServiceHelper.setAttributeValue(roleAttrList, "accessId", aId);
                    }
                    if (cmdName.equals("mapUsersToAuditRole")) {
                        if (this.findRoleIDInAuthorization(session, configService, authorization, "users", id) == null) {
                            configService.createConfigData(session, authorization, "users", "UserExt", roleAttrList);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (cmdName.equals("removeUsersFromAuditRole")) {
                        roleToDelete = this.findRoleIDInAuthorization(session, configService, authorization, "users", id);
                        if (roleToDelete != null) {
                            configService.deleteConfigData(session, roleToDelete);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (cmdName.equals("mapGroupsToAuditRole")) {
                        if (this.findRoleIDInAuthorization(session, configService, authorization, "groups", id) == null) {
                            configService.createConfigData(session, authorization, "groups", "GroupExt", roleAttrList);
                            continue;
                        }
                        failedList.add(id);
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAuditRole")) continue;
                    roleToDelete = this.findRoleIDInAuthorization(session, configService, authorization, "groups", id);
                    if (roleToDelete != null) {
                        configService.deleteConfigData(session, roleToDelete);
                        continue;
                    }
                    failedList.add(id);
                }
            }
            if (specialSubjects == null || specialSubjects.length <= 0) continue;
            for (int k = 0; k < specialSubjects.length; ++k) {
                String specSubj = specialSubjects[k];
                if (specSubj.equals("ALLAUTHENTICATED")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "AllAuthenticatedUsersExt");
                    if (cmdName.equals("mapGroupsToAuditRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "AllAuthenticatedUsersExt", new AttributeList());
                            continue;
                        }
                        failedList.add("ALLAUTHENTICATED");
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAuditRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("ALLAUTHENTICATED");
                    continue;
                }
                if (specSubj.equals("PRIMARYADMINID")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "PrimaryAdminExt");
                    if (cmdName.equals("mapGroupsToAuditRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "PrimaryAdminExt", new AttributeList());
                            continue;
                        }
                        failedList.add("PRIMARYADMINID");
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAuditRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("PRIMARYADMINID");
                    continue;
                }
                if (specSubj.equals("SERVERID")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "ServerExt");
                    if (cmdName.equals("mapGroupsToAuditRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "ServerExt", new AttributeList());
                            continue;
                        }
                        failedList.add("SERVERID");
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAuditRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("SERVERID");
                    continue;
                }
                if (specSubj.equals("EVERYONE")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "EveryoneExt");
                    if (cmdName.equals("mapGroupsToAuditRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "EveryoneExt", new AttributeList());
                            continue;
                        }
                        failedList.add("EVERYONE");
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAuditRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("EVERYONE");
                    continue;
                }
                if (specSubj.equals("SERVERID")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "ServerExt");
                    if (cmdName.equals("mapGroupsToAuditRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "ServerExt", new AttributeList());
                            continue;
                        }
                        failedList.add("SERVERID");
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAuditRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("SERVERID");
                    continue;
                }
                if (specSubj.equals("PRIMARYADMINID")) {
                    ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "PrimaryAdminExt");
                    if (cmdName.equals("mapGroupsToAuditRole")) {
                        if (checkRole == null) {
                            configService.createConfigData(session, authorization, "specialSubjects", "PrimaryAdminExt", new AttributeList());
                            continue;
                        }
                        failedList.add("PRIMARYADMINID");
                        continue;
                    }
                    if (!cmdName.equals("removeGroupsFromAuditRole")) continue;
                    if (checkRole != null) {
                        configService.deleteConfigData(session, checkRole);
                        continue;
                    }
                    failedList.add("PRIMARYADMINID");
                    continue;
                }
                if (!specSubj.equals("ALLAUTHENTICATEDINTRUSTEDREALMS")) continue;
                ObjectName checkRole = this.findRoleIDInAuthorization(session, configService, authorization, "specialSubjects", "AllAuthenticatedUsersInTrustedRealmsExt");
                if (cmdName.equals("mapGroupsToAuditRole")) {
                    if (checkRole == null) {
                        configService.createConfigData(session, authorization, "specialSubjects", "AllAuthenticatedUsersInTrustedRealmsExt", new AttributeList());
                        continue;
                    }
                    failedList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
                    continue;
                }
                if (!cmdName.equals("removeGroupsFromAuditRole")) continue;
                if (checkRole != null) {
                    configService.deleteConfigData(session, checkRole);
                    continue;
                }
                failedList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRoleOrGroupID");
        }
        return failedList;
    }

    private ObjectName createAuthzTableDocument(Session session, ConfigService configService, ObjectName authzGroup) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthzTableDocument", authzGroup);
        }
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "fileName", "audit-authz.xml");
        ObjectName authzTblTemplate = null;
        ObjectName[] authzTblTemplates = configService.queryTemplates(session, "AuthorizationTableExt");
        for (int i = 0; authzTblTemplates != null && i < authzTblTemplates.length; ++i) {
            ObjectName on = authzTblTemplates[i];
            String cId = ConfigServiceHelper.getConfigDataId(on).toString();
            int inx = cId.lastIndexOf("|");
            int einx = cId.lastIndexOf("#");
            String name = cId.substring(inx + 1, einx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name = " + name);
            }
            if (!name.equals("audit-authz.xml")) continue;
            authzTblTemplate = on;
        }
        ObjectName authzDoc = configService.createConfigDataByTemplate(session, authzGroup, "AuthorizationTableExt", attrList, authzTblTemplate);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthzTableDocument", authzDoc);
        }
        return authzDoc;
    }

    private ObjectName findRoleIDInAuthorization(Session session, ConfigService configService, ObjectName authzGrp, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findRoleIDInAuthorization", new Object[]{authzGrp, type, id});
        }
        ObjectName result = null;
        ArrayList users = (ArrayList)configService.getAttribute(session, authzGrp, type, false);
        for (int i = 0; i < users.size(); ++i) {
            ObjectName role = (ObjectName)users.get(i);
            String roleName = !type.equals("specialSubjects") ? (String)configService.getAttribute(session, role, "name", false) : ConfigServiceHelper.getConfigDataType(role);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role name to check is " + roleName);
            }
            if (!roleName.equals(id)) continue;
            result = role;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findRoleIDInAuthorization", result);
        }
        return result;
    }

    private HashMap createResourceRoleMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceRoleMap");
        }
        HashMap resourceRoleMap = new HashMap(5);
        ArrayList audList = new ArrayList();
        resourceRoleMap.put("auditor", audList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceRoleMap", resourceRoleMap);
        }
        return resourceRoleMap;
    }

    private ObjectName getCellObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellObjectName", new Object[]{session, configService, this});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + cell + ". Cell Name is " + ConfigServiceHelper.getDisplayName(cell));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellObjectName", cell);
        }
        return cell;
    }

    public HashMap listAuditResourcesForUserID(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuditResourcesForUserID", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String userid = (String)cmd.getParameter("userid");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user id to find is " + userid);
            }
            HashMap hashMap = this.listAuthzGrpOrResourcesAsSystem(session, configService, true, "users", userid);
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesForUserID", (String)"390");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuditResourcesForUserID");
            }
        }
    }

    public HashMap listAuditResourcesForGroupID(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuditResourcesForGroupID", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String groupid = (String)cmd.getParameter("groupid");
            String type = "groups";
            if (groupid.equals("EVERYONE")) {
                groupid = "EveryoneExt";
                type = "specialSubjects";
            } else if (groupid.equals("ALLAUTHENTICATED")) {
                groupid = "AllAuthenticatedUsersExt";
                type = "specialSubjects";
            } else if (groupid.equals("SERVERID")) {
                groupid = "ServerExt";
                type = "specialSubjects";
            } else if (groupid.equals("PRIMARYADMINID")) {
                groupid = "PrimaryAdminExt";
                type = "specialSubjects";
            } else if (groupid.equals("ALLAUTHENTICATEDINTRUSTEDREALMS")) {
                groupid = "AllAuthenticatedUsersInTrustedRealmsExt";
                type = "specialSubjects";
            }
            HashMap hashMap = this.listAuthzGrpOrResourcesAsSystem(session, configService, true, type, groupid);
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesForGroupID", (String)"454");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuditResourcesForGroupID");
            }
        }
    }

    public HashMap listAuditAuthorizationGroupsForUserID(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroupsForUserID", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String userid = (String)cmd.getParameter("userid");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user id to find is " + userid);
            }
            HashMap hashMap = this.listAuthzGrpOrResources(session, configService, false, "users", userid);
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesForUser", (String)"390");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroupsForUser");
            }
        }
    }

    public HashMap listAuditAuthorizationGroupsForGroupID(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroupsForGroupID", new Object[]{cmd});
        }
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String groupid = (String)cmd.getParameter("groupid");
            String type = "groups";
            if (groupid.equals("EVERYONE")) {
                groupid = "EveryoneExt";
                type = "specialSubjects";
            } else if (groupid.equals("ALLAUTHENTICATED")) {
                groupid = "AllAuthenticatedUsersExt";
                type = "specialSubjects";
            } else if (groupid.equals("PRIMARYADMINID")) {
                groupid = "PrimaryAdminExt";
                type = "specialSubjects";
            } else if (groupid.equals("SERVERID")) {
                groupid = "ServerExt";
                type = "specialSubjects";
            } else if (groupid.equals("ALLAUTHENTICATEDINTRUSTEDREALMS")) {
                groupid = "AllAuthenticatedUsersInTrustedRealmsExt";
                type = "specialSubjects";
            }
            HashMap hashMap = this.listAuthzGrpOrResources(session, configService, false, type, groupid);
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listResourcesForUser", (String)"421");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroupsForGroup");
            }
        }
    }

    public HashMap listAuditGroupIDsOfAuthorizationGroup(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listGroupIDsOfAuthorizationGroup", new Object[]{cmd});
        }
        HashMap resourceRoleMap = null;
        try {
            HashMap hashMap = resourceRoleMap = this.listIDsOfAuthozGroup(cmd, "groups");
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listGroupIDsOfAuthorizationGroup", (String)"568");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listGroupIDsOfAuthorizationGroup", resourceRoleMap);
            }
        }
    }

    public HashMap listAuditUserIDsOfAuthorizationGroup(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listUserIDsOfAuthorizationGroup", new Object[]{cmd});
        }
        HashMap resourceRoleMap = null;
        try {
            HashMap hashMap = resourceRoleMap = this.listIDsOfAuthozGroup(cmd, "users");
            return hashMap;
        }
        catch (Exception cse) {
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listUserIDsOfAuthorizationGroup", (String)"568");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listUserIDsOfAuthorizationGroup", resourceRoleMap);
            }
        }
    }

    private HashMap listIDsOfAuthozGroup(AbstractAdminCommand cmd, String type) throws Exception {
        HashMap hashMap;
        ObjectName authzTable;
        ObjectName[] authzTables;
        Session session;
        ConfigService configService;
        HashMap resourceRoleMap;
        block24: {
            ObjectName authzGrpObjName;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listUserIDsForAuthorizationGroup", new Object[]{cmd});
            }
            resourceRoleMap = null;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            configService = helper.getConfigService();
            session = cmd.getConfigSession();
            String authzGrpName = (String)cmd.getParameter("authorizationGroupName");
            if (authzGrpName == null || authzGrpName.equals("CellAuthorizationGroup")) {
                authzGrpObjName = this.getCellObjectName(session, configService);
            } else {
                ObjectName[] authzGroup = this.getAuthzGroupObjectName(session, configService, authzGrpName);
                if (authzGroup == null || authzGroup.length <= 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Authorization Group: " + authzGrpName + " does not exist");
                    }
                    throw new InvalidParameterValueException(cmd.getName(), "authorizationGroupName", authzGrpName);
                }
                authzGrpObjName = authzGroup[0];
            }
            authzTables = this.getAuditAuthzTables(session, configService, authzGrpObjName);
            authzTable = null;
            if (authzTables == null || authzTables.length != 0) break block24;
            HashMap hashMap2 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listUserIDsOfAuthorizationGroup", resourceRoleMap);
            }
            return hashMap2;
        }
        try {
            for (int i = 0; i < authzTables.length; ++i) {
                String authzFileName = ConfigServiceHelper.getDisplayName(authzTables[i]);
                if (!authzFileName.equals("audit-authz.xml")) continue;
                authzTable = authzTables[i];
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found : " + authzFileName);
                break;
            }
            resourceRoleMap = this.createResourceRoleMap();
            ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
            for (int k = 0; k < authorizationsList.size(); ++k) {
                ObjectName authz = (ObjectName)authorizationsList.get(k);
                ObjectName authzRoleID = (ObjectName)configService.getAttribute(session, authz, "role", false);
                String roleName = this.resolveRoleIDToRoleName(session, configService, authzTable, authzRoleID);
                ArrayList ids = (ArrayList)configService.getAttribute(session, authz, type, false);
                ArrayList<String> resourcesList = (ArrayList<String>)resourceRoleMap.get(roleName);
                if (resourcesList == null) {
                    resourcesList = new ArrayList<String>();
                }
                resourceRoleMap.put(roleName, resourcesList);
                for (int l = 0; l < ids.size(); ++l) {
                    ObjectName id = (ObjectName)ids.get(l);
                    String IDName = (String)configService.getAttribute(session, id, "name", false);
                    resourcesList.add(IDName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Authorization role:  " + roleName + ".  Name:  " + IDName);
                }
                if (type == null || !type.equals("groups")) continue;
                ArrayList specialSubjectsids = (ArrayList)configService.getAttribute(session, authz, "specialSubjects", false);
                for (int m = 0; m < specialSubjectsids.size(); ++m) {
                    ObjectName specialSubject = (ObjectName)specialSubjectsids.get(m);
                    String specialSubjectType = ConfigServiceHelper.getConfigDataType(specialSubject);
                    if (specialSubjectType.equals("EveryoneExt")) {
                        resourcesList.add("EVERYONE");
                        continue;
                    }
                    if (specialSubjectType.equals("AllAuthenticatedUsersExt")) {
                        resourcesList.add("ALLAUTHENTICATED");
                        continue;
                    }
                    if (specialSubjectType.equals("ServerExt")) {
                        resourcesList.add("SERVERID");
                        continue;
                    }
                    if (specialSubjectType.equals("PrimaryAdminExt")) {
                        resourcesList.add("PRIMARYADMINID");
                        continue;
                    }
                    if (!specialSubjectType.equals("AllAuthenticatedUsersInTrustedRealmsExt")) continue;
                    resourcesList.add("ALLAUTHENTICATEDINTRUSTEDREALMS");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "audit-authz.xml name is " + authzTable.getCanonicalName());
            }
            hashMap = resourceRoleMap;
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.management.commands.authzgroup.listUserIDsOfAuthorizationGroup", (String)"568");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "listUserIDsOfAuthorizationGroup", resourceRoleMap);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listUserIDsOfAuthorizationGroup", resourceRoleMap);
        }
        return hashMap;
    }

    private ObjectName[] getAuthzGroupObjectName(Session session, ConfigService configService, String authzGrpName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGroupObjectName", authzGrpName);
        }
        ObjectName[] result = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "AuthorizationGroup");
        ObjectName[] authzGroups2 = configService.queryConfigObjects(session, null, pattern, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzGroups ObjectNames are " + authzGroups2);
        }
        if (authzGrpName == null || authzGrpName.equals("")) {
            result = authzGroups2;
        } else if (authzGroups2 != null) {
            for (int i = 0; i < authzGroups2.length; ++i) {
                ObjectName authzGrp = authzGroups2[i];
                String name = (String)configService.getAttribute(session, authzGrp, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization group name to check:  " + name);
                }
                if (!name.equals(authzGrpName)) continue;
                result = new ObjectName[]{authzGrp};
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzGroupObjectName", result);
        }
        return result;
    }

    private ObjectName findAuthzGroupsWithGivenResource(Session session, ConfigService configService, ObjectName[] authzGroups2, ObjectName resource) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGroup", new Object[]{authzGroups2, resource});
        }
        String resourceID = ConfigServiceHelper.getConfigDataId(resource).toString();
        ObjectName result = null;
        boolean found = false;
        for (int i = 0; i < authzGroups2.length; ++i) {
            ObjectName authzGroup = authzGroups2[i];
            ArrayList members = (ArrayList)configService.getAttribute(session, authzGroup, "members", false);
            for (int j = 0; j < members.size(); ++j) {
                ObjectName member = (ObjectName)members.get(j);
                String memberName = (String)configService.getAttribute(session, member, "resourceName");
                if (!memberName.equals(resourceID)) continue;
                result = authzGroup;
                found = true;
                break;
            }
            if (found) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResourceInAuthzGroups", result);
        }
        return result;
    }

    private HashMap listAuthzGrpOrResourcesAsSystem(Session session, ConfigService configService, boolean isResources, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthzGrpOrResourcesAsSystem", new Object[]{new Boolean(isResources), type, id});
        }
        final Session sessionFinal = session;
        final ConfigService configServiceFinal = configService;
        final boolean isresourcesFinal = isResources;
        final String typeFinal = type;
        final String idFinal = id;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            HashMap obj = (HashMap)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuditAuthzCommandProvider.this.listAuthzGrpOrResources(sessionFinal, configServiceFinal, isresourcesFinal, typeFinal, idFinal);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthzGrpOrResourcesAsSystem", obj);
            }
            return obj;
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }

    private HashMap listAuthzGrpOrResources(Session session, ConfigService configService, boolean isResources, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthzGrpOrResources", new Object[]{type, id});
        }
        HashMap resourceRoleMap = this.createResourceRoleMap();
        ObjectName[] cellGrp = new ObjectName[]{this.getCellObjectName(session, configService)};
        this.getIdOrResourcesFromAuthzGrp(session, configService, cellGrp, resourceRoleMap, isResources, true, type, id);
        ObjectName[] authzGrps = this.getAuthzGroupObjectName(session, configService, null);
        this.getIdOrResourcesFromAuthzGrp(session, configService, authzGrps, resourceRoleMap, isResources, false, type, id);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAuthzGrpOrResources", resourceRoleMap);
        }
        return resourceRoleMap;
    }

    private HashMap getIdOrResourcesFromAuthzGrp(Session session, ConfigService configService, ObjectName[] authzGrps, HashMap resourceRoleMap, boolean isResources, boolean isCell, String type, String id) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGrpOrResources", new Object[]{authzGrps, type, id});
        }
        if (authzGrps != null) {
            block0: for (int i = 0; i < authzGrps.length; ++i) {
                ObjectName authzGroup = authzGrps[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authzGroup is " + authzGroup);
                }
                ObjectName[] authzTables = this.getAuditAuthzTables(session, configService, authzGroup);
                for (int j = 0; j < authzTables.length; ++j) {
                    ObjectName authzTable = authzTables[j];
                    ArrayList authorizationsList = (ArrayList)configService.getAttribute(session, authzTable, "authorizations", false);
                    for (int k = 0; k < authorizationsList.size(); ++k) {
                        ObjectName authz = (ObjectName)authorizationsList.get(k);
                        ObjectName user = this.findRoleIDInAuthorization(session, configService, authz, type, id);
                        if (user == null) continue;
                        ObjectName authzRoleID = (ObjectName)configService.getAttribute(session, authz, "role", false);
                        String roleName = this.resolveRoleIDToRoleName(session, configService, authzTable, authzRoleID);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found matching userid:  " + id + "  Authorization role:  " + roleName);
                        }
                        ArrayList resourcesList = (ArrayList)resourceRoleMap.get(roleName);
                        if (isResources) {
                            if (isCell) {
                                resourcesList.add("Cell");
                                continue;
                            }
                            resourcesList.addAll(this.getResourcesFromAuthorizationGroup(session, configService, authzGroup));
                            continue;
                        }
                        if (isCell) {
                            resourcesList.add("CellAuthorizationGroup");
                            continue;
                        }
                        resourcesList.add((String)configService.getAttribute(session, authzGroup, "name", false));
                    }
                    if (isCell) continue block0;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzGrpOrResources", resourceRoleMap);
        }
        return resourceRoleMap;
    }

    private List getResourcesFromAuthorizationGroup(Session session, ConfigService configService, ObjectName authzGrpObjName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcesFromAuthorizationGroup", authzGrpObjName);
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList membersList = (ArrayList)configService.getAttribute(session, authzGrpObjName, "members", false);
        for (int i = 0; i < membersList.size(); ++i) {
            ObjectName member = (ObjectName)membersList.get(i);
            String memberID = (String)configService.getAttribute(session, member, "resourceName", false);
            result.add(memberID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesFromAuthorizationGroup", result);
        }
        return result;
    }

    private ObjectName[] getAuditAuthzTables(Session session, ConfigService cs, ObjectName authzGroup) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuditAuthzTables", new Object[]{session, authzGroup});
        }
        ArrayList<ObjectName> ons = new ArrayList<ObjectName>();
        ObjectName[] authzTbls = cs.getRelationship(session, authzGroup, "AuthorizationTableExt");
        for (int i = 0; authzTbls != null && i < authzTbls.length; ++i) {
            ObjectName on = authzTbls[i];
            String cId = ConfigServiceHelper.getConfigDataId(on).toString();
            int inx = cId.lastIndexOf("|");
            int einx = cId.lastIndexOf("#");
            String name = cId.substring(inx + 1, einx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name = " + name);
            }
            if (!name.equals("audit-authz.xml")) continue;
            ons.add(on);
        }
        ObjectName[] aTables = ons.toArray(new ObjectName[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuditAuthzTables", aTables);
        }
        return aTables;
    }

    public static ObjectName[] getAuditAuthzTablesPub(Session session, ConfigService cs, ObjectName authzGroup) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAudtiAuthzTablesPub", new Object[]{session, authzGroup});
        }
        ObjectName[] aTables = new AuditAuthzCommandProvider().getAuditAuthzTables(session, cs, authzGroup);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAudtiAuthzTablesPub", aTables);
        }
        return aTables;
    }
}

