/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.management.commands.AdminAppCommands;
import com.ibm.ws.management.commands.CommandGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class AdminAppInstallCmd
extends AdminAppCommands
implements CommandGenerator {
    private static TraceComponent tc = Tr.register(AdminAppInstallCmd.class, "AdminAppInstallCmd", "com.ibm.ws.management.commands");
    public static final String SESSION_KEY = "ADMINAPP_INSTALL_CMD";
    public static final String INSTALL_CMD = "install";
    public static final String UPDATE_CMD = "update";
    public static final String MESSAGE_KEY = "ADMINAPP_HELP_INSTALL";
    private String earLocation = "";
    private String[][] userDeploymentOptions = null;
    private String[][] defaultBindingsOptions = null;
    private String name = "install";
    private String appName;

    public String getName() {
        return this.name;
    }

    public String generateScript(String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateScript");
        }
        String cmdScript = this.getInstallCmdScript(lang);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateScript", new Object[]{cmdScript});
        }
        return cmdScript;
    }

    public String getDescription(Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescription");
        }
        String desc = TraceNLS.getStringFromBundle("com.ibm.ws.scripting.resources.wscpMessage", MESSAGE_KEY, locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescription", new Object[]{desc});
        }
        return desc;
    }

    public String toString() {
        return super.toString();
    }

    public String getInstallCmdScript(String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstallCmdScript");
        }
        String script = this.getInstallCmdScript(this.getDiffHash(), lang);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstallCmdScript", new Object[]{script});
        }
        return script;
    }

    public String getInstallCmdScript(Hashtable taskHash, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstallCmdScript");
        }
        String cmdScript = "";
        if (this.isUpdate()) {
            String override = " -operation update -contents " + this.earLocation + " ";
            if (lang.equals("jacl")) {
                cmdScript = "AdminApp " + this.getName() + " " + this.appName + " " + "app" + " " + this.makeParamsString(taskHash, lang, override);
            } else if (lang.equals("jython")) {
                cmdScript = "AdminApp." + this.getName() + "('" + this.appName + "', 'app', " + "'" + this.makeParamsString(taskHash, lang, override) + "' )";
            }
        } else if (lang.equals("jacl")) {
            cmdScript = "AdminApp " + this.getName() + " " + this.earLocation + " " + this.makeParamsString(taskHash, lang);
        } else if (lang.equals("jython")) {
            cmdScript = "AdminApp." + this.getName() + "('" + this.earLocation + "', " + "'" + this.makeParamsString(taskHash, lang) + "' )";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstallCmdScript", new Object[]{cmdScript});
        }
        return cmdScript;
    }

    public void setAppDeploymentOptionsData(String earLocation, String[][] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAppDeploymentOptionsData");
        }
        this.earLocation = earLocation.replaceAll("\\\\", "/");
        int numRows = taskData.length;
        int numCols = taskData[0].length;
        this.userDeploymentOptions = new String[numRows][numCols];
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                this.userDeploymentOptions[row][col] = taskData[row][col];
            }
        }
        this.clearUnusedTasks();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAppDeploymentOptionsData");
        }
    }

    public void setDefaultBindingsOptions(String[][] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultBindingsOptions");
        }
        int numRows = taskData.length;
        int numCols = taskData[0].length + 1;
        this.defaultBindingsOptions = new String[numRows][numCols];
        this.defaultBindingsOptions[0][0] = "usedefaultbindings";
        this.defaultBindingsOptions[1][0] = "AppDeploymentOption.Yes";
        for (int row = 0; row < numRows; ++row) {
            for (int col = 1; col < numCols; ++col) {
                this.defaultBindingsOptions[row][col] = taskData[row][col - 1];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultBindingsOptions");
        }
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setAppName(String newAppName) {
        this.appName = newAppName;
    }

    private boolean isUpdate() {
        return this.getName().equals(UPDATE_CMD);
    }

    private void clearUnusedTasks() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearUnusedTasks");
        }
        if (this.userDeploymentOptions == null) {
            return;
        }
        if (this.userDeploymentOptions.length != 2) {
            return;
        }
        int numCols = this.userDeploymentOptions[0].length;
        boolean deployws = false;
        boolean deployejb = false;
        boolean precompilejsp = false;
        for (int col = 0; col < numCols; ++col) {
            if (!this.userDeploymentOptions[1][col].equals("No")) continue;
            if (this.userDeploymentOptions[0][col].equals("preCompileJSPs")) {
                precompilejsp = true;
                continue;
            }
            if (this.userDeploymentOptions[0][col].equals("deployws")) {
                deployws = true;
                continue;
            }
            if (!this.userDeploymentOptions[0][col].equals("deployejb")) continue;
            deployejb = true;
        }
        if (this.defaultTaskData != null) {
            if (!deployws) {
                this.defaultTaskData.remove("WSDeployOptions");
            }
            if (!deployejb) {
                this.defaultTaskData.remove("EJBDeployOptions");
            }
            if (!precompilejsp) {
                this.defaultTaskData.remove("JSPCompileOptions");
            }
        }
        if (this.userTaskData != null) {
            if (!deployws) {
                this.defaultTaskData.remove("WSDeployOptions");
            }
            if (!deployejb) {
                this.defaultTaskData.remove("EJBDeployOptions");
            }
            if (!precompilejsp) {
                this.defaultTaskData.remove("JSPCompileOptions");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearUnusedTasks");
        }
    }

    private String makeParamsString(Hashtable taskHash, String lang) {
        return this.makeParamsString(taskHash, lang, "");
    }

    private String makeParamsString(Hashtable taskHash, String lang, String override) {
        String CB;
        String OB;
        String SP;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeParamsString");
        }
        String ret = "";
        if (lang.equals("jacl")) {
            SP = " ";
            OB = "{";
            CB = "}";
        } else if (lang.equals("jython")) {
            SP = " ";
            OB = "[";
            CB = "]";
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "makeParamsString");
            }
            return null;
        }
        ret = ret + OB + SP;
        ret = ret + override;
        ret = ret + this.makeDefaultBindingsOptionsString(lang);
        ret = ret + this.makeDeploymentOptionsString(lang);
        Enumeration keys = taskHash.keys();
        while (keys.hasMoreElements()) {
            String currKey = (String)keys.nextElement();
            String[][] taskTable = (String[][])taskHash.get(currKey);
            if (currKey.equals("EJBDeployOptions") || currKey.equals("WSDeployOptions")) {
                int numCols = taskTable[0].length;
                for (int col = 0; col < numCols; ++col) {
                    if (taskTable[1][col] == null || taskTable[1][col].equals("") || taskTable[1][col].equals("AppDeploymentOption.No")) continue;
                    ret = taskTable[1][col].equals("AppDeploymentOption.Yes") ? ret + " -" + this.quoteStr(taskTable[0][col]) : ret + " -" + this.quoteStr(taskTable[0][col]) + " " + this.quoteStr(taskTable[1][col]);
                }
                continue;
            }
            ret = ret + SP + "-" + currKey + SP;
            ret = ret + OB;
            int numRows = taskTable.length;
            int numCols = taskTable[0].length;
            for (int row = 1; row < numRows; ++row) {
                ret = ret + OB + SP;
                for (int col = 0; col < numCols; ++col) {
                    String cellString = this.quoteStr(taskTable[row][col]);
                    ret = ret + cellString + SP;
                }
                ret = ret + CB;
            }
            ret = ret + CB;
        }
        ret = ret + CB;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeParamsString", new Object[]{ret});
        }
        return ret;
    }

    private String makeDeploymentOptionsString(String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDeploymentOptionsString");
        }
        String[][] udo = this.userDeploymentOptions;
        String ret = "";
        if (udo == null) {
            return ret;
        }
        if (udo.length != 2) {
            return ret;
        }
        int numCols = udo[0].length;
        for (int col = 0; col < numCols; ++col) {
            if (udo[1][col] == null || udo[1][col].equals("") || "buildVersion".equals(udo[0][col])) continue;
            ret = udo[1][col].equals("AppDeploymentOption.No") ? ret + " -no" + this.quoteStr(udo[0][col]) : (udo[1][col].equals("AppDeploymentOption.Yes") ? ret + " -" + this.quoteStr(udo[0][col]) : ret + " -" + this.quoteStr(udo[0][col]) + " " + this.quoteStr(udo[1][col]));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeDeploymentOptionsString", new Object[]{ret});
        }
        return ret;
    }

    private String makeDefaultBindingsOptionsString(String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDefaultBindingsOptionsString");
        }
        String[][] dbo = this.defaultBindingsOptions;
        String ret = "";
        if (dbo == null) {
            return ret;
        }
        if (dbo.length != 2) {
            return ret;
        }
        int numCols = dbo[0].length;
        for (int col = 0; col < numCols; ++col) {
            if (dbo[1][col] == null || dbo[1][col].equals("") || dbo[1][col].equals("AppDeploymentOption.No")) continue;
            ret = dbo[1][col].equals("AppDeploymentOption.Yes") ? ret + " -" + this.quoteStr(dbo[0][col]) : ret + " -" + this.quoteStr(dbo[0][col]) + " " + this.quoteStr(dbo[1][col]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeDefaultBindingsOptionsString", new Object[]{ret});
        }
        return ret;
    }
}

