/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.management.authorizer.AuthorizationGroup;
import com.ibm.ws.management.authorizer.ResourceInstanceRelations;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AuthorizationGroups {
    private static TraceComponent tc = Tr.register(AuthorizationGroups.class, "AuthorizationGroups", "com.ibm.ws.management.authorizer");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private HashMap authorizationGroups = new HashMap(5);
    private HashMap resourceToGroupMap = new HashMap(25);
    private String uuid = AdminContext.peek();
    private static AuthorizationGroups groups = null;

    public static AuthorizationGroups create() {
        String curUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create: " + curUUID);
        }
        AuthorizationGroups ret = null;
        if (curUUID == null) {
            if (groups == null) {
                ret = groups = new AuthorizationGroups();
            }
        } else {
            ret = (AuthorizationGroups)AdminSubsystemServiceRegistry.getService((String)AuthorizationGroups.class.getName());
            if (ret == null) {
                ret = new AuthorizationGroups();
                AdminSubsystemServiceRegistry.addService((String)AuthorizationGroups.class.getName(), (Object)ret);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create: " + curUUID);
        }
        return ret;
    }

    public static AuthorizationGroups getInstance() {
        SecurityManager sm;
        String curUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance: " + curUUID);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        AuthorizationGroups ret = curUUID == null ? groups : (AuthorizationGroups)AdminSubsystemServiceRegistry.getService((String)AuthorizationGroups.class.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance: " + curUUID);
        }
        return ret;
    }

    private AuthorizationGroups() {
    }

    public synchronized void addGroup(String groupName, AuthorizationGroup group) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addGroup", groupName + " " + group);
        }
        this.authorizationGroups.put(groupName, group);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addGroup");
        }
    }

    public synchronized AuthorizationGroup getGroup(String groupName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroup", groupName);
        }
        AuthorizationGroup group = null;
        Object o = this.authorizationGroups.get(groupName);
        if (o != null) {
            group = (AuthorizationGroup)o;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroup", group);
        }
        return group;
    }

    public synchronized boolean addResource(String resourceName, AuthorizationGroup group) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResource", resourceName + " " + group);
        }
        if (this.resourceToGroupMap.containsKey(resourceName)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addResource", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResource", new Boolean(true));
        }
        this.resourceToGroupMap.put(resourceName, group);
        return true;
    }

    public synchronized AuthorizationGroup getResourceGroup(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceGroup", resourceName);
        }
        AuthorizationGroup group = null;
        Object o = this.resourceToGroupMap.get(resourceName);
        if (o != null) {
            group = (AuthorizationGroup)o;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceGroup", group);
        }
        return group;
    }

    public synchronized String getResourceGroupName(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceGroupName", resourceName);
        }
        String groupName = null;
        Object o = this.resourceToGroupMap.get(resourceName);
        if (o != null) {
            groupName = ((AuthorizationGroup)o).getGroupName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceGroupName", groupName);
        }
        return groupName;
    }

    public synchronized List getAllResourceGroups(String resName, String resType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllResourceGroups", resName + " " + resType);
        }
        ArrayList groups = new ArrayList();
        String resourceName = ResourceInstanceRelations.getInstance().convertCfgId(resName, resType);
        Object o = this.resourceToGroupMap.get(resourceName);
        List parents = new ArrayList();
        if (o != null) {
            groups.add(o);
            AuthorizationGroup group = (AuthorizationGroup)o;
            parents = group.getParentResources(resourceName);
        } else {
            parents = ResourceInstanceRelations.getInstance().getParentInstances(resourceName, resType);
        }
        for (String parent : parents) {
            Object po = this.resourceToGroupMap.get(parent);
            groups.add(po);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllResourceGroups", groups);
        }
        return groups;
    }

    public synchronized List getAllResourceGroupNames(String resName, String resType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllResourceGroupNames", resName + " " + resType);
        }
        ArrayList<String> groups = new ArrayList<String>();
        String resourceName = ResourceInstanceRelations.getInstance().convertCfgId(resName, resType);
        Object o = this.resourceToGroupMap.get(resourceName);
        List parents = new ArrayList();
        if (o != null) {
            String groupName = ((AuthorizationGroup)o).getGroupName();
            groups.add(groupName);
            AuthorizationGroup group = (AuthorizationGroup)o;
            parents = group.getParentResources(resourceName);
        } else {
            parents = ResourceInstanceRelations.getInstance().getParentInstances(resourceName, resType);
        }
        for (String parent : parents) {
            Object po = this.resourceToGroupMap.get(parent);
            if (po == null) continue;
            String groupName = ((AuthorizationGroup)po).getGroupName();
            groups.add(groupName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllResourceGroupNames", groups);
        }
        return groups;
    }

    public synchronized List getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        Set keys = this.authorizationGroups.keySet();
        if (keys != null) {
            for (String groupName : keys) {
                groupNames.add(groupName);
            }
        }
        return groupNames;
    }

    public synchronized Collection getGroups() {
        return this.authorizationGroups.values();
    }

    public synchronized void flush() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flush");
        }
        this.authorizationGroups.clear();
        this.resourceToGroupMap.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flush");
        }
    }

    public void display() {
        Collection ac = this.authorizationGroups.values();
        for (AuthorizationGroup ag : ac) {
            System.out.println(ag);
        }
        System.out.println("---------------------");
        Set rc = this.resourceToGroupMap.keySet();
        for (String res : rc) {
            System.out.println("Resource = " + res);
            AuthorizationGroup ag = (AuthorizationGroup)this.resourceToGroupMap.get(res);
            System.out.println(ag);
        }
    }

    public synchronized void removeGroup(String groupName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroup", groupName);
        }
        ArrayList<String> removeList = new ArrayList<String>();
        Set rc = this.resourceToGroupMap.keySet();
        for (String res : rc) {
            AuthorizationGroup ag = (AuthorizationGroup)this.resourceToGroupMap.get(res);
            if (!ag.getGroupName().equals(groupName)) continue;
            removeList.add(res);
        }
        for (String res : removeList) {
            this.resourceToGroupMap.remove(res);
        }
        this.authorizationGroups.remove(groupName);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroup");
        }
    }
}

