/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.authorizer.ResourceInstanceIdentifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AuthorizationGroup {
    private static TraceComponent tc = Tr.register(AuthorizationGroup.class, "AuthorizationGroup", "com.ibm.ws.management.authorizer");
    private String groupName;
    private Set resourceTypes;
    private HashMap parentResources = new HashMap(5);
    private HashMap resources;

    public AuthorizationGroup() {
        this.resourceTypes = new HashSet();
        this.resources = new HashMap(5);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean hasResourceType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasResourceType", type);
        }
        boolean result = this.resourceTypes.contains(type);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasResourceType", new Boolean(result));
        }
        return result;
    }

    public boolean hasResource(String resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasResource", resource);
        }
        boolean result = this.resources.containsKey(resource);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasResource", new Boolean(result));
        }
        return result;
    }

    public List getParentResources(String resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentResources", resource);
        }
        List parents = (List)this.parentResources.get(resource);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentResources", parents);
        }
        return parents;
    }

    public String getResourceType(String resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceType", resource);
        }
        String resType = (String)this.resources.get(resource);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceType", resType);
        }
        return resType;
    }

    public void setAuthorizationGroupName(String gName) {
        this.groupName = gName;
    }

    public void addParentResources(String resource, List parentRes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addParentResources", resource + " " + parentRes);
        }
        this.parentResources.put(resource, parentRes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addParentResources");
        }
    }

    public void addResource(String resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResource", resource);
        }
        ResourceInstanceIdentifier rii = new ResourceInstanceIdentifier();
        String resType = rii.getResourceType(resource);
        this.resources.put(resource, resType);
        this.resourceTypes.add(resType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResource");
        }
    }

    public void addResource(String resource, String resType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResource", resource + " " + resType);
        }
        this.resources.put(resource, resType);
        this.resourceTypes.add(resType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResource");
        }
    }

    public void addResource(String resource, String resType, List parentRes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResource", resource + " " + resType + " " + parentRes);
        }
        this.resources.put(resource, resType);
        this.resourceTypes.add(resType);
        this.parentResources.put(resource, parentRes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResource");
        }
    }

    public void addResourceType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResourceType", type);
        }
        this.resourceTypes.add(type);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResourceType");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AuthorizationGroupName = ");
        sb.append(this.getGroupName()).append(this.getResourcesString());
        return sb.toString();
    }

    public String getResourcesString() {
        StringBuffer sb = new StringBuffer(" Resouces =");
        Set rs = this.resources.keySet();
        Iterator itr = rs.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
            sb.append(" ");
        }
        return sb.toString();
    }
}

