/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.MBeanRoute;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class MBeanRouter {
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceComponent tc = Tr.register(MBeanRouter.class, "Admin", resBundleName);
    private static TraceNLS nls = TraceNLS.getTraceNLS(resBundleName);
    private static Vector routers = new Vector();
    private static MBeanRouter[] routersArray = new MBeanRouter[0];
    private int priority = 0;

    protected MBeanRouter() {
        this(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanRouter(int priority) {
        this.priority = priority;
        Vector vector = routers;
        synchronized (vector) {
            int size = routers.size();
            boolean found = false;
            for (int i = 0; i < size; ++i) {
                MBeanRouter mbr = (MBeanRouter)routers.get(i);
                if (priority >= mbr.getPriority()) continue;
                routers.insertElementAt(this, i);
                found = true;
                break;
            }
            if (!found) {
                routers.add(this);
            }
            routersArray = new MBeanRouter[routers.size()];
            routers.copyInto(routersArray);
        }
    }

    public MBeanRoute findRoute(ObjectName objName) {
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    private static MBeanRouter[] getAllRouters() {
        return routersArray;
    }

    static ObjectName transformObjectName(ObjectName name) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformObjectName", name);
        }
        if (name.isPattern()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformObjectName", name);
            }
            return name;
        }
        MBeanRouter[] routers = MBeanRouter.getAllRouters();
        ObjectName ret = name;
        for (int i = 0; i < routers.length; ++i) {
            MBeanRoute route = null;
            try {
                route = routers[i].findRoute(name);
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMN1200W", new Object[]{routers[i].getClass().getName(), t});
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.MBeanRouter.transformObjectName", (String)"121");
            }
            if (route == null) continue;
            int routeType = route.getRouteType();
            switch (routeType) {
                case 0: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "transformObjectName: UNREACHABLE_ROUTE", name);
                    }
                    throw new InstanceNotFoundException(name + " is unreachable");
                }
                case 1: {
                    ret = route.getObjectName();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "transformObjectName", ret);
                    }
                    return ret;
                }
            }
            MBeanRouter.outputWarningAndFFDC("ADMN1201W", new Object[]{new Integer(routeType), routers[i].getClass().getName()}, "com.ibm.ws.management.MBeanRouter.transformObjectName", "139");
            throw new InstanceNotFoundException("Unexpected MBean route type " + routeType + " while processing MBean ObjectName " + name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformObjectName", ret);
        }
        return ret;
    }

    private static void outputWarningAndFFDC(String messageId, Object[] params, String sourceId, String probeId) {
        Tr.warning(tc, messageId, params);
        RuntimeException exc = new RuntimeException(nls.getFormattedMessage(messageId, params, null));
        FFDCFilter.processException((Throwable)exc, (String)sourceId, (String)probeId);
    }
}

