/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.event.ClientNotificationService;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.pmi.j2ee.StatsImpl;
import com.ibm.ws.pmi.stat.StatsAdapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class AdminClientImpl
implements AdminClient {
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS(resBundleName);
    private static TraceComponent tc = Tr.register(AdminClientImpl.class, "Admin", resBundleName);
    private static String NULL_PARAM_STRING = "The \"name\" parameter cannot be null.";
    private AdminServiceProxy proxy;
    private ClientNotificationService localNotificationService;

    public AdminClientImpl(InvocationHandler handler) {
        this((AdminServiceProxy)Proxy.newProxyInstance(AdminServiceProxy.class.getClassLoader(), new Class[]{AdminServiceProxy.class}, handler));
    }

    public AdminClientImpl(AdminServiceProxy proxy) {
        this.proxy = proxy;
    }

    public String getType() {
        return this.proxy.getType();
    }

    public Properties getConnectorProperties() {
        return this.proxy.getProxyProperties();
    }

    public Session isAlive() throws ConnectorException {
        return this.proxy.isAlive();
    }

    public Session isAlive(int timeout) throws ConnectorException {
        return this.proxy.isAlive(timeout);
    }

    public Set queryNames(ObjectName name, QueryExp query) throws ConnectorException {
        return this.proxy.queryNames(name, query);
    }

    public Integer getMBeanCount() throws ConnectorException {
        return this.proxy.getMBeanCount();
    }

    public String getDomainName() throws ConnectorException {
        return this.proxy.getDomainName();
    }

    public String getDefaultDomain() throws ConnectorException {
        return this.proxy.getDefaultDomain();
    }

    public ObjectName getServerMBean() throws ConnectorException {
        return this.proxy.getServerMBean();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, ConnectorException {
        this.assertObjectNameValid(name);
        return this.proxy.getMBeanInfo(name);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, ConnectorException {
        this.assertObjectNameValid(name);
        return this.proxy.isInstanceOf(name, className);
    }

    public boolean isRegistered(ObjectName name) throws ConnectorException {
        this.assertObjectNameValid(name);
        return this.proxy.isRegistered(name);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, ConnectorException {
        this.assertObjectNameValid(name);
        Object attr = this.proxy.getAttribute(name, attribute);
        if (Boolean.getBoolean("websphereV5Statistics") && attr instanceof StatsImpl) {
            attr = StatsAdapter.createWAS5Stats((WSStats)((StatsImpl)attr).getWSImpl());
        }
        return attr;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        this.assertObjectNameValid(name);
        AttributeList attrList = this.proxy.getAttributes(name, attributes);
        if (Boolean.getBoolean("websphereV5Statistics")) {
            ListIterator<Object> i = attrList.listIterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof StatsImpl)) continue;
                i.set(StatsAdapter.createWAS5Stats((WSStats)((StatsImpl)o).getWSImpl()));
            }
        }
        return attrList;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ConnectorException {
        this.assertObjectNameValid(name);
        this.proxy.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        this.assertObjectNameValid(name);
        return this.proxy.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, ConnectorException {
        this.assertObjectNameValid(name);
        String type = ObjectNameHelper.getMBeanType(name);
        if (type != null && type.equals("FileBrowser") && operationName.equals("translateLineNumbersToOffsets") && signature != null && signature.length > 1 && signature[1] != null && signature[1].equals("[J")) {
            signature[1] = "[Llong;";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Converting  signature type");
            }
        }
        Object[] returnVal = this.proxy.invoke(name, operationName, params, signature);
        if (Boolean.getBoolean("websphereV5Statistics")) {
            if (returnVal instanceof StatsImpl) {
                returnVal = StatsAdapter.createWAS5Stats((WSStats)((StatsImpl)returnVal).getWSImpl());
            } else if (returnVal instanceof WSStats) {
                returnVal = StatsAdapter.createWAS5Stats((WSStats)((WSStats)returnVal));
            } else if (returnVal instanceof WSStats[]) {
                returnVal = StatsAdapter.createWAS5Stats((WSStats[])((WSStats[])returnVal));
            }
        }
        return returnVal;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ConnectorException {
        this.assertObjectNameValid(name);
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        if (this.localNotificationService == null) {
            this.initLocalNotificationService();
        }
        this.localNotificationService.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListenerExtended(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ConnectorException {
        this.assertObjectNameValid(name);
        if (this.localNotificationService == null) {
            this.initLocalNotificationService();
        }
        this.localNotificationService.addNotificationListenerExtended(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, ConnectorException {
        this.assertObjectNameValid(name);
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        if (this.localNotificationService == null) {
            throw new ListenerNotFoundException();
        }
        this.localNotificationService.removeNotificationListener(name, listener);
    }

    public void removeNotificationListenerExtended(ObjectName name, NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        if (this.localNotificationService == null) {
            throw new ListenerNotFoundException();
        }
        this.localNotificationService.removeNotificationListenerExtended(name, listener);
    }

    public void removeNotificationListenerExtended(NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        this.removeNotificationListenerExtended(null, listener);
    }

    private void assertObjectNameValid(ObjectName name) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(NULL_PARAM_STRING), NULL_PARAM_STRING);
        }
    }

    private synchronized void initLocalNotificationService() {
        if (this.localNotificationService == null) {
            this.localNotificationService = new ClientNotificationService();
            RemoteReceiver rr = this.proxy.openRemoteNotificationChannel(this.proxy);
            rr.setDelegate(this.localNotificationService);
            this.localNotificationService.setFilterChangeListener(rr);
        }
    }

    public AdminServiceProxy getProxy() {
        return this.proxy;
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws ConnectorException {
        return this.proxy.queryMBeans(name, query);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws ConnectorException, InstanceNotFoundException {
        return this.proxy.getObjectInstance(objectName);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws ConnectorException, InstanceNotFoundException {
        this.proxy.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        this.proxy.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        this.proxy.removeNotificationListener(name, listener, filter, handback);
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException, ConnectorException {
        return this.proxy.getClassLoaderFor(name);
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException, ConnectorException {
        return this.proxy.getClassLoader(name);
    }
}

