/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ws.logging.ZNativeHelper;
import com.ibm.ws.logging.ZNativeHelperImpl;
import com.ibm.ws.security.util.AccessController;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZRasHelper {
    private static ZNativeHelper iZNativeHelper;
    private static ProcessInfo sProcessInfo;
    private static ThreadLocal sThreadInfo;
    private static Logger logger;
    private static final String EMPTY_STRING = "";

    public static final ProcessInfo getProcessInfo() {
        return sProcessInfo;
    }

    public static final ThreadInfo getThreadInfo() {
        return (ThreadInfo)sThreadInfo.get();
    }

    public static String getCorrelator() {
        return iZNativeHelper.getCorrelator();
    }

    private ZRasHelper() {
    }

    public static void initNative() {
        String version = RasHelper.getVersionId();
        String platform = ZRasHelper.getPlatform();
        String serverName = RasHelper.getServerName();
        String hostName = ZRasHelper.getHostName();
        iZNativeHelper.initNative(version, platform, serverName, hostName);
    }

    private static String getPlatform() {
        String platform = null;
        try {
            platform = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String osname = System.getProperty("os.name");
                    String osarch = System.getProperty("os.arch");
                    String osver = System.getProperty("os.version");
                    if (osname == null) {
                        osname = ZRasHelper.EMPTY_STRING;
                    }
                    if (osarch == null) {
                        osarch = ZRasHelper.EMPTY_STRING;
                    }
                    if (osver == null) {
                        osver = ZRasHelper.EMPTY_STRING;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append(osname).append("[").append(osarch).append("]#").append(osver);
                    return sb.toString();
                }
            });
        }
        catch (Throwable t) {
            return null;
        }
        return platform;
    }

    private static String getHostName() {
        String hostName = null;
        try {
            hostName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
        }
        catch (Throwable t) {
            logger.logp(Level.WARNING, ZRasHelper.class.getName(), "getHostName", "EXCEPTION_NULL_HOSTNAME", t);
            throw new RuntimeException("Unable to obtain host name", t);
        }
        if (hostName == null) {
            logger.logp(Level.WARNING, ZRasHelper.class.getName(), "getHostName", "EXCEPTION_NULL_HOSTNAME");
            throw new RuntimeException("Returned host name is null");
        }
        return hostName;
    }

    static {
        logger = Logger.getLogger(ZRasHelper.class.getName());
        iZNativeHelper = new ZNativeHelperImpl();
        sProcessInfo = new ProcessInfo();
        sThreadInfo = new ThreadLocal(){

            protected Object initialValue() {
                ThreadInfo threadInfo = new ThreadInfo();
                return threadInfo;
            }
        };
    }

    public static class ThreadInfo {
        private final String iTCBAddress = ZRasHelper.access$200().getTCBAddress();
        private final String iTId = ZRasHelper.access$200().getTId();

        private ThreadInfo() {
        }

        public String getTCBAddress() {
            return this.iTCBAddress;
        }

        public String getTId() {
            return this.iTId;
        }
    }

    public static class ProcessInfo {
        private static String sAddressSpaceId;
        private static String sJobName;
        private static int sLogRecordSize;
        private static String sPId;
        private static String sServer;
        private static String sSystemJobId;
        private static String sSystemName;

        private ProcessInfo() {
        }

        public static final String getAddressSpaceId() {
            return sAddressSpaceId;
        }

        public static final String getJobName() {
            return sJobName;
        }

        public static final int getLogRecordSize() {
            return sLogRecordSize;
        }

        public static final String getPId() {
            return sPId;
        }

        public static final String getServer() {
            return sServer;
        }

        public static final String getSystemJobId() {
            return sSystemJobId;
        }

        public static final String getSystemName() {
            return sSystemName;
        }

        static {
            boolean isServer = RasHelper.isServer();
            sLogRecordSize = isServer ? iZNativeHelper.getLogRecordSize() : -1;
            sServer = isServer ? iZNativeHelper.getServer() : null;
            sSystemJobId = isServer ? iZNativeHelper.getSystemJobId() : null;
            sAddressSpaceId = iZNativeHelper.getAddressSpaceId();
            sJobName = iZNativeHelper.getJobName();
            sPId = iZNativeHelper.getPId();
            sSystemName = iZNativeHelper.getSystemName();
        }
    }
}

