/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.runtime.JspClassInformation;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.webcontainerext.JSPErrorReport;
import com.ibm.ws.jsp.webcontainerext.JSPExtensionClassLoader;
import com.ibm.ws.jsp.webcontainerext.JspDependent;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import com.ibm.wsspi.webcontainer.WebContainerConstants;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorInvocationEnum;
import com.ibm.wsspi.webcontainer.filter.WebAppFilterManager;
import com.ibm.wsspi.webcontainer.servlet.GenericServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractJSPExtensionServletWrapper
extends GenericServletWrapper {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.JSPExtensionServletWrapper";
    private static final String JSP_TRANSLATION_TIME_STAMP = "jsp_translation_ts";
    protected Long lastTranslationTime = null;
    private static String separatorString = System.getProperty("line.separator");
    protected JspOptions options = null;
    protected JspConfigurationManager configManager = null;
    protected TagLibraryCache tlc = null;
    protected JspTranslationContext tcontext = null;
    protected CodeSource codeSource = null;
    protected JspInputSource inputSource = null;
    protected JspResources jspResources = null;
    protected List dependentsList = null;
    protected String versionNumber = null;
    protected boolean classloaderCreated = false;
    protected long lastCheck = 0L;
    protected boolean debugClassFile = true;
    protected Boolean recompiledJspOnRestart = null;

    public AbstractJSPExtensionServletWrapper(IServletContext parent, JspOptions options, JspConfigurationManager configManager, TagLibraryCache tlc, JspTranslationContext context, CodeSource codeSource) throws Exception {
        super(parent);
        this.options = options;
        this.configManager = configManager;
        this.tlc = tlc;
        this.tcontext = context;
        this.codeSource = codeSource;
        if (options.isTrackDependencies()) {
            this.dependentsList = new ArrayList();
        }
    }

    public void initialize(IServletConfig config) throws Exception {
        if (config.getFileName() == null || config.getFileName().equals("")) {
            throw new UnavailableException(JspCoreException.getMsg("jsp.error.failed.to.find.resource", new Object[]{config.getFileName()}));
        }
        this.inputSource = this.tcontext.getJspInputSourceFactory().createJspInputSource(config.getFileName());
        if (config.isLoadOnStartup()) {
            this.checkForTranslation(null);
            config.setClassName(this.jspResources.getPackageName() + "." + this.jspResources.getClassName());
        }
        super.initialize(config);
    }

    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest hreq = (HttpServletRequest)req;
            try {
                if (System.getSecurityManager() != null) {
                    try {
                        final HttpServletRequest finalReq = (HttpServletRequest)req;
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws JspCoreException {
                                AbstractJSPExtensionServletWrapper.this.checkForTranslation(finalReq);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ws.jsp.webcontainerext.JSPExtensionServletWrapper.handleRequest", (String)"143", (Object)this);
                        throw (JspCoreException)pae.getException();
                    }
                } else {
                    this.checkForTranslation((HttpServletRequest)req);
                }
                if (this.preCompile(hreq)) {
                    if (hreq != null) {
                        hreq.setAttribute(JSP_TRANSLATION_TIME_STAMP, this.lastTranslationTime);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "precompile was requested for [" + this.getJspUri() + "] last translation time =[" + this.lastTranslationTime + "]");
                    }
                    return;
                }
            }
            catch (JspCoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jsp.webcontainerext.JSPExtensionServletWrapper.translateJsp", (String)"259", (Object)this);
                int code = 500;
                if (e.getCause() != null && e.getCause() instanceof FileNotFoundException) {
                    code = 404;
                }
                Throwable t = null;
                Throwable rootCause = e;
                while ((t = rootCause.getCause()) != null) {
                    rootCause = t;
                }
                JSPErrorReport jser = new JSPErrorReport(rootCause.getLocalizedMessage(), rootCause);
                jser.setStackTrace(rootCause.getStackTrace());
                jser.setErrorCode(code);
                jser.setTargetServletName(super.getServletName());
                boolean wentThroughFilters = false;
                if (e.getCause() != null && e.getCause() instanceof FileNotFoundException) {
                    IServletContext context = (IServletContext)this.getWrapper().getServletContext();
                    IServletWrapper filterProxyServletWrapper = null;
                    if (context.isFiltersDefined()) {
                        filterProxyServletWrapper = (IServletWrapper)context.getMappingTarget(WebContainerConstants.FILTER_PROXY_MAPPING);
                        hreq.setAttribute("com.ibm.ws.webcontainer.filter.filenotfound", e);
                    }
                    if (WebAppFilterManager.invokeFiltersCompatibility) {
                        EnumSet<CollaboratorInvocationEnum> colEnum = EnumSet.of(CollaboratorInvocationEnum.CLASSLOADER, CollaboratorInvocationEnum.NAMESPACE, CollaboratorInvocationEnum.SECURITY, CollaboratorInvocationEnum.SESSION);
                        if (!((IServletContext)this.getServletContext()).getFilterManager().invokeFilters(hreq, (HttpServletResponse)res, filterProxyServletWrapper, this.getWrapper(), context, null, colEnum)) {
                            WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
                            if (reqState != null) {
                                Exception fe = (Exception)reqState.getAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter");
                                if (fe != null) {
                                    t = null;
                                    rootCause = fe;
                                    while ((t = rootCause.getCause()) != null) {
                                        rootCause = t;
                                    }
                                    reqState.removeAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter");
                                    JSPErrorReport errReport = new JSPErrorReport(rootCause.getLocalizedMessage(), fe);
                                    errReport.setStackTrace(fe.getStackTrace());
                                    errReport.setErrorCode(500);
                                    errReport.setTargetServletName(super.getServletName());
                                    context.sendError(hreq, (HttpServletResponse)res, errReport);
                                    return;
                                }
                                context.sendError(hreq, (HttpServletResponse)res, jser);
                                return;
                            }
                        } else {
                            wentThroughFilters = true;
                        }
                    }
                }
                if (!wentThroughFilters) {
                    this.context.sendError(hreq, (HttpServletResponse)res, jser);
                }
                return;
            }
            super.handleRequest(req, res);
            this.loadClassInformation();
        }
    }

    public String getJspUri() {
        return this.inputSource.getRelativeURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadClassInformation() {
        if (this.classloaderCreated && this.getTarget() instanceof JspClassInformation) {
            AbstractJSPExtensionServletWrapper abstractJSPExtensionServletWrapper = this;
            synchronized (abstractJSPExtensionServletWrapper) {
                JspClassInformation jspClassInformation = (JspClassInformation)((Object)this.getTarget());
                if (this.options.isTrackDependencies()) {
                    this.dependentsList.clear();
                    String[] dependents = jspClassInformation.getDependants();
                    if (dependents != null) {
                        for (int i = 0; i < dependents.length; ++i) {
                            JspDependent jspDependent = new JspDependent(dependents[i], this.tcontext);
                            this.dependentsList.add(jspDependent);
                        }
                    }
                }
                this.versionNumber = jspClassInformation.getVersionInformation();
                this.debugClassFile = jspClassInformation.isDebugClassFile();
            }
        }
    }

    protected void checkForTranslation(HttpServletRequest req) throws JspCoreException {
        if (this.options.isZOS()) {
            this.preinvokeCheckForTranslation(req);
        } else {
            this._checkForTranslation(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _checkForTranslation(HttpServletRequest req) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "About to enter checkForTranslation sync block for " + this.inputSource.getRelativeURL());
        }
        AbstractJSPExtensionServletWrapper abstractJSPExtensionServletWrapper = this;
        synchronized (abstractJSPExtensionServletWrapper) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Entered checkForTranslation sync block for " + this.inputSource.getRelativeURL());
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE) && this.versionNumber != null && this.jspResources != null) {
                logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Classfile: [" + this.jspResources.getClassName() + "] version: [" + this.versionNumber + "]");
            }
            this.classloaderCreated = false;
            if (!this.options.isDisableJspRuntimeCompilation() && System.currentTimeMillis() - this.lastCheck > this.options.getReloadInterval()) {
                boolean rc;
                boolean translationRequired = false;
                if (this.jspResources == null) {
                    this.jspResources = this.tcontext.getJspResourcesFactory().createJspResources(this.inputSource);
                    if (!this.options.isReloadEnabled() && !(translationRequired = this.jspResources.isOutdated()) && this.options.isDebugEnabled()) {
                        boolean bl = translationRequired = !this.debugClassFile;
                        if (translationRequired && !this.jspResources.getGeneratedSourceFile().getParentFile().exists()) {
                            rc = this.jspResources.getGeneratedSourceFile().getParentFile().mkdirs();
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                logger.logp(Level.FINEST, CLASS_NAME, "_checkForTranslation", (rc ? "Created" : "Unable to create") + " directory for generated source file [" + this.jspResources.getGeneratedSourceFile().getParentFile() + "]");
                            }
                        }
                    }
                    if (this.servletConfig != null) {
                        this.servletConfig.setClassName(this.jspResources.getPackageName() + "." + this.jspResources.getClassName());
                    }
                }
                this.jspResources.setCurrentRequest(req);
                if (this.options.isReloadEnabled()) {
                    translationRequired = this.jspResources.isOutdated();
                    if (!translationRequired && this.options.isDebugEnabled()) {
                        boolean bl = translationRequired = !this.debugClassFile;
                        if (translationRequired && !this.jspResources.getGeneratedSourceFile().getParentFile().exists()) {
                            rc = this.jspResources.getGeneratedSourceFile().getParentFile().mkdirs();
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                logger.logp(Level.FINEST, CLASS_NAME, "_checkForTranslation", (rc ? "Created" : "Unable to create") + " directory for generated source file [" + this.jspResources.getGeneratedSourceFile().getParentFile() + "]");
                            }
                        }
                    }
                    if (this.options.isTrackDependencies() && !translationRequired) {
                        boolean needToReset = false;
                        JspClassInformation tmpJCI = null;
                        if (this.getTarget() == null && (this.dependentsList == null || this.dependentsList.isEmpty())) {
                            block35: {
                                if (this.getTargetClassLoader() == null) {
                                    this.createClassLoader();
                                    needToReset = true;
                                }
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "_checkForTranslation", "getTargetClassLoader(): " + this.getTargetClassLoader());
                                }
                                try {
                                    tmpJCI = (JspClassInformation)Class.forName(this.jspResources.getPackageName() + "." + this.jspResources.getClassName(), true, this.getTargetClassLoader()).newInstance();
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "_checkForTranslation", "created a temporary JspClassInformation object to get dependencies: " + tmpJCI);
                                    }
                                }
                                catch (Throwable t) {
                                    if (logger == null) break block35;
                                    logger.logp(Level.INFO, CLASS_NAME, "_checkForTranslation", "Exception caught checking JSP dependencies:", t);
                                }
                            }
                            if (tmpJCI != null) {
                                this.dependentsList.clear();
                                String[] dependents = tmpJCI.getDependants();
                                if (dependents != null) {
                                    for (int i = 0; i < dependents.length; ++i) {
                                        JspDependent jspDependent = new JspDependent(dependents[i], this.tcontext);
                                        this.dependentsList.add(jspDependent);
                                    }
                                }
                                tmpJCI = null;
                            }
                        }
                        translationRequired = this.isDependentOutdated();
                        if (needToReset) {
                            this.setTargetClassLoader(null);
                            this.classloaderCreated = false;
                        }
                    }
                    if (!translationRequired && this.jspResources.isExternallyTranslated()) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", this.inputSource.getRelativeURL() + " has been externally translated");
                        }
                        this.setTargetClassLoader(null);
                        this.jspResources.sync();
                    }
                }
                if (this.options != null && this.options.isRecompileJspOnRestart() && this.recompiledJspOnRestart == null) {
                    translationRequired = true;
                    this.recompiledJspOnRestart = true;
                }
                if (translationRequired) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Translation required for " + this.inputSource.getRelativeURL());
                    }
                    this.translateJsp();
                    this.setTargetClassLoader(null);
                    this.lastTranslationTime = new Long(System.currentTimeMillis());
                }
                this.lastCheck = System.currentTimeMillis();
            }
            if (this.getTargetClassLoader() == null) {
                if (this.getTarget() != null) {
                    this.prepareForReload();
                }
                this.createClassLoader();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "checkForTranslation", "Exiting checkForTranslation sync block for " + this.inputSource.getRelativeURL());
        }
    }

    protected void translateJsp() throws JspCoreException {
        JspCompilerResult compilerResult = JspTranslatorUtil.translateJspAndCompile(this.jspResources, this.tcontext, this.configManager.getConfigurationForUrl(this.inputSource.getRelativeURL()), this.options, this.tlc, false, Collections.EMPTY_LIST);
        if (compilerResult.getCompilerReturnValue() != 0) {
            JspCoreException e = new JspCoreException("jsp.error.compile.failed", new Object[]{this.inputSource.getRelativeURL(), separatorString + compilerResult.getCompilerMessage()});
            throw e;
        }
    }

    protected void createClassLoader() {
        if (this.jspResources == null) {
            this.jspResources = this.tcontext.getJspResourcesFactory().createJspResources(this.inputSource);
            if (this.servletConfig != null) {
                this.servletConfig.setClassName(this.jspResources.getPackageName() + "." + this.jspResources.getClassName());
            }
        }
        if (this.options.isDisableJspRuntimeCompilation() && this.options.isUseFullPackageNames()) {
            this.classloaderCreated = true;
            return;
        }
        URL[] urls = null;
        try {
            PermissionCollection permissionCollection = this.createPermissionCollection();
            String sourceDir = this.jspResources.getGeneratedSourceFile().getParentFile().toString() + File.separator + "*";
            permissionCollection.add(new FilePermission(sourceDir, "read"));
            urls = !this.options.isUseFullPackageNames() ? new URL[]{this.jspResources.getGeneratedSourceFile().getParentFile().toURL(), this.options.getOutputDir().toURL(), new File(this.tcontext.getRealPath("/WEB-INF/classes") + this.inputSource.getRelativeURL().substring(0, this.inputSource.getRelativeURL().lastIndexOf("/") + 1)).toURL(), new File(this.tcontext.getRealPath("/WEB-INF/classes")).toURL()} : new URL[]{this.options.getOutputDir().toURL(), new File(this.tcontext.getRealPath("/WEB-INF/classes")).toURL()};
            JSPExtensionClassLoader jspLoader = new JSPExtensionClassLoader(urls, this.tcontext.getJspClassloaderContext(), this.jspResources.getClassName(), this.codeSource, permissionCollection);
            if (this.servletConfig != null && this.jspResources.getPackageName().equals("com.ibm._jsp")) {
                try {
                    jspLoader.loadClass(this.jspResources.getPackageName() + "." + this.jspResources.getClassName(), true);
                }
                catch (Throwable e1) {
                    this.servletConfig.setClassName("org.apache.jsp." + this.jspResources.getClassName());
                }
            }
            this.setTargetClassLoader(jspLoader);
            this.classloaderCreated = true;
        }
        catch (MalformedURLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jsp.webcontainerext.JSPExtensionProcessor.createClassLoader", (String)"312", (Object)this);
            logger.logp(Level.WARNING, CLASS_NAME, "createClassLoader", "failed to create JSP class loader", e);
        }
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    protected boolean isDependentOutdated() throws JspCoreException {
        boolean outdated = false;
        for (JspDependent jspDependent : this.dependentsList) {
            if (!jspDependent.isOutdated()) continue;
            if (!this.jspResources.getGeneratedSourceFile().exists()) {
                this.jspResources.getGeneratedSourceFile().getParentFile().mkdirs();
            }
            if (jspDependent.getDependentFilePath().endsWith(".tld")) {
                this.tlc.reloadTld(jspDependent.getDependentFilePath(), jspDependent.getTimestamp());
            }
            outdated = true;
            break;
        }
        return outdated;
    }

    public boolean isAvailable() {
        boolean available = false;
        String relativeURL = this.inputSource.getRelativeURL();
        String realPath = this.tcontext.getRealPath(relativeURL);
        available = !this.options.isDisableJspRuntimeCompilation() ? new File(realPath).exists() : true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isAvailable", "relativeURL [" + relativeURL + "]  " + "realPath [" + realPath + "] is available [" + available + "]");
        }
        return available;
    }

    public JspResources getJspResources() {
        return this.jspResources;
    }

    protected abstract void preinvokeCheckForTranslation(HttpServletRequest var1) throws JspCoreException;

    protected abstract PermissionCollection createPermissionCollection() throws MalformedURLException;
}

