/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.PageData;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageDataImpl
extends PageData {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.validator.PageDataImpl";
    private DocumentFragment jspDocument = null;

    public PageDataImpl(Document document, TagLibraryCache tlc) {
        Element pageDirectiveElement;
        Element rootElement;
        Node root = this.jspDocument = document.createDocumentFragment();
        if (document.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "root").getLength() == 0) {
            rootElement = document.createElementNS("http://java.sun.com/JSP/Page", "jsp:root");
            rootElement.setAttributeNS("http://java.sun.com/JSP/Page", "version", "2.0");
            this.jspDocument.appendChild(rootElement);
            root = rootElement;
        }
        this.copyNodes(document, document, root);
        rootElement = (Element)this.jspDocument.getFirstChild();
        NamedNodeMap attrs = rootElement.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (!tlc.getImplicitTagLibPrefixMap().containsValue(attr.getNodeValue())) continue;
            rootElement.removeAttribute(attr.getNodeName());
        }
        NodeList nl = rootElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "directive.page");
        boolean pageEncodingFound = false;
        boolean contentTypeFound = false;
        if (nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                pageDirectiveElement = (Element)nl.item(i);
                if (pageDirectiveElement.hasAttribute("pageEncoding")) {
                    pageEncodingFound = true;
                    pageDirectiveElement.setAttribute("pageEncoding", "UTF-8");
                }
                if (!pageDirectiveElement.hasAttribute("contentType")) continue;
                contentTypeFound = true;
                pageDirectiveElement.setAttribute("contentType", "text/xml;charset=UTF-8");
            }
        }
        String jspId = rootElement.getAttributeNS("http://java.sun.com/JSP/Page", "id");
        if (!pageEncodingFound) {
            pageDirectiveElement = document.createElementNS("http://java.sun.com/JSP/Page", "jsp:directive.page");
            pageDirectiveElement.setAttributeNS("http://java.sun.com/JSP/Page", "pageEncoding", "UTF-8");
            pageDirectiveElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
            rootElement.insertBefore(pageDirectiveElement, rootElement.getFirstChild());
        }
        if (!contentTypeFound) {
            pageDirectiveElement = document.createElementNS("http://java.sun.com/JSP/Page", "jsp:directive.page");
            pageDirectiveElement.setAttributeNS("http://java.sun.com/JSP/Page", "contentType", "text/xml;charset=UTF-8");
            pageDirectiveElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
            rootElement.insertBefore(pageDirectiveElement, rootElement.getFirstChild());
        }
    }

    public InputStream getInputStream() {
        if (System.getSecurityManager() != null) {
            return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PageDataImpl.this._getInputStream();
                }
            });
        }
        return this._getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream _getInputStream() {
        ByteArrayInputStream is = null;
        ClassLoader oldLoader = null;
        try {
            oldLoader = ThreadContextHelper.getContextClassLoader();
            ClassLoader newLoader = ThreadContextHelper.getExtClassLoader();
            if (newLoader == null) {
                ThreadContextHelper.setClassLoader(PageDataImpl.class.getClassLoader());
            } else {
                ThreadContextHelper.setClassLoader(newLoader);
            }
            try {
                TransformerFactory tfactory = TransformerFactory.newInstance();
                Transformer serializer = tfactory.newTransformer();
                Properties oprops = new Properties();
                oprops.put("method", "xml");
                serializer.setOutputProperties(oprops);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                serializer.transform(new DOMSource(this.jspDocument), result);
                is = new ByteArrayInputStream(writer.toString().getBytes("UTF-8"));
            }
            finally {
                ThreadContextHelper.setClassLoader(oldLoader);
            }
        }
        catch (TransformerConfigurationException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "_getInputStream", "Encountered configuration error during transform of jspDocument", e);
        }
        catch (TransformerException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "_getInputStream", "failed to transform jspDocument", e);
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "_getInputStream", "Failed to convert document to inputstream", e);
        }
        return is;
    }

    private void copyNodes(Document document, Node in, Node out) {
        String parentNamespace = in.getNamespaceURI();
        String parentLocalName = in.getLocalName();
        for (int i = 0; i < in.getChildNodes().getLength(); ++i) {
            Node childNode = in.getChildNodes().item(i);
            Node newNode = document.importNode(childNode, false);
            if (childNode != null && childNode.getNodeType() == 4) {
                if (parentNamespace != null) {
                    String jspId;
                    if (parentNamespace.equals("http://java.sun.com/JSP/Page")) {
                        if (!(parentLocalName.equals("declaration") || parentLocalName.equals("expression") || parentLocalName.equals("scriptlet"))) {
                            jspId = ((Element)in).getAttributeNS("http://java.sun.com/JSP/Page", "id");
                            Element jspTextElement = document.createElementNS("http://java.sun.com/JSP/Page", "jsp:text");
                            jspTextElement.appendChild(newNode);
                            jspTextElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
                            out.appendChild(jspTextElement);
                        }
                    } else {
                        jspId = ((Element)in).getAttributeNS("http://java.sun.com/JSP/Page", "id");
                        Element jspTextElement = document.createElementNS("http://java.sun.com/JSP/Page", "jsp:text");
                        jspTextElement.appendChild(newNode);
                        jspTextElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
                        out.appendChild(jspTextElement);
                    }
                }
            } else if (newNode != null) {
                if (newNode.getNodeType() == 1) {
                    NamedNodeMap attrs = newNode.getAttributes();
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Attr attr = (Attr)attrs.item(j);
                        String value = attr.getValue();
                        value = value.replaceAll("&gt;", ">");
                        value = value.replaceAll("&lt;", "<");
                        value = value.replaceAll("&amp;", "&");
                        attr.setValue(value);
                    }
                }
                out.appendChild(newNode);
            }
            if (childNode == null || newNode == null) continue;
            this.copyNodes(document, childNode, newNode);
        }
    }
}

