/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.resource;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.FileSystem;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceUtil {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.resource.ResourceUtil";

    public static void sync(File sourceFile, File generatedSourceFile, File classFile, String className, boolean keepgenerated, boolean keepGeneratedclassfiles) {
        boolean rc;
        boolean delete;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "sync", "Synching for sourceFile [" + sourceFile + "] ts [" + sourceFile.lastModified() + "]");
        }
        if (!keepGeneratedclassfiles) {
            delete = classFile.delete();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (delete ? "Deleted" : "Unable to delete") + " classFile [" + classFile + "]");
            }
            File[] icList = generatedSourceFile.getParentFile().listFiles(new InnerclassFilenameFilter(className));
            for (int i = 0; i < icList.length; ++i) {
                if (!icList[i].isFile()) continue;
                boolean innerDelete = icList[i].delete();
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINEST)) continue;
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (innerDelete ? "Deleted" : "Unable to delete") + " inner classFile [" + icList[i] + "]");
            }
        } else {
            rc = classFile.setLastModified(sourceFile.lastModified());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for classFile [" + classFile + "] [" + classFile.lastModified() + "]");
            }
        }
        if (generatedSourceFile.exists()) {
            if (!keepgenerated) {
                delete = generatedSourceFile.delete();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "sync", (delete ? "Deleted" : "Unable to delete") + " generatedSourceFile [" + generatedSourceFile + "]");
                }
            } else {
                rc = generatedSourceFile.setLastModified(sourceFile.lastModified());
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "sync", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + generatedSourceFile + "] [" + generatedSourceFile.lastModified() + "]");
                }
            }
        }
    }

    public static boolean isOutdated(File sourceFile, File generatedSourceFile, File classFile, File webinfClassFile) {
        boolean outdated = true;
        if (sourceFile != null) {
            if (!sourceFile.exists()) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isOutdated", "sourceFile [" + sourceFile + "] does not exist");
                }
                return true;
            }
            try {
                if (classFile.exists() && FileSystem.uriCaseCheck((File)classFile, (String)classFile.getAbsolutePath())) {
                    if (sourceFile.lastModified() == classFile.lastModified()) {
                        outdated = false;
                    } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile [" + sourceFile + "]");
                        logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "classFile [" + classFile + "]");
                        logger.logp(Level.FINER, CLASS_NAME, "isOutdated", "sourceFile ts [" + sourceFile.lastModified() + "] differs from tempDirClassFile ts [" + classFile.lastModified() + "]. Recompile JSP.");
                    }
                } else if (webinfClassFile.exists() && FileSystem.uriCaseCheck((File)webinfClassFile, (String)webinfClassFile.getAbsolutePath())) {
                    if (sourceFile.lastModified() == webinfClassFile.lastModified()) {
                        outdated = false;
                    } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile [" + sourceFile + "]");
                        logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "webinfClassFile [" + webinfClassFile + "]");
                        logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile ts [" + sourceFile.lastModified() + "] differs from webinfClassFile ts [" + webinfClassFile.lastModified() + "]. Recompile JSP.");
                    }
                }
            }
            catch (IOException e) {
                return true;
            }
            if (outdated && !generatedSourceFile.getParentFile().exists()) {
                boolean rc = generatedSourceFile.getParentFile().mkdirs();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", (rc ? "Created" : "Unable to create") + " directory for generated source file [" + generatedSourceFile.getParentFile() + "]");
                }
            }
        } else {
            outdated = false;
        }
        return outdated;
    }

    public static boolean isTagFileOutdated(File sourceFile, File generatedSourceFile, File classFile, File webinfClassFile) {
        boolean outdated = true;
        if (!sourceFile.exists()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + sourceFile + "] does not exist");
            }
            return true;
        }
        if (generatedSourceFile.exists()) {
            if (sourceFile.lastModified() == generatedSourceFile.lastModified()) {
                outdated = false;
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + sourceFile + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "generatedSourceFile [" + generatedSourceFile + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + sourceFile.lastModified() + "] differs from generatedSourceFile ts [" + generatedSourceFile.lastModified() + "]. Recompile tag file.");
            }
        } else if (classFile.exists()) {
            if (sourceFile.lastModified() == classFile.lastModified()) {
                outdated = false;
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + sourceFile + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "classFile [" + classFile + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + sourceFile.lastModified() + "] differs from tempDirClassFile ts [" + classFile.lastModified() + "]. Recompile tag file.");
            }
        } else if (webinfClassFile.exists()) {
            if (sourceFile.lastModified() == webinfClassFile.lastModified()) {
                outdated = false;
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + sourceFile + "]");
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "webinfClassFile [" + webinfClassFile + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + sourceFile.lastModified() + "] differs from webinfClassFile ts [" + webinfClassFile.lastModified() + "]. Recompile tag file.");
            }
        }
        if (outdated && !generatedSourceFile.getParentFile().exists()) {
            boolean rc = generatedSourceFile.getParentFile().mkdirs();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", (rc ? "Created" : "Unable to create") + " directory for generated source file [" + generatedSourceFile.getParentFile() + "]");
            }
        }
        return outdated;
    }

    public static void syncGeneratedSource(File sourceFile, File generatedSourceFile) {
        if (generatedSourceFile.exists()) {
            boolean rc = generatedSourceFile.setLastModified(sourceFile.lastModified());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "syncGeneratedSource", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + generatedSourceFile + "] [" + generatedSourceFile.lastModified() + "]");
            }
        }
    }

    public static void syncTagFile(File sourceFile, File generatedSourceFile, File classFile, boolean keepgenerated, boolean keepGeneratedclassfiles) {
        if (sourceFile.lastModified() == generatedSourceFile.lastModified()) {
            boolean rc;
            boolean delete;
            if (!keepGeneratedclassfiles) {
                delete = classFile.delete();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (delete ? "Deleted" : "Unable to delete") + " classFile [" + classFile + "]");
                }
            } else {
                rc = classFile.setLastModified(sourceFile.lastModified());
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for classFile [" + classFile + "] [" + classFile.lastModified() + "]");
                }
            }
            if (generatedSourceFile.exists()) {
                if (!keepgenerated) {
                    delete = generatedSourceFile.delete();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (delete ? "Deleted" : "Unable to delete") + " generatedSourceFile [" + generatedSourceFile + "]");
                    }
                } else {
                    rc = generatedSourceFile.setLastModified(sourceFile.lastModified());
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + generatedSourceFile + "] [" + generatedSourceFile.lastModified() + "]");
                    }
                }
            }
        }
    }

    private static class InnerclassFilenameFilter
    implements FilenameFilter {
        String filename = null;

        public InnerclassFilenameFilter(String filename) {
            this.filename = filename;
        }

        public boolean accept(File dir, String name) {
            String nameStart;
            int dollarIndex = name.indexOf("$");
            return dollarIndex > -1 && this.filename.equals(nameStart = name.substring(0, dollarIndex));
        }
    }
}

